#!/usr/local/bin/perl

# --------------------------------------------------------
# createSprite.cgi:
#      cgi for creating Sprite
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------

use strict;
use CGI qw/-debug :standard/;
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
use PositLogConfig;
use PositLogParam;

my $CGI = new CGI;
print $CGI->header(-charset => 'utf-8');  # HTTP header

my $pageid = $CGI->param("pageid");

my $public_password = $CGI->param("public_password");

my $newleft = $CGI->param("left");
my $newtop = $CGI->param("top");

# Read temporal cookie
my $loginid = $CGI->cookie("loginid") || "";
my $loginpass = $CGI->cookie("loginpass") || "";

# authentication

my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
my $loginerror = "";
my $validUser = 0;
my $adminUser = 0;
my $publicUser = 0;
if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
{
	my $cryptpass = $adminnameAuth->{$loginid}{"password"};
	my $salt="lc";
	my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 1;
		$publicUser = 0;
	}
	else
	{
		print "Permission denied.\n";
		exit(0);	
	}
}
elsif($useridAuth ne "" && $useridAuth->{$loginid})
{
	my $cryptpass = $useridAuth->{$loginid}{"password"};
	my $salt="ry";
	my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$adminUser = 0;
		$validUser = 1;
		$publicUser = 0;
	}
	else
	{
		print "Permission denied.\n";		
		exit(0);	
	}
}
else
{
	$adminUser = 0;
	$validUser = 0;
	$publicUser = 1;
}


my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};
if($permissionHash eq "")
{
	print "Cannot read permission.cgi.\n";
	exit(0);
}

my $write_plainsprite = 0;
my $write_attachedsprite = 0;
my $write_supersprite = 0;
if($adminUser || scalar($permissionHash->{"write_plainsprite"}{$loginid}) == 1)
{
	$write_plainsprite = 1;
}
foreach my $usergroupname (keys %{$permissionHash->{"write_plainsprite_group"}})
{
	my $usergroupnameenc = $usergroupname;
	$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$usergroupnameenc =~ tr/ /+/;

	my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	if(scalar($tmpList->{$loginid}) == 1)
	{
		$write_plainsprite = 1;		
	}
}

if($adminUser || scalar($permissionHash->{"write_attachedsprite"}{$loginid}) == 1)
{
	$write_attachedsprite = 1;
}
foreach my $usergroupname (keys %{$permissionHash->{"write_attachedsprite_group"}})
{
	my $usergroupnameenc = $usergroupname;
	$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$usergroupnameenc =~ tr/ /+/;

	my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	if(scalar($tmpList->{$loginid}) == 1)
	{
		$write_attachedsprite = 1;		
	}
}


if($adminUser || scalar($permissionHash->{"write_supersprite"}{$loginid}) == 1)
{
	$write_supersprite = 1;
}
foreach my $usergroupname (keys %{$permissionHash->{"write_supersprite_group"}})
{
	my $usergroupnameenc = $usergroupname;
	$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$usergroupnameenc =~ tr/ /+/;

	my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	if(scalar($tmpList->{$loginid}) == 1)
	{
		$write_supersprite = 1;		
	}
}

if($write_plainsprite != 1 
   && $write_attachedsprite != 1 
   && $write_supersprite != 1)
{
	print "Permission denied.\n";
	exit(0);
}

my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")} or {};
if($spritesHash eq ""){ print "Cannot read sprites.dat.\n"; exit(0); }

# generate new spriteID
my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst);
($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
my $createtime = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);

my $newSpriteID = "";
do
{
	my $rand = int (rand(1000));
	$rand = sprintf("%03d", $rand);
# id must start from alphabet in HTML4.01
	$newSpriteID = "sprite_" . $createtime . "_" . $rand;
}while(exists($spritesHash->{$newSpriteID}));

my $newContents = $CGI->param("contents");
$newContents =~ tr/+/ /;
$newContents =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack('H2', $1)/eg;
my $newcanvasID = $newSpriteID . "_canvas";
$newContents =~ s/tmpid/$newcanvasID/eg;

Storable::lock_nstore \$newContents, $PositLogConfig::datapath . $pageid . "/static/" . $newSpriteID.".spr";

if($adminUser)
{
	$spritesHash->{$newSpriteID}{"author_id"} = "admin";
}
else
{
	$spritesHash->{$newSpriteID}{"author_id"} = $loginid;
}

if($CGI->param("style") ne ""){
		$spritesHash->{$newSpriteID}{"display_created_time"} = 1;
		$spritesHash->{$newSpriteID}{"display_author"} = 1;
		$spritesHash->{$newSpriteID}{"display_positlink"} = 1;
}
else{
		$spritesHash->{$newSpriteID}{"display_created_time"} = 0;
		$spritesHash->{$newSpriteID}{"display_author"} = 0;
		$spritesHash->{$newSpriteID}{"display_positlink"} = 0;
}

$spritesHash->{$newSpriteID}{"style"} = "left:" .  $newleft . "px; top:" . $newtop .  "px; width:" . $CGI->param("width") . "px;  z-index:500000;  border-left:0px none #000000; border-right:0px none #000000; border-top:0px none #000000; border-bottom:0px none #000000;";
$spritesHash->{$newSpriteID}{"public_password"} = "";

$spritesHash->{$newSpriteID}{"contents_style"} = $CGI->param("style");

# change modified time

my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};
if($configHash eq "")
{
	print "Cannot read the page configuration.\n";
	exit(0);
}
my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
my $time = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);

$spritesHash->{$newSpriteID}{"modified_time"} = $time;
$spritesHash->{$newSpriteID}{"created_time"} = $time;
$configHash->{"modified_time"} = $time;


my $author;
if($adminUser)
{
    $author = "admin";
}
else
{
	if($loginid eq "public")
	{
			if($public_password ne ""){
					my $salt="zi";
					$spritesHash->{$newSpriteID}{"public_password"} = crypt($public_password, $salt);
					$author = "&lt;public&gt;";
			}
			else{
					$author = "[public]";
			}
	}
	else
	{
		$author = $useridAuth->{$loginid}{"nickname"};
	}
}

$configHash->{"version"} = $PositLogParam::version;

if(!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pageid . "/sprites.dat"})
{
	print "Cannot write sprites.dat.\n";
	exit(0);
}

if(!eval{Storable::lock_nstore $configHash, $PositLogConfig::datapath . $pageid . "/config.dat"})
{
	print "Cannot write the page configuration.\n";
	exit(0);
}


print "succeed,$newSpriteID,$author,$time\n";
