package PositLogSprites;

use strict;
use PositLogConfig;
use Storable qw(lock_retrieve lock_nstore);
use List::Util qw{first};
use Encode qw/encode decode/;

# ----------------------------
# sub getSpritesFromPlugin
#   executes function dynamically
# ----------------------------

sub getSpritesFromPlugin {
    my ($pluginName, $pageid, $keyID, $loginid, $loginpass, $args) = @_;
    eval 'use ' .$pluginName .';' . $pluginName . q/::getSprites($pageid, $keyID, $loginid, $loginpass, $args)/;
}


# ----------------------------
# sub importDynamicSprites
# ----------------------------

sub importDynamicSprites
{
    my $pluginBody = "";

    my ($self, $pluginID, $parentID, $authorName, $args) = @_;

		my $spritesHash = $self->{pageSpritesHash};
		my $pageid = $self->{pageid};
		my $loginid = $self->{loginid};
		my $loginpass = $self->{loginpass};
		my $className = $self->{classname};

		my $valueStyle = $spritesHash->{$parentID}{"style"};
		$valueStyle =~ /z-index:(-?\d+?);/is;
		my $zindex = $1;

    # getSprites(arg1, arg2, ...) returns array of hash

    my $spritesArray = &getSpritesFromPlugin("PositLogPlugin::" . $pluginID, $pageid, $parentID, $loginid, $loginpass,$args);


    my $pluginType = eval 'use ' . "PositLogPlugin::" . $pluginID .';' . "PositLogPlugin::" . $pluginID . q/::getType()/;

		my %idContents;

    if($pluginType eq "create")
    {
				# sprites are created and arranged by user

				my $widthOfSprite = eval 'use ' . "PositLogPlugin::" . $pluginID .';' . "PositLogPlugin::" . $pluginID . q/::getWidth()/;

				# current number of sprites
				my $spriteCounter = scalar($zindex);

				# variables for generating new spriteStyle
				my $xcount = 0;
				my $xdiv = 600 / 40 -1;
				my $ycount = 0;
				my $ydiv = 600 / 40 -1;

				# sort by date
				foreach my $sprite (@$spritesArray) {

						$pluginBody = "";
						# get modified date and spriteID
						my $spriteID = $sprite->{"id"};
						my $modified_time = $sprite->{"modified_date"};

						$spritesHash->{$spriteID}{"modified_time"} = $modified_time;

						# check if existing page data includes style of $spriteID
						my $spriteStyle = $spritesHash->{$spriteID}{"style"};
						if (!$spriteStyle) {
								# if not, generate new spriteStyle

								my $newleft = 10;
								my $newtop = 80;
								if ($xcount > $xdiv) {
										$xcount = 0;
										$ycount ++;
										if ($ycount > $ydiv) {
												$ycount = 0;
										}
								}
								$newleft += 40 * $xcount;
								$newtop += 40 * $ycount;

								$xcount ++;

								$spriteStyle = "border-left:0px none #000000; border-right:0px none #000000; border-top:0px none #000000; border-bottom:0px none #000000; top:" . $newtop ."px; left:" . $newleft . "px; width:" . $widthOfSprite . "px;  z-index:" . $spriteCounter . ";";
						}

						if(!$spritesHash->{$spriteID}{"parent"} || $spritesHash->{$spriteID}{"parent"} eq ""){
								$spritesHash->{$spriteID}{"parent"} = $parentID;
								if($spritesHash->{$parentID}{"children"} && $spritesHash->{$parentID}{"children"} ne ""){
										my @children = @{$spritesHash->{$parentID}{"children"}};
										my $isExist = first {$_ eq $spriteID} @children;
										if(!defined $isExist){
												push(@children, $spriteID);
												$spritesHash->{$parentID}{"children"} = \@children;
										}
								}
								else{
										my @children;
										push(@children, $spriteID);
										$spritesHash->{$parentID}{"children"} = \@children;
								}
						}


						# create sprite
						my $valueContents = $sprite->{"body"};

						$pluginBody .= "<li class='" . $className . "' id='";
						$pluginBody .= $spriteID;
						$pluginBody .= "' style='" . $spriteStyle . "'>";
						$pluginBody .= "<div class='spriteregion'>";
						$pluginBody .= "<div class='spritecontents'>";
						$pluginBody .= $valueContents;
						$pluginBody .= "</div>\n";

						$pluginBody .= "<div class='spriteinfo'>";
						$pluginBody .= "<span class='iemagic'> </span>"; # need space for IE

						$pluginBody .= "<span class='spriteplugin'";
						$pluginBody .= " style='display:none;'>";
						$pluginBody .= "</span>\n";

						if(scalar($spritesHash->{$spriteID}{"display_author"}) == 1)
						{
								$pluginBody .= "<span class='spriteauthor'";
								$pluginBody .= " style='display:block;'>";
								utf8::decode($authorName);
								$pluginBody .= $authorName;
								$pluginBody .= "</span>\n";
						}

						if(!exists($spritesHash->{$spriteID}{"display_created_time"}) || scalar($spritesHash->{$spriteID}{"display_created_time"}) == 1)
						{
								$pluginBody .= "<span class='spritedate'";
								$pluginBody .= " style='display:block;'>";
								my $cdate = $spritesHash->{$spriteID}{"modified_time"};
								$cdate =~ /^(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)$/i;
								my $timeStr = $1 . "/" . $2 . "/" . $3 . " " . $4 . ":" . $5 . ":" .$6;
								$pluginBody .= $timeStr;
								$pluginBody .= "</span>\n";
						}

						if(scalar($spritesHash->{$spriteID}{"display_positlink"}) == 1)
						{
								$pluginBody .= "<span class='spriteuri'";
								$pluginBody .= " style='display:block;'>";
								$pluginBody .= "<a href='./positlog.cgi?load=" . $pageid . "&amp;id=" . $spriteID . "'>link</a>";
								$pluginBody .= "</span>\n";
						}

						$pluginBody .= "</div>\n";
						$pluginBody .= "</div>\n";

						$spriteCounter++;

						$idContents{$spriteID} = $pluginBody;
				}
    }
    elsif($pluginType eq "replace" || $pluginType eq "alias")
    {
				foreach my $sprite (@$spritesArray) {
						my $modtime = $sprite->{"time"};
						$spritesHash->{$parentID}{"modified_time"} = $modtime;
						$pluginBody = $sprite->{"body"};
						$idContents{$sprite->{"id"}} = $pluginBody;
				}
    }
    elsif($pluginType eq "createarranged")
    {
				# sprites are created and arranged by plugin

				# sort by date
				my $prevSprite = "";
				my $margin_p = 20;
				foreach my $sprite (@$spritesArray) {
						my $modtime = $sprite->{"time"};
						my $myID = $sprite->{"id"};
						my $myParent = $sprite->{"parent"};
						my $pos = $sprite->{"position"};
						my $p_pixel = $sprite->{"p_pixel"};
						my $elder = $sprite->{"elder"};
						my $s_pixel = $sprite->{"s_pixel"};

						$pluginBody = $sprite->{"body"};

						$idContents{$myID} = $pluginBody;

						$spritesHash->{$myID}{"author"}	=	$spritesHash->{$parentID}{"author"};
						$spritesHash->{$myID}{"author_name"} = getAuthorName($spritesHash->{$parentID}{"author"}, $spritesHash->{$parentID}{"public_author"}, $spritesHash->{$parentID}{"public_password"});
						$spritesHash->{$myID}{"modified_time"} = $modtime;

						$spritesHash->{$myID}{"margin_s"}{"elder"} = $elder;
						$spritesHash->{$myID}{"margin_s"}{"pixel"} = $s_pixel;

						if($myParent eq ""){
								$spritesHash->{$myID}{"parent"} = $parentID;
								$spritesHash->{$myID}{"margin_p"}{"position"} = "BT";
								$spritesHash->{$myID}{"margin_p"}{"pixel"} = $margin_p;
								$spritesHash->{$myID}{"margin_s"}{"pixel"} = $s_pixel;

								$margin_p = scalar($margin_p) + 1;

								if($spritesHash->{$parentID}{"children"} && $spritesHash->{$parentID}{"children"} ne ""){
										my @children = @{$spritesHash->{$parentID}{"children"}};
										my $isExist = first {$_ eq $myID} @children;
										if(!defined $isExist){
												push(@children, $myID);
												$spritesHash->{$parentID}{"children"} = \@children;
										}
								}
								else{
										my @children;
										push(@children, $myID);
										$spritesHash->{$parentID}{"children"} = \@children;
								}

						
								if($prevSprite ne ""){
										$spritesHash->{$myID}{"margin_s"}{"elder"} = $prevSprite;
										$spritesHash->{$myID}{"margin_s"}{"pixel"} = $s_pixel;
								}
								else{
										$spritesHash->{$myID}{"margin_s"}{"elder"} = "";
								}
								$prevSprite = $myID;
						}
						else{
								$spritesHash->{$myID}{"parent"} = $myParent;
								$spritesHash->{$myID}{"margin_p"}{"position"} = $pos;
								$spritesHash->{$myID}{"margin_p"}{"pixel"} = $p_pixel;

								if($spritesHash->{$myParent}{"children"} && $spritesHash->{$myParent}{"children"} ne ""){
										my @children = @{$spritesHash->{$myParent}{"children"}};
										my $isExist = first {$_ eq $myID} @children;
										if(!defined $isExist){
												push(@children, $myID);
												$spritesHash->{$myParent}{"children"} = \@children;
										}
								}
								else{
										my @children;
										push(@children, $myID);
										$spritesHash->{$myParent}{"children"} = \@children;
								}
						}

				}

    }

		\%idContents;
}


sub getAuthorName
{
		my($author_id,$public_author,$public_password) = @_;

		my $authorName = "[public]";
		if($author_id eq "admin"){
				$authorName = "admin";
		}
		else{
				if($author_id eq "public"){
						if($public_password eq ""){
								if($public_author eq "" || $public_author eq "public"){
										$authorName = "[public]";
								}
								else{
										$authorName = '[' . $public_author . ']';
								}
						}
						else{
								if($public_author eq "" || $public_author eq "public"){
										$authorName = "&lt;public&gt;";
								}
								else{
										$authorName = '&lt;' . $public_author . '&gt;';
								}
						}
				}
				else{
						my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")};
						if($@){ warn $@; exit(0);}

						if($useridAuth->{$author_id}{"nickname"} ne ""){
								$authorName = $useridAuth->{$author_id}{"nickname"};
						}
						else{
								$authorName = "emanon";
						}
				}
		}
		return $authorName;
}

#################################################
## getContents generates contents of a sprite. 
## $spritetype allows 
##  Substance, DynamicAlias or Alias
#################################################
sub getContents
{
		my($self, $skeltonid, $displayid, $substanceid, $spritetype) = @_;
		
		my $pageid = $self->{pageid};
		my $className = $self->{classname};
		my $valueContentsStyle = $self->{pageSpritesHash}{$skeltonid}{"contents_style"};
		my $author_id = $self->{pageSpritesHash}{$skeltonid}{"author_id"};
		my $modified_time = $self->{pageSpritesHash}{$skeltonid}{"modified_time"};
		my $created_time = $self->{pageSpritesHash}{$skeltonid}{"created_time"};
		my $display_created_time = $self->{pageSpritesHash}{$skeltonid}{"display_created_time"};
		my $display_author = $self->{pageSpritesHash}{$skeltonid}{"display_author"};
		my $display_positlink = $self->{pageSpritesHash}{$skeltonid}{"display_positlink"};
		my $sprite_plugin = $self->{pageSpritesHash}{$skeltonid}{"plugin"};
		my $valueStyle = $self->{pageSpritesHash}{$skeltonid}{"style"};

		# get position
		$valueStyle =~ /top:(-?\d+?)px/is;
		my $spritetop = $1;
		$valueStyle =~ /left:(-?\d+?)px/is;
		my $spriteleft = $1;
		$valueStyle =~ /z-index:(-?\d+?);/is;
		my $spriteZindex = $1;

		# get author name
		my $authorName = getAuthorName($author_id, $self->{pageSpritesHash}{$skeltonid}{"public_author"}, $self->{pageSpritesHash}{$skeltonid}{"public_password"});

		# temporal author_name data for exporting to JavaScript
		$self->{pageSpritesHash}{$skeltonid}{"author_name"} = $authorName;

		# get contents
		my $spriteContents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/static/" . $skeltonid .".spr")} or "";

		my $staticContents;

		if($spriteContents ne "" || ($self->{replaceContents}{$skeltonid} && $self->{replaceContents}{$skeltonid} ne "")){
				$staticContents .= "<li class='" . $className . "' id='" . $displayid . "' ";
				$staticContents .= "style='" . $valueStyle . "'>";
				$staticContents .= "<div class='spriteregion'>";
				$staticContents .= "<div class='spritecontents' style='" . $valueContentsStyle . "'>";
				if($self->{replaceContents}{$skeltonid} && $self->{replaceContents}{$skeltonid} ne ""){
#						my $utf8Contents = $self->{replaceContents}{$skeltonid};
#						utf8::decode($utf8Contents);
						$staticContents .= $self->{replaceContents}{$skeltonid};
#						$staticContents .= $utf8Contents;
				}
				else{
						my $utf8Contents = $$spriteContents;
						utf8::decode($utf8Contents);
						$staticContents .= $utf8Contents;
				}
				$staticContents .= "</div>\n";

				$staticContents .= "<div class='spriteinfo'>";
				$staticContents .= "<span class='iemagic'> </span>"; # need space for IE

				$staticContents .= "<span class='spriteplugin'";
				$staticContents .= " style='display:none;'>";
				utf8::decode($sprite_plugin);
				$staticContents .= $sprite_plugin;
				$staticContents .= "</span>\n";

				if(scalar($display_author) == 1)
				{
						$staticContents .= "<span class='spriteauthor'";
						$staticContents .= " style='display:block;'>";
						utf8::decode($authorName);
						$staticContents .= $authorName;
						$staticContents .= "</span>\n";
				}

				if(scalar($display_created_time) == 1)
				{
						$staticContents .= "<span class='spritedate'";
						$staticContents .= " style='display:block;'>";
						$modified_time =~ /^(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)$/i;
						my $timeStr = "";
						if($modified_time ne "")
						{
								$timeStr = $1 . "/" . $2 . "/" . $3 . " " . $4 . ":" . $5 . ":" .$6;
						}
						$staticContents .= $timeStr;
						$staticContents .= "</span>\n";
				}

				if(scalar($display_positlink) == 1)
				{
						$staticContents .= "<span class='spriteuri'";
						$staticContents .= " style='display:block;'>";

						my $linkStr = "";
						if($spritetype eq "Substance"){
								$linkStr = "<a href='./positlog.cgi?load=" . $pageid . "&amp;id=" . $skeltonid . "'>link</a>";
						}
						elsif($spritetype eq "Alias"){
								$linkStr = "<a href='./positlog.cgi?load=" . $self->{srcpageid} . "&amp;id=" . $substanceid . "'>src</a>&nbsp;&nbsp;<a href='./positlog.cgi?load=" . $pageid . "&amp;id=" . $displayid . "'>link</a>";
						}
						elsif($spritetype eq "DynamicAlias"){
								$linkStr = "<a href='./positlog.cgi?load=" . $pageid . "&amp;id=" . $skeltonid . "'>src</a>";
						}

						$staticContents .= $linkStr;
						$staticContents .= "</span>\n";
				}

				$staticContents .= "</div>\n";
				$staticContents .= "</div>\n";
		}

		return $staticContents;
}


################################################
## createSpriteTree builds a tree of sprites ###
################################################
sub createSpriteTree
{
		my($self, $rootID) = @_;

		my $treeBody = "";
		if($self->{createContents}{$rootID} && $self->{createContents}{$rootID} ne ""){
				# This is the sprite created by plugin
				$treeBody = $self->{createContents}{$rootID};
		}
		else{
				my $spritetype = "Substance";
				my $substanceID = $rootID;
				my $sprite_plugin = $self->{pageSpritesHash}{$rootID}{"plugin"};
				if ($sprite_plugin && $sprite_plugin ne "") {
						if ($sprite_plugin =~ /^(.+?),(.+?);(.+?)$/is) {
								my $pluginName = $1;
								my $pluginOption = $2;
								if ($pluginOption =~ /^(.+?),(.+?)$/is) {
										my $pluginType = eval 'use ' . "PositLogPlugin::" . $pluginName .';' . "PositLogPlugin::" . $pluginName . q/::getType()/;
										if ($pluginType eq "alias") {
												$spritetype = "Alias";
												$substanceID = $2;
												$self->{srcpageid} = $1;
										}
								}
						}
				}
	
				$treeBody = getContents($self, $rootID, $rootID, $substanceID, $spritetype);
		}

		if($treeBody ne ""){
				$self->{spriteshash}{$rootID} = $self->{pageSpritesHash}{$rootID};
				if($self->{pageSpritesHash}{$rootID}{"children"} && $self->{pageSpritesHash}{$rootID}{"children"} ne ""){
						$treeBody .= "<ul class='parent'>";
						my @children = @{$self->{pageSpritesHash}{$rootID}{"children"}};
						foreach my $sortedID (sort {$self->{idPosition}->{$a} <=> $self->{idPosition}->{$b}} @children) {
								$treeBody .= createSpriteTree($self, $sortedID);
						}
						$treeBody .= "</ul>";
				}

				$treeBody .= "</li>";
		}
		return $treeBody;
}



##########################################
## generateSprites()
## $max : maximum number of generating trees
## $order : unimplemented
## $filter : uninplemented
##########################################
sub generateSprites
{
    my ($self, $pageid, $loginid, $loginpass, $classname, $max, $order, $filter) = @_;
		$self->{pageid} = $pageid;
		$self->{loginid} = $loginid;
		$self->{loginpass} = $loginpass;
		$self->{classname} = $classname;
		$self->{max} = $max;

		$self->{pageSpritesHash} = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $self->{pageid} . "/sprites.dat")} or {};
		if($self->{pageSpritesHash} eq "") {
				print "Cannot read the sprite list.\n";
				return "";
		}

		my @rootIDs;
		my $BODY = "";
		my $CSSHEADER = "";

		# extract root sprites
		foreach my $keyID (keys %{$self->{pageSpritesHash}}) {
				my $type = $self->{pageSpritesHash}{$keyID}{"type"};
				if($type eq "dynamic")
				{
				  my $psourceid = $self->{pageSpritesHash}{$keyID}{"plugin_source"};
				  if(!exists($self->{pageSpritesHash}{$psourceid})){
				    delete $self->{pageSpritesHash}{$keyID};
				    if(!eval{Storable::lock_nstore $self->{pageSpritesHash}, $PositLogConfig::datapath . $self->{pageid} . "/sprites.dat"}){ print "Cannot write the sprite list."; exit(0); }
				    unlink $PositLogConfig::datapath . $self->{pageid} . "/static/" . $keyID.".spr";
				  }
						next;
				}

				if(!($self->{pageSpritesHash}{$keyID}{"parent"} && $self->{pageSpritesHash}{$keyID}{"parent"} ne "")){
						push(@rootIDs, $keyID);
				}

				my $valueStyle = $self->{pageSpritesHash}{$keyID}{"style"};
				$valueStyle =~ /top:(-?\d+?)px/is;
				my $spritetop = $1;
				$valueStyle =~ /left:(-?\d+?)px/is;
				my $spriteleft = $1;
				my $spriteposition = sprintf("%010d:%010d", $spritetop, $spriteleft);
				# idPosition is used for sorting <li>s by position
				$self->{idPosition}{$keyID} = $spriteposition;

				my $sprite_plugin = $self->{pageSpritesHash}{$keyID}{"plugin"};
				# check plugin
				my $pluginName = "";
				my $pluginOption = "";
				my $idPlugincontents = "";
				my $pluginType = "";
				my $spritesArray = "";
				my $template = "";
				$sprite_plugin =~ s/&amp;/&/gis;
				if($sprite_plugin =~ /^(.+?),(.+?);(.+?)$/is)
				{
						$pluginName = $1;
						$pluginOption = $2;
						$template = $3;
						utf8::decode($template);
						# import dynamic sprites
						if (-f "./PositLogPlugin/" . $pluginName . ".pm")
						{
								# load plugin
								my $author_id = $self->{pageSpritesHash}{$keyID}{"author_id"};
								my $authorName = getAuthorName($author_id, $self->{pageSpritesHash}{$keyID}{"public_author"}, $self->{pageSpritesHash}{$keyID}{"public_password"});
								
								$idPlugincontents = &importDynamicSprites($self, $pluginName, $keyID, $authorName, $pluginOption);
								# add related CSS
								my $cssfile = eval 'use ' . "PositLogPlugin::" . $pluginName .';' . "PositLogPlugin::" . $pluginName . q/::getCSS()/;
								if($cssfile ne ""){
										$CSSHEADER .= "		<link rel='stylesheet' href='" .  $PositLogConfig::systempath . $cssfile ."' type='text/css'>\n";
								}
								$pluginType = eval 'use ' . "PositLogPlugin::" . $pluginName .';' . "PositLogPlugin::" . $pluginName . q/::getType()/;
								
								if($pluginType eq "create"){
										# generate new sprites
										foreach my $tmpID (keys %$idPlugincontents){
												my $utf8Contents = $idPlugincontents->{$tmpID};
												utf8::decode($utf8Contents);
												$self->{createContents}{$tmpID} = $utf8Contents;
#												$self->{createContents}{$tmpID} = $idPlugincontents->{$tmpID};
												$self->{pageSpritesHash}->{$tmpID}{"author_name"} = $authorName;
												if(!($self->{pageSpritesHash}{$tmpID}{"parent"} && $self->{pageSpritesHash}{$tmpID}{"parent"} ne "")){
														push(@rootIDs, $tmpID);
												}
										}
										my $dynamicContents = $template;
										$dynamicContents =~ s/\[\[plugin\]\]//gis;
										$self->{replaceContents}{$keyID} = $dynamicContents;                                                                                                                                    
								}
								elsif($pluginType eq "createarranged"){
										my $pluginContents = "";
										foreach my $tmpID (keys %$idPlugincontents) {
												my $utf8Contents = $idPlugincontents->{$tmpID};
												utf8::decode($utf8Contents);
												$self->{createContents}{$tmpID} = $utf8Contents;
#												$self->{createContents}{$tmpID} = $idPlugincontents->{$tmpID};
												if(!($self->{pageSpritesHash}{$tmpID}{"parent"} && $self->{pageSpritesHash}{$tmpID}{"parent"} ne "")){
														push(@rootIDs, $tmpID);
												}
										}

										my $dynamicContents = $template;
										$dynamicContents =~ s/\[\[plugin\]\]//gis;
										$self->{replaceContents}{$keyID} = $dynamicContents;
								}
								elsif($pluginType eq "replace" || $pluginType eq "alias"){
										# replace the contents of this sprite by plugin contents
										my $dynamicContents = "";
										my $pluginContents = "";
										foreach my $value (values %$idPlugincontents) {
												$pluginContents = $value;
										}
										my $utf8Contents = $pluginContents;
										utf8::decode($utf8Contents);
										$dynamicContents = $template;
#										$dynamicContents =~ s/\[\[plugin\]\]/$pluginContents/gis;
										$dynamicContents =~ s/\[\[plugin\]\]/$utf8Contents/gis;
										$self->{replaceContents}{$keyID} = $dynamicContents;
								}
						}
				}

		}

		my $counter = 0;
		foreach my $sortedID (sort {$self->{idPosition}{$a} <=> $self->{idPosition}{$b}} @rootIDs){
				if(scalar($self->{max}) == -1 || $counter < scalar($self->{max})){
						$BODY .= createSpriteTree($self, $sortedID);
				}
				if(scalar($self->{max}) != -1){
						$counter = $counter+1;
				}
		}

		$self->{spriteshtml} = \$BODY;
		$self->{spritescss} = \$CSSHEADER;
}

sub getHash{
		my $self = shift;
		return $self->{spriteshash};
}

sub getCss{
		my $self = shift;
		return $self->{spritescss};
}

sub getHtml{
		my $self = shift;
		return $self->{spriteshtml};
}

sub new{
		my $pkg = shift;
		my $hash= {
				pageid   => undef,
				loginid => undef,
				loginpass => undef,
				classname => undef,
				max => undef,
				order => undef,
				filter => undef,

				srcpageid   => undef,

				idPosition => {},
				createContents => {},
				replaceContents => {},
				pageSpritesHash => {},

				spriteshtml => undef,
				spriteshash => {},
				spritescss => undef
		};
		bless $hash,$pkg;
}



1;




