package PositLogPlugin::RecentSprites;

# --------------------------------------------------------
# RecentSprites.pm:
#      module for showing recent sprite groups on the page
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

use strict;
use Time::Local;
use Storable qw(lock_retrieve lock_nstore);
use Encode qw/encode decode/;
use PositLogConfig;
use PositLogSprites;
use PositLogAuth;

my $serializedData = "recentsprites_oldsprites";

my $dstSpritesHash = "";
my $srcSpritesHash = "";

my $oldSpritesHash = "";
my %newSpritesHash = {};

my @spritesArray;

my $pluginSpriteID = "";
my $dstpageid = "";
my $margin = 20;

sub getWidth{
    return 320;
}

sub getCSS{
    return "recent_sprites_contents.css";
}

sub getType{
    return "createarranged";
}


sub clearCache{
    return "No cache.";
}


sub getSprites{
    my ($pageid_, $pluginSpriteID_, $loginid, $loginpass, $args) = @_;
    
    $dstpageid = $pageid_;
    $pluginSpriteID = $pluginSpriteID_;
    my @argsArray = split(/,/, $args);
    my $srcpageid = $argsArray[0];

    # Check page group
		if($srcpageid =~ /^pg/){
				my $pgHash = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "pagegroup_" . $srcpageid . ".cgi")} or {};
				my $latestpid = "";
				my $latesttime = 0;
				foreach my $pid (keys %{$pgHash}){
						my $cHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/config.dat")} or {};
						if($latesttime < scalar($cHash->{"created_time"})){
								$latesttime = scalar($cHash->{"created_time"});
								$latestpid = $pid;
						}
				}
				if($latestpid ne ""){
						$srcpageid = $latestpid;
				}
		}

    my $maxnumber = $argsArray[1];

    if(scalar(@argsArray) >= 3)
    {
				$margin = $argsArray[2];
    }

		# Authentication
		PositLogAuth::authenticateUser($loginid, $loginpass);
		if(!(PositLogAuth::isValidUser ||	PositLogAuth::isPublicUser)){
				return \@spritesArray;
		}
		PositLogAuth::authenticateReadPage($srcpageid, $loginid);
    if (PositLogAuth::canReadPage == 0) {
				return \@spritesArray;
    }

    my $counter = 0;

    # Get sprites
    $dstSpritesHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $dstpageid . "/sprites.dat")};
    if ($@) {	warn $@; print "Cannot read the sprite list.\n"; return \@spritesArray; }

    $srcSpritesHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $srcpageid . "/sprites.dat")};
    if ($@) {	warn $@; print "Cannot read the sprite list.\n"; return \@spritesArray; }

		# $oldSpritesHash is used to delete unused data
    $oldSpritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $dstpageid . "/dynamic/" . $serializedData.$pluginSpriteID.".dat")} or {};

    my $newContents = "";

    # Select root sprites from sourcepage
    my @rootIDs;
    my $counter = 0;
    foreach my $keyID (sort {$srcSpritesHash->{$b}{"modified_time"} <=> $srcSpritesHash->{$a}{"modified_time"}} (keys %$srcSpritesHash)) {
				my $sprite_plugin = $srcSpritesHash->{$keyID}{"plugin"};
				if ($sprite_plugin && $sprite_plugin ne "") {
						if ($sprite_plugin =~ /^(.+?),(.+?);(.+?)$/is) {
								my $pluginName = $1;
								my $pluginType = eval 'use ' . "PositLogPlugin::" . $pluginName .';' . "PositLogPlugin::" . $pluginName . q/::getType()/;
								if ($pluginType eq "replace") {
										next;
								}
						}
				}

				my $parent = $srcSpritesHash->{$keyID}{"parent"};
				my $topID = $keyID;
				while ($parent && $parent ne "") {
						$topID = $parent;
						$parent = $srcSpritesHash->{$parent}{"parent"};
				}

				if ((grep {$_ eq $topID} @rootIDs) == 0) {
						if ($counter < scalar($maxnumber)) {
								my $valueStyle = $dstSpritesHash->{$pluginSpriteID}{"style"};
								# get position
								$valueStyle =~ /left:(-*\d+)px/is;
								#								my $parentleft = $1;
								my $parentleft = 0;

								my $parent = $dstSpritesHash->{$pluginSpriteID}{"parent"};
								while ($parent && $parent ne "") {
										my $valueStyle = $dstSpritesHash->{$parent}{"style"};
										# get position
										$valueStyle =~ /left:(-*\d+)px/is;
										#										my $pleft = $1;
										my $pleft = 0;
										$parentleft += scalar($pleft);
										$parent = $dstSpritesHash->{$parent}{"parent"};
								}

								createSpriteTree("", $topID, $srcpageid, $parentleft);

								$counter = $counter+1;
						}
						if ($counter >= scalar($maxnumber)) {
								last;
						}
						push(@rootIDs, $topID);
				}
    }

    foreach my $sid (keys %$oldSpritesHash){
				unlink $PositLogConfig::datapath . $dstpageid . "/static/" . $oldSpritesHash->{$sid}.".spr";
				delete $oldSpritesHash->{$sid};
    }
    if (!eval{Storable::lock_nstore $dstSpritesHash, $PositLogConfig::datapath . $dstpageid . "/sprites.dat"}) {
				print "Cannot write the sprite list."; exit(0);
    }
    if (!eval{Storable::lock_nstore \%newSpritesHash, $PositLogConfig::datapath . $dstpageid . "/dynamic/" . $serializedData.$pluginSpriteID.".dat";}) {
				warn "RecentSprites.pm: Cannot write hash data\n"; return "";
    }

    return \@spritesArray;
}

sub createSpriteTree
{
    my($parentID, $targetID, $srcpageid, $pleft) = @_;
    my %replaceContents;

		# Calculate left position
    my $valueStyle = $srcSpritesHash->{$targetID}{"style"};
    $valueStyle =~ /left:(-*\d+)px/is;
    my $left = scalar($1);
    if ($parentID ne "") {
				$left = $left + scalar($pleft);
    }
    my $maxleft = $left;

    if ($srcSpritesHash->{$targetID}{"children"} && $srcSpritesHash->{$targetID}{"children"} ne "" && @{$srcSpritesHash->{$targetID}{"children"}}) {
				#----------------------
				# has children
				#----------------------
				my @children = @{$srcSpritesHash->{$targetID}{"children"}};
				foreach my $childid (@children) {
						my $childleft = createSpriteTree($targetID, $childid, $srcpageid, $left);
						if ($maxleft > $childleft) {
								$maxleft = $childleft;
						}
				}

				my $pos = $srcSpritesHash->{$targetID}{"margin_p"}{"position"};
				my $p_pixel = $srcSpritesHash->{$targetID}{"margin_p"}{"pixel"};
				my $elder = $pluginSpriteID . "_alias_" . $srcSpritesHash->{$targetID}{"margin_s"}{"elder"};
				my $s_pixel = $srcSpritesHash->{$targetID}{"margin_s"}{"pixel"};
				my $modtime = $srcSpritesHash->{$targetID}{"modified_time"};

				my $aliassid = $pluginSpriteID . "_alias_" . $targetID;

				if ($parentID eq "") {
						# get position
						$valueStyle =~ /top:(-?\d+?)px/is;
						my $spritetop = $1;
						$valueStyle =~ /z-index:(-?\d+?);/is;
						my $spriteZindex = $1;
						$valueStyle =~ /width:(\d+?)px;/is;
						my $spriteWidth = $1;
						
						my $newleft = - ($maxleft - $left) + $pleft;

						# This change is saved.
						$dstSpritesHash->{$aliassid}{"style"} = "left:" . $newleft . "px; top:" . $spritetop . "px; width:" . $spriteWidth . "px; z-index:" . $spriteZindex . ";";

						# This change is temporal.
						$srcSpritesHash->{$targetID}{"style"} = "left:" . $newleft . "px; top:" . $spritetop . "px; width:" . $spriteWidth . "px; z-index:" . $spriteZindex . ";";

						$s_pixel = $margin;

				} else {
						$parentID = $pluginSpriteID . "_alias_" . $parentID;
				}


				my $spritesObj = PositLogSprites->new();
				$spritesObj->{pageid} = $srcpageid;
				$spritesObj->{classname} = "sprite";
				$spritesObj->{pageSpritesHash} = $srcSpritesHash;
				my $body = PositLogSprites::getContents($spritesObj, $targetID, $aliassid, $targetID, "DynamicAlias");
#				push(@spritesArray, {"time" => $recenttime, "id" => $aliassid, "parent" => $parentID, "position" => $pos, "p_pixel" => $p_pixel, "elder" => $elder, "s_pixel" => $s_pixel, "body" => $body});
				push(@spritesArray, {"time" => $modtime, "id" => $aliassid, "parent" => $parentID, "position" => $pos, "p_pixel" => $p_pixel, "elder" => $elder, "s_pixel" => $s_pixel, "body" => $body});

				
				if ($oldSpritesHash ne "" && exists($oldSpritesHash->{$targetID})) {
						# spriteID already exists
						delete $oldSpritesHash->{$targetID};
				}
				$newSpritesHash{$targetID} = $aliassid;

				if($dstSpritesHash->{$aliassid}{"modified_time"} < $srcSpritesHash->{$targetID}{"modified_time"}){
						# save sprite
						$dstSpritesHash->{$aliassid}{"type"} = "dynamic";
						$dstSpritesHash->{$aliassid}{"plugin_source"} = $pluginSpriteID;
						my $spriteContents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $srcpageid . "/static/" . $targetID.".spr")} or "";
						if (!eval{Storable::lock_nstore $spriteContents, $PositLogConfig::datapath . $dstpageid . "/static/" . $aliassid.".spr"}) {
								print "Cannot write .spr.";
						}
						$dstSpritesHash->{$aliassid}{"created_time"} = $srcSpritesHash->{$targetID}{"created_time"};
						$dstSpritesHash->{$aliassid}{"modified_time"} = $srcSpritesHash->{$targetID}{"modified_time"};
				}
				return $maxleft;


    } else {
				#----------------------
				# has no children
				#----------------------

				my $recenttime = $srcSpritesHash->{$targetID}{"modified_time"};

				my $aliassid = $pluginSpriteID . "_alias_" . $targetID;
				if ($oldSpritesHash ne "" && exists($oldSpritesHash->{$targetID})) {
						# spriteID already exists
						delete $oldSpritesHash->{$targetID};
				}
				$newSpritesHash{$targetID} = $aliassid;

				my $pos = $srcSpritesHash->{$targetID}{"margin_p"}{"position"};
				my $p_pixel = $srcSpritesHash->{$targetID}{"margin_p"}{"pixel"};
				my $elder = $pluginSpriteID . "_alias_" . $srcSpritesHash->{$targetID}{"margin_s"}{"elder"};
				my $s_pixel = $srcSpritesHash->{$targetID}{"margin_s"}{"pixel"};

				if ($parentID eq "") {
						my $valueStyle = $srcSpritesHash->{$targetID}{"style"};
						# get position
						$valueStyle =~ /top:(-*\d+)px/is;
						my $spritetop = $1;
						$valueStyle =~ /z-index:(-*\d+?);/is;
						my $spriteZindex = $1;
						$valueStyle =~ /width:(\d+?)px;/is;
						my $spriteWidth = $1;

						# This change is saved.
						$dstSpritesHash->{$aliassid}{"style"} = "left:" . $pleft . "px; top:" . $spritetop . "px; width:" . $spriteWidth . "px; z-index:" . $spriteZindex . ";";

						# This change is temporal.
						$srcSpritesHash->{$targetID}{"style"} = "left:" . $pleft . "px; top:" . $spritetop . "px; width:" . $spriteWidth . "px; z-index:" . $spriteZindex . ";";

						$s_pixel = $margin;

				} else {
						$parentID = $pluginSpriteID . "_alias_" . $parentID;
				}

				my $spritesObj = PositLogSprites->new();
				$spritesObj->{pageid} = $srcpageid;
				$spritesObj->{classname} = "sprite";
				$spritesObj->{pageSpritesHash} = $srcSpritesHash;
				my $body = PositLogSprites::getContents($spritesObj, $targetID, $aliassid, $targetID, "DynamicAlias");
				push(@spritesArray, {"time" => $recenttime, "id" => $aliassid, "parent" => $parentID, "position" => $pos, "p_pixel" => $p_pixel, "elder" => $elder, "s_pixel" => $s_pixel, "body" => $body});

				if($dstSpritesHash->{$aliassid}{"modified_time"} < $srcSpritesHash->{$targetID}{"modified_time"}){
						# save sprite
						$dstSpritesHash->{$aliassid}{"type"} = "dynamic";
						$dstSpritesHash->{$aliassid}{"plugin_source"} = $pluginSpriteID;
						my $spriteContents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $srcpageid . "/static/" . $targetID.".spr")} or "";
						if (!eval{Storable::lock_nstore $spriteContents, $PositLogConfig::datapath . $dstpageid . "/static/" . $aliassid.".spr"}) {
								print "Cannot write .spr.";
						}
						$dstSpritesHash->{$aliassid}{"created_time"} = $srcSpritesHash->{$targetID}{"created_time"};
						$dstSpritesHash->{$aliassid}{"modified_time"} = $srcSpritesHash->{$targetID}{"modified_time"};
				}

				return $maxleft;
    }
}



1;
