package PositLogPlugin::HatenaAntenna;

# --------------------------------------------------------
# HatenaAntenna.pm:
#      module for retrieving PositLog dynamic sprites
#      from Hatena Antenna
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp>
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This perl module generate new srprites from HatenaAntenna
# --------------------------------------------------------

use strict;
use HTTP::Lite;			# must be locally installed
use Time::Local;
use Storable qw(lock_retrieve lock_nstore);
use Encode qw/encode decode/;
use PositLogConfig;

# prefix of hash file (url, spriteID)
my $serializedData = "ha_url_spriteid_";

sub getWidth{
		return 150;
}

sub getCSS{
		return "hatena_antenna_contents.css";
}

sub getType{
		return "create";
}

sub clearCache{
    my ($pageid, $sourceID, $args) = @_;
    my @argsArray = split(/,/, $args);
    my $rssurl = $argsArray[0];
    if($rssurl eq "" || $rssurl !~ /^http/){ return "RSS error."; }
    my $rssurlenc = $rssurl;
    $rssurlenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
    $rssurlenc =~ tr/ /+/;

    my $urlSpriteid = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/dynamic/" . $serializedData.$rssurlenc.".dat")} or {};

		if($urlSpriteid eq ""){
				return "No cache."
		}
    delete $urlSpriteid->{"modified_time"};
    delete $urlSpriteid->{"rss"};

		if(!eval{Storable::lock_nstore $urlSpriteid, $PositLogConfig::datapath . $pageid . "/dynamic/" . $serializedData.$rssurlenc.".dat";}){ return "Save error."; }

		return "Succeed.";
}

sub getSprites{
    # get (URL of RSS)
    my ($pageid, $sourceID, $loginid, $loginpass, $args) = @_;
    my @argsArray = split(/,/, $args);

    my @spritesArray;

    my $rssurl = $argsArray[0];
    my $spritecolor = "#ffc0b0";
    if(scalar(@argsArray) >= 2){
				$spritecolor = $argsArray[1];
    }
    
    if($rssurl eq "" || $rssurl !~ /^http/){ return \@spritesArray; }

    my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")};
    if($@){ warn $@; return \@spritesArray; }

    # URL encoding for serialized data file name
    my $rssurlenc = $rssurl;
    $rssurlenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
    $rssurlenc =~ tr/ /+/;

    # retrieve rss file

    # success flag for retrieving RSS
    my $httpsuccess = 1;

    # get dynamic sprite table
    my $urlSpriteid = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/dynamic/" . $serializedData.$rssurlenc.".dat")} or {};

		# rss file
		my $rss = "";
		my $cache = 0;


    # Check HTTP Status code 304
    if (exists($urlSpriteid->{"modified_time"})){
				my $modifiedtime = $urlSpriteid->{"modified_time"};
				$modifiedtime =~ /(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/;
				my $sec = $6;	my $min = $5; 	my $hour = $4; 	my $mday = $3; 	my $mon = $2; 	my $year = $1;
				my $modifiedtimeStr = $year . "/" . $mon . "/" . $mday . " " . $hour . ":" . $min . ":" . $sec;
				$sec =~ s/0(\d)/$1/;
				$min =~ s/0(\d)/$1/;
				$hour =~ s/0(\d)/$1/;
				$mday =~ s/0(\d)/$1/;
				$mon =~ s/0(\d)/$1/;
				my $time = timelocal(scalar($sec), scalar($min), scalar($hour), scalar($mday), scalar($mon) - 1, scalar($year));
				my @DoW = qw(Sun Mon Tue Wed Thu Fri Sat);
				my @MoY = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
				my %MonHash = ("Jan" => 1, "Feb" => 2, "Mar" => 3, "Apr" => 4, "May" => 5, "Jun" => 6, "Jul" => 7,  "Aug" => 8,  "Sep" => 9, "Oct" => 10,  "Nov" => 11, "Dec" => 12);
				my ($sec, $min, $hour, $mday, $mon, $year, $wday) = gmtime($time);
				my $modifiedHTTPdate = sprintf("%s, %02d %s %04d %02d:%02d:%02d GMT",
																			 $DoW[$wday],
																			 $mday, $MoY[$mon], $year+1900,
																			 $hour, $min, $sec);
				my $http = new HTTP::Lite;

				$http->add_req_header('If-Modified-Since', $modifiedHTTPdate);

				# HEAD request
				$http->method('GET');
				my $req = $http->request($rssurl) or $httpsuccess = 0;
				if($httpsuccess == 0){
						warn "HatenaAntenna.pm: HTTP request error!\n";
						return \@spritesArray;
				}

				# check Not Modified
				# check Not Modified or Serve error
				if($req =~ /304/gi || $req =~ /50\d/gi){
						# load cached rss
						$cache = 1;
						$rss = $urlSpriteid->{"rss"};
				}
				else{
						$rss =  $http->body();
				}

				if($rss eq ""){
						$cache = 0;
						$rss = $http->body();
				}
    }
		else{
				my $http = new HTTP::Lite;
				$http->method('GET');
				my $req = $http->request($rssurl) or $httpsuccess = 0;

				if($httpsuccess == 0){
						warn "HatenaAntenna.pm: HTTP request error!\n";
						return \@spritesArray;
				}
				$rss =  $http->body();
		}

		if($rss eq ""){
				warn "HatenaAntenna.pm: Invalid RSS\n";
				return \@spritesArray;
		}

    # -----------------------------------
    # get items from Hatena Antenna RSS
    # (using XML::RSS is more functional, 
    #  but needs installing perl module)
    # -----------------------------------

    # create associative array (url, modified date) 
    # %urlDate = ("URL", "date", ...);
    my %urlDate;

    # create associative array (url, item)
    # %urlItem = ("URL", "item", ...);
    my %urlItem;

    foreach my $item ($rss =~ /<item.*?>.*?<\/item>/gis) {
				$item =~ /<item rdf:about="(.*?)">/i;
				my $url = $1;

				# modify item in Hatena Antenna RSS

				$item =~ /<title>(.*?)<\/title>/i;
				my $title = $1;

				$item =~ /<dc:date>(.*?)<\/dc:date>/i;
				my $date = $1;
				$date =~ /(\d\d\d\d)-(\d\d)-(\d\d)T(\d\d):(\d\d):(\d\d)\+(.*?)/i;
				my $dateStr = "$1$2$3$4$5$6";

				$item =~ /<link>(.*?)<\/link>/i;
				my $link = $1;

				$item =~ /<description>(.*?)<\/description>/is;
				my $description = $1;

				# make short
				$description = decode("utf-8", $description);
#				my $len = length($description)/2;
				my $len = length($description);
				$description = substr($description, 0, $len);
				$description = encode("utf-8", $description);

				$item = "<div class='hatena_antenna_contents'><div class='title'><a href='$link'>$title</a></div>\n<div class='description'>$description</div></div>";

				$urlItem{$url} = $item;
				$urlDate{$url} = $dateStr;
    }


    # generate new spriteID if antenna configuration is modified
    my %newUrlSpriteid;

		if(!$cache){
				# change modified time
				my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
				my $modifiedtime = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
				$newUrlSpriteid{"modified_time"} = $modifiedtime;
				$newUrlSpriteid{"rss"} = $rss;
		}


    while ( (my $keyURL, my $valueItem) = each %urlItem ) {
				if ($urlSpriteid ne "" && exists($urlSpriteid->{$keyURL})){
						# spriteID for the rss item already exists
						my $sid = $urlSpriteid->{$keyURL};
						push(@spritesArray, {"modified_date" => $urlDate{$keyURL}, "id" => $sid, "body" => $valueItem});

						# save sprite
						if(!$cache){
								$spritesHash->{$sid}{"type"} = "dynamic";
								$spritesHash->{$sid}{"plugin_source"} = $sourceID;
#								if(!eval{Storable::lock_nstore \$valueItem, $PositLogConfig::datapath . $pageid . "/static/" . $sid.".spr"}) { print "Cannot write .spr."; return \@spritesArray; }
								$spritesHash->{$sid}{"modified_time"} = $urlDate{$keyURL};

								$newUrlSpriteid{$keyURL} = $sid;
						}
				}
				else{
						# generate new spriteID
						my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst);
						($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
						my $createtime = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
						my $newSpriteID = "";
						do{
								my $rand = int (rand(1000));
								$rand = sprintf("%03d", $rand);
								# id must start from alphabet in HTML4.01
								$newSpriteID = "sprite_" . $createtime . "_" . $rand;
						}while(exists($spritesHash->{$newSpriteID}));

						push(@spritesArray, {"modified_date" => $urlDate{$keyURL}, "id" => $newSpriteID, "body" => $valueItem});

						if(!$cache){
								$spritesHash->{$newSpriteID}{"type"} = "dynamic";
								$spritesHash->{$newSpriteID}{"plugin_source"} = $sourceID;
#								if(!eval{Storable::lock_nstore \$valueItem, $PositLogConfig::datapath . $pageid . "/static/" . $newSpriteID.".spr"}) { print "Cannot write .spr."; return \@spritesArray; }

								# use Antenna Date as created_time and modified_time
								$spritesHash->{$newSpriteID}{"created_time"} = $createtime;
								$spritesHash->{$newSpriteID}{"modified_time"} = $urlDate{$keyURL};

								$spritesHash->{$newSpriteID}{"style"} = "";
								$newUrlSpriteid{$keyURL} = $newSpriteID;
						}

				}
    }

		if(!$cache){
				# save spriteHash
				if(!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pageid . "/sprites.dat"}){ print "Cannot write sprites.dat."; return \@spritesArray; }

				# store new serialized "Hatena Antenna hash (url, spriteID)"
				if(!eval{Storable::lock_nstore \%newUrlSpriteid, $PositLogConfig::datapath . $pageid . "/dynamic/" . $serializedData.$rssurlenc.".dat";}){ warn "HatenaAntenna.pm: Cannot write hash data\n"; return ""; }
		}

    # current number of sprites
    my $spriteCounter = 0;

    # color
    $spritecolor =~ /\s*\#(\w\w)(\w\w)(\w\w)/i;
    my $red = hex(scalar($1));
    my $green = hex(scalar($2));
    my $blue = hex(scalar($3));
    my $newColor = "#ffffff";

    # sorting ...
		my @sortedArray;
    foreach my $sprite (sort {$b->{"modified_date"} cmp $a->{"modified_date"}} @spritesArray) {
				# overwrite contents
				my $revisedContents = $sprite->{"body"};

				if($spriteCounter == 0){
						$newColor = "rgb($red, $green, $blue);";
				}
				elsif($spriteCounter < 5){
						my $newRed = scalar($red) + int((256-scalar($red))/5);
						my $newGreen = scalar($green) + int((256-scalar($green))/5);
						my $newBlue = scalar($blue) + int((256-scalar($blue))/5);
						$newColor = "rgb($newRed, $newGreen, $newBlue);";
				}
				elsif($spriteCounter < 10){
						my $newRed = scalar($red) + int((256-scalar($red))*2/5);
						my $newGreen = scalar($green) + int((256-scalar($green))*2/5);
						my $newBlue = scalar($blue) + int((256-scalar($blue))*2/5);
						$newColor = "rgb($newRed, $newGreen, $newBlue);";
				}
				elsif($spriteCounter < 20){
						my $newRed = scalar($red) + int((256-scalar($red))*3/5);
						my $newGreen = scalar($green) + int((256-scalar($green))*3/5);
						my $newBlue = scalar($blue) + int((256-scalar($blue))*3/5);
						$newColor = "rgb($newRed, $newGreen, $newBlue);";
				}
				elsif($spriteCounter < 30){
						my $newRed = scalar($red) + int((256-scalar($red))*4/5);
						my $newGreen = scalar($green) + int((256-scalar($green))*4/5);
						my $newBlue = scalar($blue) + int((256-scalar($blue))*4/5);
						$newColor = "rgb($newRed, $newGreen, $newBlue);";
				}
				else{
						$newColor = "#ffffff";
				}
				
				$revisedContents =~ s/^(<div.*?>)(.*)<\/div>$/$1<div class="frame" style="background-color: $newColor">$2<\/div><\/div>/is;
				

				$sprite->{"body"} = $revisedContents;

				if(!eval{Storable::lock_nstore \$revisedContents, $PositLogConfig::datapath . $pageid . "/static/" . $sprite->{"id"} . ".spr"}) { print "Cannot write .spr."; return \@spritesArray; }

				push(@sortedArray, $sprite);

				$spriteCounter++;
    }

    return \@sortedArray;
}


1;
