package PositLogConfig;

#-----------------------------
# Global Configuration File
#-----------------------------

#-------------------------------------------------------------------
# 以下の設定において挙げる例は，次のようなサイト・ディレクトリ構成の場合について
# 記述しています．
# http://xxx.com/yyy/ があなたのサイトのルートURL
# http://xxx.com/yyy/positlog/ がPositLogのルートURL
# http://xxx.com/yyy/positlog/system/ がPositLogのシステムURL
#
# DocumentRoot/positlog/ がルートURLと対応するディレクトリ
# DocumentRoot/positlog/system/ がシステムURLと対応するディレクトリ
# DocumentRoot/positlog/pages/ がページデータ保存用ディレクトリ
# DocumentRoot/positlog/bgimages/ が背景画像保存用ディレクトリ
# DocumentRoot/admin/ が管理用データ保存用ディレクトリ
# （ここで，DocumentRootは，公開したいHTMLドキュメントを設置する
# 　ディレクトリへのパス．）
#
#-------------------------------------------------------------------

#-------------------------------------------------------------------
# PositLogのルートURL
#（おわりの"/"を省略しないでください）
# 例）http://xxx.com/yyy/positlog/

my $rooturl = "http://xxx.com/yyy/positlog/";

#-------------------------------------------------------------------
# PositLogのシステムURL
#（.css, .js, システム画像ファイルなど，systemフォルダ内の
#  ファイルをアップロードする先のディレクトリと対応するURLです）
#（おわりの"/"を省略しないでください）
# 例）http://xxx.com/yyy/positlog/system/
#

my $systemurl = "http://xxx.com/yyy/positlog/system/";

#-------------------------------------------------------------------
# ページデータ保存用ディレクトリ
# （ルートURLと対応するディレクトリからの相対パスで指定してください）
# （おわりの"/"を省略しないでください）
# 例) ./pages/

$datapath = "./pages/";

#-------------------------------------------------------------------
# 背景画像保存用ディレクトリ
# （ルートURLと対応するディレクトリからの相対パス，
# 　あるいはサーバのルートディレクトリからの絶対パスで指定してください）
# (おわりの"/"を省略しないでください)
# 相対パスの例) ./bgimages/
# 絶対パスの例) /var/www/html/positlog/bgimages/

$bgimagespath = "./bgimages/";

#-------------------------------------------------------------------
# 管理用データ保存用ディレクトリ
# Webからはアクセスできない位置に設定するのが理想です．
# （ルートURLと対応するディレクトリからの相対パス，
# 　あるいはサーバのルートディレクトリからの絶対パスで指定してください）
# (おわりの"/"を省略しないでください)
# 相対パスの例) ../admin/
# 絶対パスの例) /var/www/admin/

$adminpath = "../admin/";

#-------------------------------------------------------------------
# 添付ファイルの最大バイト数
# スプライトの添付ファイルとしてアップロード可能なファイルの
# 最大サイズを指定します．バイト数で指定してください．
# 例）100キロバイトの場合，$uploadmax = 102400;
# 1メガバイトの場合　$uploadmax = 1048576;

$uploadmax = 102400;

#-------------------------------------------------------------------
# 添付ファイルのセキュリティ
#
# PositLogを用いてアップロードした添付ファイルは，通常，
# URLさえ判っていれば，誰でもアクセスすることができます．
#
# アカウントをもつユーザ以外に添付ファイルが見えないようにするためには，
# $datapath に，外部からhttpプロトコルでアクセス出来ない場所を指定する
# 必要があります．
# この場合，ファイルアップロード機能を利用するには，次の手順でファイル
# ローダーを設置する必要があります．
#
# 1. まずmod_rewriteの利用できることが前提
# 2．以下のRewriteRuleを.htaccess 等に設定
#   (fileloader.cgiのパスは適当なものに変更してください)
#
#   RewriteRule ^(.*)([0-9]{6}[a-zA-Z]{2})(/images/.+)$ /fileloader.cgi?page=$2&path=$3 [L]
#   RewriteRule ^(.*)([0-9]{6}[a-zA-Z]{2})(/files/.+)$ /fileloader.cgi?page=$2&path=$3 [L]
#
# 3．fileloader.cgi を positlog.cgiと同じディレクトリに設置（755）
# 4．下の $filesecure の値を1にする．
#

$filesecure = 0;

# 以上でファイルアップロードが可能となります．ただし，ファイルへの
# アクセスがすべてCGIを経由するので若干遅くなります．
#
# 以上の設定が不可能なサーバの場合，または意味の判らない場合，
# $filesecure = 0 のままにしておいてください．
# この場合，アカウントをもつユーザ以外に見せたくないファイルのURLがばれない
# ように気をつけてください．あるいは，ページにBASIC 認証をつけてください．


# 設定が必要なのはここまでです．以下には手を加えないでください．

$language = "ja";

$rooturl =~ /^http:\/\/.+?(\/.*)$/;
$cgipath = $1;
$systemurl =~ /^http:\/\/.+?(\/.*)$/;
$systempath = $1;
$rooturl =~ /^(http:\/\/.+?\/).*$/;
$site = $1;

1;
