#!/usr/local/bin/perl

# --------------------------------------------------------
# pageproperty.cgi
#      cgi for PositLog page property management
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------


use strict;
use CGI qw/-debug :standard/;
use CGI::Cookie;
use Storable qw(lock_retrieve lock_nstore);   # is default module (upper perl 5.8)
use File::Basename; # is default module
use PositLogConfig;
use PositLogAuth;

# I17n
eval 'use lang::lang_' . $PositLogConfig::language . ';';
sub MESSAGE{
		no strict "refs"; my ($NAME) = @_; ${ "lang::lang_" . $PositLogConfig::language . "::" . $NAME };
}


# parameters are already URL decoded.
my $CGI = new CGI;

# administration command
my $command = $CGI->param("command");

my $pageid = $CGI->param("page");

my $listcounter;

my $index = $CGI->param("index");
if($index ne ""){
    $command = $CGI->param("command_" . $index);
    $pageid = $CGI->param("page_" . $index);
    $listcounter = $CGI->param("listcounter_" . $index);
}

my $auto_layout = $CGI->param("auto_layout_check");
if($auto_layout ne "1"){
    $auto_layout = 0;
}
else{
    $auto_layout = 1;
}

my $show_tree = $CGI->param("show_tree_check");
if($show_tree ne "1"){
    $show_tree = 0;
}
else{
    $show_tree = 1;
}

my $sprite_autobr = $CGI->param("sprite_autobr_check");
if($sprite_autobr ne "1"){
    $sprite_autobr = 0;
}
else{
    $sprite_autobr = 1;
}

my $sprite_autolink = $CGI->param("sprite_autolink_check");
if($sprite_autolink ne "1"){
    $sprite_autolink = 0;
}
else{
    $sprite_autolink = 1;
}


my $sprite_html = $CGI->param("sprite_html_check");
if($sprite_html ne "1"){
    $sprite_html = 0;
}
else{
    $sprite_html = 1;
}

my $map_type = $CGI->param("map_type_check");
if($map_type ne "1"){
    $map_type = 0;
}
else{
    $map_type = 1;
}

my $document_type = $CGI->param("document_type_check");
if($document_type ne "1"){
    $document_type = 0;
}
else{
    $document_type = 1;
}

my $page_type = "document";
if(scalar($map_type) == 1){
		$page_type = "map";
}

my $author_id = $CGI->param("page_author_field");

my $page_title = $CGI->param("page_title_field");
my $page_max_width = $CGI->param("page_max_width_field");
my $page_max_height = $CGI->param("page_max_height_field");

my $page_bgcolor = $CGI->param("page_bgcolor_field");
my $footer_bgcolor = $CGI->param("footer_bgcolor_field");

my $background_image_clear = $CGI->param("background_image_clear");


#--------------------------------------
# Authentication
#--------------------------------------

my $loginid = $CGI->param("loginid");
my $loginpass = $CGI->param("loginpass");

if($loginid eq ""){
# Read temporal cookie
		$loginid = $CGI->cookie("loginid") || "";
		$loginpass = $CGI->cookie("loginpass") || "";
}

PositLogAuth::authenticateUser($loginid, $loginpass);
PositLogAuth::authenticateCreatePage($loginid, $pageid);


if($loginid eq "public"){
		$loginid = "";
}

my $cookieUser = new CGI::Cookie(
		-path => "$PositLogConfig::cgipath",
		-name => "loginid",
		-value => "$loginid",
		);
my $cookiePass = new CGI::Cookie(
		-path => "$PositLogConfig::cgipath",
		-name => "loginpass",
		-value => "$loginpass",
		);

# Print HTTP header
# (Set cookies)
print $CGI->header(-charset => 'utf-8', -cookie => [$cookieUser,$cookiePass]); 

if(!PositLogAuth::isAdminUser && !PositLogAuth::isPageCreator){

		my $checked = "";
		my $savedpass = "";
		if($loginid eq ""){
				$loginid = $CGI->cookie("savedloginid");
				$savedpass = $CGI->cookie("savedloginpass");
				if($loginid ne ""){
						$checked = "checked";
				}
		}

		my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='" . $PositLogConfig::language . "'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<meta http-equiv='Content-Style-Type' content='text/css'>\n
		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "logincheck.css' type='text/css'>\n
		<script type='text/javascript'>
		<!--
		function saveOnClick()
		{
				theDay = new Date();
				theDay.setTime(theDay.getTime() + (30 * 1000 * 60 * 60 * 24));
				var box = document.getElementById('saveaccount');
				var loginid = document.getElementById('loginid').value;
				var loginpass = document.getElementById('loginpass').value;
				if(loginid == '' || loginpass == ''){
						box.checked = false;
						alert('Please enter user id and password')
						return;
				}
				if(!box.checked){
						loginid = '';
						loginpass = '';
				}
				var cs='savedloginid='+loginid+';';
				cs+=' path=" . $PositLogConfig::cgipath . ";';
				if(box.checked)
				{
						cs+=' expires='+theDay.toGMTString()+';';
				}
				document.cookie=cs;

				cs='savedloginpass='+loginpass+';';
				cs+=' path=" . $PositLogConfig::cgipath . ";';
				if(box.checked)
				{
						cs+=' expires='+theDay.toGMTString()+';';
				}
				document.cookie=cs;
		}
		// -->
		</script>
		<title>PositLog Administration : Login</title>\n
	</head>\n";


	my $BODY = "<body onLoad='document.getElementById(\"loginid\").focus()'>\n
  <div id='logintop'>\n
  <div id='login'>\n
  <h1>Login to PositLog Administration</h1>\n
  <form id='loginform' action='pagemanager.cgi' method='post'>\n
    <p>\n
      user id<br>\n
      <input type='text' name='loginid' id='loginid' value='" . $loginid . "' size='20' tabindex='1'>\n
    </p>\n
    <p>\n
      password<br>\n
      <input type='password' name='loginpass' id='loginpass' value='" . $savedpass . "' size='20' tabindex='2'>\n
    </p>\n
    <p id='saveaccount-label'>\n
    Save my user id and password&nbsp;&nbsp;<input type='checkbox' name='saveaccount' id='saveaccount' onclick='saveOnClick();'  tabindex='3' value='1' " . $checked . ">\n
    </p>\n
    <p id='submitarea'>\n" . "Permission denied." . 
    "<br/><input type='submit' id='submitbtn' value='Login' tabindex='4'>\n
    </p>\n
  </form>\n
  </div>\n
  <div id='copyright'>\n
  Powered by <a href='http://positlog.storybook.jp/'>PositLog</a>\n
  </div>\n
  </div>\n
</body>\n";

		my $FOOTER = "</html>";

		print $HEADER . $BODY . $FOOTER;
		exit(0);

}


#---------------------------------------------------------
# Generate JavaScript
#---------------------------------------------------------

my $ScriptBody = <<__ScriptBody__;
<script type='text/javascript'>
<!--
function changeBasicinfo()
{
    var pageAuthor = document.getElementById('page_author_field').value;

    if(pageAuthor == ""){alert("Please enter the author name."); return false;}

    return true;
}


function pageConfiguration()
{
		//    var pageWidth = parseInt(document.getElementById('page_max_width_field').value);
		//    var pageHeight = parseInt(document.getElementById('page_max_height_field').value);
		//    if(isNaN(pageWidth)){alert("Please enter the number into the page width field."); return false;}
		//    if(isNaN(pageHeight)){alert("Please enter the number into the page height field."); return false;}

    var reg = new RegExp("^[0-9a-fA-F]{6}\$", "i");
    var pageBgColor = document.getElementById('page_bgcolor_field').value;
    var footerBgColor = document.getElementById('footer_bgcolor_field').value;
    if(!pageBgColor.match(reg)){alert("Please enter the HEX number into the page color field."); return false;}
    if(!footerBgColor.match(reg)){alert("Please enter the HEX number into the footer color field."); return false;}
		
    return true;
}

function removeUsers(index)
{
    var removeUserList = "";

    var reg = new RegExp("^userremovecheck_", "i");

    var reg2 = new RegExp(".+_group\$", "i");
    var counter = 2;
    if(index.match(reg2))
    {
				counter = 1;
    }

    for(var i=0; i<document.forms["userlistform_" + index].elements.length; i++)
    {
				if (document.forms["userlistform_" + index].elements[i].name.match(reg))
				{
						if(document.forms["userlistform_" + index].elements[i].checked)
						{
								removeUserList += document.getElementById("userid_" + index + "_" + counter).innerHTML + ", ";
						}
						counter++;
				}
    }

    var mes = "Delete ";

    if(removeUserList == "")
    {
				alert('Please check one or more items.');
				return false;
    }
    else{
				if(window.confirm(mes + removeUserList.substr(0, removeUserList.length-2) + ' ?'))
				{
						return true;
				}
    }

    return false;

}


function addPermission(index)
{
    var selection = document.getElementById('addlist_' + index);

    var selected = false;
    for(i=0; i<selection.options.length; i++)
    {
				if(selection.options[i].selected)
				{
						selected = true;
				}
    }

    if(!selected)
    {
				alert('Please select one or more items.');
				return false;
    }

    return true;

}

function spritehtmlOnClick()
{
    var box = document.getElementById('sprite_html_check');
    if(box.checked)
    {
				box = document.getElementById('sprite_autobr_check');
				box.checked = false;
				box = document.getElementById('sprite_autolink_check');
				box.checked = false;
    }
}


function spriteautoOnClick()
{
    var auto = false;
    var box = document.getElementById('sprite_autobr_check');
    if(box.checked)
    {
				auto = true;
    }
    box = document.getElementById('sprite_autolink_check');
    if(box.checked)
    {
				auto = true;
    }

    if(auto)
    {
				box = document.getElementById('sprite_html_check');
				box.checked = false;
    }
}


function documentTypeOnClick()
{
		var map = document.getElementById('map_type_check');
		map.checked = false;
}

function mapTypeOnClick()
{
    var doc = document.getElementById('document_type_check');
		doc.checked = false;
}

function btnAreaMouseOver(elm)
{
    elm.style.backgroundColor = "#ffd0d0";
}

function btnAreaMouseOut(elm)
{
    elm.style.backgroundColor = "#ffffff";
}


// -->
</script>
__ScriptBody__

#---------------------------------------------------------
# Upload file
#---------------------------------------------------------

# upload file name
my $filename = $CGI->param('background_image_file');
my $basename = "";
my $errormsg = "";
if($filename ne ""){
# MIME type
    my $type = $CGI->uploadInfo($filename)->{'Content-Type'};
    my $buffer;
    my $file;
    my $BUFSZ = 2048;
    my $bytesread;
    while($bytesread = read($filename, $buffer, $BUFSZ)){
				$file .= $buffer;

# $file_size ++;
# if($file_size > 300){
#   - insert size checking function - 
# }
    }

    $filename =~ s/\\/\//gi;

    $basename = basename($filename);

    if ( -f $PositLogConfig::bgimagespath . $basename) {
				$errormsg = "$basename is overwritten.<br>";
    }

    open(OUT, "> $PositLogConfig::bgimagespath" .  $basename) or exit(0);
    binmode(OUT);
    print(OUT $file);
    close(OUT);
    chmod (0666, "$PositLogConfig::bgimagespath" . $basename); 
}

#---------------------------------------------------------
# Generate HTML
#---------------------------------------------------------

my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
    'http://www.w3.org/TR/html4/loose.dtd'>\n
 <html lang='" . $PositLogConfig::language . "'>\n
	 <head>\n
		 <meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		 <meta http-equiv='Content-Style-Type' content='text/css'>\n
		 <link rel='stylesheet' href='" . $PositLogConfig::systempath . "positlog_admin.css' type='text/css'>\n
		 <meta http-equiv='Content-Script-Type' content='text/javascript'>
		 <title>PositLog Page Management</title>\n"
		. $ScriptBody
		. "</head>\n";

my $BODY ="";


sub generatePermissionControl
{
    my ($titleStr, $permissionType, $tmpUserList, $tmpUserGroupList, $permissionHash, $statusStr, $statusPosition) = @_;

    my $length;
    my $glength;
		
		my %AllUserList = %$tmpUserList;
		my %AllUserGroupList = %$tmpUserGroupList;

		foreach my $id (keys %{$permissionHash->{$permissionType}}){
				delete $AllUserList{$id};
		}

		my @AllUserArray= sort {$a cmp $b} (keys %AllUserList);

		if(scalar($permissionHash->{$permissionType}{"public"}) != 1){
				unshift(@AllUserArray, "public");	
		}


    my $length = scalar(keys %AllUserList);
    if($length > 20){
				$length = 20;
    }
    elsif($length < 3){
				$length = 3;
    }

		foreach my $id (keys %{$permissionHash->{$permissionType . "_group"}}){
				delete $AllUserGroupList{$id};
    }

    my $glength = scalar(keys %AllUserGroupList);
    if($glength > 20){
				$glength = 20;
    }
    elsif($glength < 3){
				$glength = 3;
    }

		my @AllUserGroupArray= sort {$a cmp $b} (keys %AllUserGroupList);
		if(scalar($permissionHash->{$permissionType . "_group"}{"all"}) != 1){
				unshift(@AllUserGroupArray, "all");	
		}

    my $BODY = "<h4 class='pagemanagement' id='title_$permissionType' name='title_$permissionType'>$titleStr</h4>\n\n";

		if($permissionType eq $index){
				$BODY .="<p><span class='StatusArea'>" . $statusStr . "</span></p>";
		}


    # current user list
    $BODY .= "<h5 class='pagemanagement'>user list</h5>\n\n";

    my $usercounter = 1;
    $BODY .= "<form class=permissionlist id='userlistform_$permissionType' action='./pageproperty.cgi#title_" . $permissionType ."' onSubmit=\"return removeUsers('$permissionType')\" method='POST'>\n";
    $BODY .= "<div class='PermissionNameArea'>&nbsp;</div>";
    $BODY .= "<input type='submit' name='btn_removeusers' value='remove checked users' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'>\n";
    $BODY .= "<input type='hidden' name='page_$permissionType' value='$pageid'>\n";
    $BODY .= "<input type='hidden' name='command_$permissionType' value='removeusers'>";
    $BODY .= "<input type='hidden' name='index' value='$permissionType'>\n";

    # admin
    $BODY .= "<div class='permissionline1'>\n"
				. "<div class='PermissionNameArea'>"
				. "001" . ".&nbsp;&nbsp;&nbsp;\n"
				. "<span  class='userid' id='userid_" . $permissionType . '_' . $usercounter . "'>admin</span>\n"
				. "</div>"
				. "<div class='DeleteCheckArea'>&nbsp;</div>\n"
				. "</div>\n";
    # other 
    foreach my $uname (sort {$a cmp $b} keys %{$permissionHash->{$permissionType}}){
				if($uname eq "admin"){
						next;
				}
				if(scalar($permissionHash->{$permissionType}{$uname}) != 1){
						next;
				}
				$usercounter++;
				my $userclass = "permissionline1";
				if($usercounter % 2 == 0){
						$userclass = "permissionline2";
				}
				my $usercounterStr = sprintf("%03d", $usercounter);
				$BODY .= "<div class='" . $userclass . "'>\n"
						. "<div class='PermissionNameArea'>"
						. $usercounterStr . ".&nbsp;&nbsp;&nbsp;\n"
						. "<span  class='userid' id='userid_" . $permissionType . '_' . $usercounter . "'>" . $uname . "</span>\n"
						. "</div>"
						. "<div class='DeleteCheckArea'><input type='checkbox' name='userremovecheck_" . $permissionType . "_" . $usercounter . "' value='" . $uname  . "'>remove"
						. "</div>\n"
						. "</div>\n";
    }
    $BODY .= "<input type='hidden' name='listcounter_$permissionType' id='listcounter_$permissionType' value='" . $usercounter . "'>\n";
    $BODY .= "</form>\n\n";

    # select box
    $BODY .= "<form class='permissionform' id='addpermissionform_$permissionType' action='./pageproperty.cgi#title_" . $permissionType ."' onSubmit=\"return addPermission('$permissionType')\"  method='POST'>\n<br><select id='addlist_$permissionType' multiple size='3' name='addlist_$permissionType' onmousedown='this.size=" . $length . ";'>\n";
    foreach my $auser (@AllUserArray){
				$BODY .= "<option value='" . $auser . "'>" . $auser . "</option>\n";
    }
    $BODY .= "</select>\n";
    $BODY .= "<input type='submit' id='btn_$permissionType' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'  value='Add selected users' >\n";
    $BODY .= "<input type='hidden' name='command_$permissionType' value='addusers'>";
    $BODY .= "<input type='hidden' name='page_$permissionType' value='$pageid'>\n";
    $BODY .= "<input type='hidden' name='index' value='$permissionType'>";
    $BODY .= "</form>\n\n";

		my $permissionTypeG = $permissionType . "_group";

    # current group list
    $BODY .= "<h5 class='pagemanagement'>user group list</h5>\n\n";

    my $usercounter = 0;
    $BODY .= "<form class=permissionlist id='userlistform_$permissionTypeG' action='./pageproperty.cgi#title_" . $permissionType ."' onSubmit=\"return removeUsers('$permissionTypeG')\" method='POST'>\n";	
    $BODY .= "<div class='PermissionNameArea'>&nbsp;</div>";
    $BODY .= "<input type='submit' name='btn_removeusers' value='remove checked user groups' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'>\n";
    $BODY .= "<input type='hidden' name='page_$permissionTypeG' value='$pageid'>\n";
    $BODY .= "<input type='hidden' name='command_$permissionTypeG' value='removeusers'>";
    $BODY .= "<input type='hidden' name='index' value='$permissionTypeG'>\n";

    my @groups = sort {$a cmp $b} (keys %{$permissionHash->{$permissionTypeG}});
    if(scalar(@groups) == 0){
				$BODY .= "&nbsp;"
    }
    foreach my $uname (@groups){
				if(scalar($permissionHash->{$permissionTypeG}{$uname}) != 1){
						next;
				}

				$usercounter++;
				my $userclass = "permissionline1";
				if($usercounter % 2 == 0){
						$userclass = "permissionline2";
				}
				my $usercounterStr = sprintf("%03d", $usercounter);
				$BODY .= "<div class='" . $userclass . "'>\n"
						. "<div class='PermissionNameArea'>"
						. $usercounterStr . ".&nbsp;&nbsp;&nbsp;\n"
						. "<span  class='userid' id='userid_" . $permissionTypeG . '_' . $usercounter . "'>" . $uname . "</span>\n"
						. "</div>"
						. "<div class='DeleteCheckArea'><input type='checkbox' name='userremovecheck_" . $permissionTypeG . "_" . $usercounter . "' value='" . $uname  . "'>remove"
						. "</div>\n"
						. "</div>\n";
    }
    $BODY .= "<input type='hidden' name='listcounter_$permissionTypeG' id='listcounter_$permissionTypeG' value='" . $usercounter . "'>\n";
    $BODY .= "</form>\n\n";

    # select box
    $BODY .= "<form class='permissionform' id='addpermissionform_$permissionType' action='./pageproperty.cgi#title_" . $permissionType ."' onSubmit=\"return addPermission('$permissionTypeG')\" method='POST'>\n<br><select id='addlist_$permissionTypeG' multiple size='3' name='addlist_$permissionTypeG' onmousedown='this.size=" . $glength . ";'>\n";
    foreach my $auser (@AllUserGroupArray){
				$BODY .= "<option value='" . $auser . "'>" . $auser . "</option>\n";
    }
    $BODY .= "</select>\n";
    $BODY .= "<input type='submit' id='btn_$permissionTypeG' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'  value='Add selected user groups' >\n";
    $BODY .= "<input type='hidden' name='command_$permissionTypeG' value='addusers'>";
    $BODY .= "<input type='hidden' name='page_$permissionTypeG' value='$pageid'>\n";
    $BODY .= "<input type='hidden' name='index' value='$permissionTypeG'>";
    $BODY .= "</form>\n\n";

    return $BODY;

}


sub generateMainPage
{
		my ($statusStr, $statusPosition) = @_;

		my $BODY = "<body>\n";

    my @PageList;

		my $usernamestr = "";
		if(PositLogAuth::isAdminUser){
				$usernamestr = "<span class='usernamearea'>You are the 'admin' user.</span>";
		}
		elsif($loginid eq ""){
				$usernamestr = "<span class='usernamearea'>You are the 'public' user.</span>";
		}
		else{
				$usernamestr = "<span class='usernamearea'>Your id is '$loginid'.</span>";
		}
		$BODY .="<h1><a href='./positlogadmin.cgi'>PositLog Administration</a>&nbsp;&nbsp;&nbsp;&nbsp;$usernamestr [<a href='./positlogadmin.cgi?command=logout'>logout</a>]</h1>\n";

		$BODY .="<h2 class='pagemanagement'><a href='./pagemanager.cgi'>Page Management</a></h2>\n";

		my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};
		if($configHash eq ""){
				print "Cannot read the page configuration.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}

		$BODY .="<h3 class='pagemanagement'>Page '<a href='./positlog.cgi?load=" . $pageid  . "'>" . $configHash->{"page_title"} . "</a>' (<a href='./positlog.cgi?load=" . $pageid  . "&mode=EditMode'>edit</a>)</h3>\n";

		$BODY .="<h4 class='pagemanagement'>Basic information</h4>\n";

		if($statusPosition eq "basicinfo"){
				$BODY .="<p><span class='StatusArea'>" . $statusStr . "</span></p>";
		}

		my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};
		if($permissionHash eq ""){
				print "Cannot read the page permission.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}

		$BODY .= "<form id='basicinfoform' name='basicinfoform' action='./pageproperty.cgi' method='POST' onSubmit='return changeBasicinfo()'>\n";
		$BODY .="<div class='propertyline1'>";
		$BODY .= MESSAGE("PAGEMNG_AUTHOR") . "&nbsp;&nbsp;$configHash->{'author_id'}";
		if(PositLogAuth::isAdminUser){
				$BODY .="&nbsp;&nbsp;&lt;-<input type='text' size='20' class='fieldL' name='page_author_field' id='page_author_field' value=''>";
				$BODY .= "&nbsp;&nbsp;<input type='submit' name='btn_changeauthor' value='Change author' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'>\n";
		}
		$BODY .="</div>";

		$BODY .="<div class='propertyline2'>";
		$BODY .= MESSAGE("PAGEMNG_ID") . "&nbsp;&nbsp;$pageid";
		$BODY .="</div>";

		$BODY .="<div class='propertyline1'>";
		$configHash->{"created_time"} =~ /(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/i;
		my $createdTime = "$1/$2/$3&nbsp;&nbsp;$4:$5:$6";
		$BODY .= MESSAGE("PAGEMNG_CREATEDDATE") . "&nbsp;&nbsp;$createdTime";
		$BODY .="</div>";

		$BODY .="<div class='propertyline2'>";
		$configHash->{"modified_time"} =~ /(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/i;
		my $modifiedTime = "$1/$2/$3&nbsp;&nbsp;$4:$5:$6";
		$BODY .= MESSAGE("PAGEMNG_LASTMODIFIEDDATE") . "&nbsp;&nbsp;$modifiedTime";
		$BODY .="</div>";


		$BODY .= "<input type='hidden' name='page_basicinfo' value='$pageid'>\n";
		$BODY .= "<input type='hidden' name='command_basicinfo' value='changebasicinfo'>\n";
		$BODY .= "<input type='hidden' name='index' value='basicinfo'>\n";

		$BODY .="</form>";

		#--------------------------
		# Page Configurations
		#--------------------------
		$BODY .="<h4 class='pagemanagement' id='title_configuration'>Configurations</h4>\n";

		if($statusPosition eq "configuration"){
				$BODY .="<p><span class='StatusArea'>" . $statusStr . "</span></p>";
		}

		my $checked = "";

		$BODY .= "<form id='configurationform' name='configurationform' enctype='multipart/form-data' action='./pageproperty.cgi#title_configuration' method='POST' onSubmit='return pageConfiguration()'>\n";

		$BODY .= "<div class='ConfigurationArea'>&nbsp;</div><input type='submit' name='btn_configuration' value='Change configurations' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'>\n";

		# page title
		$BODY .="<div class='propertyline1'>";
		my $page_title = $configHash->{'page_title'};
		$BODY .="<div class='ConfigurationArea'>" . MESSAGE("PAGEMNG_TITLE") . "</div>";
		$BODY .="<input type='text' size='30' class='fieldL' name='page_title_field' id='page_title_field' value='$page_title'>";
		$BODY .="</div>\n\n";

		# page type
		$BODY .="<div class='propertyline2'>";
		$BODY .="<div class='ConfigurationArea'>" . MESSAGE("PAGEMNG_TYPE") . "</div>";

		my $mapCheck = "";
		my $documentCheck = "";
		if(exists($configHash->{"page_type"})){
				if($configHash->{"page_type"} eq "map"){
						$mapCheck = "checked";
				}
				else{
						$documentCheck = "checked";
				}
		}
		else{
				$documentCheck = "checked";
		}
		$BODY .= "<input type='radio' name='map_type_check' id='map_type_check' onclick='mapTypeOnClick()' value='1' $mapCheck>Map</input> <input type='radio' name='document_type_check' id='document_type_check' value='1' onclick='documentTypeOnClick()' $documentCheck>Document</input>";
		$BODY .="</div>\n\n";

		# auto layout
		$BODY .="<div class='propertyline1'>";

		if(scalar($configHash->{"auto_layout"}) eq ""){$checked = "";}
		elsif(scalar($configHash->{"auto_layout"}) == 1){$checked = "checked";}
		else{$checked = "";}
		$BODY .="<div class='ConfigurationArea'>" . MESSAGE("PAGEMNG_AUTOLAYOUT") . "</div>";
		$BODY .= MESSAGE("PAGEMNG_AUTOLAYOUTENABLE") . "&nbsp;<input type='checkbox' name='auto_layout_check' id='auto_layout_check' value='1' $checked>&nbsp;&nbsp;";
		$BODY .="</div>\n\n";

		# show tree
#		$BODY .="<div class='propertyline2'>";
#		if(scalar($configHash->{"show_tree"}) eq ""){$checked = "";}
#		elsif(scalar($configHash->{"show_tree"}) == 1){$checked = "checked";}
#		else{$checked = "";}
#		$BODY .="<div class='ConfigurationArea'>Show tree</div>";
#		$BODY .= "Enable&nbsp;<input type='checkbox' name='show_tree_check' id='show_tree_check' value='1' $checked>&nbsp;&nbsp;";
#		$BODY .="</div>\n\n";

		# sprite autobr
		$BODY .="<div class='propertyline2'>";

		if(scalar($configHash->{"sprite_autobr"}) == 1){$checked = "checked";}
		else{$checked = "";}
		$BODY .="<div class='ConfigurationArea'>" . MESSAGE("PAGEMNG_PUBLICUSERCONFIG") . "</div>";
		$BODY .= MESSAGE("PAGEMNG_AUTOBR") . "&nbsp;<input type='checkbox' name='sprite_autobr_check' id='sprite_autobr_check' value='1' onclick='spriteautoOnClick();' $checked>&nbsp;&nbsp;";

		# sprite autolink
		if(scalar($configHash->{"sprite_autolink"}) == 1){$checked = "checked";}
		else{$checked = "";}
		$BODY .= MESSAGE("PAGEMNG_AUTOLINK") . "&nbsp;";
		$BODY .="<input type='checkbox' name='sprite_autolink_check' id='sprite_autolink_check' value='1' onclick='spriteautoOnClick();' $checked>&nbsp;&nbsp;";

		# sprite html
		if(scalar($configHash->{"sprite_html"}) == 1){$checked = "checked";}
		else{$checked = "";}
		$BODY .= MESSAGE("PAGEMNG_USEHTML") . "&nbsp;";
		$BODY .="<input type='checkbox' name='sprite_html_check' id='sprite_html_check' value='1' onclick='spritehtmlOnClick();' $checked>";
		$BODY .="</div>\n\n";


		# page bgcolor
		$BODY .="<div class='propertyline1'>";
		my $page_bgcolor = $configHash->{'page_bgcolor'};
		$BODY .="<div class='ConfigurationArea'>" . MESSAGE("PAGEMNG_BGCOLOR") . "</div>";
		$BODY .="#<input class='fieldL' type='text' size='6' maxlength='6' name='page_bgcolor_field' id='page_bgcolor_field' value='$page_bgcolor'>";
		$BODY .="</div>\n\n";

		# footer bgcolor
		$BODY .="<div class='propertyline2'>";
		my $footer_bgcolor = $configHash->{'footer_bgcolor'};
		$BODY .="<div class='ConfigurationArea'>" . MESSAGE("PAGEMNG_FOOTERCOLOR") . "</div>";
		$BODY .="#<input class='fieldL' type='text' size='6' maxlength='6' name='footer_bgcolor_field' id='footer_bgcolor_field' value='$footer_bgcolor'>";
		$BODY .="</div>\n\n";

		# background-image
		$BODY .="<div class='propertyline1'>";
		my $background_image = $configHash->{'background_image'};
		$BODY .="<div class='ConfigurationArea'>" . MESSAGE("PAGEMNG_BGIMAGE") . "</div>";
		$BODY .="<a href='" . $PositLogConfig::bgimagespath . $background_image . "'>";
		$BODY .="$background_image</a>&nbsp;&nbsp;&nbsp;&nbsp;";
		$BODY .= MESSAGE("PAGEMNG_BGIMAGECLEAR") . " <input type='checkbox' name='background_image_clear' id='background_image_clear' value='1'>&nbsp;&nbsp;&nbsp;&nbsp;";
		$BODY .= MESSAGE("PAGEMNG_BGIMAGESELECT") . "&nbsp;&nbsp;<input class='fieldL' type='file' size='30' name='background_image_file' id='background_image_file'>";
		$BODY .="</div>\n\n";


		$BODY .= "<input type='hidden' name='page_configuration' value='$pageid'>\n";
		$BODY .= "<input type='hidden' name='command_configuration' value='changeconfiguration'>\n";
		$BODY .= "<input type='hidden' name='index' value='configuration'>\n";

		$BODY .="</form>";

		if(!PositLogAuth::isAdminUser){
				return $BODY;	
		}

		#-------------------------------------
		# Permissions
		#-------------------------------------
		my $AllUserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_all.cgi")} or {};
		if($AllUserList eq ""){
				print "<div style='text-align: center'>Cannot read the user list.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}

		my $AllUserGroupList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergrouplist.cgi")} or {};
		if($AllUserGroupList eq ""){
				print "<div style='text-align: center'>Cannot read the user group list.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}

		# read page
		$BODY .= generatePermissionControl( MESSAGE("PAGEMNG_ALLOWREADPAGE"), "read_page", $AllUserList, $AllUserGroupList, $permissionHash,  $statusStr, $statusPosition);

		# write plainsprite
		$BODY .= generatePermissionControl( MESSAGE("PAGEMNG_ALLOWPLAINSPRITE"), "write_plainsprite", $AllUserList, $AllUserGroupList, $permissionHash,  $statusStr, $statusPosition);

		# write attached sprite
		$BODY .= generatePermissionControl( MESSAGE("PAGEMNG_ALLOWATTACHEDSPRITE"), "write_attachedsprite", $AllUserList, $AllUserGroupList, $permissionHash,  $statusStr, $statusPosition);

		# write super sprite
		$BODY .= generatePermissionControl( MESSAGE("PAGEMNG_ALLOWSUPERSPRITE"), "write_supersprite", $AllUserList, $AllUserGroupList, $permissionHash, $statusStr, $statusPosition);

		# create page
		$BODY .= generatePermissionControl( MESSAGE("PAGEMNG_ALLOWNEWPAGE"), "create_page", $AllUserList, $AllUserGroupList, $permissionHash, $statusStr, $statusPosition);

		return $BODY;
}


#---------------------------------------------------------------
# command processor
#---------------------------------------------------------------

if($command eq ""){
		$BODY = generateMainPage();
}
elsif($command eq "addusers" && $pageid ne ""){
		my @addlist = $CGI->param("addlist_$index");
		my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};
		if($permissionHash eq ""){
				print "Cannot open the permission file.\n";
				print "Please check the file permission.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}

		
		my $addedlist = "";
		foreach my $account (@addlist){
				$permissionHash->{$index}{$account} = 1;
				$addedlist .= "'" . $account . "', ";
		}

		if(!eval{Storable::lock_nstore $permissionHash, $PositLogConfig::datapath . $pageid . "/permission.cgi"}){
				print "Cannot create the permission file.\n";
				print "Please check the file permission.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}

		$addedlist = substr($addedlist, 0, length($addedlist)-2);

		if(scalar(@addlist) == 1){
				$BODY = generateMainPage($addedlist . " is added to $index.", $index);
		}
		else{
				$BODY = generateMainPage($addedlist . " are added to $index.", $index);
		}
}
elsif($command eq "removeusers" && $pageid ne ""){
		my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};
		if($permissionHash eq ""){
				print "Cannot read the page permission.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}

		my $removedList = "";
		my $removeCounter = 0;

		for(my $i=1; $i < $listcounter+1; $i++){
				my $account = $CGI->param("userremovecheck_" . $index. "_" . $i);
				if($account ne ""){
						delete $permissionHash->{$index}{$account};
						$removedList .= "'" . $account . "', ";
						$removeCounter++;
				}
		}


		if(!eval{Storable::lock_nstore $permissionHash, $PositLogConfig::datapath . $pageid . "/permission.cgi"}){
				print "Cannot create the permission file.\n";
				print "Please check the file permission.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}

		$removedList = substr($removedList, 0, length($removedList)-2) . "\n";

		if($removeCounter == 1){
				$BODY = generateMainPage($removedList . " is removed from " . $index . ".", $index);
		}
		elsif($removeCounter > 1){
				$BODY = generateMainPage($removedList . " are removed from " . $index . ".", $index);
		}
		else{
				$BODY = generateMainPage("");
		}

}
elsif($command eq "changeconfiguration"  && $pageid ne ""){
		my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};
		if($configHash eq ""){
				print "Cannot read the page configuration.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}

		$configHash->{"auto_layout"} = $auto_layout;
		$configHash->{"show_tree"} = $show_tree;
		$configHash->{"sprite_autobr"} = $sprite_autobr;
		$configHash->{"sprite_autolink"} = $sprite_autolink;
		$configHash->{"sprite_html"} = $sprite_html;
		$configHash->{"page_type"} = $page_type;
		$configHash->{"page_title"} = $page_title;
		$configHash->{"page_max_width"} = $page_max_width;
		$configHash->{"page_max_height"} = $page_max_height;
		$configHash->{"page_bgcolor"} = $page_bgcolor;
		$configHash->{"footer_bgcolor"} = $footer_bgcolor;

		if(scalar($background_image_clear) == 1){
				$configHash->{"background_image"} = "";
		}
		if($basename ne ""){
				$configHash->{"background_image"} = $basename;
		}

		if(!eval{Storable::lock_nstore $configHash, $PositLogConfig::datapath . $pageid . "/config.dat"}){
				print "Cannot create the page configuration.\n";
				print "Please check the file permission.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}

		$BODY = generateMainPage("Configurations are changed.<br>$errormsg", "configuration");
}
elsif($command eq "changebasicinfo"  && $pageid ne ""){
		my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};
		if($configHash eq ""){
				print "Cannot read the page configuration.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}

		my $usernameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
		my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
		if($adminnameAuth ne "" && $adminnameAuth->{$author_id} || $author_id eq "admin"){
				$configHash->{"author_id"} = "admin";
		}
		elsif($usernameAuth ne "" && $usernameAuth->{$author_id}){
				$configHash->{"author_id"} = $author_id;
		}
		else{
				print "User '" . $author_id . "' does not exist.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}


		if(!eval{Storable::lock_nstore $configHash, $PositLogConfig::datapath . $pageid . "/config.dat"}){
				print "Cannot create the page configuration.\n";
				print "Please check the file permission.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
		}

		$BODY = generateMainPage("Basic information is changed.<br>$errormsg", "basicinfo");
}






$BODY .= "</body>\n";

my $FOOTER = "</html>";

print $HEADER . $BODY . $FOOTER;


