//-------------------------------------------------
// positlog.js
//
// Copyright (c) 2006-2007 Hidekazu Kubota (Taro Sosui) All right reserved
//  taro@summer.nifty.jp  
//  http://positlog.storybook.jp/ 
//
// This file is part of PositLog.
// PositLog is distributed under the MIT License.
//-------------------------------------------------


error = "";
function putErr(msg){error += msg + ",";}
function showErr(){	if(error == ""){return;}	var win = window.open(); 	win.document.open(); 	win.document.write(error); 	win.document.close();}

//---------------------------
// DEFINITION
//---------------------------

// z-index
ZIND = new Object();
ZIND.BACKGROUND = 0; // this is the same value as z-index of spritesworld defined in positlog.cgi
ZIND.DRAWCANVASBACK = 1; // this is the same value as z-index of drawcanvas defined in positlog.cgi
ZIND.GO_TEMP_BACKGROUND = 10;
ZIND.SPRITE_MIN = 1000;
ZIND.SPRITE_CREATEMIN = 500000;
ZIND.SPRITE_MAX = 999999;
ZIND.GO_TEMP_FOREGROUND = 1000000;
ZIND.DRAWCANVASFRONT = 1500000;
ZIND.CONTROLPANEL = 2000000; // this is the same value as z-index of controlpanel defined in positlog.css
ZIND.EDITOR = 3000000; // this is the same value as z-index of editor/password-dialog defined in positlog.css
ZIND.EDITOR2 = 3000100; // this is the same value as z-index of plugin-dialog/fileuploadframe/trianglecolorselector defined in positlog.css

// STATES
STATES = new Object();

STATES.VIEWING = 0;
STATES.VIEWINGSELECTED = 1;
STATES.VIEWINGFIXED = 2;
STATES.VIEWINGFIXEDSELECTED = 3;
STATES.WORKING = 100;
STATES.SELECTED = 101;
STATES.FIXED = 102;
STATES.FIXEDSELECTED = 103;
STATES.MOVING = 104;
STATES.MOVINGSELECTED = 105;
STATES.SCALING = 106;
STATES.EDITING = 107;
STATES.EDITINGSELECTED = 108;

// PLG is abbreviation of PositLog
PLG = new Object();

// Copyright
PLG.copyright = "PositLog 0.57";

PLG.numberOfSprites = 0;

// Border width between sprite and its region
PLG.spriteBorderOffset = 1;

// For opera
PLG.onloadcount = 0;

PLG.canvasSpriteExists = false;

//PLG.debug = true;
PLG.debug = false;

// Ignore mouse down event
PLG.ignoreMouseDown = false;

// Ignore mouse up event
PLG.ignoreMouseUp = false;

// Check font size to ajust margins
PLG.fontSizeChecker = null;
PLG.fontSize = 0;

// Current state
PLG.state = STATES.WORKING;

// Hash of sprites
PLG.sprites = new Object();

// Modified time of sprites
PLG.recentSpriteTimes = new Array();

// View position of sprites world
PLG.viewPositionX = 0;
PLG.viewPositionY = 0;
PLG.setViewPositionFlag = false;
PLG.adjustViewPositionFlag = false;

// Selected sprite (selected by Mouse)
// - Temporal selection (dashed frame)
PLG.selectedSprite = null;
// - Fixed sprite (solid frame)
PLG.fixedSprite = null;

// Focused sprite (indicated by SpriteID)
// (colored solid frame)
PLG.focusedSprite = null;

// Is editor moving?
PLG.movingEditorFlag = false;

// Is drawing tool moving?
PLG.movingDrawingToolFlag = false;

// Is mouse out of world?
PLG.mouseOutOfWorld = false;

// Original z-index of focused sprite
PLG.orgZindexOfFocusedSprite = 0;

// Original z-index of selected sprite 
PLG.orgZindexOfSelectedSprite = 0;

// Original attributes of fixed sprite 
PLG.orgZindexOfFixedSprite = 0;

// Offset of mouse position
PLG.mousePositionOffset = 0;

// Previous mouse position
PLG.prevMouseX = 0;
PLG.prevMouseY = 0;

// Previous mouse down
PLG.prevMouseDownX = 0;
PLG.prevMouseDownY = 0;

// Click four times to move foreground sprite to background
// This is a counter
PLG.counterForMoveToBackground = 0;

// For checking browser
PLG.cb = new chkAjaBrowser();

// For SmallMap
PLG.mapcanvas = null;
PLG.mapctx = null;
PLG.viewcanvas = null;
PLG.viewctx = null;
PLG.drawcanvas = null;
PLG.drawctx = null;
PLG.mapSize = 150;
PLG.setSmallMapFlag = false;
PLG.borderOfMap = 2;

// For callback
PLG.waitSavingFlag = false;

// Grouping
PLG.groupingFlag = false;
PLG.groupingDirection = "";
PLG.ungroupingFlag = false;

// Timer
PLG.moveTimer = null;
PLG.moveCount = 0;
PLG.moveDivision = 10;
PLG.animeStartX = 0;
PLG.animeStartY = 0;
PLG.animeEndX = 0;
PLG.animeEndY = 0;

PLG.focusSmallMapCount = 0;
PLG.focusSmallMapTimer = null;
PLG.unfocusSmallMapCount = 0;
PLG.unfocusSmallMapTimer = null;

// World
PLG.worldLeft = Number.MAX_VALUE;
PLG.worldRight = Number.MIN_VALUE;
PLG.worldTop = Number.MAX_VALUE;
PLG.worldBottom = Number.MIN_VALUE;

PLG.leftSprID = "";
PLG.rightSprID = "";
PLG.topSprID = "";
PLG.bottomSprID = "";

PLG.prevWindowWidth = 0;
PLG.prevWindowHeight = 0;

PLG.currentURL = "";

PLG.drawingFlag = false;
PLG.pendownFlag = false;
PLG.pendownFirstFlag = false;
PLG.pensize = 2;
PLG.penColor = "#000000";

// Magic margin for hiding vertical scroll bar in EditMode
//PLG.magicMargin = 4;
PLG.magicMargin = 0;


// parameters below are defined in positlog.cgi
// PARAM.pageid
// PARAM.vp
// PARAM.id
// PARAM.edge
// PARAM.worldMaxWidth
// PARAM.worldMaxHeight
// PARAM.positlogMode
// PARAM.IMAGEFILEPATH
// PARAM.CGIFILEPATH
// PARAM.DATAFILEPATH
// PARAM.attachedSprite
// PARAM.superSprite
// PARAM.sprite_html
// PARAM.sprite_autobr
// PARAM.sprite_autolink
// PARAM.page_type
// PARAM.spritesHash
// PARAM.filesecure

PLG.drawRecord = new Array();
PLG.drawCanvasLeft = Number.MAX_VALUE;
PLG.drawCanvasRight = Number.MIN_VALUE;
PLG.drawCanvasTop = Number.MAX_VALUE;
PLG.drawCanvasBottom = Number.MIN_VALUE;
PLG.drawCommand = new Array();

PLG.ignoreKeyPressFlag = false;
PLG.bodyTimer = null;

showSpritesList();
function showSpritesList()
{
//	if(PLG.cb.bw.iemobile){
		// IE mobile does not have document.getElementById method.
		// nop 
//	}
//	else
	if(document.getElementById("spriteslist")){
		var sl = document.getElementById("spriteslist");
		if(PARAM.page_type == "map"){
			PLG.viewPositionX = Math.floor(getInnerWidth()/2);
			PLG.viewPositionY = Math.floor(getInnerHeight()/2);
			sl.style.left = PLG.viewPositionX + "px";
			sl.style.top = PLG.viewPositionY + "px";
			var sw = document.getElementById("spritesworld");
			sw.style.backgroundPosition = PLG.viewPositionX.toString() + "px" + " " + PLG.viewPositionY.toString() + "px";
		}
		if(PARAM.positlogMode == "ViewMode"){
			document.getElementById("spritesworld").style.overflow = "visible";
		}
		else{
			document.getElementById("spritesworld").style.overflow = "hidden";
		}
		sl.style.display = "block";

	}
	else{
		setTimeout("showSpritesList()", 10);
	}
}

//-------------------------
// Drawing
//-------------------------

function execDrawCommand()
{
	if(PLG.drawcanvas != null){
		if(PLG.drawcanvas && PLG.drawcanvas.getContext){
			if(PLG.drawCommand.length > 0){
				var cmd = PLG.drawCommand.shift();
				var cmdArray = cmd.split(",");
				var canvasid = cmdArray[0];
				var canvas = document.getElementById(canvasid);
				if(!canvas){
					setTimeout("execDrawCommand()",10);
					return;
				}

				PLG.canvasSpriteExists = true;

				if(document.getElementById(cmdArray[0] + "_title")){
					document.getElementById(cmdArray[0] + "_title").style.display = "none";
				}

				if(cmdArray[1] == "l"){
					var ctx = canvas.getContext("2d");
					ctx.strokeStyle = "#000000";
					ctx.lineWidth = 2;
					ctx.lineCap = "round";
					ctx.lineJoin = "round";
					var cmdStr = new String(cmdArray[2]);
					var startIndex = 4;
					ctx.beginPath();
					if(cmdStr.match(/^s(.+)$/)){
						ctx.lineWidth = parseFloat(RegExp.$1);
						startIndex++;
					}
					cmdStr = new String(cmdArray[3]);
					if(cmdStr.match(/^c(.+)$/)){
						ctx.strokeStyle = RegExp.$1;
						startIndex++;
					}

					ctx.moveTo(parseInt(cmdArray[startIndex-2]),parseInt(cmdArray[startIndex-1]));

					for(var i=startIndex; i<cmdArray.length; i++){
						if(cmdArray[i] == "l"){
							ctx.stroke();
							i++;
							var cmdStr = new String(cmdArray[i]);
							if(cmdStr.match(/^s(.+)$/)){
								ctx.lineWidth = parseFloat(RegExp.$1);
								i++;
							}
							cmdStr = new String(cmdArray[i]);
							if(cmdStr.match(/^c(.+)$/)){
								ctx.strokeStyle = RegExp.$1;
								i++;
							}
							ctx.beginPath();
							ctx.moveTo(parseInt(cmdArray[i]),parseInt(cmdArray[i+1]));
						}
						else{
							ctx.lineTo(parseInt(cmdArray[i]),parseInt(cmdArray[i+1]));
						}

						i++;
					}
					ctx.stroke();
				}

				setTimeout("execDrawCommand()",10);
				return;
			}
		}
	}
	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		if(document.body.style.cursor == 'wait'){
			document.body.style.cursor = 'auto';
			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand.cur), default";
		}
	}

	var cr = document.getElementById("copyright");
	if(cr){
		cr.innerHTML = PLG.copyright;
	}

}


function draw(cmd)
{
	PLG.drawCommand.push(cmd);

	var cmdArray = cmd.split(",");
	var canvasid = cmdArray[0];
	var canvas = document.getElementById(canvasid);
	if(!canvas){
		return;
	}

	if(canvas.parentNode){
		if(canvas.parentNode.parentNode){
			if(canvas.parentNode.parentNode.parentNode){
				var spr = canvas.parentNode.parentNode.parentNode;
				if(PARAM.spritesHash){
					if(PARAM.spritesHash[spr.id]){
						PARAM.spritesHash[spr.id].isDrawing = true;
					}
				}
				else{
					if(PLG.sprites[spr.id]){
						PLG.sprites[spr.id].isDrawing = true;
					}
				}
			}
		}
	}

}

//-----------------------------------
// Get sprite geometry
//-----------------------------------

// get relative position (integer) of sprite
function sprLeft(spr){ if(!spr || !spr.style){return 0;} return parseInt(spr.style.left);}
function sprTop(spr){ if(!spr || !spr.style){return 0;} return parseInt(spr.style.top); }
function sprWidth(spr){ if(!spr || !spr.style){return 0;} return parseInt(spr.style.width); }
function sprHeight(spr){ if(!spr){return 0;} return spr.offsetHeight; }


// get elements in sprite
function getSpriteContents(spr)
{
	if(!spr){
		return null;
	}
	var region = getSpriteRegion(spr);
	if(region != null){
		var children = region.childNodes;
		for(var i=0; i<children.length; i++){
			if(children[i].className == "spritecontents"){
				return children[i];
			}
		}
	}
	return null;
}

// get absolute position (integer) of sprite
function sprLeftAbs(spr)
{
  var absLeft = sprLeft(spr);
  var parent = spr.parentNode;
  if(parent.className == "parent"){
		parent = parent.parentNode;
  }
  while(parent && parent.id != "spriteslist"){
		absLeft += sprLeft(parent);
		parent = parent.parentNode;      
		if(parent && parent.className == "parent"){
			parent = parent.parentNode;
		}
  }
  return absLeft;
}

function sprTopAbs(spr)
{
  var absTop = sprTop(spr);
  var parent = spr.parentNode;
  if(parent.className == "parent"){
		parent = parent.parentNode;
  }
  while(parent && parent.id != "spriteslist"){
		absTop += sprTop(parent);
		parent = parent.parentNode;      
		if(parent && parent.className == "parent"){
			parent = parent.parentNode;
		}
  }

  return absTop;
}

//------------------------------------
// Get parts of a sprite
//------------------------------------
function getSpriteInfo(spr, className)
{
	if(!spr){
		return null;
	}
	var region = getSpriteRegion(spr);
	if(region != null){
		var children = region.childNodes;
		for(var i=0; i<children.length; i++){
			if(children[i].className == "spriteinfo"){
				var infos = children[i].childNodes;
				for(var j=0; j<infos.length; j++){
					if(infos[j].className == className){
						return infos[j];
					}
				}
			}
		}
	}
	return null;
}

function getSpriteRegion(spr)
{
	if(!spr){
		return null;
	}
	var children = spr.childNodes;
	for(var i=0; i<children.length; i++){
		if(children[i].className == "spriteregion"){
			return children[i];
		}
	}
	return null;
}

//------------------------------------
// Get size of the world
//------------------------------------
function getInnerWidth()
{
  if(!PLG.cb.bw.safari && !PLG.cb.bw.opera){
		return parseInt(document.documentElement.clientWidth);
  }
	else if(PLG.cb.bw.opera){
		var trueWidth = parseInt(window.innerWidth);
		if(parseInt(window.innerHeight) < parseInt(PLG.worldBottom - PLG.worldTop)){
				// vertical scroll bar is visible
			trueWidth -= 17;
		}
		return trueWidth;
	}
	else{
		return parseInt(window.innerWidth);
  }
}


function getInnerHeight()
{
  if(!PLG.cb.bw.safari && !PLG.cb.bw.opera){
		return parseInt(document.documentElement.clientHeight);
  }
	else if(PLG.cb.bw.opera){
		var trueHeight = parseInt(window.innerHeight);
		if(parseInt(window.innerWidth) < parseInt(PLG.worldRight - PLG.worldLeft)){
				// vertical scroll bar is visible
			trueHeight -= 17;
		}
		return trueHeight;
	}
	else{
		return parseInt(window.innerHeight);
  }
}


//------------------------------------
// Get Mouse Position
//-------------------------------------
function getMouseX(e)
{
  if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		return  parseInt(window.event.clientX - PLG.mousePositionOffset);
  }
  else{
		if(PLG.cb.bw.safari){
			return parseInt(e.pageX) - document.body.scrollLeft;
		}
		else{
			return parseInt(e.pageX) - 	document.documentElement.scrollLeft;
		}
  }
}

function getMouseY(e)
{		
	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		return parseInt(window.event.clientY - PLG.mousePositionOffset);
	}
	else{
		if(PLG.cb.bw.safari){
			return parseInt(e.pageY) - document.body.scrollTop;
		}
		else{
			return parseInt(e.pageY) - 	document.documentElement.scrollTop;
		}

	}
}


//------------------------------------
// Set current URL
//------------------------------------
function setCurrentURL(url)
{
	PLG.currentURL = url;
	var newURLshort = url;
	document.getElementById("currentposition").innerHTML = "<a href='"+url+"'>url</a>"; 
}



//------------------------------------
// Set button events
//------------------------------------
function setButtonEvents(id, mouseoverimg, mouseoutimg, mousedownimg, myfunc)
{
  var btnNode = document.getElementById(id);
  if(btnNode != null && btnNode != undefined){
		btnNode.onmouseover = function(){this.style.backgroundImage = "url('" + PARAM.IMAGEFILEPATH + mouseoverimg + "')";};
		btnNode.onmouseout = function(){this.style.backgroundImage = "url('" + PARAM.IMAGEFILEPATH + mouseoutimg + "')";};
		btnNode.onmousedown = function(){this.style.backgroundImage = "url('" + PARAM.IMAGEFILEPATH + mousedownimg + "')"; eval(myfunc)};
		btnNode.onmouseup = function(){this.style.backgroundImage = "url('" + PARAM.IMAGEFILEPATH + mouseoutimg + "')";};
  }
}

//-------------------------------------
// Process tree
//-------------------------------------

function isUpperSiblings(id, hash)
{
	if(!hash[id].margin_p){
		return false;
	}
	if(hash[id].margin_p.position == "TT" || hash[id].margin_p.position == "TB"){
		return true;
	}
	else{
		return false;
	}
}

function rebuildWholeGeometry(id, hash)
{
	if(!id){
		return;
	}
	var spr = document.getElementById(id);
	hash[id].position.x = sprLeft(spr);
	hash[id].position.y = sprTop(spr);	
	hash[id].width = sprWidth(spr);
	hash[id].height = sprHeight(spr);

	if(hash[id].parent && hash[id].parent != ""){
		hash[id].position.absx = hash[hash[id].parent].position.absx + sprLeft(spr);
		hash[id].position.absy = hash[hash[id].parent].position.absy + sprTop(spr);
	}
	else{
		hash[id].position.absx = sprLeft(spr);
		hash[id].position.absy = sprTop(spr);
	}

	// Rebuild recursively
	var maxLeft = 0;
	var maxRight = hash[id].width;
	var maxTop = 0;
	var maxBottom = hash[id].height;

	var children = hash[id].children;
	if(children && children.length > 0){
		for(var i=0; i<children.length; i++){
			var cid = children[i];
			if(hash[cid]){
				rebuildWholeGeometry(cid, hash);

  			// calc region
				var child = hash[cid];
				if(maxLeft > child.position.x + child.region.left){
					maxLeft = child.position.x + child.region.left;
				}
				if(maxRight < child.position.x + child.region.right){
					maxRight = child.position.x + child.region.right;
				}
				if(maxTop > child.position.y + child.region.top){
					maxTop = child.position.y + child.region.top;
				}
				if(maxBottom < child.position.y + child.region.bottom){
					maxBottom = child.position.y + child.region.bottom;
				}
			}
			else{
				children = (children.slice(0,i)).concat(children.slice(i+1));
				hash[id].children = children;
				i--;
			}
		}
	}

	hash[id].region = new Object();
	hash[id].region.left = maxLeft;
	hash[id].region.right = maxRight;
	hash[id].region.top = maxTop;
	hash[id].region.bottom = maxBottom;


	// Calc edge of the world
	if(PLG.leftSprID == "" || hash[PLG.leftSprID].position.absx > hash[id].position.absx){
		PLG.leftSprID = id;
		PLG.worldLeft = hash[id].position.absx;
	}
	if(PLG.rightSprID == "" || hash[PLG.rightSprID].position.absx + hash[PLG.rightSprID].width < hash[id].position.absx + hash[id].width){
		PLG.rightSprID = id;
		PLG.worldRight = hash[id].position.absx + hash[id].width;
	}
	if(PLG.topSprID == "" || hash[PLG.topSprID].position.absy > hash[id].position.absy){
		PLG.topSprID = id;
		PLG.worldTop = hash[id].position.absy;
	}
	if(PLG.bottomSprID == "" || hash[PLG.bottomSprID].position.absy + hash[PLG.bottomSprID].height < hash[id].position.absy + hash[id].height){
		PLG.bottomSprID = id;
		PLG.worldBottom = hash[id].position.absy + hash[id].height;
	}
}

function searchNearestSibling(id, siblings, position, hash)
{
	var minmargin = "";
	var minmarginid = "";
	for(var j=0; j<siblings.length; j++){
		if((hash[id].position.x + hash[id].region.left <= hash[siblings[j]].position.x + hash[siblings[j]].region.left
				&& hash[id].position.x + hash[id].region.right >= hash[siblings[j]].position.x + hash[siblings[j]].region.left)
			 ||
			 (hash[id].position.x + hash[id].region.left <= hash[siblings[j]].position.x + hash[siblings[j]].region.right
				&& hash[id].position.x + hash[id].region.right >= hash[siblings[j]].position.x + hash[siblings[j]].region.left)
			 ||
			 (hash[id].position.x + hash[id].region.left >= hash[siblings[j]].position.x + hash[siblings[j]].region.left
				&& hash[id].position.x + hash[id].region.right <= hash[siblings[j]].position.x + hash[siblings[j]].region.right)
			 ){
				 if(position == "upper"){
					 // Use === instead of ==
 					 if(minmargin === "" || minmargin > (hash[siblings[j]].position.y + hash[siblings[j]].region.top) - (hash[id].position.y + hash[id].region.bottom)){
						 minmargin = (hash[siblings[j]].position.y + hash[siblings[j]].region.top) - (hash[id].position.y + hash[id].region.bottom);
						 minmarginid = siblings[j];
					 }
				 }
				 else{
					 if(!isUpperSiblings(siblings[j], hash) 
							|| (isUpperSiblings(siblings[j], hash) && hash[siblings[j]].position.y + hash[siblings[j]].height > 0)
						 ){
							 // Use === instead of ==
							 if(minmargin === "" || minmargin > (hash[id].position.y + hash[id].region.top) - (hash[siblings[j]].position.y + hash[siblings[j]].region.bottom)){
								 minmargin = (hash[id].position.y + hash[id].region.top) - (hash[siblings[j]].position.y + hash[siblings[j]].region.bottom);
								 minmarginid = siblings[j];
							 }
					 }
				 }
			 }
	}

	return minmarginid;
}

function adjustSiblingsMargin(siblings, hash, maxTop, maxBottom)
{
	if(!PARAM.autolayout){	
		return maxTop + "," + maxBottom;
	}

	var upperSiblings = new Array();
	var lowerSiblings = new Array();

	// Process upper siblings (margin_p.position is TT or TB)

	for(var i=0; i<siblings.length; i++){
		if(hash[siblings[i]].margin_p
			 && hash[siblings[i]].margin_p.position
			 ){
				 if(isUpperSiblings(siblings[i], hash)){
					 upperSiblings.push(siblings[i]);
				 }
			 }
	}

	var sortByBottomReverse = function(a,b){
		var result = (hash[b].position.y + hash[b].region.bottom) - (hash[a].position.y + hash[a].region.bottom);
		if(result == 0){
			if(hash[a].margin_s && hash[a].margin_s && hash[a].margin_s.elder == b){
				result = 1;
			}
			else{
				result = -1;
			}
		}
		return result;
	};
	upperSiblings.sort(sortByBottomReverse);

	var tempLowerSiblings = new Array();
	for(var i=0; i<upperSiblings.length; i++){
		var sibid = upperSiblings[i];

		var nearestid = "";
				
		if(hash[sibid].margin_s  && hash[sibid].margin_s.pixel 
			 && hash[sibid].margin_s.elder && hash[hash[sibid].margin_s.elder]
			 && hash[sibid].margin_s.pixel < 0){
			// The target spriet originally overlapped on the elder sprite
			nearestid = hash[sibid].margin_s.elder;
		}
		else{
			nearestid = searchNearestSibling(sibid, tempLowerSiblings, "upper", hash);
		}

		if(nearestid != ""){
			if(hash[sibid].margin_s  && hash[sibid].margin_s.pixel 
				 && hash[nearestid]
				 && hash[sibid].margin_s.elder && hash[hash[sibid].margin_s.elder]
				 && hash[nearestid].position.y + hash[nearestid].region.top > hash[hash[sibid].margin_s.elder].position.y + hash[hash[sibid].margin_s.elder].region.top){
				// The elder sprite exists above the target sprite
				nearestid = hash[sibid].margin_s.elder;
			}
		}

		
		if(nearestid != ""){
				var nearTop = hash[nearestid].position.y + hash[nearestid].region.top;

				if(hash[sibid].margin_s && hash[sibid].margin_s.pixel){
					if(hash[sibid].margin_s.position == "BB"){
						// Case BB
						hash[sibid].position.y = hash[hash[sibid].margin_s.elder].position.y + hash[hash[sibid].margin_s.elder].region.bottom - hash[sibid].margin_s.pixel - hash[sibid].region.bottom;
					}
					else{
						// Case TB
						hash[sibid].position.y = nearTop - hash[sibid].margin_s.pixel - hash[sibid].region.bottom;
					}
				}
				document.getElementById(sibid).style.top = hash[sibid].position.y + "px";
		}
		if(maxTop > parseInt(hash[sibid].position.y) + parseInt(hash[sibid].region.top)){
			maxTop = parseInt(hash[sibid].position.y) + parseInt(hash[sibid].region.top);
		}
		if(maxBottom < parseInt(hash[sibid].position.y) + parseInt(hash[sibid].region.bottom)){
			maxBottom = parseInt(hash[sibid].position.y) + parseInt(hash[sibid].region.bottom);
		}
		
		tempLowerSiblings.push(sibid);
	}

	// Process lower siblings

	var sortByTop = function(a,b){
		var result = (hash[a].position.y + hash[a].region.top) - (hash[b].position.y + hash[b].region.top);
		if(result == 0){
			if(hash[a].margin_s && hash[a].margin_s && hash[a].margin_s.elder == b){
				result = 1;
			}
			else{
				result = -1;
			}
		}
		return result;
	};
	siblings.sort(sortByTop);

	var tempUpperSiblings = new Array();
	for(var i=0; i<siblings.length; i++){
		var sibid = siblings[i];

		if(!isUpperSiblings(siblings[i], hash)){
			var nearestid = "";
				
			if(hash[sibid].margin_s  && hash[sibid].margin_s.pixel 
				 && hash[sibid].margin_s.elder && hash[hash[sibid].margin_s.elder]
				 && hash[sibid].margin_s.pixel < 0){
					// The target spriet originally overlapped on the elder sprite
				nearestid = hash[sibid].margin_s.elder;
			}
			else{
				nearestid = searchNearestSibling(sibid, tempUpperSiblings, "lower", hash);
			}

			if(nearestid != ""){
				if(hash[sibid] && hash[sibid].margin_s  && hash[sibid].margin_s.pixel 
					 && hash[sibid].margin_s.elder && hash[hash[sibid].margin_s.elder] && hash[hash[sibid].margin_s.elder].position && hash[hash[sibid].margin_s.elder].region
					 && hash[nearestid] && hash[nearestid].position && hash[nearestid].region
					 && hash[nearestid].position.y + hash[nearestid].region.bottom < hash[hash[sibid].margin_s.elder].position.y + hash[hash[sibid].margin_s.elder].region.bottom){
					// The elder sprite exists below the target sprite
					nearestid = hash[sibid].margin_s.elder;
				}
			}

			if(nearestid != "" && hash[nearestid].position && hash[nearestid].region){
				var nearBottom = hash[nearestid].position.y + hash[nearestid].region.bottom;

				if(hash[sibid].margin_s && hash[sibid].margin_s.pixel){
					// The target sprite has margin_s
					if(hash[sibid].margin_s.position == "TT"){
						// Case TT
						hash[sibid].position.y = hash[hash[sibid].margin_s.elder].position.y + hash[hash[sibid].margin_s.elder].region.top + hash[sibid].margin_s.pixel - hash[sibid].region.top;
					}
					else{
						// Case BT
						hash[sibid].position.y = nearBottom + hash[sibid].margin_s.pixel - hash[sibid].region.top;
					}
				}
				else if(isUpperSiblings(nearestid, hash)	&& (nearBottom > hash[sibid].position.y + hash[sibid].region.top)){
					// The target sprite does not have margin_s,
					// and is unintentionally on an upper sprite
// This case could be happen?
//					hash[sibid].position.y = nearBottom - hash[sibid].region.top;
				}

				if(PLG.debug && PARAM.positlogMode == "EditMode" ){
					hash[sibid].s_bottom = nearBottom;
					hash[sibid].s_id = nearestid;
				}

				document.getElementById(sibid).style.top = parseInt(hash[sibid].position.y) + "px";
			}

			if(maxTop > parseInt(hash[sibid].position.y) + parseInt(hash[sibid].region.top)){
				maxTop = parseInt(hash[sibid].position.y) + parseInt(hash[sibid].region.top);
			}
			if(maxBottom < parseInt(hash[sibid].position.y) + parseInt(hash[sibid].region.bottom)){
				maxBottom = parseInt(hash[sibid].position.y) + parseInt(hash[sibid].region.bottom);
			}
		}

		tempUpperSiblings.push(sibid);
	}

	return maxTop + "," + maxBottom;
}

function adjustMargin(id, hash)
{
	if(id == ""){
		var children = new Array();
		for (var cid in hash){
			if(!cid.match(/^sprite_.+$/)){
				continue;
			}
			if(hash[cid] && document.getElementById(cid) && !hash[cid].parent){
				adjustMargin(cid, hash);
				children.push(cid);
			}
		}
		adjustSiblingsMargin(children, hash, 0, 0);
		return;
	}
	
	var spr = document.getElementById(id);
	if(!spr){
		return;
	}
	hash[id].position = new Object();
	hash[id].position.x = sprLeft(spr);
	hash[id].position.y = sprTop(spr);	
	hash[id].width = sprWidth(spr);
	hash[id].height = sprHeight(spr);

	var maxLeft = 0;
	var maxRight = hash[id].width;
	var maxTop = 0;
	var maxBottom = hash[id].height;

	var children = hash[id].children;
	if(children && children.length > 0){
		for(var i=0; i<children.length; i++){
			var cid = children[i];
			if(hash[cid]){
				adjustMargin(cid, hash);
			}
			else{
				children = (children.slice(0,i)).concat(children.slice(i+1));
				hash[id].children = children;
				i--;
			}
		}

		var maxValues = adjustSiblingsMargin(children, hash, 0, hash[id].height);
		var maxArray = maxValues.split(",");
		maxTop = parseInt(maxArray[0]);
		maxBottom = parseInt(maxArray[1]);
	}

	hash[id].region = new Object();
	hash[id].region.left = maxLeft;
	hash[id].region.right = maxRight;
	hash[id].region.top = maxTop;
	hash[id].region.bottom = maxBottom;


  // Re-arrange between my parent and my region
	var parentHeight = 0;
	if(hash[id].parent && hash[id].parent != ""){
		parentHeight = hash[hash[id].parent].height;
	}

	if(!PARAM.autolayout){
		return;
	}

	if(hash[id].margin_p){
		if(hash[id].margin_p.position == "BT"){
			hash[id].position.y = parentHeight + hash[id].margin_p.pixel - hash[id].region.top;
			spr.style.top = parseInt(hash[id].position.y) + "px";
		}
		else if(hash[id].margin_p.position == "TT"){
			hash[id].position.y = hash[id].margin_p.pixel - hash[id].region.top;
			spr.style.top = parseInt(hash[id].position.y) + "px";
		}
		else if(hash[id].margin_p.position == "TB"){
			hash[id].position.y = hash[id].margin_p.pixel - hash[id].region.bottom;
			spr.style.top = parseInt(hash[id].position.y) + "px";
		}
		else if(hash[id].margin_p.position == "NO"){
			// nop
		}
	}
}



function layouter()
{
	if(PLG.fontSize != document.getElementById("footer").offsetHeight){
		PLG.fontSize = document.getElementById("footer").offsetHeight;

		adjustMargin("", PLG.sprites);

		PLG.leftSprID = "";
		PLG.rightSprID = "";
		PLG.topSprID = "";
		PLG.bottomSprID = "";
		for (var id in PLG.sprites){
			if(!id.match(/^sprite_.+$/)){
				continue;
			}

			if(!PLG.sprites[id].parent && document.getElementById(id)){
				rebuildWholeGeometry(id, PLG.sprites);
			}
		}

		initSmallMap();
		drawViewArea();
		drawSmallMap();

		if(PLG.state == STATES.FIXED || PLG.state == STATES.FIXEDSELECTED){
			var menu = document.getElementById("spritemenu");
			menu.style.left = (sprLeftAbs(PLG.fixedSprite) + PLG.viewPositionX) + "px";
			menu.style.top = (sprTopAbs(PLG.fixedSprite) - 20 + PLG.viewPositionY) + "px";

			var scalerElm = document.getElementById("sprite-scaler");
			scalerElm.style.left = (sprLeftAbs(PLG.fixedSprite) + sprWidth(PLG.fixedSprite) - 18 + PLG.viewPositionX) + "px";
			scalerElm.style.top = (sprTopAbs(PLG.fixedSprite) + sprHeight(PLG.fixedSprite) - 24 + PLG.viewPositionY) + "px";

			redrawCanvas(PLG.fixedSprite);
		}
	}
}

function rebuildYoungerArray()
{
	for (var id in PLG.sprites){
		if(!id.match(/^sprite_.+$/)){
			continue;
		}
		if(PLG.sprites[id].margin_s && PLG.sprites[id].margin_s.younger){
			delete(PLG.sprites[id].margin_s.younger);
		}
	}

	for (var id in PLG.sprites){
		if(!id.match(/^sprite_.+$/)){
			continue;
		}
		if(PLG.sprites[id].margin_s && PLG.sprites[id].margin_s.elder && PLG.sprites[id].margin_s.elder != ""){
			if(!PLG.sprites[PLG.sprites[id].margin_s.elder]){
				delete(PLG.sprites[id].margin_s.pixel);
				delete(PLG.sprites[id].margin_s.elder);
				continue;
			}
			if(!PLG.sprites[PLG.sprites[id].margin_s.elder].margin_s){
				PLG.sprites[PLG.sprites[id].margin_s.elder].margin_s = new Object();
			}
			if(!PLG.sprites[PLG.sprites[id].margin_s.elder].margin_s.younger){
				PLG.sprites[PLG.sprites[id].margin_s.elder].margin_s.younger = new Array();
			}
			PLG.sprites[PLG.sprites[id].margin_s.elder].margin_s.younger.push(id);
		}
	}
}


function setViewPositionCookie()
{
  var viewpositionValue = "";
	viewpositionValue = PARAM.pageid + "," + PARAM.positlogMode + "," + PLG.viewPositionX + "," + PLG.viewPositionY;
  var date = new Date();
  setCookie("viewposition", viewpositionValue, PARAM.CGIFILEPATH, 0);
  setCookie("viewDate", date.getTime(), PARAM.CGIFILEPATH, 0);
}


//-------------------------------------
// Page onUnoad()
//-------------------------------------
function bodyUnLoad()
{
	setViewPositionCookie();

}

// Check browser
//   alert("iemobile:" + PLG.cb.bw.iemobile + "\nsafari:"+PLG.cb.bw.safari+"\nkonqueror:"+PLG.cb.bw.konqueror+"\nmozes:"+PLG.cb.bw.mozes+"\nopera:"+PLG.cb.bw.opera+"\nmsie7:"+PLG.cb.bw.msie7+"\nmsie:"+PLG.cb.bw.msie);

//-------------------------------------
// Body onLoad()
//-------------------------------------
function bodyOnLoad()
{
	clearTimeout(PLG.bodyTimer);

	// Browser "Back" operation does not wait DOM loading
	if(document.getElementById("spriteslist")){
		var sl = document.getElementById("spriteslist");
		if(sl.style.display == "none"){
			PLG.bodyTimer = setTimeout("bodyOnLoad()", 10);
			return;
		}
	}
	else{
		PLG.bodyTimer = setTimeout("bodyOnLoad()", 10);
		return;
	}


	var footer = document.getElementById("footer");
	footer.style.display = "block";

	// Wait image loading on opera
	if(PLG.cb.bw.opera){
		if(PLG.onloadcount < 30){
			var imgArray = document.getElementsByTagName("img");
			for(var i=0; i<imgArray.length; i++){
				if(!imgArray[i].complete){
					setTimeout("bodyOnLoad()",1000);
					PLG.onloadcount++;
					return;
				}
			}
		}
	}

	var cr = document.getElementById("copyright");
	if(cr){
		cr.innerHTML = "Drawing ...";
	}

	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		PLG.mousePositionOffset = 2;
	}	


  if(PARAM.positlogMode == "EditMode"){
		PLG.state = STATES.WORKING;
	}
	else{
		PLG.state = STATES.VIEWING;
	}

	if(document.getElementById("drawingCheck")){
		document.getElementById("drawingCheck").checked = false;
	}

//	if(document.getElementById("allRegionCheck")){
//		EDT.showAllRegionFlag = document.getElementById("allRegionCheck").checked;
//	}
	if(document.getElementById("showRegionCheck")){
		EDT.showRegionFlag = document.getElementById("showRegionCheck").checked;
		EDT.showAllRegionFlag = document.getElementById("showRegionCheck").checked;
	}
	if(document.getElementById("showGuideCheck")){
		EDT.showGuideFlag = document.getElementById("showGuideCheck").checked;
	}


	// Set default url
	setCurrentURL(location.href);

	var spritesWorldNode = document.getElementById("spritesworld");
	var spritesListNode = document.getElementById("spriteslist");

	// Store current window size
	PLG.prevWindowWidth = getInnerWidth();
	PLG.prevWindowHeight = getInnerHeight();

	// Set drawing canvas
	PLG.drawcanvas = document.getElementById("drawcanvas");
	if(PLG.drawcanvas){
		if(PLG.drawcanvas && PLG.drawcanvas.getContext){
			PLG.drawcanvas.style.position = "absolute";
			PLG.drawcanvas.width = getInnerWidth();
			if(PARAM.positlogMode == "EditMode"){
//				PLG.drawcanvas.height = getInnerHeight() - document.getElementById("controlpanel").offsetHeight - document.getElementById("footer").offsetHeight;
				PLG.drawcanvas.height = getInnerHeight() - document.getElementById("controlpanel").offsetHeight - PLG.magicMargin;
			}
			else{
				PLG.drawcanvas.height = getInnerHeight();
			}
			PLG.drawcanvas.style.width = PLG.drawcanvas.width + "px";
			PLG.drawcanvas.style.height = PLG.drawcanvas.height + "px";
			PLG.drawctx = PLG.drawcanvas.getContext("2d");
		}
		else{
			PLG.drawcanvas.style.display = "none";
		}
		PLG.drawcanvas.style.display = "none";
	}

  // Set cursor
	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		document.body.style.cursor = 'wait';
	}
	if(PLG.cb.bw.mozes){
		spritesWorldNode.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand.cur), default";
	}

  // Process all sprites
	for (var id in PARAM.spritesHash){
		if(!id.match(/^sprite_.+$/)){
			continue;
		}

		if(PLG.debug){
			PARAM.spritesHash[id].orgy = sprTop(document.getElementById(id));
		}
  	// Set events
		if(document.getElementById(id)){
			var myRegion = document.getElementById(id).firstChild;
			if(myRegion.className == "spriteregion"){
				myRegion.onmouseover = spriteOnMouseOver;
			}
			else{
				alert("Error: Invalid sprite format");
			}

			// Store time
			PLG.recentSpriteTimes.push(PARAM.spritesHash[id].time);
		}
		else{
			delete(PARAM.spritesHash[id]);
		}
	}

	// Adjust margin
	adjustMargin("", PARAM.spritesHash);

	for (var id in PARAM.spritesHash){
		if(!id.match(/^sprite_.+$/)){
			continue;
		}

		// Correct absx and absy can not be calculated in adjustMargin() above
		if(!PARAM.spritesHash[id].parent && document.getElementById(id)){
			rebuildWholeGeometry(id, PARAM.spritesHash);
		}

   	// Store processed sprite
		if(document.getElementById(id)){
			PLG.sprites[id] = PARAM.spritesHash[id];
			PLG.numberOfSprites ++;
		}
	}
	delete(PARAM.spritesHash);

	var minLeft = 0;
	var minTop = 0;
	PLG.worldLeft += PLG.spriteBorderOffset;
	PLG.worldTop += PLG.spriteBorderOffset;
	if(PLG.worldTop > minTop){
		PLG.worldTop = minTop;
	}
	if(PLG.worldLeft > minLeft){
		PLG.worldLeft = minLeft;
	}
	if(PLG.worldBottom < minTop+1){
		PLG.worldBottom = minTop+1;
	}
	if(PLG.worldRight < minLeft+1){
		PLG.worldRight = minLeft+1;
	}


	// rebuild margin_s.younger
  if(PARAM.positlogMode == "EditMode"){
		rebuildYoungerArray();
	}

  // Sort by date
	var sortFunc = function(a,b){return b - a;};
	PLG.recentSpriteTimes.sort(sortFunc);

	// Create sprite menu 
	if(PLG.state == STATES.WORKING){
		var menuElm = document.createElement("div");
		menuElm.setAttribute("id", "spritemenu");
		menuElm.style.display = "none";
		if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
// Don't use alpha.
//			menuElm.style.filter = "alpha(opacity=80)";
		}
		else{
//			menuElm.style.opacity = 0.8;
		}

		var moverElm = document.createElement("div");
		moverElm.setAttribute("id", "sprite-mover");
		moverElm.onmousedown = moverOnMouseDown;
		menuElm.appendChild(moverElm);

		var editElm = document.createElement("div");
		editElm.setAttribute("id", "sprite-editor");
		editElm.onmousedown = function(){
			openEditor();
		};
		if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
			editElm.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand3.cur), default";
		}
		menuElm.appendChild(editElm);

		var commentElm = document.createElement("div");
		commentElm.setAttribute("id", "sprite-comment");
		commentElm.onmousedown = function(){
			createComment();
		};
		if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
			commentElm.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand3.cur), default";
		}
		menuElm.appendChild(commentElm);


		var deleteElm = document.createElement("div");
		deleteElm.setAttribute("id", "sprite-delete");
		deleteElm.onmousedown = function(){
			PLG.waitSavingFlag = true;			
			if(window.confirm("Detele OK?")){
				deleteSprite(false);
			}
			else{
				PLG.setViewPositionFlag = false;
				PLG.waitSavingFlag = false;
				PLG.ignoreMouseDown = true;
				return false;
			}
		};


		if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
			deleteElm.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand3.cur), default";
		}
		menuElm.appendChild(deleteElm);

		spritesWorldNode.appendChild(menuElm);

		var scalerElm = document.createElement("div");
		scalerElm.setAttribute("id", "sprite-scaler");
		scalerElm.style.top = "0px";
		scalerElm.style.left = "0px";
		scalerElm.onmousedown = scalerOnMouseDown;
		scalerElm.style.display = "none";
		spritesWorldNode.appendChild(scalerElm);
	}

	// Resize world
	if(PARAM.positlogMode == "ViewMode"){
		spritesListNode.style.height = (PLG.worldBottom +  Math.floor(getInnerHeight())/2) + "px";

		if(PARAM.page_type == "document"){
			spritesWorldNode.style.height = (PLG.worldBottom - PLG.worldTop + Math.floor(getInnerHeight())/2) + "px";
			spritesWorldNode.style.width = (PLG.worldRight - PLG.worldLeft + Math.floor(getInnerWidth())/2) + "px";
		}
		else{
			spritesWorldNode.style.height = (PLG.worldBottom - PLG.worldTop + Math.floor(getInnerHeight())) + "px";
			spritesWorldNode.style.width = (PLG.worldRight - PLG.worldLeft + Math.floor(getInnerWidth())) + "px";
		}
		
		spritesListNode.style.width = (PLG.worldRight + Math.floor(getInnerWidth())/2) + "px";

	}

	if(PARAM.positlogMode == "EditMode"){
		spritesWorldNode.style.top = document.getElementById("controlpanel").offsetHeight + "px";
		spritesWorldNode.style.height = (getInnerHeight() - document.getElementById("controlpanel").offsetHeight - PLG.magicMargin) + "px";
		spritesListNode.style.height = (PLG.worldBottom - PLG.worldTop + Math.floor(getInnerHeight()/2)) + "px";
		spritesListNode.style.width = (PLG.worldRight - PLG.worldLeft + Math.floor(getInnerWidth()/2)) + "px";
	}


  // Init small map
	initSmallMap();


	if(PLG.cb.bw.opera){
		PLG.magicMargin = 1;
	}
	else if(PLG.cb.bw.mozes){
		PLG.magicMargin = 3;		
	}
	else if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		PLG.magicMargin = 0;
	}

	if(PARAM.positlogMode == "ViewMode"){
		if(PLG.cb.bw.msie) {
		// set position:fixed for IE6
			var cpoffset = 0;
			var cp = document.getElementById("controlpanel");
			if(cp){
				cp.style.position = "absolute";
				cp.style.setExpression("top", "eval(document.compatMode && document.compatMode=='CSS1Compat') ?  document.documentElement.scrollTop : document.body.scrollTop");
				cp.style.setExpression("left", "eval(document.compatMode && document.compatMode=='CSS1Compat') ?  documentElement.scrollLeft : document.body.scrollLeft");
				cpoffset = cp.offsetHeight;
			}

			var hbtn = document.getElementById("homebtn");
			hbtn.style.position = "absolute";
			hbtn.style.setExpression("top", "eval(document.compatMode && document.compatMode=='CSS1Compat') ?  document.documentElement.scrollTop+" + cpoffset + " : document.body.scrollTop+" + cpoffset);
			hbtn.style.setExpression("left", "eval(document.compatMode && document.compatMode=='CSS1Compat') ?  documentElement.scrollLeft : document.body.scrollLeft");

			footer.style.position = "absolute";
			footer.style.setExpression("top", "eval(document.compatMode && document.compatMode=='CSS1Compat') ?  document.documentElement.scrollTop+document.documentElement.clientHeight-" + footer.offsetHeight + " : document.body.scrollTop+document.body.clientHeight-" + footer.offsetHeight);
			footer.style.setExpression("left",  "eval(document.compatMode && document.compatMode=='CSS1Compat') ?  document.documentElement.scrollLeft+document.documentElement.clientWidth-" + footer.offsetWidth + " : document.body.scrollLeft+document.body.clientWidth-" + footer.offsetWidth);

			PLG.drawcanvas.style.position = "absolute";
			PLG.drawcanvas.style.setExpression("top", "document.documentElement.scrollTop");
			PLG.drawcanvas.style.setExpression("left", "document.documentElement.scrollLeft");

			PLG.viewcanvas.style.position = "absolute";
			PLG.viewcanvas.style.setExpression("top",  "eval(document.compatMode && document.compatMode=='CSS1Compat') ?  document.documentElement.scrollTop+document.documentElement.clientHeight-" + PLG.viewcanvas.offsetHeight + "-" + footer.offsetHeight + " : document.body.scrollTop+document.body.clientHeight-" + PLG.viewcanvas.offsetHeight + "-" + footer.offsetHeight);
			PLG.viewcanvas.style.setExpression("left",  "eval(document.compatMode && document.compatMode=='CSS1Compat') ?  document.documentElement.scrollLeft+document.documentElement.clientWidth-" + PLG.viewcanvas.offsetWidth + " : document.body.scrollLeft+document.body.clientWidth-" + PLG.viewcanvas.offsetWidth);

			PLG.mapcanvas.style.position = "absolute";
			PLG.mapcanvas.style.setExpression("top",  "eval(document.compatMode && document.compatMode=='CSS1Compat') ?  document.documentElement.scrollTop+document.documentElement.clientHeight-" + PLG.mapcanvas.offsetHeight + "-" + footer.offsetHeight + " : document.body.scrollTop+document.body.clientHeight-" + PLG.mapcanvas.offsetHeight + "-" + footer.offsetHeight);
			PLG.mapcanvas.style.setExpression("left",  "eval(document.compatMode && document.compatMode=='CSS1Compat') ?  document.documentElement.scrollLeft+document.documentElement.clientWidth-" + PLG.mapcanvas.offsetWidth + " : document.body.scrollLeft+document.body.clientWidth-" + PLG.mapcanvas.offsetWidth);
		}
		else{
			var cpoffset = 0;
			var cp = document.getElementById("controlpanel");
			if(cp){
				cp.style.position = "fixed";
				cp.style.top = "0px";
				cp.style.left = "0px";
				cpoffset = cp.offsetHeight;
			}

			var hbtn = document.getElementById("homebtn");
			hbtn.style.position = "fixed";
			hbtn.style.top = cpoffset + "px";
			hbtn.style.left = "0px";

			footer.style.position = "fixed";
			footer.style.right = "0px";
			footer.style.bottom = PLG.magicMargin + "px";

			if(PLG.drawcanvas != null){
				PLG.drawcanvas.style.position = "fixed";
				PLG.drawcanvas.style.left = "0px";
				PLG.drawcanvas.style.top = "0px";
			}

			if(PLG.viewcanvas != null){
				PLG.viewcanvas.style.position = "fixed";
				PLG.viewcanvas.style.right = "0px";
// 				PLG.viewcanvas.style.bottom = (footer.offsetHeight + PLG.magicMargin + PLG.borderOfMap) + "px";
 				PLG.viewcanvas.style.bottom = (footer.offsetHeight + PLG.magicMargin) + "px";
			}
			if(PLG.mapcanvas != null){
				PLG.mapcanvas.style.position = "fixed";
				PLG.mapcanvas.style.right = "0px";
// 				PLG.mapcanvas.style.bottom = (footer.offsetHeight  + PLG.magicMargin + PLG.borderOfMap) + "px";
 				PLG.mapcanvas.style.bottom = (footer.offsetHeight  + PLG.magicMargin) + "px";
			}
		}
	}
	else{
		var cpoffset = 0;
		var cp = document.getElementById("controlpanel");
		if(cp){
			cp.style.position = "absolute";
			cp.style.top = "0px";
			cp.style.left = "0px";
			cpoffset = cp.offsetHeight;
		}
		var hbtn = document.getElementById("homebtn");
		hbtn.style.position = "absolute";
		hbtn.style.top = cpoffset + "px";
		hbtn.style.left = "0px";

		footer.style.position = "absolute";
		footer.style.bottom = PLG.magicMargin + "px";
		footer.style.right = "0px";

		PLG.mapcanvas.style.position = "absolute";
		PLG.mapcanvas.style.right = "0px";

		if(PLG.cb.bw.msie7) {
			PLG.mapcanvas.style.bottom = (footer.offsetHeight + PLG.magicMargin) + "px";
		}
		else{
			PLG.mapcanvas.style.bottom = (footer.offsetHeight + PLG.magicMargin + PLG.borderOfMap) + "px";
		}

		PLG.viewcanvas.style.position = "absolute";
 		PLG.viewcanvas.style.right = "0px";
		if(PLG.cb.bw.msie7) {
 			PLG.viewcanvas.style.bottom = (footer.offsetHeight + PLG.magicMargin) + "px";
		}
		else{
 			PLG.viewcanvas.style.bottom = (footer.offsetHeight + PLG.magicMargin + PLG.borderOfMap) + "px";
		}
	}

	//-------------------------------------------
	// Focus specific position
	//
  // Apply order:  edge > id > view position
	//-------------------------------------------
  if(PARAM.edge != ""){
		if(PARAM.edge == "top"){
			PARAM.id = PLG.topSprID;
		}
		else if(PARAM.edge == "bottom"){
			PARAM.id = PLG.bottomSprID;
		}
		else if(PARAM.edge == "left"){
			PARAM.id = PLG.leftSprID;
		}
		else if(PARAM.edge == "right"){
			PARAM.id = PLG.rightSprID;
		}
  }


  if(PARAM.id == "" && PARAM.vp == ""){
		var viewpositionValue = getCookie("viewposition");
		var viewDateValue = getCookie("viewDate");
		var date = new Date;

		if(viewpositionValue != undefined
			 && parseInt(date.getTime()) - parseInt(viewDateValue) < 1800000
			 ){
				 var vpArray = viewpositionValue.split(",");
				 if(vpArray[0] == PARAM.pageid){
					 setViewPosition(vpArray[2], vpArray[3]);
				 }
				 else{
					 if(PARAM.page_type == "map"){
						 setViewPosition(Math.floor(getInnerWidth()/2), Math.floor(getInnerHeight()/2));
					 }
					 else if(PARAM.page_type == "document"){
						 setViewPosition(-PLG.spriteBorderOffset, -PLG.spriteBorderOffset);
					 }
				 }
			 }
		else{
			if(PARAM.page_type == "map"){
				setViewPosition(Math.floor(getInnerWidth()/2), Math.floor(getInnerHeight()/2));
			}
			else if(PARAM.page_type == "document"){
				setViewPosition(-PLG.spriteBorderOffset, -PLG.spriteBorderOffset);
			}
		}
	}
	else if(PARAM.id != ""){
			PLG.focusedSprite = document.getElementById(PARAM.id);
			if(PLG.focusedSprite != null){
			var innerWidth = getInnerWidth();
			var leftOffset = Math.round(innerWidth/2 - sprWidth(PLG.focusedSprite)/2);
			if(leftOffset < 10){
				leftOffset = 10;
			}
//			var innerHeight = getInnerHeight() - document.getElementById("footer").offsetHeight;
			var innerHeight = getInnerHeight();
			if(innerHeight > Math.abs(PLG.worldBottom - PLG.worldTop)){
				innerHeight = Math.abs(PLG.worldBottom - PLG.worldTop);
			}
			var topOffset = Math.round(innerHeight/2 - sprHeight(PLG.focusedSprite)/2);
			if(topOffset < 10){
				topOffset = 10;
			}

      // Change view position if the focused sprite is not in the worldArea.
			var vpX = - sprLeftAbs(PLG.focusedSprite) + parseInt(leftOffset);
			var vpY = - sprTopAbs(PLG.focusedSprite) + parseInt(topOffset)
			setViewPosition(vpX,vpY);

      // show rectangle of PLG.focusedSprite
			var region = getSpriteRegion(PLG.focusedSprite);
			region.style.border = "2px solid #c06060";
			region.style.padding = "1px";
			PLG.orgZindexOfFocusedSprite = PLG.focusedSprite.style.zIndex;
			PLG.focusedSprite.style.zIndex = ZIND.GO_TEMP_FOREGROUND;
		}
  }
  else if(PARAM.vp != ""){
    // move to focused viewposition
		PARAM.vp.match(/^(.+),(.+)$/);
		var vpX = parseInt(RegExp.$1);
		var vpY = parseInt(RegExp.$2);

		if(PARAM.page_type == "map"){
			vpX += Math.floor(getInnerWidth()/2);
			vpY += Math.floor(getInnerHeight()/2);
		}
		setViewPosition(vpX, vpY);
  }


  // config control panel
  if(PARAM.positlogMode == "EditMode"){
		var controlPanelNode = document.getElementById("controlpanel");

		if(PLG.cb.bw.msie){
			controlPanelNode.style.position = "absolute";
		}
		else{
			controlPanelNode.style.position = "fixed";
		}

		setButtonEvents("newspritebtn", "newspritebtn_hl.gif", "newspritebtn.gif", "newspritebtn_rev.gif", "createSprite();");
		setButtonEvents("newpagebtn", "newpagebtn_hl.gif", "newpagebtn.gif", "newpagebtn_rev.gif", "createPage()");

  }

	// Set events
	if(PARAM.positlogMode == "ViewMode"){
		window.onscroll = adjustViewPosition;
	}
	else{
		window.onresize = generalOnResize;
	}

  document.onmousedown = generalOnMouseDown;
  document.onmouseup = generalOnMouseUp;
  document.onmousemove = generalOnMouseMove;
  document.onmouseout = generalOnMouseOut;

	if (window.addEventListener){
		window.addEventListener('DOMMouseScroll', generalOnMouseWheel, false);
	}
	window.onmousewheel = document.onmousewheel = generalOnMouseWheel;


	// Draw small map
	drawViewArea();
	if(PLG.cb.bw.safari){
		window.setTimeout('drawSmallMap()', 1000);
	}
	else{
		drawSmallMap();
	}

	// Keep watch on the change of fontsize
	PLG.fontSize = document.getElementById("footer").offsetHeight;
	PLG.fontSizeChecker = setInterval('layouter()', 1000);

	if(PARAM.positlogMode == "EditMode"){
		var status = "&nbsp;&nbsp;(" + PLG.numberOfSprites + "sprites, " + Math.abs(PLG.worldRight - PLG.worldLeft) + "x" +Math.abs(PLG.worldBottom - PLG.worldTop) + "pixels)";
		document.getElementById("status").innerHTML = status;
	}

	// Execute draw command on sprites
	setTimeout("execDrawCommand()",10);


}

//-----------------------------------
// Small map
//-----------------------------------
function focusingSmallmap()
{
	PLG.focusSmallMapCount++;
	var delta = 10;
	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		delta = 30;
	}
	var opacity = 40 + PLG.focusSmallMapCount * delta;
	if(opacity >= 100){
		opacity = 100;
		clearInterval(PLG.focusSmallMapTimer);
		PLG.focusSmallMapCount = 0;
		PLG.focusSmallMapTimer = null;
	}
	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		PLG.mapcanvas.style.filter = "alpha(opacity=" + opacity + ")";
	}
	else{
		PLG.mapcanvas.style.opacity = opacity / 100;
	}	
}

function unfocusingSmallmap()
{
	PLG.unfocusSmallMapCount++;
	var delta = 10;
	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		delta = 30;
	}
	var opacity = 100 - PLG.unfocusSmallMapCount * delta;
	if(opacity <= 40){
		opacity = 40;
		clearInterval(PLG.unfocusSmallMapTimer);
		PLG.unfocusSmallMapCount = 0;
		PLG.unfocusSmallMapTimer = null;
	}
	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		PLG.mapcanvas.style.filter = "alpha(opacity=" + opacity + ")";
	}
	else{
		PLG.mapcanvas.style.opacity = opacity / 100;
	}	
}

function focusSmallMap()
{
	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		if(PLG.mapcanvas.style.filter.match(/alpha\(opacity=(.+)\)/)){
			if(parseInt(RegExp.$1) == 100){
				return;
			}
		}
	}
	else{
		if(PLG.mapcanvas.style.opacity == 1.0){
			return;
		}
	}	
	if(PLG.focusSmallMapTimer != null){
		return;
	}
	PLG.focusSmallMapTimer = setInterval("focusingSmallmap()",20);
}

function unfocusSmallMap()
{
	if(PLG.focusSmallMapTimer != null){
		clearInterval(PLG.focusSmallMapTimer);
		PLG.focusSmallMapTimer = null;
		PLG.focusSmallMapCount = 0;
	}
	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		if(PLG.mapcanvas.style.filter.match(/alpha\(opacity=(.+)\)/)){
			if(parseInt(RegExp.$1) == 40){
				return;
			}
		}
	}
	else{
		if(PLG.mapcanvas.style.opacity == 0.4){
			return;
		}
	}
	if(PLG.unfocusSmallMapTimer != null){
		return;
	}	
  PLG.unfocusSmallMapTimer = setInterval("unfocusingSmallmap()",20);
}

function initSmallMap()
{
  // init small map
	PLG.mapcanvas = document.getElementById("mapcanvas");
	if(PLG.mapcanvas && PLG.mapcanvas.getContext){
		PLG.mapcanvas.style.border = "2px solid #505050";
		PLG.mapcanvas.style.zIndex = "2500000";
		PLG.mapcanvas.style.backgroundColor = "#ffffff";
		if(PLG.worldLeft == Number.MAX_VALUE
			 || PLG.worldRight == Number.MIN_VALUE
			 || PLG.worldTop == Number.MAX_VALUE
			 || PLG.worldBottom == Number.MIN_VALUE){
				 PLG.mapcanvas.width = 1;
				 PLG.mapcanvas.height = 1;
			 }
		else{
			var maxWidth = Math.abs(PLG.worldRight - PLG.worldLeft);
			var maxHeight = Math.abs(PLG.worldBottom - PLG.worldTop);
			if(maxWidth > maxHeight){
				PLG.mapcanvas.width = PLG.mapSize;
				PLG.mapcanvas.height = Math.round(PLG.mapSize * maxHeight / maxWidth);
			}
			else{
				PLG.mapcanvas.height = PLG.mapSize;
				PLG.mapcanvas.width = Math.round(PLG.mapSize * maxWidth / maxHeight);
			}
		}


		PLG.mapcanvas.style.height = PLG.mapcanvas.height + "px";
		PLG.mapcanvas.style.width = PLG.mapcanvas.width + "px";


		if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
			PLG.mapcanvas.style.filter = "alpha(opacity=40)";
		}
		else{
			PLG.mapcanvas.style.opacity = 0.4;
		}

		PLG.mapctx = PLG.mapcanvas.getContext("2d");
	}
	else if(PLG.mapcanvas){
		PLG.mapcanvas.style.display = "none";
	}

	PLG.viewcanvas = document.getElementById("viewcanvas");
	if(PLG.viewcanvas && PLG.viewcanvas.getContext){
		PLG.viewcanvas.style.border = "2px solid #e0e0e0";
		PLG.viewcanvas.style.zIndex = "2500010";
		PLG.viewcanvas.style.right = "0px";
		PLG.viewcanvas.width = PLG.mapcanvas.width;
		PLG.viewcanvas.height = PLG.mapcanvas.height;
		PLG.viewcanvas.style.height = PLG.mapcanvas.style.height;
		PLG.viewcanvas.style.width = PLG.mapcanvas.style.width;

		if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
			PLG.viewcanvas.style.filter = "alpha(opacity=30)";
		}
		else{
			PLG.viewcanvas.style.opacity = 0.3;
		}

		PLG.viewctx = PLG.viewcanvas.getContext("2d");
	}
	else if(PLG.viewcanvas){
		PLG.viewcanvas.style.display = "none";
	}
}


function drawSmallMap()
{
	if(PLG.mapcanvas && PLG.mapcanvas.getContext){
		var rate = 1;
		var maxWidth = Math.abs(PLG.worldRight - PLG.worldLeft);
		var maxHeight = Math.abs(PLG.worldBottom - PLG.worldTop);
		if(maxWidth > maxHeight){
			rate = PLG.mapSize / maxWidth;
		}
		else{
			rate = PLG.mapSize / maxHeight;
		}
		PLG.mapctx.clearRect(0, 0, PLG.mapcanvas.offsetWidth, PLG.mapcanvas.offsetHeight);
		
		var len = PLG.recentSpriteTimes.length;
		if(len > 5){
			len = 5;
		}

		for (var id in PLG.sprites){
			if(!id.match(/^sprite_.+$/)){
				continue;
			}

			if(PLG.sprites[id].isDrawing){
				PLG.mapctx.fillStyle = "#70a070";
			}
			else{
				PLG.mapctx.fillStyle = "#303030";
			}

			for(var i=0; i<len; i++){
				if(PLG.recentSpriteTimes[i] == PLG.sprites[id].time){
					var red = 255 - i*25;
					PLG.mapctx.fillStyle = "rgb(" + red + ",80,80)";
				}
			}

			if(PLG.sprites[id].position){
				var left = 1 + Math.round((-PLG.worldLeft + PLG.sprites[id].position.absx)*parseFloat(rate));
				var top = 1+Math.round((-PLG.worldTop + PLG.sprites[id].position.absy)*parseFloat(rate));
				var width = Math.round(PLG.sprites[id].width*parseFloat(rate));
				var height = Math.round(PLG.sprites[id].height*parseFloat(rate));

				if(left && top && width && height){
					PLG.mapctx.fillRect(left, top, width, height);
				}
			}
		}
	}
}


function drawViewArea()
{

	if(PLG.viewcanvas && PLG.viewcanvas.getContext){
		var maxWidth = Math.abs(PLG.worldRight - PLG.worldLeft);
		var maxHeight = Math.abs(PLG.worldBottom - PLG.worldTop);
		if(maxWidth > maxHeight){
			rate = PLG.mapSize / maxWidth;
		}
		else{
			rate = PLG.mapSize / maxHeight;
		}

		PLG.viewctx.clearRect(0, 0, PLG.viewcanvas.offsetWidth, PLG.viewcanvas.offsetHeight);

		var spritesWorldNode = document.getElementById("spritesworld");
		var left = Math.round((-PLG.worldLeft - parseInt(PLG.viewPositionX)) * parseFloat(rate));
		var top = Math.round((-PLG.worldTop - parseInt(PLG.viewPositionY)) * parseFloat(rate));
		var width = Math.round(getInnerWidth() * parseFloat(rate));
		var height = Math.round(getInnerHeight() * parseFloat(rate));

		if(left < 0){
			width += left;
			left = 0;
		}
		if(left + width > parseInt(PLG.mapcanvas.style.width)){
			width -= left + width - parseInt(PLG.mapcanvas.style.width);
		}
		if(top < 0){
			height += top;
			top = 0;
		}
		if(top + height > parseInt(PLG.mapcanvas.style.height)){
			height -= top + height - parseInt(PLG.mapcanvas.style.height);
		}

		PLG.viewctx.fillStyle = "#0000ff";
		PLG.viewctx.fillRect(left, top, width, height);
	}
}



function isInActiveArea(e)
{
	var yoffset = 0;
	if(PARAM.positlogMode == "EditMode"){
		yoffset = document.getElementById("controlpanel").offsetHeight;
	}

	var x = 0;
	var y = 0;
  if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		x = window.event.clientX;
		y = window.event.clientY;
	}
	else{
		x = e.pageX - parseInt(window.pageXOffset);
		y = e.pageY - parseInt(window.pageYOffset);
	}

	var cw = getInnerWidth();
	if(x > cw || x < 1){
		return false;
	}
	var ch = getInnerHeight();
//	ch -= document.getElementById("footer").offsetHeight;

	if(y > ch || y < yoffset + 1){
		return false;
	}

  return true;
}

function myScroll(delta)
{
  if(PLG.state == STATES.WORKING || PLG.state == STATES.VIEWING || PLG.state == STATES.VIEWINGFIXED || PLG.state == STATES.VIEWINGFIXEDSELECTED || PLG.state == STATES.VIEWINGSELECTED || PLG.state == STATES.SELECTED || PLG.state == STATES.FIXED || PLG.state == STATES.FIXEDSELECTED){
		var yoffset = 100;
		var moveY = delta * 2;
		var top = parseInt(PLG.viewPositionY) + moveY;

		var maxTop = PLG.worldTop	- Math.floor(getInnerHeight()/2);
		var maxBottom = PLG.worldBottom + Math.floor(getInnerHeight()/2);
//		if(PARAM.page_type == "map"){
			if(maxTop > -Math.floor(getInnerHeight()/2)){
				maxTop = -Math.floor(getInnerHeight()/2);
			}
			if(maxBottom < Math.floor(getInnerHeight()/2)){
				maxBottom = Math.floor(getInnerHeight()/2);
			}
//		}

		if(delta > 0 && maxTop - yoffset > -top){
			top = - (maxTop - yoffset);
		}
		if(delta <= 0 && maxBottom + yoffset - getInnerHeight() < - top){
			top = - (maxBottom + yoffset - getInnerHeight());
		}

		setViewPosition(PLG.viewPositionX, top);
	}
}


function generalOnResize(){
	setCurrentURL(PLG.currentURL);

	var footer = document.getElementById("footer");	
//	footer.style.bottom = "0px";
	footer.style.bottom = PLG.magicMargin + "px";
	footer.style.right = "0px";

	PLG.drawcanvas = document.getElementById("drawcanvas");
	if(PLG.drawcanvas != null){
		if(PLG.drawcanvas && PLG.drawcanvas.getContext){
			PLG.drawcanvas.width = getInnerWidth();
			var yoffset = 0;
			if(PARAM.positlogMode == "EditMode"){
//				yoffset = - document.getElementById("controlpanel").offsetHeight - document.getElementById("footer").offsetHeight;
				yoffset = - document.getElementById("controlpanel").offsetHeight;
			}
			PLG.drawcanvas.height = getInnerHeight() + yoffset;
			PLG.drawcanvas.style.width = getInnerWidth() + "px";
			PLG.drawcanvas.style.height = getInnerHeight() + yoffset + "px";
		}
	}

	var spritesWorldNode = document.getElementById("spritesworld");     
	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		spritesWorldNode.style.width = getInnerWidth() + "px";
		spritesWorldNode.style.height = getInnerHeight() + "px";
	}

	if(PARAM.positlogMode == "EditMode"){
//		spritesWorldNode.style.height = (getInnerHeight() - document.getElementById("controlpanel").offsetHeight - document.getElementById("footer").offsetHeight) + "px";
		spritesWorldNode.style.top = document.getElementById("controlpanel").offsetHeight + "px";
		spritesWorldNode.style.height = (getInnerHeight() - document.getElementById("controlpanel").offsetHeight-PLG.magicMargin) + "px";
	}

	if(PARAM.page_type == "map"){
		var newWidth = getInnerWidth();
		var newHeight = getInnerHeight();

		setViewPosition(PLG.viewPositionX + Math.floor((newWidth - PLG.prevWindowWidth)/2), PLG.viewPositionY + Math.floor((newHeight - PLG.prevWindowHeight)/2));

		PLG.prevWindowWidth = newWidth;
		PLG.prevWindowHeight = newHeight;
	}

	drawViewArea();
}

function generalOnMouseWheel(e){
	if(PARAM.positlogMode == "ViewMode"){
		return;
	}
	
  var delta = 0;
  if (!e){ /* For IE */
    e = window.event;
	}
  if (e.wheelDelta){ // IE/Opera
    delta = e.wheelDelta/5;
    // In Opera (<9.2), delta differs in sign as compared to IE.
		navigator.userAgent.match(/^Opera\/(.+?) \(.+$/);
		var version = parseFloat(RegExp.$1);
    if (PLG.cb.bw.opera && version < 9.2){
      delta = -delta;
		}
  } else if (e.detail) { // Mozilla
    delta = -e.detail*6;
  }
  if (delta){
    myScroll(delta);
	}
}



function generalOnMouseOut(e)
{
  if(!isInActiveArea(e) 
		 && PLG.state != STATES.MOVING 
		 && PLG.state != STATES.SCALING 
		 && !PLG.movingEditorFlag
		 && !PLG.movingDrawingToolFlag){
			 generalOnMouseUp();
		 }
}


function mouseDownProcedures(e)
{
  // ungroup
	if(PLG.ungroupingFlag){

		if(!PLG.waitSavingFlag){
			PLG.waitSavingFlag = true;
			saveStyles(PLG.fixedSprite);
			return;
		}
	}
	

  // check region of editor
  if(PLG.state == STATES.EDITING){
		var editor = document.getElementById("editor");
		if(getMouseX(e) > parseInt(editor.style.left) 
			 && getMouseX(e) < parseInt(editor.style.left)+editor.offsetWidth
			 && getMouseY(e) > parseInt(editor.style.top) 
			 && getMouseY(e) < parseInt(editor.style.top)+editor.offsetHeight){
				 return;
			 }
  }

	if(PLG.state == STATES.WORKING){
		if(getMouseX(e) - PLG.prevMouseDownX == 0 
			 && getMouseY(e) - PLG.prevMouseDownY == 0){
//				 if(PLG.cb.bw.mozes || PLG.cb.bw.opera || PLG.cb.bw.safari){
					 createSprite(false, false, true);
//				 }
			 }
		return;
	}
  else if(PLG.state == STATES.FIXED || PLG.state == STATES.VIEWINGFIXED){
		if(PARAM.positlogMode == "EditMode"){
			// check region of spritemenu
			var left = (sprLeft(PLG.fixedSprite) + PLG.viewPositionX) + "px";
			var top = (sprTop(PLG.fixedSprite) - 20 + PLG.viewPositionY) + "px";
			var width = (sprWidth(PLG.fixedSprite) + 6) + "px";
			if(getMouseX(e) > left
				 && getMouseX(e) < left + width
				 && getMouseY(e) > top
				 && getMouseY(e) < top + 21){
				return;
			}

			removeSpriteIcons();
			removeFixedFrame();
		}

		clearFixedSprite();

		if(PARAM.positlogMode == "EditMode"){
			PLG.state = STATES.WORKING;
		}
		else{
			PLG.state = STATES.VIEWING;
		}
  }
  else if(PLG.state == STATES.FIXEDSELECTED || PLG.state == STATES.VIEWINGFIXEDSELECTED){
		if(PLG.fixedSprite != PLG.selectedSprite){
      // Fix another sprite
			if(PARAM.positlogMode == "EditMode"){			
				removeSpriteIcons();
				removeFixedFrame();
				removeUngroupIcon();
			}
			clearFixedSprite();
			var tmpSprite = PLG.selectedSprite;
			setFixedSprite(tmpSprite);
			if(PARAM.positlogMode == "EditMode"){
				setFixedFrame(tmpSprite);
				setFamilyFrame(tmpSprite);
				setSpriteIcons(tmpSprite);
			}
		}
		else{
			if(PLG.state == STATES.FIXEDSELECTED){
				if(getMouseX(e) - PLG.prevMouseDownX == 0 
					 && getMouseY(e) - PLG.prevMouseDownY == 0){
						 openEditor();
				}
			}
		}
	}
  else if(PLG.state == STATES.SELECTED || PLG.state == STATES.VIEWINGSELECTED){
		if(PARAM.positlogMode == "EditMode"){
			PLG.state = STATES.FIXEDSELECTED;
 			removeSelectedFrame(PLG.selectedSprite);
			setFamilyFrame(PLG.selectedSprite);
 			setFixedSprite(PLG.selectedSprite);
			setFixedFrame(PLG.selectedSprite);

			setSpriteIcons(PLG.selectedSprite);		
		}
		else{
			PLG.state = STATES.VIEWINGFIXEDSELECTED;
 			setFixedSprite(PLG.selectedSprite);
		}
  }

  // spoit for picking color
  if(PLG.state == STATES.EDITINGSELECTED){
		var selContents = getSpriteContents(PLG.selectedSprite);
		var contents = getSpriteContents(PLG.fixedSprite);
		if(EDT.frameColorDialogOpen){
			setColor2Selector(selContents.style.borderTopColor, "#000000");
		}
		else if(EDT.bgColorDialogOpen){
			setColor2Selector(selContents.style.backgroundColor, "#ffffff");
		}
		else if(EDT.foreColorDialogOpen){
			setColor2Selector(selContents.style.color, "#000000");
		}
		return;
  }


  // Move fixed sprite to front or back
  if((PLG.state == STATES.FIXEDSELECTED || PLG.state == STATES.VIEWINGFIXEDSELECTED)
		 && PLG.fixedSprite == PLG.selectedSprite){
			 if(PARAM.positlogMode != "EditMode"){
      // Use parseFloat to pase 1e+06 to 1000000 on Safari
				 if(parseFloat(PLG.selectedSprite.style.zIndex) == ZIND.GO_TEMP_FOREGROUND){
					 if(PLG.counterForMoveToBackground >= 4){
						 PLG.selectedSprite.style.zIndex = ZIND.GO_TEMP_BACKGROUND;
					 }
					 else{
						 PLG.counterForMoveToBackground++;
					 }
				 }
				 else if(parseFloat(PLG.selectedSprite.style.zIndex) == ZIND.GO_TEMP_BACKGROUND){
					 PLG.selectedSprite.style.zIndex = PLG.orgZindexOfFixedSprite;
					 PLG.counterForMoveToBackground = 0;
				 }
				 else{
					 PLG.selectedSprite.style.zIndex = ZIND.GO_TEMP_FOREGROUND;
					 PLG.counterForMoveToBackground = 0;
				 }
				 return;
			 }
			 else{
				 PLG.selectedSprite.style.zIndex = ZIND.GO_TEMP_FOREGROUND;
			 }
		 }
  else{
		PLG.counterForMoveToBackground = 0;
  }
}


function generalOnMouseDown(e)
{
  if(PLG.state == STATES.SCALING){
		return;
	}

	if(PLG.ignoreMouseDown){
		PLG.ignoreMouseDown = false;
		return;
	}
	if(PLG.waitSavingFlag){
		return;
	}

	var x = 0;	var y = 0; var offx = 0; var offy = 0;
	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		x = window.event.clientX;	y = window.event.clientY;	
		if(PLG.cb.bw.msie){
			offx = document.documentElement.scrollLeft; offy = document.documentElement.scrollTop;
		}
	}
	else{
		x = e.pageX - parseInt(window.pageXOffset);	y = e.pageY - parseInt(window.pageYOffset);	
	}

	if(PLG.mapcanvas && PLG.mapcanvas.getContext){
		if(x+offx >= PLG.mapcanvas.offsetLeft && x+offx < PLG.mapcanvas.offsetLeft + PLG.mapcanvas.offsetWidth && y+offy >= PLG.mapcanvas.offsetTop && y+offy < PLG.mapcanvas.offsetTop + PLG.mapcanvas.offsetHeight){
			if(PLG.drawingFlag){
				return;
			}

			PLG.setSmallMapFlag = true;
			return;
		}
		else{
			PLG.setSmallMapFlag = false;
		}
	}

	// check drawing tool area
	if(PLG.drawingFlag){
    var tcsElm = document.getElementById("trianglecolorselector");
    var barElm = document.getElementById("drawingtitlebar");
    var cpElm = document.getElementById("controlpanel");
		if(x >= tcsElm.offsetLeft && x <= tcsElm.offsetLeft + tcsElm.offsetWidth && 
			 y >= cpElm.offsetHeight + tcsElm.offsetTop - barElm.offsetHeight && y <= cpElm.offsetHeight + tcsElm.offsetTop + tcsElm.offsetHeight){
			if(y < cpElm.offsetHeight + tcsElm.offsetTop){
				PLG.movingDrawingToolFlag = true;
			}
			else{
				return;
			}
		}
	}

  // check region of active area
  if(!isInActiveArea(e)){
		return;
  }

  //-------------------------
  // Process mouse down event
  //-------------------------
	if(PLG.focusedSprite != null){
		var region = getSpriteRegion(PLG.focusedSprite);
		region.style.border = "0px none black";
		region.style.padding = "3px";
		PLG.focusedSprite.style.zIndex = PLG.orgZindexOfFocusedSprite;
		PLG.focusedSprite = null;
	}
	
	mouseDownProcedures(e);

	PLG.prevMouseDownX = getMouseX(e);
	PLG.prevMouseDownY = getMouseY(e);

  if(PLG.prevMouseX == 0){
		PLG.prevMouseX = getMouseX(e);
  }
  if(PLG.prevMouseY == 0){
		PLG.prevMouseY = getMouseY(e);
  }


	if(PLG.movingDrawingToolFlag){
		return;
	}

	if(PLG.drawingFlag){
		PLG.pendownFlag = true;
		PLG.pendownFirstFlag = true;
		return;
	}


	// Move view position of sprites world
	var canMove = false;
	if(PLG.selectedSprite != null){
		var contents = getSpriteContents(PLG.selectedSprite).firstChild;
		if(contents.nodeType == 1 && 
			 (contents.tagName.match(/^canvas$/gi) 
				|| 	(contents.tagName.match(/^img$/gi)) )){
			canMove = true;
			if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
				e=event;
				e.returnValue = false;
				e.cancelBubble = true;
			}
			else{
				e.preventDefault(); 
				e.stopPropagation();
			}
			if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
				PLG.selectedSprite.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand.cur), default";
			}
		}
		else{
			enableSelection();
		}
	}
	else{
		canMove = true;
		if((!document.getElementById("editor") || PLG.movingEditorFlag)){
			disableSelection();
		}
		else{
			enableSelection();
		}
	}


	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		if(document.selection.type != "None"){
//			document.selection.empty();
		}
	}


  if(PLG.state == STATES.WORKING || ((PLG.state == STATES.VIEWING || PLG.state == STATES.VIEWINGSELECTED || PLG.state == STATES.VIEWINGFIXEDSELECTED || PLG.state == STATES.VIEWINGFIXED)  && canMove)){
		PLG.setViewPositionFlag = true;

		if(PLG.cb.bw.mozes || PLG.cb.bw.msie7){
			var spritesWorldNode = document.getElementById("spritesworld");     
			spritesWorldNode.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand2.cur), default";
		}
	}
}

// It does not work on opera
function disableSelection()
{
	var body = document.getElementById("positlogbody");
	if(PLG.cb.bw.mozes){
		body.style.MozUserSelect = "none";
	}else if(PLG.cb.bw.safari){
		body.style.KhtmlUserSelect = "none"; 
	}else	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		document.onselectstart = function(){return false;};
	}
}

// It does not work on opera
function enableSelection()
{	
	var body = document.getElementById("positlogbody");
	if(PLG.cb.bw.mozes){
		body.style.MozUserSelect = "";
	}else if(PLG.cb.bw.safari){
		body.style.KhtmlUserSelect = ""; 
	}else	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		document.onselectstart = function(){return true;};
	}
}

function adjustViewPosition(){
	var worldOffsetX = 0;
	var worldOffsetY = 0;

	if(PARAM.positlogMode == "ViewMode"){
		if(PARAM.page_type == "document"){
			worldOffsetX = PLG.worldLeft + PLG.spriteBorderOffset;
			worldOffsetY = PLG.worldTop + PLG.spriteBorderOffset;
		}
		else if(PARAM.page_type == "map"){
			worldOffsetX = PLG.worldLeft - Math.floor(getInnerWidth()/2);
			worldOffsetY = PLG.worldTop - Math.floor(getInnerHeight()/2);
		}
	}

	if(PLG.cb.bw.safari){
		PLG.viewPositionX = -document.body.scrollLeft - worldOffsetX;
		PLG.viewPositionY = -document.body.scrollTop - worldOffsetY;
	}
	else{
		PLG.viewPositionX = -document.documentElement.scrollLeft - worldOffsetX;
		PLG.viewPositionY = -document.documentElement.scrollTop - worldOffsetY
	}

//	setViewPosition(PLG.viewPositionX, PLG.viewPositionY, true, true);

	drawViewArea();

	var homeX = 0;
	var homeY = 0;	
	if(PARAM.page_type == "document"){
		homeX = -PLG.spriteBorderOffset;
		homeY = -PLG.spriteBorderOffset;
	}
	else if(PARAM.page_type == "map"){
		homeX = Math.floor(getInnerWidth()/2);
		homeY = Math.floor(getInnerHeight()/2);
	}

	if(document.getElementById("homebtn")){
		if(PLG.viewPositionX != homeX || PLG.viewPositionY != homeY){
			var homeBtn = document.getElementById("homebtn");		
			homeBtn.style.display = "block";
		}
		else{
			var homeBtn = document.getElementById("homebtn");		
			homeBtn.style.display = "none";
		}
	}

	var pageX = PLG.viewPositionX;
	var pageY = PLG.viewPositionY;
	if(PARAM.page_type == "document"){
		pageX += PLG.spriteBorderOffset;
		pageY += PLG.spriteBorderOffset;
	}
	else if(PARAM.page_type == "map"){
		pageX -= Math.floor(getInnerWidth()/2);
		pageY -= Math.floor(getInnerHeight()/2);
	}

	var urlArray = location.href.split("?");
	var urlArray2 = urlArray[0].split("/");
	var newURL = "";
	for(var i=0; i<urlArray2.length-1; i++){
		newURL += urlArray2[i];
		newURL += "/";
	}
	newURL += "positlog.cgi?load=" + PARAM.pageid + "&vp=" + pageX + "," + pageY;
	setCurrentURL(newURL);

}

function generalOnMouseMove(e)
{
	if(PLG.adjustViewPositionFlag){
		PLG.adjustViewPositionFlag = false;
		adjustViewPosition();
	}

	if(PLG.waitSavingFlag){
		return;
	}

	// Small map
	var x = 0;	var y = 0; var offx = 0; var offy = 0;
	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		x = window.event.clientX;	y = window.event.clientY;	
		if(PLG.cb.bw.msie){
			offx = document.documentElement.scrollLeft; offy = document.documentElement.scrollTop;
		}
	}
	else{
		x = e.pageX - parseInt(window.pageXOffset);	y = e.pageY - parseInt(window.pageYOffset);
	}

	if(PLG.mapcanvas && PLG.mapcanvas.getContext){
		if(x+offx >= PLG.mapcanvas.offsetLeft && x+offx < PLG.mapcanvas.offsetLeft + PLG.mapcanvas.offsetWidth && y+offy >= PLG.mapcanvas.offsetTop && y+offy < PLG.mapcanvas.offsetTop + PLG.mapcanvas.offsetHeight){
			if(PLG.setSmallMapFlag){
				var rate = Math.abs(PLG.worldBottom - PLG.worldTop) / parseInt(PLG.mapcanvas.style.height);
				var newX = PLG.worldLeft + Math.floor((x+offx-PLG.mapcanvas.offsetLeft)*rate);
				var newY = PLG.worldTop + Math.floor((y+offy-PLG.mapcanvas.offsetTop)*rate);
				setViewPosition(-newX + Math.floor(getInnerWidth()/2), -newY + Math.floor(getInnerHeight()/2),true,true);
				return;
			}
			else{
				focusSmallMap();
			}
		}
		else{
			PLG.setSmallMapFlag = false;
			unfocusSmallMap();
		}
	}


	if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		if(PARAM.positlogMode != "EditMode" && PLG.selectedSprite != null){
			var contents = getSpriteContents(PLG.selectedSprite).firstChild;
			if(contents.nodeType == 1 && 
				 (contents.tagName.match(/^canvas$/gi) 
					|| 	(contents.tagName.match(/^img$/gi)) )){
						e=event;
						e.returnValue = false;
						e.cancelBubble = true;
						if(document.selection.type != "None"){
							document.selection.empty();
						}
					}
		}
	}

  // check border of Sprites World
 if(!PLG.setViewPositionFlag 
		 && !PLG.movingEditorFlag
		 && !PLG.movingDrawingToolFlag
		 && !(PLG.state == STATES.MOVING || PLG.state == STATES.MOVINGSELECTED || PLG.state == STATES.SCALING || PLG.state == STATES.SCALINGSELECTED)){
			 if(!isInActiveArea(e)){
				 PLG.mouseOutOfWorld = true;
				 if(PARAM.positlogMode == "ViewMode"){
					 PLG.adjustViewPositionFlag = true;
				 }
				 return;
			 }
		 }

	PLG.mouseOutOfWorld = false;

  var moveX = getMouseX(e) - PLG.prevMouseX;
  var moveY = getMouseY(e) - PLG.prevMouseY;

	if(PLG.drawingFlag && !PLG.movingDrawingToolFlag){
		if(PLG.pendownFlag){
			if(PLG.pendownFirstFlag){
				PLG.drawctx.lineCap = "round";
				PLG.drawctx.lineJoin = "round";
				PLG.drawctx.lineWidth = PLG.pensize;
				PLG.drawctx.strokeStyle = PLG.penColor;

				PLG.drawRecord.push("l");
				PLG.drawRecord.push("s" + PLG.pensize);
				PLG.drawRecord.push("c" + PLG.penColor);
				PLG.pendownFirstFlag = false;
			}

			var yoffset = document.getElementById("controlpanel").offsetHeight;
			var prevY = parseInt(PLG.prevMouseY)-parseInt(yoffset);

			PLG.drawctx.beginPath();
			PLG.drawctx.moveTo(PLG.prevMouseX,prevY);		
			PLG.drawRecord.push(PLG.prevMouseX);
			PLG.drawRecord.push(prevY);
			
			if(PLG.drawCanvasLeft > PLG.prevMouseX){
				PLG.drawCanvasLeft = PLG.prevMouseX;
			}
			if(PLG.drawCanvasRight < PLG.prevMouseX){
				PLG.drawCanvasRight = PLG.prevMouseX;
			}
			if(PLG.drawCanvasTop > prevY){
				PLG.drawCanvasTop = prevY;
			}
			if(PLG.drawCanvasBottom < prevY){
				PLG.drawCanvasBottom = prevY;
			}

			var nextX = getMouseX(e);
			var nextY = getMouseY(e)-parseInt(yoffset)
			PLG.drawctx.lineTo(nextX,nextY);		
			PLG.drawctx.stroke();

			PLG.drawRecord.push(nextX);
			PLG.drawRecord.push(nextY);
			if(PLG.drawCanvasLeft > nextX){
				PLG.drawCanvasLeft = nextX;
			}
			if(PLG.drawCanvasRight < nextX){
				PLG.drawCanvasRight = nextX;
			}
			if(PLG.drawCanvasTop > nextY){
				PLG.drawCanvasTop = nextY;
			}
			if(PLG.drawCanvasBottom < nextY){
				PLG.drawCanvasBottom = nextY;
			}
		}

		PLG.prevMouseX = getMouseX(e);
		PLG.prevMouseY = getMouseY(e);

		return;
	}

  PLG.prevMouseX = getMouseX(e);
  PLG.prevMouseY = getMouseY(e);


	if(PLG.state == STATES.WORKING){
		document.getElementById("controlresult").innerHTML="";
	}
	
	if(PARAM.positlogMode == "EditMode"){
		editModeOnMouseMove(moveX, moveY);
	}

  if(PLG.setViewPositionFlag){
		setViewPosition(parseInt(PLG.viewPositionX) + moveX, parseInt(PLG.viewPositionY) + moveY, true, true);
		return;
  }

  // Check whether mouse is on the selected Sprite.
  if((PLG.state == STATES.VIEWINGSELECTED
			|| PLG.state == STATES.VIEWINGFIXEDSELECTED
			|| PLG.state == STATES.SELECTED
			|| PLG.state == STATES.FIXEDSELECTED
			|| PLG.state == STATES.EDITINGSELECTED
			|| PLG.state == STATES.MOVINGSELECTED)
		 && !PLG.movingEditorFlag){
			 checkClearSelectedSprite(e);
		 }

}


function setViewPosition(posX, posY, refreshView, noCookie)
{
	if(isNaN(posX) || isNaN(posY)){
		return;
	}

	var worldOffsetX = 0;
	var worldOffsetY = 0;
	if(PARAM.positlogMode == "ViewMode"){
		if(PARAM.page_type == "document"){
			worldOffsetX = PLG.worldLeft + PLG.spriteBorderOffset;
			worldOffsetY = PLG.worldTop + PLG.spriteBorderOffset;

			if(posX > -worldOffsetX){
				posX = -worldOffsetX;
			}
			else if(posX < -(PLG.worldRight- Math.floor(getInnerWidth()/2))){
				posX = -(PLG.worldRight- Math.floor(getInnerWidth()/2));
			}
			if(posY > -worldOffsetY){
				posY = -worldOffsetY;
			}
			else if(posY < -(PLG.worldBottom- Math.floor(getInnerHeight()/2))){
				posY = -(PLG.worldBottom- Math.floor(getInnerHeight()/2));
			}			
		}
		else if(PARAM.page_type == "map"){
			worldOffsetX = PLG.worldLeft - Math.floor(getInnerWidth()/2);
			worldOffsetY = PLG.worldTop - Math.floor(getInnerHeight()/2);

			if(posX > -worldOffsetX){
				posX = -worldOffsetX;
			}
			else if(posX < -(PLG.worldRight- Math.floor(getInnerWidth()/2))){
				posX = -(PLG.worldRight- Math.floor(getInnerWidth()/2));
			}
			if(posY > -worldOffsetY){
				posY = -worldOffsetY;
			}
			else if(posY < -(PLG.worldBottom- Math.floor(getInnerHeight()/2))){
				posY = -(PLG.worldBottom- Math.floor(getInnerHeight()/2));
			}
		}
	}

  // move view posion (namely, move all Sprites)
	PLG.viewPositionX = parseInt(posX);
	PLG.viewPositionY = parseInt(posY);

	var pageX = parseInt(posX);
	var pageY = parseInt(posY);
	if(PARAM.page_type == "document"){
		pageX += PLG.spriteBorderOffset;
		pageY += PLG.spriteBorderOffset;
	}
	else if(PARAM.page_type == "map"){
		pageX -= Math.floor(getInnerWidth()/2);
		pageY -= Math.floor(getInnerHeight()/2);
	}

	var urlArray = location.href.split("?");
	var urlArray2 = urlArray[0].split("/");
	var newURL = "";
	for(var i=0; i<urlArray2.length-1; i++){
		newURL += urlArray2[i];
		newURL += "/";
	}
	newURL += "positlog.cgi?load=" + PARAM.pageid + "&vp=" + pageX + "," + pageY;


	if(PARAM.positlogMode == "ViewMode"){
		var spritesListNode = document.getElementById("spriteslist");
		spritesListNode.style.left = (-worldOffsetX) + "px";
		spritesListNode.style.top = (-worldOffsetY) + "px";
		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.style.backgroundPosition = (-worldOffsetX) + "px" + " " + (-worldOffsetY) + "px";

		window.scrollTo( -PLG.viewPositionX - worldOffsetX, -PLG.viewPositionY - worldOffsetY);
	}
	else{
		var spritesListNode = document.getElementById("spriteslist");
		spritesListNode.style.left = PLG.viewPositionX + "px";
		spritesListNode.style.top = PLG.viewPositionY + "px";
		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.style.backgroundPosition = PLG.viewPositionX.toString() + "px" + " " + PLG.viewPositionY.toString() + "px";
		setCurrentURL(newURL);
	}

	if(refreshView == undefined || refreshView == true){
		drawViewArea();
	}

	var homeX = 0;
	var homeY = 0;	
	if(PARAM.page_type == "document"){
		homeX = -PLG.spriteBorderOffset;
		homeY = -PLG.spriteBorderOffset;
	}
	else if(PARAM.page_type == "map"){
		homeX = Math.floor(getInnerWidth()/2);
		homeY = Math.floor(getInnerHeight()/2);
	}

	if(document.getElementById("homebtn")){
		if(posX != homeX || posY != homeY){
			var homeBtn = document.getElementById("homebtn");		
			homeBtn.style.display = "block";
		}
		else{
			var homeBtn = document.getElementById("homebtn");		
			homeBtn.style.display = "none";
		}
	}

	if(PLG.state == STATES.FIXED || PLG.state == STATES.FIXEDSELECTED){
		var menu = document.getElementById("spritemenu");
		menu.style.left = (sprLeftAbs(PLG.fixedSprite) + PLG.viewPositionX) + "px";
		menu.style.top = (sprTopAbs(PLG.fixedSprite) - 20 + PLG.viewPositionY) + "px";

		var scalerElm = document.getElementById("sprite-scaler");
		scalerElm.style.left = (sprLeftAbs(PLG.fixedSprite) + sprWidth(PLG.fixedSprite) - 18 + PLG.viewPositionX) + "px";
		scalerElm.style.top = (sprTopAbs(PLG.fixedSprite) + sprHeight(PLG.fixedSprite) - 24 + PLG.viewPositionY) + "px";

		redrawCanvas(PLG.fixedSprite);
	}

	if(!noCookie){
		// ViewPositionCookie must be set in unloading and reloading page.
		// Almost browsers throw unload event when a page is reload,
		// however Opera does not.
		if(PLG.cb.bw.opera){
			setViewPositionCookie();
		}
	}

}

function f(t){
	return Math.sin(Math.PI*t/2.0);
}

function hokan(r,zs,ze,ts,te){
  //r=[0:1]の値を同じく[0:1]に関数ｆで射影します
  r=(f((te-ts)*r+ts)-f(ts))/(f(te)-f(ts));
  return (ze-zs)*r+zs;
}

function moving()
{
  var r=PLG.moveCount/(PLG.moveDivision-1.0);

  var x=hokan(r,PLG.animeStartX,PLG.animeEndX,-1,1); x=Math.round(x);
  var y=hokan(r,PLG.animeStartY,PLG.animeEndY,-1,1); y=Math.round(y);


	if(PLG.moveCount >= PLG.moveDivision-1.0){
		clearInterval(PLG.moveTimer);
		PLG.moveCount = 0;
	}
	else{
		PLG.moveCount++;
	}
	setViewPosition(x, y);
}

function moveHomePosition()
{
	moveViewPosition(0,0);
}

function moveToSprite(id)
{
	var spr = document.getElementById(id);
	var innerWidth = getInnerWidth();
	if(innerWidth > Math.abs(PLG.worldRight - PLG.worldLeft)){
		innerWidth = Math.abs(PLG.worldRight - PLG.worldLeft);
	}
	var leftOffset = Math.round(innerWidth/2 - sprWidth(spr)/2);
	if(leftOffset < 10){
		leftOffset = 10;
	}
//	var innerHeight = getInnerHeight() - document.getElementById("footer").offsetHeight;
	var innerHeight = getInnerHeight();
	if(innerHeight > Math.abs(PLG.worldBottom - PLG.worldTop)){
		innerHeight = Math.abs(PLG.worldBottom - PLG.worldTop);
	}
	var topOffset = Math.round(innerHeight/2 - sprHeight(spr)/2);
	if(topOffset < 10){
		topOffset = 10;
	}

  // Change view position if the focused sprite is not in the worldArea.
	var vpX = - sprLeftAbs(spr) + parseInt(leftOffset);
	var vpY = - sprTopAbs(spr) + parseInt(topOffset);

	moveViewPosition(vpX, vpY, false);

}

function moveViewPosition(posX, posY, centering)
{
	if(PLG.moveTimer != null){
		clearInterval(PLG.moveTimer);
		PLG.moveCount = 0;
	}

	if(PARAM.page_type == "document"){
		posX -= PLG.spriteBorderOffset;
		posY -= PLG.spriteBorderOffset;
	}
	else if(centering == undefined && PARAM.page_type == "map" || centering){
		posX += Math.floor(getInnerWidth()/2);
		posY += Math.floor(getInnerHeight()/2);
	}

  PLG.moveTimer = setInterval("moving()",20);
	PLG.animeStartX = PLG.viewPositionX;
	PLG.animeStartY = PLG.viewPositionY;
	PLG.animeEndX = posX;
	PLG.animeEndY = posY;
}


function generalOnMouseUp(e)
{
	if(PLG.ignoreMouseUp){
		PLG.ignoreMouseUp = false;
		return;
	}

	if(PLG.ignoreMouseDown){
		PLG.ignoreMouseDown = false;
	}

	if(PLG.waitSavingFlag){
		return;
	}

	if(PLG.drawingFlag){
		PLG.prevMouseX = 0;
		PLG.prevMouseY = 0;
		PLG.pendownFlag = false;

		PLG.movingDrawingToolFlag = false;
	}


	if(PLG.setSmallMapFlag){
		var x = 0;	var y = 0; var offx = 0; var offy = 0;
		if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
			x = window.event.clientX;	y = window.event.clientY;	
			if(PLG.cb.bw.msie){
				offx = document.documentElement.scrollLeft; offy = document.documentElement.scrollTop;
			}
		}
		else{	x = e.pageX - parseInt(window.pageXOffset);	y = e.pageY - parseInt(window.pageYOffset);	}
		if(x+offx >= PLG.mapcanvas.offsetLeft && x+offx < PLG.mapcanvas.offsetLeft + PLG.mapcanvas.offsetWidth && y+offy >= PLG.mapcanvas.offsetTop && y+offy < PLG.mapcanvas.offsetTop + PLG.mapcanvas.offsetHeight){
			var rate = Math.abs(PLG.worldBottom - PLG.worldTop) / parseInt(PLG.mapcanvas.style.height);
			var newX = PLG.worldLeft + Math.floor((x+offx-PLG.mapcanvas.offsetLeft)*rate);
			var newY = PLG.worldTop + Math.floor((y+offy-PLG.mapcanvas.offsetTop)*rate);

			if(PARAM.page_type == "document"){
				newX -= Math.floor(getInnerWidth()/2);
				newY -= Math.floor(getInnerHeight()/2);
			}
			moveViewPosition(-newX, -newY, true);
		}

		PLG.setSmallMapFlag = false;
		return;
	}

	if(PLG.setViewPositionFlag){
		PLG.setViewPositionFlag = false;	
		if(PLG.cb.bw.opera){
			setViewPositionCookie();
		}
	}

	if(PLG.cb.bw.mozes || PLG.cb.bw.msie7  || PLG.cb.bw.msie){
		if(!PLG.drawingFlag){
			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand.cur), default";
		}
	}

	if(PARAM.positlogMode == "EditMode"){
		editModeOnMouseUp();
	}

}



//------------------------------------
// SpriteOnMouseOver
//------------------------------------

function spriteOnMouseOver()
{
	if(PLG.groupingFlag || PLG.waitSavingFlag || PLG.ungroupingFlag){
		return;
	}
	if(PLG.drawingFlag){
		return;
	}

  var contElm = this;
  if(contElm == null && contElm == undefined){
		return;
	}

  var elm = contElm.parentNode;
  if((elm == null && elm == undefined)
		 || PLG.mouseOutOfWorld
		 || document.getElementById("password-dialog")
		 ){
			 return;
		 }

	if(PLG.debug && PARAM.positlogMode == "EditMode" ){
		var s_pix = "none";
		var s_pos = "none";
		var p_pix = "none";
		var p_pos = "none";
		var s_bottom = "none";
		var s_id = "none";
		var parent = "none";
		if(PLG.sprites[elm.id].margin_s){
			s_pix = PLG.sprites[elm.id].margin_s.pixel;
			s_pos = PLG.sprites[elm.id].margin_s.position;
		}
		if(PLG.sprites[elm.id].margin_p){
			p_pix = PLG.sprites[elm.id].margin_p.pixel;
			p_pos = PLG.sprites[elm.id].margin_p.position;
		}
		if(PLG.sprites[elm.id].s_bottom){
			s_bottom = PLG.sprites[elm.id].s_bottom;
			s_id = PLG.sprites[elm.id].s_id;
		}
		if(PLG.sprites[elm.id].parent){
			parent = PLG.sprites[elm.id].parent;
		}
		document.getElementById("currentposition").innerHTML = elm.id + "(parent:" + parent + "),orgy:" + PLG.sprites[elm.id].orgy + ",y:" + PLG.sprites[elm.id].position.y + ",absy:" + PLG.sprites[elm.id].position.absy + ",realy:" + sprTop(elm) + ",s_pix:" + s_pix + ",s_pos:" + s_pos + ",p_pix:" + p_pix + ",p_pos:" + p_pos + ",s_bottom:" + s_bottom + "(" + s_id + "),my_bottom:" + PLG.sprites[elm.id].region.bottom;
	}

	if(PLG.state == STATES.WORKING || PLG.state == STATES.VIEWING){
		setSelectedSprite(elm);
		if(PARAM.positlogMode == "EditMode"){
			PLG.state = STATES.SELECTED;
			setSelectedFrame(elm);
		}
		else{
			PLG.state = STATES.VIEWINGSELECTED;
		}
  }
  else if(PLG.state == STATES.SELECTED || PLG.state == STATES.VIEWINGSELECTED){
		if(PLG.selectedSprite != elm){
			if(PARAM.positlogMode == "EditMode"){
				removeSelectedFrame(PLG.selectedSprite);
				clearSelectedSprite();
				setSelectedSprite(elm);
				setSelectedFrame(elm);
			}
			else{
				clearSelectedSprite();
				setSelectedSprite(elm);
			}
		}
  }
	else if(PLG.state == STATES.FIXED || PLG.state == STATES.VIEWINGFIXED){
		if(PARAM.positlogMode == "EditMode"){
			PLG.state = STATES.FIXEDSELECTED;
		}
		else{
			PLG.state = STATES.VIEWINGFIXEDSELECTED;
		}
		setSelectedSprite(elm);
		if(PLG.fixedSprite != PLG.selectedSprite){
			if(PARAM.positlogMode == "EditMode"){
				setSelectedFrame(elm);
				if(elm.parentNode.parentNode == PLG.fixedSprite || elm == PLG.fixedSprite.parentNode.parentNode){
					setUngroupIcon(elm);
				}
			}
		}
	}
  else if(PLG.state == STATES.FIXEDSELECTED || PLG.state == STATES.VIEWINGFIXEDSELECTED){
		// select another sprite
		if(PLG.selectedSprite != elm){
			if(PLG.selectedSprite != PLG.fixedSprite){
				if(PARAM.positlogMode == "EditMode"){
					removeSelectedFrame(PLG.selectedSprite);
					removeUngroupIcon();
					setFamilyFrame(PLG.fixedSprite);
				}
				clearSelectedSprite();
			}
			setSelectedSprite(elm);
			if(PLG.selectedSprite != PLG.fixedSprite){
				if(PARAM.positlogMode == "EditMode"){
					setSelectedFrame(elm);
					if(elm.parentNode.parentNode == PLG.fixedSprite || elm == PLG.fixedSprite.parentNode.parentNode){
						setUngroupIcon(elm);
					}
				}
			}
		}
  }
	else if(PLG.state == STATES.MOVING && !PLG.movingEditorFlag){
		if(PLG.fixedSprite != elm){
			PLG.state = STATES.MOVINGSELECTED;
			setSelectedSprite(elm);
			setSelectedFrame(elm);
			setGroupIcon(elm);
		}
	}
  else if(PLG.state == STATES.MOVINGSELECTED){
		if(PLG.fixedSprite != elm){
			removeSelectedFrame(PLG.selectedSprite);
			removeGroupIcon(PLG.selectedSprite);
			clearSelectedSprite();
			setSelectedSprite(elm);
			setSelectedFrame(elm);
			setGroupIcon(elm);
		}
  }
	else if(PLG.state == STATES.EDITING){
		if(PLG.fixedSprite != elm){
			PLG.state = STATES.EDITINGSELECTED;
			setSelectedSprite(elm);
			setSelectedFrame(elm);
			setFamilyFrame(elm);
		}
	}
  else if(PLG.state == STATES.EDITINGSELECTED){
		removeSelectedFrame(PLG.selectedSprite);
		clearSelectedSprite();
		setSelectedSprite(elm);
		setSelectedFrame(elm);
		setFamilyFrame(elm);
  }

}


function checkClearSelectedSprite(e)
{
    // Onmouseout events are occurred when mouse is on the region.
    // An onmouseout event is occurred when mouse is moved onto another object
    // on the selected object.
    // So, here, check whether mouse is out or not.
	var spriteLeft = sprLeftAbs(PLG.selectedSprite) + PLG.viewPositionX;
	var spriteTop = sprTopAbs(PLG.selectedSprite) + PLG.viewPositionY;
	var spriteWidth = sprWidth(PLG.selectedSprite);
	var spriteHeight = sprHeight(PLG.selectedSprite);
	var magicX = 6;

	var spritesWorldNode = document.getElementById("spritesworld");

	if(PLG.ungroupingFlag){
		if(getMouseX(e) < parseInt(spritesWorldNode.style.left)+spriteLeft+Math.floor(spriteWidth/2) -10
			 || getMouseX(e) > parseInt(spritesWorldNode.style.left)+spriteLeft+Math.floor(spriteWidth/2) -10 + 21
			 || getMouseY(e) < parseInt(spritesWorldNode.style.top)+spriteTop+Math.floor(spriteHeight/2) -10
			 || getMouseY(e) > parseInt(spritesWorldNode.style.top)+spriteTop+Math.floor(spriteHeight/2) -10 + 21){
				 if(!PLG.waitSavingFlag){
					 if(document.getElementById("sprite-ungroup")){
						 var ungroupElm = document.getElementById("sprite-ungroup");
						 ungroupElm.style.border = "2px solid #606060";
						 PLG.ungroupingFlag = false;
					 }
				 }
			 }
	}


	if(getMouseX(e) < parseInt(spritesWorldNode.style.left)+spriteLeft
		 || getMouseX(e) > parseInt(spritesWorldNode.style.left)+spriteLeft+spriteWidth+ magicX
		 || getMouseY(e) < parseInt(spritesWorldNode.style.top)+spriteTop
		 || getMouseY(e) > parseInt(spritesWorldNode.style.top)+spriteTop+spriteHeight){
			 if(PLG.state == STATES.SELECTED || PLG.state == STATES.VIEWINGSELECTED){
				 if(PARAM.positlogMode == "EditMode"){
					 PLG.state = STATES.WORKING;
					 removeSelectedFrame();
				 }
				 else{
					 PLG.state = STATES.VIEWING;
				 }
				 clearSelectedSprite();
			 }
			 else if(PLG.state == STATES.FIXEDSELECTED || PLG.state == STATES.VIEWINGFIXEDSELECTED){
				 if(PARAM.positlogMode == "EditMode"){
					 PLG.state = STATES.FIXED;
				 }
				 else{
					 PLG.state = STATES.VIEWINGFIXED;				 
				 }
				 if(PLG.fixedSprite != PLG.selectedSprite){
					 if(PARAM.positlogMode == "EditMode"){
						 removeSelectedFrame();
						 removeUngroupIcon();
					 }
					 clearSelectedSprite();
					 if(PARAM.positlogMode == "EditMode"){
						 setFamilyFrame(PLG.fixedSprite);
					 }
				 }
				 else{
					 clearSelectedSprite();
				 }
			 }
			 else if(PLG.state == STATES.EDITINGSELECTED){
				 PLG.state = STATES.EDITING;
				 removeSelectedFrame();
				 clearSelectedSprite();
				 setFamilyFrame(PLG.fixedSprite);
			 }
			 else if(PLG.state == STATES.MOVINGSELECTED){
				 PLG.state = STATES.MOVING;
				 removeGroupIcon(PLG.selectedSprite);
				 removeSelectedFrame();
				 clearSelectedSprite();
				 setFamilyFrame(PLG.fixedSprite);
			 }
		 }
}


//--------------------------------
// Cookie
//--------------------------------
function getCookie(key)
{
  if(!document.cookie) return undefined;
		var v="; " + document.cookie;
  var ns=v.indexOf("; "+key+"="); if(ns<0) return undefined; ns=ns+key.length+1+2;
  var ne=v.indexOf(";",ns); if(ne<0) ne=v.length;
  return v.substring(ns,ne);
}
function setCookie(key, val, path, day)
{
  theDay = new Date();
  theDay.setTime(theDay.getTime() + (day * 1000 * 60 * 60 * 24));
  var cs=key+"="+val+";";
  if(path != ""){
		cs+=" path="+path+";";
  }
  if(day != 0){
		cs+=" expires="+theDay.toGMTString()+";";
  }
  document.cookie=cs;
}


// extended for msie7
function chkAjaBrowser()
{
  var a,ua = navigator.userAgent;
  this.bw= { 
		iemobile  : (navigator.appName == 'Microsoft Pocket Internet Explorer'),
//		safari    : ((a=ua.split('AppleWebKit/')[1])?a.split('.')[0]:0)>=124 || ((a=ua.split('Konqueror/')[1])?a.split(';')[0]:0)>=3.3,
		safari    : ua.match(/AppleWebKit/gi) != null || ((a=ua.split('Konqueror/')[1])?a.split(';')[0]:0)>=3.3,
		konqueror : ((a=ua.split('Konqueror/')[1])?a.split(';')[0]:0)>=3.3 ,
		mozes     : ((a=ua.split('Gecko/')[1])?a.split(' ')[0]:0) >= 20011128 ,
		opera     : (!!window.opera) && ((typeof XMLHttpRequest)=='function') ,
		msie7     : (!!window.ActiveXObject)?((typeof XMLHttpRequest)=='object'):false,
		msie      : (!!window.ActiveXObject)?(!!createHttpRequest())&&((typeof XMLHttpRequest)!='object'):false
  }
  return (this.bw.safari||this.bw.konqueror||this.bw.mozes||this.bw.opera||this.bw.msie)
}

function createHttpRequest(){if(window.XMLHttpRequest){return new XMLHttpRequest();}else if(window.ActiveXObject){try{return new ActiveXObject('Msxml2.XMLHTTP');}catch(e){try{return new ActiveXObject('Microsoft.XMLHTTP');}catch(e2){return null;}}}else{return null;}}function sendRequest(c,d,p,u,y,t,v,w){var o=createHttpRequest();if(o==null)return null;var t=(!!sendRequest.arguments[5])?t:false;if(t||p.toUpperCase()=='GET')u+='?';if(t)u=u+'t='+(new Date()).getTime();var z=new chkAjaBrowser();var op=z.bw.opera;var s=z.bw.safari;var k=z.bw.konqueror;var m=z.bw.mozes;if(typeof c=='object'){var l=c.onload;var h=c.onbeforsetheader}else{var l=c;var h=null;}if(op||s||m){o.onload=function(){l(o);}}else{o.onreadystatechange=function(){if(o.readyState==4){l(o);}}}d=r(d,u);if(p.toUpperCase()=='GET'){u+=d}o.open(p,u,y,v,w);if(!!h)h(o);x(o);o.send(d);function x(o){var g='application/x-www-form-urlencoded; charset=UTF-8';if(!window.opera){o.setRequestHeader('Content-Type',g);}else{if((typeof o.setRequestHeader)=='function')o.setRequestHeader('Content-Type',g);}return o}function r(d,u){var n=(u.indexOf('?')==-1)?'?dmy':'';if(typeof d=='object'){for(var i in d)n+='&'+encodeURIComponent(i)+'='+encodeURIComponent(d[i]);}else if(typeof d=='string'){if(d=='')return'';var n='';var f=d.split('&');for(var i=1;i<f.length;i++){var q=f[i].split('=');n+='&'+encodeURIComponent(q[0])+'='+encodeURIComponent(q[1]);}}return n;}return o}

if(PARAM.positlogMode == "EditMode"){
	document.onkeydown = keydownevent;
	document.onkeypress = keypressevent;
}

function keydownevent(e) {

	if(!(PLG.state == STATES.WORKING
			 || PLG.state == STATES.VIEWING
			 || PLG.state == STATES.VIEWINGFIXED
			 || PLG.state == STATES.VIEWINGSELECTED
			 || PLG.state == STATES.VIEWINGFIXEDSELECTED
			 || PLG.state == STATES.SELECTED
			 || PLG.state == STATES.FIXEDSELECTED)
		|| PLG.drawingFlag){
				 return;
			 }

    // Mozilla(Firefox, NN) and Opera 
  if (e != null && !PLG.cb.bw.opera) { 
    keycode = e.which;
    // Internet Explorer 
  } else { 
    keycode = event.keyCode; 
  } 

	dokeyevents(keycode);
}

function keypressevent(e) {

	if(PLG.ignoreKeyPressFlag){
		PLG.ignoreKeyPressFlag = false;
		return;
	}

	if(!(PLG.state == STATES.WORKING
			 || PLG.state == STATES.VIEWING
			 || PLG.state == STATES.VIEWINGFIXED
			 || PLG.state == STATES.VIEWINGSELECTED
			 || PLG.state == STATES.VIEWINGFIXEDSELECTED
			 || PLG.state == STATES.SELECTED
			 || PLG.state == STATES.FIXEDSELECTED)
		|| PLG.drawingFlag){
				 return;
			 }

    // Mozilla(Firefox, NN)
  if (e != null && !PLG.cb.bw.opera) { 
//		keycode = e.which;
		keycode = (e.keyCode!=0)?e.keyCode:e.charCode;
    // Internet Explorer and Opera 
  } else { 
    keycode = event.keyCode; 
  } 

	if(PLG.cb.bw.safari){
		switch(keycode){
		case 63273: 
			keycode = 36;
			break;
		case 63275: 
			keycode = 35;
			break;
		case 63276:
			keycode = 33;
			break;
		case 63277:
			keycode = 34;
			break;
		case 63234:
			keycode = 37;
			break;
		case 63232:
			keycode = 38;
			break;
		case 63235:
			keycode = 39;
			break;
		case 63233:
			keycode = 40;
			break;
		}
	}

  if (keycode == 36 || keycode == 8){
		return;
  } 

	dokeyevents(keycode);
}

function dokeyevents(keycode)
{
    // 36 Home 
    // 33 PageUp 
    // 34 PageDown 
    // 38 up
    // 40 down
    // 37 left 
    // 39 right
    // 32 space
    // 8 backspace

  if (keycode == 36){
		moveHomePosition();
  } 
  else if (keycode == 8){
//  not to disturb drawingPassword
//		window.history.back();
  } 
  else if (keycode == 33){
		PLG.ignoreKeyPressFlag = true;

		var scroll = Math.floor(getInnerHeight()-100);
		if(scroll<0){
			scroll = getInnerHeight();
		}
		var top = parseInt(PLG.viewPositionY)+scroll;
		var left = parseInt(PLG.viewPositionX);
		var yoffset = 100;
		if(PLG.worldTop - yoffset > -top){
			top = - (PLG.worldTop - yoffset);
		}
		if(PLG.worldBottom + yoffset - getInnerHeight() < - top){
			top = - (PLG.worldBottom + yoffset - getInnerHeight());
		}

		setViewPosition(left,top);
  } 
  else if (keycode == 34 || keycode == 32){
		PLG.ignoreKeyPressFlag = true;

		var scroll = Math.floor(getInnerHeight()-100);
		if(scroll<0){
			scroll = getInnerHeight();
		}
		var top = parseInt(PLG.viewPositionY)-scroll;
		var left = parseInt(PLG.viewPositionX);
		var yoffset = 100;
		if(PLG.worldTop - yoffset > -top){
			top = - (PLG.worldTop - yoffset);
		}
		if(PLG.worldBottom + yoffset - getInnerHeight() < - top){
			top = - (PLG.worldBottom + yoffset - getInnerHeight());
		}

		setViewPosition(left,top);
  } 
  else if (keycode == 38){
		var scroll = 50;
		var top = parseInt(PLG.viewPositionY)+scroll;
		var yoffset = 100;
		if(PLG.worldTop - yoffset > -top){
			top = - (PLG.worldTop - yoffset);
		}
		if(PLG.worldBottom + yoffset - getInnerHeight() < - top){
			top = - (PLG.worldBottom + yoffset - getInnerHeight());
		}
		setViewPosition(parseInt(PLG.viewPositionX),top);
  } 
  else if (keycode == 40){
		var scroll = 50;
		var top = parseInt(PLG.viewPositionY)-scroll;
		var yoffset = 100;
		if(PLG.worldTop - yoffset > -top){
			top = - (PLG.worldTop - yoffset);
		}
		if(PLG.worldBottom + yoffset - getInnerHeight() < - top){
			top = - (PLG.worldBottom + yoffset - getInnerHeight());
		}
		setViewPosition(parseInt(PLG.viewPositionX),top);
  } 
  else if (keycode == 37){
		var scroll = 50;
		setViewPosition(parseInt(PLG.viewPositionX)+scroll,parseInt(PLG.viewPositionY));
  } 
  else if (keycode == 39){
		var scroll = 50;
		setViewPosition(parseInt(PLG.viewPositionX)-scroll,parseInt(PLG.viewPositionY));
  } 
} 

function setSelectedSprite(spr)
{
  PLG.selectedSprite = spr;
  PLG.orgZindexOfSelectedSprite = PLG.selectedSprite.style.zIndex;
}

function setFixedSprite(spr)
{
  PLG.fixedSprite = spr;
  PLG.orgZindexOfFixedSprite = PLG.orgZindexOfSelectedSprite;
}


function clearSelectedSprite()
{ 
  if(PLG.selectedSprite != null){
		if(PLG.selectedSprite != PLG.fixedSprite){
			PLG.selectedSprite.style.zIndex = PLG.orgZindexOfSelectedSprite;
		}
		PLG.selectedSprite = null;
  }
}

function clearFixedSprite()
{ 
  if(PLG.fixedSprite != null){
    // reset z-index
		PLG.fixedSprite.style.zIndex = PLG.orgZindexOfFixedSprite;
		PLG.fixedSprite = null;
	}
}
