#!/usr/local/bin/perl

# --------------------------------------------------------
# positlogadmin.cgi:
#      cgi for PositLog administration
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------


use strict;
use CGI qw/-debug :standard/;
use CGI::Cookie;
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
use PositLogConfig;

my $CGI = new CGI;

# administration command
my $command = $CGI->param("command");

# changepassword
my $newpassword = $CGI->param("newpassword");
my $newnickname = $CGI->param("newnickname");

#--------------------------------------
# Initialization
#--------------------------------------

if (! -d $PositLogConfig::adminpath)
{
    if(!mkdir($PositLogConfig::adminpath, 0755))
    {
		print "Cannot create the admin directory '" . $PositLogConfig::adminpath . " '.\n";
		print "Please check the file permission.\n";
		exit(0);
    }
}

if (! -f $PositLogConfig::adminpath . "usergrouplist.cgi")
{
	my %UserGroupList = ();
    if(!eval{Storable::lock_nstore \%UserGroupList, $PositLogConfig::adminpath . "usergrouplist.cgi"})
	{
		print "Cannot save the user group list.\n";
		print "Please check the file permission.\n";
		exit(0);
	}
}


if (! -f $PositLogConfig::adminpath . "usergroup_all.cgi")
{
	my %UserGroupAll = ();
    if(!eval{Storable::lock_nstore \%UserGroupAll, $PositLogConfig::adminpath . "usergroup_all.cgi"})
	{
		print "Cannot save the user group all.\n";
		print "Please check the file permission.\n";
		exit(0);
	}
}



if (! -f $PositLogConfig::adminpath . "pagegrouphash.cgi")
{
  my %PageGroupHash = ();
    if(!eval{Storable::lock_nstore \%PageGroupHash, $PositLogConfig::adminpath . "pagegrouphash.cgi"})
	{
		print "Cannot save the page group list.\n";
		print "Please check the file permission.\n";
		exit(0);
	}
}


if (! -f $PositLogConfig::adminpath . "pagegroup_all.cgi")
{
  my %PageGroupAll = ();

  opendir( DATADIR, $PositLogConfig::datapath );
  my @PageList = readdir( DATADIR );
  closedir( DATADIR );
    
  foreach my $pid (@PageList) {
    if ($pid eq "." || $pid eq ".." || $pid eq ".htaccess") {
      next;
    }
    $PageGroupAll{$pid} = 1;
  }

  if(!eval{Storable::lock_nstore \%PageGroupAll, $PositLogConfig::adminpath . "pagegroup_all.cgi"}){
    print "Cannot save the page group all.\n";
    print "Please check the file permission.\n";
    exit(0);
  }
}


if (! -f $PositLogConfig::adminpath . "authentication.cgi")
{
	my %useridAuth = ();
    if(!eval{Storable::lock_nstore \%useridAuth, $PositLogConfig::adminpath . "authentication.cgi"})
	{
		print "Cannot save the authentication file for users.\n";
		print "Please check the file permission.\n";
		exit(0);
	}
}


#--------------------------------------
# Authentication
#--------------------------------------

my $loginid = $CGI->param("loginid");
my $loginpass = $CGI->param("loginpass");

if($loginid eq "")
{
# Read temporal cookie
	$loginid = $CGI->cookie("loginid") || "";
	$loginpass = $CGI->cookie("loginpass") || "";
}

if($loginid eq "public")
{
	$loginid = "";
}

if($command eq "logout")
{
	$loginid = "";
	$loginpass = "";
}

my $cookieUser = new CGI::Cookie(
-path => "$PositLogConfig::cgipath",
-name => "loginid",
-value => "$loginid",
);
my $cookiePass = new CGI::Cookie(
-path => "$PositLogConfig::cgipath",
-name => "loginpass",
-value => "$loginpass",
);


# Print HTTP header
# (Set cookies)
print $CGI->header(-charset => 'utf-8', -cookie => [$cookieUser,$cookiePass]);

my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
my $loginerror = "";
my $validUser = 0;
my $adminUser = 0;

# Check admin -> Check valid user -> show error
if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
{
	my $cryptpass = $adminnameAuth->{$loginid}{"password"};
    my $salt="lc";
    my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 1;
	}
	else
	{
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
		$validUser = 0;
		$adminUser = 0;
	}
}
elsif($useridAuth ne "" && $useridAuth->{$loginid})
{
	my $cryptpass = $useridAuth->{$loginid}{"password"};
    my $salt="ry";
    my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 0;
	}
	else
	{
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
		$validUser = 0;
		$adminUser = 0;
	}
}
else
{
	if($loginid eq ""	&& $loginpass eq "")
	{
		$loginerror = "";
	}
	else
	{
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
	}
	$validUser = 0;
	$adminUser = 0;
}


if(!$validUser && !$adminUser)
{
	my $checked = "";
	my $savedpass = "";
	if($loginid eq ""){
			$loginid = $CGI->cookie("savedloginid");
			$savedpass = $CGI->cookie("savedloginpass");
			if($loginid ne ""){
					$checked = "checked";
			}
	}

	my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<meta http-equiv='Content-Style-Type' content='text/css'>\n
		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "logincheck.css' type='text/css'>\n
		<script type='text/javascript'>
		<!--
		function saveOnClick()
		{
				theDay = new Date();
				theDay.setTime(theDay.getTime() + (30 * 1000 * 60 * 60 * 24));
				var box = document.getElementById('saveaccount');
				var loginid = document.getElementById('loginid').value;
				var loginpass = document.getElementById('loginpass').value;
				if(loginid == '' || loginpass == ''){
						box.checked = false;
						alert('Please enter user id and password')
						return;
				}
				if(!box.checked){
						loginid = '';
						loginpass = '';
				}
				var cs='savedloginid='+loginid+';';
				cs+=' path=" . $PositLogConfig::cgipath . ";';
				if(box.checked)
				{
						cs+=' expires='+theDay.toGMTString()+';';
				}
				document.cookie=cs;

				cs='savedloginpass='+loginpass+';';
				cs+=' path=" . $PositLogConfig::cgipath . ";';
				if(box.checked)
				{
						cs+=' expires='+theDay.toGMTString()+';';
				}
				document.cookie=cs;
		}
		// -->
		</script>
		<title>PositLog Administration : Login</title>\n
	</head>\n";

	my $BODY = "<body onLoad='document.getElementById(\"loginid\").focus()'>\n
  <div id='logintop'>\n
  <div id='login'>\n
  <h1>Login to PositLog Administration</h1>\n
  <form name='loginform' id='loginform' action='positlogadmin.cgi' method='post'>\n
    <p>\n
      user id<br>\n
      <input type='text' name='loginid' id='loginid' value='" . $loginid . "' size='20' tabindex='1'>\n
    </p>\n
    <p>\n
      password<br>\n
      <input type='password' name='loginpass' id='loginpass' value='" . $savedpass . "' size='20' tabindex='2'>\n
    </p>\n
    <p id='saveaccount-label'>\n
    Save my user id and password&nbsp;&nbsp;<input type='checkbox' name='saveaccount' id='saveaccount' onclick='saveOnClick();'  tabindex='3' value='1' " . $checked . ">\n
    </p>\n
    <p id='submitarea'>\n" . $loginerror . 
    "<br/><input type='submit' id='submitbtn' value='Login' tabindex='4'>\n
    </p>\n
  </form>\n
  </div>\n
  <div id='copyright'>\n
  Powered by <a href='http://positlog.storybook.jp/'>PositLog</a>\n
  </div>\n
  </div>\n
</body>\n";

	my $FOOTER = "</html>";

	print $HEADER . $BODY . $FOOTER;
	exit(0);

}

my $statusStr = "";

#--------------------------------------
# Change password
#--------------------------------------

if($command eq "changepassword")
{
    if($newpassword =~ /[^a-zA-Z0-9\^\~\_\!\#\%\&\(\)\*\+\-\/\.\:\;\<\=\>\'\"\\\?\@\[\]\^\`\{\|\}]/)
    {
		print "<div style='text-align: center'>The password includes invalid characters.<br>\n";
		print "<a href='./positlogadmin.cgi'>back</a></div>\n";
		exit(0);
    }

    my $salt="ry";
    my $cryptpass = crypt($newpassword, $salt);
    $useridAuth->{$loginid}{"password"} = $cryptpass;

    if(eval{Storable::lock_nstore $useridAuth, $PositLogConfig::adminpath . "authentication.cgi"})
	{
		$statusStr = "<p style='color:red;'>The password was changed.</p>";
	}
	else
	{
		$statusStr = "<p style='color:red;'>Cannot save the authentication data.</p>";
	}

}
elsif($command eq "changenickname")
{
    if($newnickname =~ /[\[\]\<\>]/g)
    {
		print "<div style='text-align: center'>The nickname includes invalid characters.<br>\n";
		print "<a href='./positlogadmin.cgi'>back</a></div>\n";
		exit(0);
    }

    $useridAuth->{$loginid}{"nickname"} = $newnickname;

    if(eval{Storable::lock_nstore $useridAuth, $PositLogConfig::adminpath . "authentication.cgi"})
	{
		$statusStr = "<p style='color:red;'>The nickname was changed.</p>";
	}
	else
	{
		$statusStr = "<p style='color:red;'>Cannot save the authentication data.</p>";
	}

}


#---------------------------------------------------------
# Generate JavaScript
#---------------------------------------------------------

my $ScriptBody = <<__ScriptBody__;
<script type='text/javascript'>
<!--

function changePassword()
{
	var passElm = document.getElementById("newpassword");
	var passElm2 = document.getElementById("newpassword2");
	if(passElm.value == '')
	{
		alert('Please enter a password.');
		return false;
	}
	if(passElm.value != passElm2.value)
	{
		alert('Two passwords are different. Please re-enter passwords.');
		return false;
	}
	else
	{
		return true;
	}
}

function btnAreaMouseOver(elm)
{
	elm.style.backgroundColor = "#ffd0d0";
}

function btnAreaMouseOut(elm)
{
	elm.style.backgroundColor = "#ffffff";
}

// -->
</script>
__ScriptBody__


#---------------------------------------------------------
# Generate HTML
#---------------------------------------------------------

my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<meta http-equiv='Content-Style-Type' content='text/css'>\n
		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "positlog_admin.css' type='text/css'>\n
                <meta http-equiv='Content-Script-Type' content='text/javascript'>
		<title>PositLog Administration</title>\n"
	. $ScriptBody

	. "</head>\n";

my $BODY ="";
$BODY = "<body class='portal'>\n";
if($adminUser)
{
	$BODY .="<h1>PositLog Administration&nbsp;&nbsp;&nbsp;&nbsp;<span class='usernamearea'>You are the 'admin' user.</span> [<a href='./positlogadmin.cgi?command=logout'>logout</a>]</h1>\n";
	$BODY .="<h2 class='usermanagement'><a href='./usermanager.cgi'>User management</a></h2>\n";
	$BODY .="<h2 class='pagemanagement'><a href='./pagemanager.cgi'>Page management</a></h2>\n";
	$BODY .="<h2 class='recentcontents'><a href='./recentcontents.cgi'>Recently modified pages</a></h2>\n";
}
else
{
    $BODY .="<h1>PositLog Administration&nbsp;&nbsp;&nbsp;&nbsp;<span class='usernamearea'>You are " . $useridAuth->{$loginid}{"nickname"} . " (id: $loginid). </span> [<a href='./positlogadmin.cgi?command=logout'>logout</a>]</h1>\n";

	$BODY .="<h2 class='recentcontents'><a href='./recentcontents.cgi'>Recently modified pages</a></h2>\n";

	$BODY .="<p><span class='StatusArea'>" . $statusStr . "</span></p>";

	# change nickname
	$BODY .="<h2 class='changenickname'>Change your nickname</h2>\n";

	$BODY .="<ul id='howtotext'><li>Nickname を入力してください．[ ] &lt;&gt;以外の全ての文字が利用できます．</ul>\n";
	$BODY .= "<form id='form_changenickname' action='./positlogadmin.cgi' method='POST'>\n";
	$BODY .= "<div class='NewUserNameArea'>Nickname<br><input type='text' name='newnickname' id='newnickname' size='18' tabindex='1'></div>\n"
	. "<div class='NewUserBtnArea'><br><input type='submit' id='btn_changenickname' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'  value='Change nickname' tabindex='2'></div>\n"
	. "<input type='hidden' name='command' value='changenickname'>\n"
	. "</form>\n";

	# change password
	$BODY .="<h2 class='changepassword'>Change your password</h2>\n";

	$BODY .="<ul id='howtotext'><li>Password を入力してください．念のため (re-enter) 欄に同じパスワードをもう一度入力してください．<br>Password の最大文字数は 8 文字です．また，利用可能な文字は次のものです： 0-9a-zA-Z ! # $ \% &amp; ( ) * + - . / \\ \' \" : ; &lt; = &gt; ? @ [ ] ^ ~ _ ` { | } </ul>\n";
	$BODY .= "<form id='form_changepassword' onSubmit='return changePassword()' action='./positlogadmin.cgi' method='POST'>\n"
		. "<div class='NewUserPassArea'>New Password<br><input maxlength='8'  type='password' name='newpassword' id='newpassword' size='10' tabindex='3'></div>\n"
		. "<div class='NewUserPassArea'>(re-enter)<br><input maxlength='8' type='password' name='newpassword2' id='newpassword2' size='10' tabindex='4'></div>\n"
		. "<div class='NewUserBtnArea'><br><input type='submit' id='btn_changepassword' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'  value='Change password' tabindex='5'></div>\n"
		. "<input type='hidden' name='command' value='changepassword'>\n"
		. "</form>\n";

}

$BODY .= "<p id='copyright'><hr>Powered by <a href='http://positlog.storybook.jp/'>PositLog</a></p>\n";

my $FOOTER = "</body></html>";

print $HEADER . $BODY . $FOOTER;
