package PositLogAuth;

use strict;
use PositLogConfig;
use Storable qw(lock_retrieve lock_nstore);

my $errormsg = "";
# authentication for user
my $adminUser = 0;
my $validUser = 0;
my $publicUser = 0;

# authentication for page
my $pageCreator = 0;

sub getErrorMsg
{
    return $errormsg;
}

sub isAdminUser
{
    return scalar($adminUser);
}

sub isValidUser
{
    return scalar($validUser);
}

sub isPublicUser
{
    return scalar($publicUser);
}

sub isPageCreator
{
    return scalar($pageCreator);
}

sub authenticatePage
{
    my ($loginid, $pageid) = @_;

		if($loginid eq ""){
				$loginid = "public";
		}

    my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};
    if($configHash eq ""){ 
				$errormsg = "Cannot read config.dat.";
    }

    if($configHash->{"author_id"} eq $loginid){
				$pageCreator = 1;
    }
}


sub authenticateUser
{
    my ($loginid, $loginpass) = @_;

    my $usernameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
    my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};

    if($loginid eq "public"){
				$adminUser = 0;
				$validUser = 0;
				$publicUser = 1;
    }
    elsif($adminnameAuth ne "" && $adminnameAuth->{$loginid}){
				my $cryptpass = $adminnameAuth->{$loginid}{"password"};
				my $salt="lc";
				my $cryptpass2 = crypt($loginpass, $salt);
				if($cryptpass eq $cryptpass2){
						$validUser = 1;
						$adminUser = 1;
						$publicUser = 0;
        }
				else{
						$errormsg = "Permission denied.";
        }
    }
    elsif($usernameAuth ne "" && $usernameAuth->{$loginid}){
				my $cryptpass = $usernameAuth->{$loginid}{"password"};
				my $salt="ry";
				my $cryptpass2 = crypt($loginpass, $salt);
				if($cryptpass eq $cryptpass2){
						$adminUser = 0;
						$validUser = 1;
						$publicUser = 0;
        }
				else{
						$errormsg = "Permission denied.";
        }
    }

}

1;
