package PositLogGroup;

use strict;

my $spritesHash;

sub getLeftAbs
{
		my ($id) = @_;
		if($id eq ""){
				return 0;
		}
		my $left = scalar(getLeft($id));
		my $parent = "";
		if($spritesHash->{$id}{"parent"} && $spritesHash->{$id}{"parent"} ne ""){
				$parent = $spritesHash->{$id}{"parent"};
		}
		while($parent ne ""){
				$left += scalar(getLeft($parent));
				if($spritesHash->{$parent}{"parent"} && $spritesHash->{$parent}{"parent"} ne ""){
						$parent = $spritesHash->{$parent}{"parent"};
				}
				else{
						$parent = "";
				}
		}
		return $left;
}


sub getTopAbs
{
		my ($id) = @_;
		if($id eq ""){
				return 0;
		}
		my $top = scalar(getTop($id));
		my $parent = "";
		if($spritesHash->{$id}{"parent"} && $spritesHash->{$id}{"parent"} ne ""){
				$parent = $spritesHash->{$id}{"parent"};
		}
		while($parent ne ""){
				$top += scalar(getTop($parent));
				if($spritesHash->{$parent}{"parent"} && $spritesHash->{$parent}{"parent"} ne ""){
						$parent = $spritesHash->{$parent}{"parent"};
				}
				else{
						$parent = "";
				}
		}
		return $top;
}


sub getLeft
{
		my ($id) = @_;
		if($id eq ""){
				return 0;
		}
		else{
				$spritesHash->{$id}{"style"} =~ /^left:(-?\d+?)px;.*$/i;
				return $1;
		}
}

sub getTop
{
		my ($id) = @_;
		if($id eq ""){
				return 0;
		}
		else{
				$spritesHash->{$id}{"style"} =~ /.*?top:(-?\d+?)px;.*/i;
				return $1;
		}
}

sub getWidth
{
		my ($id) = @_;
		if($id eq ""){
				return 0;
		}
		else{
				$spritesHash->{$id}{"style"} =~ /.*?width:(\d+?)px;.*/i;
				return $1;
		}
}

sub getZindex
{
		my ($id) = @_;
		if($id eq ""){
				return 0;
		}
		else{
				$spritesHash->{$id}{"style"} =~ /.*?z-index:(\d+?);.*$/i;
				return $1;
		}
}


sub group
{
		my ($hash, $commandList) = @_;
		$spritesHash = $hash;

		# valiadte
		foreach my $command (@$commandList){
				$command =~ /^(.*?),(.*?)$/;
				my $parent = $1;
				my $child = $2;
				if($parent ne "" && !$spritesHash->{$parent}){
						return 0;
				}
				if($child ne "" && !$spritesHash->{$child}){
						return 0;
				}
		}

		foreach my $command (@$commandList){
				$command =~ /^(.*?),(.*?)$/;
				my $parent = $1;
				my $child = $2;

				# relocate child
				my $oldParent = $spritesHash->{$child}{"parent"};
				my $oldLeft = 0;
				my $oldTop = 0;
				if($oldParent && $oldParent ne ""){
						$oldLeft = getLeftAbs($oldParent);
						$oldTop = getTopAbs($oldParent);
				}
				
				my $newLeft = getLeftAbs($parent);
				my $newTop = getTopAbs($parent);
										
				my $childLeft = scalar(getLeft($child)) + scalar($oldLeft) - scalar($newLeft);
				my $childTop = scalar(getTop($child)) + scalar($oldTop) - scalar($newTop);
								
				my $styles = "left:" . $childLeft . "px; top:" . $childTop . "px; width:" . getWidth($child) . "px; z-index:" . getZindex($child) . ";";
				$spritesHash->{$child}{"style"} = $styles;

				# remove child
				if($spritesHash->{$child}{"parent"} && $spritesHash->{$child}{"parent"} ne ""){
						my $oldParent = $spritesHash->{$child}{"parent"};
						my @children = @{$spritesHash->{$oldParent}{"children"}};
						my @newChildren;
						foreach my $tmpChild (@children){
								if($tmpChild ne $child){
										push(@newChildren, $tmpChild);
								}
						}
						$spritesHash->{$oldParent}{"children"} = \@newChildren;
				}

				# add child
				if($parent eq ""){
						delete $spritesHash->{$child}{"parent"};
						next;
				}
				elsif($spritesHash->{$parent}{"children"} && $spritesHash->{$parent}{"children"} ne "" && @{$spritesHash->{$parent}{"children"}}){
						my @children = @{$spritesHash->{$parent}{"children"}};
						my $isExist = 0;
						foreach my $tmpChild (@children){
								if($tmpChild eq $child){
										$isExist = 1;
								}
						}
						if($isExist == 0){
								push(@children, $child);
								$spritesHash->{$parent}{"children"} = \@children;
						}
				}
				else{
						my @children;
						push(@children, $child);
						$spritesHash->{$parent}{"children"} = \@children;
				}

				# change parent
				$spritesHash->{$child}{"parent"} = $parent;
		}
		return 1;
}

1;
