#!/usr/local/bin/perl

# --------------------------------------------------------
# usermanager.cgi:
#      cgi for PositLog user management
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------


use strict;
use CGI qw/-debug :standard/;
use CGI::Cookie;
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
use PositLogConfig;

# CGI parameters are already URL decoded.
my $CGI = new CGI;


# administration command
my $command = $CGI->param("command");

my $listcounter_user = $CGI->param("listcounter_user");
my $listcounter_usergroup = $CGI->param("listcounter_usergroup");

my $userid = $CGI->param("userid");
my $nickname = $CGI->param("nickname");
my $usergroupname = $CGI->param("usergroupname");
my $password = $CGI->param("password");

my @useridlist = $CGI->param("useridlist");

# Postfix is added to "command",  "userid", "usergroupname", "password" parameter name
# when parameter is sent by using identified <input> element 
# e.g.) <input type='hidden' name='command_1' id='command_1'>
# "index" parameter is set in order to remove this postfix.
my $index = $CGI->param("index");
if($index ne "")
{
    $command = $CGI->param("command_" . $index);
    $userid = $CGI->param("userid_" . $index);
    $nickname = $CGI->param("nickname_" . $index);
    $usergroupname = $CGI->param("usergroupname_" . $index);
    $password = $CGI->param("password_" . $index);
}
my $usergroupnameenc = $usergroupname;
$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
$usergroupnameenc =~ tr/ /+/;


#--------------------------------------
# Authentication
#--------------------------------------

my $loginid = $CGI->param("loginid");
my $loginpass = $CGI->param("loginpass");

if($loginid eq "")
{
# Read temporal cookie
	$loginid = $CGI->cookie("loginid") || "";
	$loginpass = $CGI->cookie("loginpass") || "";
}

if($loginid eq "public")
{
	$loginid = "";
}

my $cookieUser = new CGI::Cookie(
-path => "$PositLogConfig::cgipath",
-name => "loginid",
-value => "$loginid",
#-domain => "$cookieDomain"
);
my $cookiePass = new CGI::Cookie(
-path => "$PositLogConfig::cgipath",
-name => "loginpass",
-value => "$loginpass",
#-domain => "$cookieDomain"
);

# Print HTTP header
# (Set cookies)
print $CGI->header(-charset => 'utf-8', -cookie => [$cookieUser,$cookiePass]); 

my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
my $loginerror = "";
my $validUser = 0;
my $adminUser = 0;

# Check admin -> Check valid user -> show error
if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
{
	my $cryptpass = $adminnameAuth->{$loginid}{"password"};
    my $salt="lc";
    my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 1;
	}
	else
	{
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
		$validUser = 0;
		$adminUser = 0;
	}
}
elsif($useridAuth ne "" && $useridAuth->{$loginid})
{
	my $cryptpass = $useridAuth->{$loginid}{"password"};
    my $salt="ry";
    my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 0;
	}
	else
	{
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
		$validUser = 0;
		$adminUser = 0;
	}
}
else
{
	if($loginid eq ""	&& $loginpass eq "")
	{
		$loginerror = "";
	}
	else
	{
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
	}
	$validUser = 0;
	$adminUser = 0;
}


if(!$adminUser)
{

	my $checked = "";
	my $savedpass = "";
	if($loginid eq ""){
			$loginid = $CGI->cookie("savedloginid");
			$savedpass = $CGI->cookie("savedloginpass");
			if($loginid ne ""){
					$checked = "checked";
			}
	}

	my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<meta http-equiv='Content-Style-Type' content='text/css'>\n
		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "logincheck.css' type='text/css'>\n
		<script type='text/javascript'>
		<!--
		function saveOnClick()
		{
				theDay = new Date();
				theDay.setTime(theDay.getTime() + (30 * 1000 * 60 * 60 * 24));
				var box = document.getElementById('saveaccount');
				var loginid = document.getElementById('loginid').value;
				var loginpass = document.getElementById('loginpass').value;
				if(loginid == '' || loginpass == ''){
						box.checked = false;
						alert('Please enter user id and password')
						return;
				}
				if(!box.checked){
						loginid = '';
						loginpass = '';
				}
				var cs='savedloginid='+loginid+';';
				cs+=' path=" . $PositLogConfig::cgipath . ";';
				if(box.checked)
				{
						cs+=' expires='+theDay.toGMTString()+';';
				}
				document.cookie=cs;

				cs='savedloginpass='+loginpass+';';
				cs+=' path=" . $PositLogConfig::cgipath . ";';
				if(box.checked)
				{
						cs+=' expires='+theDay.toGMTString()+';';
				}
				document.cookie=cs;
		}
		// -->
		</script>
		<title>PositLog Administration : Login</title>\n
	</head>\n";

	my $BODY = "<body onLoad='document.loginform.loginid.focus()'>\n
  <div id='logintop'>\n
  <div id='login'>\n
  <h1>Login to PositLog Administration</h1>\n
  <form id='loginform' action='usermanager.cgi' method='post'>\n
    <p>\n
      user id<br>\n
      <input type='text' name='loginid' id='loginid' value='" . $loginid . "' size='20' tabindex='1'>\n
    </p>\n
    <p>\n
      password<br>\n
      <input type='password' name='loginpass' id='loginpass' value='" . $savedpass . "' size='20' tabindex='2'>\n
    </p>\n
    <p id='saveaccount-label'>\n
    Save my user id and password&nbsp;&nbsp;<input type='checkbox' name='saveaccount' id='saveaccount' onclick='saveOnClick();'  tabindex='3' value='1' " . $checked . ">\n
    </p>\n
    <p id='submitarea'>\n" . $loginerror . 
    "<br/><input type='submit' id='submitbtn' value='Login' tabindex='4'>\n
    </p>\n
  </form>\n
  </div>\n
  <div id='copyright'>\n
  Powered by <a href='http://positlog.storybook.jp/'>PositLog</a>\n
  </div>\n
  </div>\n
</body>\n";

	my $FOOTER = "</html>";

	print $HEADER . $BODY . $FOOTER;
	exit(0);

}




#---------------------------------------------------------
# Generate User Group List 
#---------------------------------------------------------

sub generateUserGroupList
{
    my ($tmpGroupList) = @_;

    my $BODY ="<h3 class='usermanagement'>User Group List</h3>\n";
    my $groupcounter = 0;

	my @UserGroupList = sort {$a cmp $b} (keys %$tmpGroupList);
	# insert "all" into the top of @UserGroupList
	unshift(@UserGroupList, "all");

	$BODY .= "<form id='usergrouplistform' action='./usermanager.cgi' onSubmit='return deleteUserGroups()' method='POST'>\n";
	$BODY .= "<div class='GroupNameArea'>&nbsp;</div>";
	if(scalar(@UserGroupList) > 1){
		$BODY .= "<input type='submit' name='btn_deleteusergroups' value='delete checked user groups from this PositLog' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)' >\n";
	}


    foreach my $usergroupname (@UserGroupList)
    {
		$groupcounter++;

		my $usergroupnameenc = $usergroupname;
		$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
		$usergroupnameenc =~ tr/ /+/;

		my $groupclass = "usergroupline1";
		if($groupcounter % 2 == 0)
		{
			$groupclass = "usergroupline2";
		}

		my $groupcounterStr = sprintf("%03d", $groupcounter);
		$BODY .= "<div class='" . $groupclass . "'>\n"
			. "<div class='GroupNameArea'>\n";

		$BODY .= $groupcounterStr . ".";

		$BODY .= "&nbsp;&nbsp;&nbsp;\n"
			. "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>"
			. "<span  class='groupname' id='usergroupname_" . $groupcounter . "'>"
			. $usergroupname . "</span></a>\n"
			. "</div>\n";

				
		if($usergroupname ne "all")
		{
			$BODY .= "<div class='DeleteCheckArea'><input type='checkbox' name='usergroupdeletecheck_" . $groupcounter . "' value='" . $usergroupname  . "'>delete</div>\n";
		}
		
		$BODY .= "</div>\n\n";


    }
	$BODY .= "<input type='hidden' name='listcounter_usergroup' id='listcounter_usergroup' value='" . $groupcounter . "'>\n"
		. "<input type='hidden' name='command' value='deleteusergroups'>\n";

	$BODY .= "</form>\n\n";
    return $BODY;
}



#---------------------------------------------------------
# Generate User List 
#---------------------------------------------------------

sub generateUserList
{
    my ($tmpList) = @_;

	my @UserList = keys %$tmpList;

    my $BODY ="";
	my $btnStr = "";
	
	$btnStr = " into ". $usergroupname;

	$BODY .= "<h4 class='usermanagement'>Add User to '" . $usergroupname . "' User Group</h4>\n";

	$BODY .= "<h5 class='usermanagement'>Add new user</h5>\n";

	# Add new user to this group

		$BODY .= "<ul id='howtotext'><li>新しい user id　を入力してください．利用可能な文字は次のものです: 0-9a-zA-Z @ _ - <li>Nickname を入力してください．[ ] &lt;&gt;以外の全ての文字が利用できます．<li>Password を入力してください．念のため (re-enter) 欄に同じパスワードをもう一度入力してください．<br>Password の最大文字数は 8 文字です．また，利用可能な文字は次のものです： 0-9a-zA-Z ! # $ \% &amp; ( ) * + - . / \\ \' \" : ; &lt; = &gt; ? @ [ ] ^ ~ _ ` { | } </ul>";

	$BODY .= "<form id='form_newuser' action='./usermanager.cgi' onSubmit='return addNewUser()' method='post'>\n"
		. "<div class='NewUserNameArea'>New user id<br><input type='text' name='userid_newuser' id='userid_newuser' size='18' tabindex='1'></div>\n"
		. "<div class='NewUserNameArea'>Nickname<br><input type='text' name='nickname_newuser' id='nickname_newuser' size='18' tabindex='2'></div>\n"
		. "<div class='NewUserPassArea'>Password<br><input maxlength='8'  type='password' name='password_newuser' id='password_newuser' size='10' tabindex='3'></div>\n"
		. "<div class='NewUserPassArea'>(re-enter)<br><input maxlength='8' type='password' name='password2_newuser' id='password2_newuser' size='10' tabindex='4'></div>\n"
		. "<div class='NewUserBtnArea'><br><input type='submit' id='btn_newuser' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'  value='Create this user" . $btnStr ."' tabindex='5' ></div>\n";

    $BODY .= "<input type='hidden' name='command_newuser' value='addnewuser'>\n"
		. "<input type='hidden' name='index' value='newuser'>\n"
		. "<input type='hidden' name='usergroupname_newuser' value='" . $usergroupname . "'>" # posted parameter is automatically URL encoded
		. "</div></form>\n\n";


	$BODY .= "<br style='clear:left'>";

	$BODY .= "<h5 class='usermanagement'>Change nickname</h5>\n";
	# Change user profile
		$BODY .= "<ul id='howtotext'><li>変更する user id と，新しい Nickname を入力してください．[ ] &lt;&gt;以外の全ての文字が利用できます．</ul>";


	$BODY .= "<form id='form_changenickname' action='./usermanager.cgi' onSubmit='return changeNickname()' method='post'>\n"
		. "<div class='NewUserNameArea'>User id<br><input type='text' name='userid_changenickname' id='userid_changenickname' size='18' tabindex='10'></div>\n"
		. "<div class='NewUserNameArea'>New nickname<br><input type='text' name='nickname_changenickname' id='nickname_changenickname' size='18' tabindex='11'></div>\n"
		. "<div class='NewUserBtnArea'><br><input type='submit' id='btn_changenickname' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'  value='Change nickname' tabindex='12' ></div>\n";

    $BODY .= "<input type='hidden' name='command_changenickname' value='changenickname'>\n"
		. "<input type='hidden' name='index' value='changenickname'>\n"
		. "</div></form>\n\n";


	$BODY .= "<br style='clear:left'>";

	# Add user to this group
	if($usergroupname ne "all")
	{
		$BODY .= "<h5 class='usermanagement'>Add from user list</h5>\n";

		my $AllUserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_all.cgi")} or {};
		if($AllUserList eq "")
		{
			print "<div style='text-align: center'>Error! : Cannot open 'all' user group.<br>\n";
			print "<a href='./usermanager.cgi'>back</a></div>\n";
			exit(0);
		}
		my $length = scalar(keys %$AllUserList);
		if($length > 20)
		{
			$length = 20;
		}

		$BODY .= "<form id='form_adduserstogroup' action='./usermanager.cgi' onSubmit='return addSelectedUsersToGroup()'  method='POST'>\n<select id='useridlist' multiple size='3' name='useridlist' onmousedown='this.size=" . $length . ";'>\n";
		foreach my $auser (sort {$a cmp $b} (keys %$AllUserList))
		{
			if(scalar($tmpList->{$auser}) != 1)
			{
				$BODY .= "<option value='" . $auser . "'>" . $auser . "</option>\n";
			}
		}
		$BODY .= "</select>\n";
		$BODY .= "<input type='submit' id='btn_adduserstogroup' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'  value='Add selected users to " . $usergroupname ."' >\n";
		$BODY .= "<input type='hidden' name='command' value='adduserstogroup'>";
		$BODY .= "<input type='hidden' name='usergroupname' value='" . $usergroupname . "'>"; # posted parameter is automatically URL encoded
		$BODY .= "</form>";
	}

	# User List
	$BODY .= "<h4 class='usermanagement'>User List of '" . $usergroupname . "' User Group</h4>\n";
	
	$BODY .= "<form id='userlistform' action='./usermanager.cgi' onSubmit='return deleteUsers()' method='POST'>\n";
    my $usercounter = 0;
	my $tmpBODY = "";
    foreach my $uid (sort {$a cmp $b} @UserList)
    {
		$usercounter++;

		my $userclass = "userline1";
		if($usercounter % 2 == 0)
		{
			$userclass = "userline2";
		}

		my $usercounterStr = sprintf("%03d", $usercounter);
		$tmpBODY .= "<div class='" . $userclass . "'>\n"
			. "<div class='UserNameArea'>"
			. $usercounterStr . ".&nbsp;&nbsp;&nbsp;\n"
			. "<span  class='userid' id='userid_" . $usercounter . "'>" . $uid . "</span>\n"
			. "<span  class='nickname' id='nickname_" . $usercounter . "'>&nbsp;&nbsp;(" . $useridAuth->{$uid}{"nickname"} . ")</span>\n"
			. "</div>"
			. "<div class='DeleteCheckArea'><input type='checkbox' name='userdeletecheck_" . $usercounter . "' value='" . $uid  . "'>";
		if($usergroupname eq "all")
		{
			$tmpBODY .= "delete</div>\n";
		}
		else
		{
			$tmpBODY .= "remove</div>\n";
		}
		$tmpBODY .= "</div>\n\n";
    }
	
	$BODY .= "<div class='UserNameArea'>&nbsp;</div>";
	if($usergroupname eq "all")
	{
		$BODY .= "<input type='submit' name='btn_deleteusers' value='delete checked users from this PositLog' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'>\n";
	}
	else{
		$BODY .= "<input type='submit' name='btn_deleteusers' value='remove checked users from this group' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'>\n";
	}

	$BODY .= $tmpBODY;
	$BODY .= "<input type='hidden' name='usergroupname' value='" . $usergroupname . "'>\n";
	$BODY .= "<input type='hidden' name='listcounter_user' id='listcounter_user' value='" . $usercounter . "'>\n";
	$BODY .= "<input type='hidden' name='command' value='deleteusers'>\n";

	$BODY .= "</form>";

    return $BODY;
}


#---------------------------------------------------------
# Generate Main Page
#---------------------------------------------------------

sub generateMainPage
{
	my ($statusStr) = @_;

	my $BODY = "<body class='usermanage'>\n";

	#---------------------------------------------------------
    # User Management
    #---------------------------------------------------------

    if($usergroupname ne "")
    {
		#---------------------------
		# Manage User Group Members
		#---------------------------
		my $useridstr = "";
		if($adminUser)
		{
			$useridstr = "<span class='usernamearea'>You are the 'admin' user.</span>";
		}
		else
		{
			$useridstr = "<span class='usernamearea'>Your id is '$loginid'.</span>";
		}
		$BODY .="<h1><a href='./positlogadmin.cgi'>PositLog Administration</a>&nbsp;&nbsp;&nbsp;&nbsp;$useridstr [<a href='./positlogadmin.cgi?command=logout'>logout</a>]</h1>\n";
		
		$BODY .="<h2 class='usermanagement'><a href='./usermanager.cgi'>User Management</a></h2>\n";

		$BODY .="<p><span class='StatusArea'>" . $statusStr . "</span></p>";

		$BODY .= "<h3 class='usermanagement'>User Group '" . $usergroupname . "'</h3>\n";

		my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
		if($UserList eq "")
		{
			print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n";
			print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
			exit(0);
		}

		$BODY .= generateUserList($UserList);
    }
    else{
		#---------------------------
		# Manage User Groups
		#---------------------------
		my $useridstr = "";
		if($adminUser)
		{
			$useridstr = "<span class='usernamearea'>You are the 'admin' user.</span>";
		}
		else
		{
			$useridstr = "<span class='usernamearea'>Your id is '$loginid'.</span>";
		}
		$BODY .="<h1><a href='./positlogadmin.cgi'>PositLog Administration</a>&nbsp;&nbsp;&nbsp;&nbsp;$useridstr [<a href='./positlogadmin.cgi?command=logout'>logout</a>]</h1>\n";

		$BODY .="<h2 class='usermanagement'>User Management</h2>\n";

		$BODY .="<p><span class='StatusArea'>" . $statusStr . "</span></p>";

		# Create new user 
		$BODY .="<h4 class='usermanagement'>Create New User</h4>\n";
		
		$BODY .= "<ul id='howtotext'><li>新しい user id　を入力してください．利用可能な文字は次のものです: 0-9a-zA-Z @ _ - <li>Nickname を入力してください．&lt;&gt; [ ] 以外の全ての文字が利用できます．<li>Password を入力してください．念のため (re-enter) 欄に同じパスワードをもう一度入力してください．<br>Password の最大文字数は 8 文字です．また，利用可能な文字は次のものです： 0-9a-zA-Z ! # $ \% &amp; ( ) * + - . / \\ \' \" : ; &lt; = &gt; ? @ [ ] ^ ~ _ ` { | } </ul>";

		$BODY .= "<form id='form_newuser' action='./usermanager.cgi' onSubmit='return addNewUser()' method='post'>\n"
			. "<div class='NewUserNameArea'>New user id<br><input type='text' name='userid_newuser' id='userid_newuser' size='18' tabindex='1'></div>\n"
			. "<div class='NewUserNameArea'>Nickname<br><input type='text' name='nickname_newuser' id='userid_newuser' size='18' tabindex='2'></div>\n"
			. "<div class='NewUserPassArea'>Password<br><input maxlength='8'  type='password' name='password_newuser' id='password_newuser' size='10' tabindex='2'></div>\n"
			. "<div class='NewUserPassArea'>(re-enter)<br><input maxlength='8' type='password' name='password2_newuser' id='password2_newuser' size='10' tabindex='3'></div>\n"
			. "<div class='NewUserBtnArea'><br><input type='submit' id='btn_newuser' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'  value='Create this user'  tabindex='4'></div>\n";
		
		$BODY .= "<input type='hidden' name='command_newuser' value='addnewuser'>\n"
			. "<input type='hidden' name='index' value='newuser'>\n"
			. "<input type='hidden' name='usergroupname_newuser' value='" . $usergroupname . "'>" # posted parameter is automatically URL encoded
			. "</div></form>\n\n";


		# Create new group
		$BODY .="<h4 class='usermanagement'>Create New User Group</h4>\n";

		$BODY .= "<ul id='howtotext'><li>新しい group name を入力してください．UTF-8 文字セットに含まれる文字が利用可能です．（このままふつうに日本語か英語を入力すればOKです．）</ul>";
		$BODY .= "<form id='form_newgroup' action='./usermanager.cgi' onSubmit='return addNewUserGroup()' method='post'>\n"
			. "<div class='NewUserNameArea'>New group name<br><input type='text' name='usergroupname_newgroup' id='usergroupname_newgroup' size='18' tabindex='5'></div>\n"
			. "<div class='NewUserBtnArea'><br><input type='submit' id='btn_newgroup' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'  value='Create this group'  tabindex='6'></div>\n";
		
		$BODY .= "<input type='hidden' name='command_newgroup' value='addnewusergroup'>\n"
			. "<input type='hidden' name='index' value='newgroup'>\n"
			. "</div></form>\n\n";


		# Show user group list
		my $UserGroupList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergrouplist.cgi")} or {};
		if($UserGroupList eq "")
		{
			print "<div style='text-align: center'>Error! : Cannot open the user group list.<br>\n";
			print "<a href='./usermanager.cgi'>back</a></div>\n";
			exit(0);
		}
		
		$BODY .= generateUserGroupList($UserGroupList);
    }
	
	return $BODY;
}
    


#---------------------------------------------------------
# Generate JavaScript
#---------------------------------------------------------

my $ScriptBody = <<__ScriptBody__;
<script type='text/javascript'>
<!--
function addNewUserGroup()
{
	if(document.getElementById('usergroupname_newgroup').value == ''){alert('Please enter a user group name.');return false;}

	return true;
}

function addSelectedUsersToGroup()
{
	var selection = document.getElementById('useridlist');

	var selected = false;
	for(i=0; i<selection.options.length; i++)
	{
		if(selection.options[i].selected)
		{
			selected = true;
		}
	}

	if(!selected)
	{
		alert('Please select one or more user ids.');
		return false;
	}

	return true;

}

function addNewUser()
{
	if(document.getElementById('userid_newuser').value == '')
	{
		alert('Please enter user id.');
		return false;
	}
	
	var passElm = document.getElementById("password_newuser");
	var passElm2 = document.getElementById("password2_newuser");
	if(passElm.value == ''){alert('Please enter password.');return false;}
	if(passElm.value != passElm2.value){alert('Two passwords are different. Please re-enter passwords.');return false;}
	else{return true;}
}


function changeNickname()
{
	if(document.getElementById('userid_changenickname').value == '')
	{
		alert('Please enter user id.');
		return false;
	}

	if(document.getElementById('nickname_changenickname').value == '')
	{
		alert('Please enter nickname.');
		return false;
	}

	return true;
}



function deleteUsers()
{
	var deleteUserList = "";

    var reg = new RegExp("^userdeletecheck_", "i");

	var counter = 1;
	for(var i=0; i<document.forms["userlistform"].elements.length; i++)
	{
		if (document.forms["userlistform"].elements[i].name.match(reg))
		{
			if(document.forms["userlistform"].elements[i].checked)
			{
				deleteUserList += document.getElementById("userid_" + counter).innerHTML + ", ";
			}
			counter++;
		}
	}

	var mes = "Delete Users: ";
	if(counter == 2)
	{
		mes = "Delete User: ";
	}

	if(deleteUserList == "")
	{
		alert('Please check one or more user ids.');
		return false;
	}
	else{
		if(window.confirm(mes + deleteUserList.substr(0, deleteUserList.length-2) + ' ?'))
		{
			return true;
		}
	}

	return false;
}


function deleteUserGroups()
{
	var deleteUserGroupList = "";

    var reg = new RegExp("^usergroupdeletecheck_", "i");

	var counter = 2;
	for(var i=0; i<document.forms["usergrouplistform"].elements.length; i++)
	{
		if ((document.forms["usergrouplistform"].elements[i].name.match(reg)))
		{
			if(document.forms["usergrouplistform"].elements[i].checked) 
			{
				deleteUserGroupList += document.getElementById("usergroupname_" + counter).innerHTML + ", ";
			}
			counter ++;
		}
	}

	var mes = "Delete User Groups: ";
	if(counter == 2)
	{
		mes = "Delete User Group: ";
	}

	if(deleteUserGroupList == "")
	{
		alert('Please check one or more user group names.');
		return false;
	}
	else{
		if(window.confirm(mes + deleteUserGroupList.substr(0, deleteUserGroupList.length-2) + ' ?'))
		{
			return true;
		}
	}

	return false;
}

function btnAreaMouseOver(elm)
{
	elm.style.backgroundColor = "#ffd0d0";
}

function btnAreaMouseOut(elm)
{
	elm.style.backgroundColor = "#ffffff";
}

// -->
</script>
__ScriptBody__


#---------------------------------------------------------
# Generate HTML
#---------------------------------------------------------

	my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<meta http-equiv='Content-Style-Type' content='text/css'>\n
		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "positlog_admin.css' type='text/css'>\n
                <meta http-equiv='Content-Script-Type' content='text/javascript'>
		<title>PositLog User Management</title>\n"
	. $ScriptBody
	. "</head>\n";

my $BODY ="";


#---------------------------------------------------------------
# Command Processor
#---------------------------------------------------------------

if($command eq "")
{
		$BODY = generateMainPage();
}
elsif($command eq "addnewuser")
{
    #---------------------------------------------------------
    # Create a new user
    #---------------------------------------------------------

    if($useridAuth ne "" && $useridAuth->{$userid})
    {
		print "<div style='text-align: center'>User id '" . $userid . "' already exists.<br>\n";
		print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
		exit(0);
    }

    if($userid =~ /[^a-zA-Z0-9\_\-\@]/)
	{
		print "<div style='text-align: center'>User's id includes invalid characters.<br>\n";
		print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
		exit(0);
	}

    if($userid eq "public"
	   || $userid eq "admin")
	{
		print "<div style='text-align: center'>You can not use this id.<br>\n";
		print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
		exit(0);
	}
	   
    if($password =~ /[^a-zA-Z0-9\^\~\_\!\#\%\&\(\)\*\+\-\/\.\:\;\<\=\>\'\"\\\?\@\[\]\^\`\{\|\}]/)
    {
		print "<div style='text-align: center'>The password includes invalid characters.<br>\n";
		print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
		exit(0);
    }

    if($nickname =~ /[\[\]\<\>]/g)
    {
		print "<div style='text-align: center'>The nickname includes invalid characters.<br>\n";
		print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
		exit(0);
    }

    if($nickname eq "")
    {
	$useridAuth->{$userid}{"nickname"} = $userid;
    }
    else
    {
	$useridAuth->{$userid}{"nickname"} = $nickname;
    }

    my $salt="ry";
    my $cryptpass = crypt($password, $salt);
    $useridAuth->{$userid}{"password"} = $cryptpass;

	if($usergroupname ne "")
	{
		my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
		if($UserList eq "")
		{
			print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n";
			print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
			exit(0);
		}
		$UserList->{$userid} = 1;

		if(!eval{Storable::lock_nstore $UserList, $PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi"})
		{
			print "<div style='text-align: center'>Error! : Cannot add " . $userid ." to " . $usergroupname . " user group.<br>\n";
			print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
			exit(0);
		}

	}

	# user must be added to "all" user group
	if($usergroupname ne "all")
	{
		my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_all.cgi")} or {};
		if($UserList eq "")
		{
			print "<div style='text-align: center'>Error! : Cannot open 'all' user group.<br>\n";
			print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
			exit(0);
		}

		$UserList->{$userid} = 1;

		if(!eval{Storable::lock_nstore $UserList, $PositLogConfig::adminpath . "usergroup_all.cgi"})
		{
			print "<div style='text-align: center'>Error! : Cannot add " . $userid ." to 'all'  user group.<br>\n";
			print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
			exit(0);
		}
	}

		# save user
    if(eval{Storable::lock_nstore $useridAuth, $PositLogConfig::adminpath . "authentication.cgi"})
    {
		if($usergroupname ne "")
		{
			$BODY .= generateMainPage("User '" . $userid . "' is added to '" .$usergroupname . "' user group.");
		}
		else
		{
			$BODY .= generateMainPage("User '" . $userid . "' is added to 'all' user group.");
		}
    }
    else
    {
		print "<div style='text-align: center'>Error! : Cannot save the authentication file.<br>\n";
		print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
		exit(0);
    }

}
elsif($command eq "changenickname")
{
    #---------------------------------------------------------
    # Change nickname
    #---------------------------------------------------------

    if($userid eq "public" || $userid eq "admin"){
				print "<div style='text-align: center'>You can not use this id.<br>\n";
				print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
				exit(0);
		}

    if($useridAuth ne "" && $useridAuth->{$userid}){
				if($nickname =~ /[\[\]\<\>]/g){
						print "<div style='text-align: center'>The nickname includes invalid characters.<br>\n";
						print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
						exit(0);
				}

				# save nickname
				$useridAuth->{$userid}{"nickname"} = $nickname;
				if(eval{Storable::lock_nstore $useridAuth, $PositLogConfig::adminpath . "authentication.cgi"}){
						$BODY .= generateMainPage("Nickname of user '" . $userid . "' is changed to '" .$nickname . "'.");
				}
				else{
						print "<div style='text-align: center'>Error! : Cannot save the authentication file.<br>\n";
						print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
						exit(0);
				}
    }
		else{
				print "<div style='text-align: center'>User id '" . $userid . "' does not exist.<br>\n";
				print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
		exit(0);
		}

}
elsif($command eq "adduserstogroup")
{
    #---------------------------------------------------------
    # Add Users to a Group
    #---------------------------------------------------------

	if($usergroupname ne "")
	{
		my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
		if($UserList eq "")
		{
			print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n";
			print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
			exit(0);
		}
		my $addedlist = "";
		my $alllist = "";
		my $usercount = 0;

		foreach my $newid (@useridlist)
		{
			if(scalar($UserList->{$newid}) != 1){
				$UserList->{$newid} = 1;
				$addedlist .= $newid . ", ";
				$usercount++;
				$alllist .= $newid . ", ";
			}
		}

		if($alllist ne "")
		{
			$alllist = substr($alllist, 0, length($alllist)-2);
		}
		if($addedlist ne "")
		{
			$addedlist = substr($addedlist, 0, length($addedlist)-2);
		}

		if(eval{Storable::lock_nstore $UserList, $PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi"})
		{

			if($usercount == 1)
			{
				$BODY .= generateMainPage("User '" . $addedlist . "' is added to '" .$usergroupname . "' user group.");
			}
			elsif($usercount > 1)
			{
				$BODY .= generateMainPage("Users '" . $addedlist . "' are added to '" .$usergroupname . "' user group.");
			}
			else
			{
				$BODY .= generateMainPage("No user is added to '" .$usergroupname . "' user group.");
			}
		}
		else
		{
			print "<div style='text-align: center'>Error! : Cannot add " . $alllist ." to " . $usergroupname . " user group.<br>\n";
			print "<a href='./usermanager.cgi?usergroupname=" . $usergroupnameenc . "'>back</a></div>\n";
			exit(0);
		}

	}

}
elsif($command eq "addnewusergroup")
{
    #---------------------------------------------------------
    # Create a new group
    #---------------------------------------------------------

    my $UserGroupList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergrouplist.cgi")} or {};

	if(scalar($UserGroupList->{$usergroupname}) == 1)
    {
		print "<div style='text-align: center'>User group name '" . $usergroupname . "' already exists.<br>\n";
		print "<a href='./usermanager.cgi'>back</a></div>\n";
		exit(0);
    }

    if($usergroupname eq "all")
	{
		print "<div style='text-align: center'>You can not use this name.<br>\n";
		print "<a href='./usermanager.cgi'>back</a></div>\n";
		exit(0);
	}

	$UserGroupList->{$usergroupname} = 1;

    if(!eval{Storable::lock_nstore $UserGroupList, $PositLogConfig::adminpath . "usergrouplist.cgi"})
	{
		print "Cannot save the user group list.<br>\n";
		print "Please check the file permission.\n";
		exit(0);
	}

	my %UserList = ();
	if(!eval{Storable::lock_nstore \%UserList, $PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi"})
	{
		delete $UserGroupList->{$usergroupname};
		print "<div style='text-align: center'>Error! : Cannot create " . $usergroupname . " user group.<br>\n";
		print "<a href='./usermanager.cgi'>back</a></div>\n";
		exit(0);
	}
	my $tmpname = $usergroupname;
	$usergroupname = "";
	$BODY .= generateMainPage("User group '" . $tmpname . "' is created.");

}
elsif($command eq "deleteusergroups")
{
    #---------------------------------------------------------
    # Delete User Groups
    #---------------------------------------------------------

	my $deleteUserGroupNameList = "";

	my $UserGroupList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergrouplist.cgi")} or {};
	if($UserGroupList eq "")
	{
		print "<div style='text-align: center'>Error! : Cannot open the group name list.<br>\n";
		print "<a href='./usermanager.cgi?usergroupname='" . $usergroupnameenc . "'>back</a></div>\n";
		exit(0);
	}


	for(my $i=1; $i < $listcounter_usergroup+1; $i++)
	{
		my $gname = $CGI->param("usergroupdeletecheck_" . $i);
		
		if($gname ne ""){
			if(scalar($UserGroupList->{$gname}) == 1)
			{
				delete $UserGroupList->{$gname};
				if(!eval{Storable::lock_nstore $UserGroupList, $PositLogConfig::adminpath . "usergrouplist.cgi"})
				{
					print "<div style='text-align: center'>Error! : Cannot save the user group list.<br>\n";
					print "<a href='./usermanager.cgi'>back</a></div>\n";
				}
					
				$deleteUserGroupNameList .= "User group '" . $gname . "' is deleted.<br>\n";

				my $gnameenc = $gname;
				$gnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
				$gnameenc =~ tr/ /+/;
					
				if(0 == unlink($PositLogConfig::adminpath . "usergroup_" . $gnameenc  . ".cgi"))
				{
					print "<div style='text-align: center'>Error! : Cannot delete the user group data of '" . $gname ."'.<br>\n";
					print "<a href='./usermanager.cgi'>back</a></div>\n";
				}
			}

			# delete from page configuration
			opendir( DATADIR, $PositLogConfig::datapath );
			my @PageList = readdir( DATADIR );
			closedir( DATADIR );
			foreach my $pageid (@PageList)
			{
				if($pageid eq "." || $pageid eq ".." || $pageid eq ".htaccess")
				{
					next;
				}

				my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};
				if($permissionHash eq "")
				{
					print "Cannot read the page permission.<br>\n";
					print "<a href='./pagemanager.cgi'>back</a></div>\n";
					exit(0);
				}
				
				my $changed = 0;
				if(scalar($permissionHash->{"read_page_group"}{$gname}) == 1)
				{
					$changed = 1;
					delete $permissionHash->{"read_page_group"}{$gname};
				}
				if(scalar($permissionHash->{"write_plainsprite_group"}{$gname}) == 1)
				{
					$changed = 1;
					delete $permissionHash->{"write_plainsprite_group"}{$gname};
				}
				if(scalar($permissionHash->{"write_attachedsprite_group"}{$gname}) == 1)
				{
					$changed = 1;
					delete $permissionHash->{"write_attachedsprite_group"}{$gname};
				}
				if(scalar($permissionHash->{"write_supersprite_group"}{$gname}) == 1)
				{
					$changed = 1;
					delete $permissionHash->{"write_supersprite_group"}{$gname};
				}
				if(scalar($permissionHash->{"create_page_group"}{$gname}) == 1)
				{
					$changed = 1;
					delete $permissionHash->{"create_page_group"}{$gname};
				}

				if($changed == 1)
				{
					if(!eval{Storable::lock_nstore $permissionHash, $PositLogConfig::datapath . $pageid . "/permission.cgi"})
					{
						print "Cannot create the permission file.\n";
						print "Please check the file permission.<br>\n";
						print "<a href='./usermanager.cgi'>back</a></div>\n";
						exit(0);
					}
				}
			}

		}
	}

	$BODY .= generateMainPage($deleteUserGroupNameList);

}
elsif($command eq "deleteusers" && $usergroupname ne "")
{
	my $deleteUserIdList = "";

	#---------------------------------------------------------
	# Remove users
	#---------------------------------------------------------

	if($usergroupname ne "all")
	{
		my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};

		if($UserList eq "")
		{
			print "<div style='text-align: center'>Error! : Cannot open the member's list of '" . $usergroupname . "' user group.<br>\n";
			print "<a href='./usermanager.cgi?usergroupname='" . $usergroupnameenc . "'>back</a></div>\n";
			exit(0);
		} 

		for(my $i=1; $i < $listcounter_user+1; $i++)
		{
			my $id = $CGI->param("userdeletecheck_" . $i);
			if($id ne ""){
				if(scalar($UserList->{$id}) == 1)
				{
					delete $UserList->{$id};
					$deleteUserIdList .= "User '" . $id . "' is deleted from '" . $usergroupname . "'.<br>\n";
				}
			}
		}
		
		if(!eval{Storable::lock_nstore $UserList, $PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi"})
		{
			print "<div style='text-align: center'>Error! : Cannot save the member list of ". $usergroupname . " user group.";
			print "<a href='./usermanager.cgi?usergroupname='" . $usergroupnameenc . "'>back</a></div>\n";
			exit(0);
		}
	}

	#---------------------------------------------------------
	# Delete users
	#---------------------------------------------------------
	else{


		my $UserGroupList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergrouplist.cgi")} or {};
		my $allmemberList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_all.cgi")} or {};

		if($useridAuth eq "")
		{
			print "<div style='text-align: center'>Error! : Cannot open the authentication file.<br>\n";
			print "<a href='./usermanager.cgi?usergroupname='" . $usergroupnameenc . "'>back</a></div>\n";
			exit(0);
		}
		if($UserGroupList eq "")
		{
			print "<div style='text-align: center'>Error! : Cannot open the group name list.<br>\n";
			print "<a href='./usermanager.cgi?usergroupname='" . $usergroupnameenc . "'>back</a></div>\n";
			exit(0);
		}
		if($allmemberList eq "")
		{
			print "<div style='text-align: center'>Error! : Cannot open the member's list of 'all' user group.<br>\n";
			print "<a href='./usermanager.cgi?usergroupname='" . $usergroupnameenc . "'>back</a></div>\n";
			exit(0);
		} 


		for(my $i=1; $i < $listcounter_user+1; $i++)
		{
			my $id = $CGI->param("userdeletecheck_" . $i);
			if($id ne ""){
				# delete from authentication database
				if($useridAuth->{$id})
				{
					delete $useridAuth->{$id};
					if(!eval{Storable::lock_nstore $useridAuth, $PositLogConfig::adminpath . "authentication.cgi"})
					{
						print "<div style='text-align: center'>Error! : Cannot save the authentication file.<br>\n";
						print "<a href='./usermanager.cgi?usergroupname='" . $usergroupnameenc . "'>back</a></div>\n";
						exit(0);
					}
				}

				# delete from 'all' user group
				if(scalar($allmemberList->{$id}) == 1)
				{
					delete $allmemberList->{$id};
					if(!eval{Storable::lock_nstore $allmemberList, $PositLogConfig::adminpath . "usergroup_all.cgi"})
					{
						print "<div style='text-align: center'>Error! : Cannot save the member's list of 'all' user group.<br>\n";
						print "<a href='./usermanager.cgi?usergroupname='" . $usergroupnameenc . "'>back</a></div>\n";
						exit(0);
					}
				}

				$deleteUserIdList .= "User '" . $id . "' is deleted from group 'all, ";

				# delete from another user group
				if($usergroupname eq "all")
				{
					foreach my $groupname (keys %$UserGroupList)
					{
						my $groupnameenc = $groupname;
						$groupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
						$groupnameenc =~ tr/ /+/;
						
						my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $groupnameenc . ".cgi")} or {};

						if($tmpList eq "")
						{
							print "<div style='text-align: center'>Error! : Cannot open the member's list of '" . $groupname . "' user group.<br>\n";
							print "<a href='./usermanager.cgi?usergroupname='" . $usergroupnameenc . "'>back</a></div>\n";
							exit(0);
						} 

						if(scalar($tmpList->{$id}) == 1)
						{
							delete $tmpList->{$id};
							if(!eval{Storable::lock_nstore $tmpList, $PositLogConfig::adminpath . "usergroup_" . $groupnameenc . ".cgi"})
							{
								print "<div style='text-align: center'>Error! : Cannot save the member's list of '" . $groupname . "' user group.<br>\n";
								print "<a href='./usermanager.cgi?usergroupname='" . $usergroupnameenc . "'>back</a></div>\n";
								exit(0);
							}
							
							$deleteUserIdList .= $groupname . ", ";
						}
					}
				}

				$deleteUserIdList = substr($deleteUserIdList, 0, length($deleteUserIdList)-2) . "'.<br>\n";


				# delete from page configuration
				opendir( DATADIR, $PositLogConfig::datapath );
				my @PageList = readdir( DATADIR );
				closedir( DATADIR );
				foreach my $pageid (@PageList)
				{
					if($pageid eq "." || $pageid eq ".." || $pageid eq ".htaccess")
					{
						next;
					}

					my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};
					if($permissionHash eq "")
					{
						print "Cannot read the page permission.<br>\n";
						print "<a href='./pagemanager.cgi'>back</a></div>\n";
						exit(0);
					}
					
					my $changed = 0;
					if(scalar($permissionHash->{"read_page"}{$id}) == 1)
					{
						$changed = 1;
						delete $permissionHash->{"read_page"}{$id};
					}
					if(scalar($permissionHash->{"write_plainsprite"}{$id}) == 1)
					{
						$changed = 1;
						delete $permissionHash->{"write_plainsprite"}{$id};
					}
					if(scalar($permissionHash->{"write_attachedsprite"}{$id}) == 1)
					{
						$changed = 1;
						delete $permissionHash->{"write_attachedsprite"}{$id};
					}
					if(scalar($permissionHash->{"write_supersprite"}{$id}) == 1)
					{
						$changed = 1;
						delete $permissionHash->{"write_supersprite"}{$id};
					}
					if(scalar($permissionHash->{"create_page"}{$id}) == 1)
					{
						$changed = 1;
						delete $permissionHash->{"create_page"}{$id};
					}

					if($changed == 1)
					{
						if(!eval{Storable::lock_nstore $permissionHash, $PositLogConfig::datapath . $pageid . "/permission.cgi"})
						{
							print "Cannot create the permission file.\n";
							print "Please check the file permission.<br>\n";
							print "<a href='./usermanager.cgi'>back</a></div>\n";
							exit(0);
						}
					}


				}


			}
		}
	}

	$BODY .= generateMainPage($deleteUserIdList);

}


$BODY .= "</body>\n";

my $FOOTER = "</html>";

print $HEADER . $BODY . $FOOTER;


