#!/usr/local/bin/perl

# --------------------------------------------------------
# PositLog
#
# The position logger for web contents.
#
# positlog.cgi 
#     main cgi script for PositLog
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp>
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# PositLog is distributed under the MIT License.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
# --------------------------------------------------------

use strict;
# Default library (upper perl 5.8)
use CGI qw/-debug :standard/;
use CGI::Cookie;
use Storable qw(lock_retrieve lock_nstore);
# Additional library
use JSON;
# Additional plugins
use PositLogConfig;
use PositLogAuth;
use PositLogSprites;

# CSS
my $CSSHEADER = "";

# Set default world position (pixel) 
my $worldTop = 0;
my $worldLeft = 0;

# parameters are already URL decoded.
my $CGI = new CGI;

# view position
my $arg_vp = $CGI->param("vp");
# sprite id
my $arg_id = $CGI->param("id");
# edge of contents
my $arg_edge = $CGI->param("edge");

my $noscript = $CGI->param("noscript");
if($noscript eq ""){
		$noscript = "false";
}

my $pageid = $CGI->param("load");
if($pageid eq ""){
    my $homepageid = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "homepage.cgi")} or {};
    if($homepageid ne "")
    {
				$pageid = $$homepageid;
    }
}

# load serialized configuration data
my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")};
if($@)
{
    print $CGI->header(-charset => 'utf-8');
    print "<html><head><title>PositLog: Page not found</title></head><body style='background-color: #c0c0c0;'><h1 style='background-color: #305030; color: #ffffff; padding: 5px; font-size: 18px;'>Page not found</h1></body></html>";
    exit(0);
}


my $positlogMode = $CGI->param("mode");
# Check available mode
if($positlogMode ne "ViewMode"
   && $positlogMode ne "EditMode"
   && $positlogMode ne "ViewEditMode"
   && $positlogMode ne "Login"
   && $positlogMode ne "Logout"
    )
{
    # default mode
    $positlogMode = "ViewMode";
}

#-------------------------------------------------------------
# Authentication
#-------------------------------------------------------------
my $loginerror = "";

my $loginid = $CGI->param("loginid");
my $loginpass = $CGI->param("loginpass");

my $permissionHash;

my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")};
if($@){ warn $@; print $CGI->header(-charset => 'utf-8'); print "Cannot read the authentication file for admin.<br>\n"; exit(0);}
my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")};
if($@){ warn $@; print $CGI->header(-charset => 'utf-8'); print "Cannot read the authentication file for users.<br>\n"; exit(0);}

sub showLoginScreen
{
    my ($clearid, $mode) = @_;

    # mode
    #  EditMode : Go to EditMode. If the user is not permitted to edit, showLoginScreen again.
    #  ViewEditMode : Go to ViewMode. If the user is permitted to edit, go to EditMode.

    if($clearid eq "clearid")
    {
				$loginid = "";
    }

		my $checked = "";
		my $savedpass = "";
		if($loginid eq ""){
				$loginid = $CGI->cookie("savedloginid");
				$savedpass = $CGI->cookie("savedloginpass");
				if($loginid ne ""){
						$checked = "checked";
				}
		}

    my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<meta http-equiv='Content-Style-Type' content='text/css'>\n
		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "logincheck.css' type='text/css'>\n
		<script type='text/javascript'>
		<!--
		function saveOnClick()
		{
				theDay = new Date();
				theDay.setTime(theDay.getTime() + (30 * 1000 * 60 * 60 * 24));
				var box = document.getElementById('saveaccount');
				var loginid = document.getElementById('loginid').value;
				var loginpass = document.getElementById('loginpass').value;
				if(loginid == '' || loginpass == ''){
						box.checked = false;
						alert('Please enter user id and password')
						return;
				}
				if(!box.checked){
						loginid = '';
						loginpass = '';
				}
				var cs='savedloginid='+loginid+';';
				cs+=' path=" . $PositLogConfig::cgipath . ";';
				if(box.checked)
				{
						cs+=' expires='+theDay.toGMTString()+';';
				}
				document.cookie=cs;

				cs='savedloginpass='+loginpass+';';
				cs+=' path=" . $PositLogConfig::cgipath . ";';
				if(box.checked)
				{
						cs+=' expires='+theDay.toGMTString()+';';
				}
				document.cookie=cs;
		}
		// -->
		</script>
		<title>PositLog Administration : Login</title>\n
	</head>\n";


    my $BODY = "<body onLoad=\"(document.getElementById('loginid')).focus()\">\n
  <div id='logintop'>\n
  <div id='login'>\n
  <h1>Login to <a href='./positlog.cgi?load=" . $pageid . "'>" . $configHash->{"page_title"} . "</a></h1>\n
  <form id='loginform' action='positlog.cgi?load=" . $pageid . "&mode=" . $mode . "' method='post'>\n
    <p>\n
      user id<br>\n
      <input type='text' name='loginid' id='loginid' value='" . $loginid . "' size='20' tabindex='1'>\n
    </p>\n
    <p>\n
      password<br>\n
      <input type='password' name='loginpass' id='loginpass' value='" . $savedpass . "' size='20' tabindex='2'>\n
    </p>\n
    <p id='saveaccount-label'>\n
    Save my user id and password&nbsp;&nbsp;<input type='checkbox' name='saveaccount' id='saveaccount' onclick='saveOnClick();'  tabindex='3' value='1' " . $checked . ">\n
    </p>\n
    <p id='submitarea'>\n" . $loginerror . 
    "<br/><input type='submit' id='submitbtn' value='Login' tabindex='4'><br>\n
	</p>\n
    <input type='hidden' name='mode' id='mode' value='" . $mode . "'>\n
    <input type='hidden' name='load' id='load' value='" . $pageid . "'>\n
  </form>\n
  </div>\n
  <div id='copyright'>\n
  Powered by <a href='http://positlog.storybook.jp/'>PositLog</a>\n
  </div>\n
  </div>\n
</body>\n";

    my $FOOTER = "</html>";

    print $HEADER . $BODY . $FOOTER;
}


if($loginid eq "")
{
# Read temporal cookie
    $loginid = $CGI->cookie("loginid") || "";
    $loginpass = $CGI->cookie("loginpass") || "";
    if($loginid eq "" || $loginid eq "public")
    {
				$loginid = "public";
				$loginpass = "";
    }
}
elsif($loginid eq "public")
{
    $loginpass = "";
}

if($positlogMode eq "Logout")
{
    $positlogMode = "ViewMode";
    #-------------------
    # Logout and Show View Screen
    #-------------------
    $loginid = "public";
    $loginpass = "";
}

if($loginid eq "public" || $positlogMode eq "EditMode" || $positlogMode eq "ViewEditMode")
{
    $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};
    if($permissionHash eq "")
    {
				print $CGI->header(-charset => 'utf-8');
				print "Cannot read the page permission.<br>\n";
				exit(0);
    }
}


if($positlogMode eq "Login")
{
    if($loginid eq "public")
    {
				$loginid = "";
    }
    print $CGI->header(-charset => 'utf-8');
    &showLoginScreen("", "ViewEditMode");
    exit(0);
}
elsif($positlogMode eq "EditMode" || $positlogMode eq "ViewEditMode" || $positlogMode eq "ViewMode")
{
    PositLogAuth::authenticateUser($loginid, $loginpass);


    if(PositLogAuth::isPublicUser)
    {
				# public user
				$loginpass = "";

				my $cookieUser = new CGI::Cookie(
						-path => "$PositLogConfig::cgipath",
						-name => "loginid",
						-value => "$loginid",
						);
				my $cookiePass = new CGI::Cookie(
						-path => "$PositLogConfig::cgipath",
						-name => "loginpass",
						-value => "$loginpass",
						);
				print $CGI->header(-charset => 'utf-8', -cookie => [$cookieUser,$cookiePass]);
    }
    elsif(PositLogAuth::isValidUser)
    {
				# Valid user 
				my $cookieUser = new CGI::Cookie(
						-path => "$PositLogConfig::cgipath",
						-name => "loginid",
						-value => "$loginid",
						);
				my $cookiePass = new CGI::Cookie(
						-path => "$PositLogConfig::cgipath",
						-name => "loginpass",
						-value => "$loginpass",
						);

				print $CGI->header(-charset => 'utf-8', -cookie => [$cookieUser,$cookiePass]);
    }
    else{
				# Invalid user 
				$loginpass = "";
				my $cookieUser = new CGI::Cookie(
						-path => "$PositLogConfig::cgipath",
						-name => "loginid",
						-value => "$loginid",
						);
				my $cookiePass = new CGI::Cookie(
						-path => "$PositLogConfig::cgipath",
						-name => "loginpass",
						-value => "$loginpass",
						);

				print $CGI->header(-charset => 'utf-8', -cookie => [$cookieUser,$cookiePass]);

				&showLoginScreen("", $positlogMode);
				exit(0);
    }
}


#-------------------------------------------------------------
# Can read?
#-------------------------------------------------------------

my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")};
if($@){ warn $@; print "Cannot read permission.cgi."; exit(0); }

my $canRead = 0;
if(PositLogAuth::isAdminUser)
{
    $canRead = 1;
}
elsif(scalar($permissionHash->{"read_page"}{"public"}) == 1)
{
    $canRead = 1;
}
else
{
    # check user list
    if(scalar($permissionHash->{"read_page"}{$loginid}) == 1)
    {
				$canRead = 1;
    }
    else
    {
				# check user group list
				foreach my $usergroupname (keys %{$permissionHash->{"read_page_group"}})
				{
						my $usergroupnameenc = $usergroupname;
						$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
						$usergroupnameenc =~ tr/ /+/;

						my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
						if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
						if(scalar($UserList->{$loginid}) == 1)
						{
								$canRead = 1;
						}
				}
    }
}

if(!$canRead)
{
    # The user cannot read this page.
    $loginerror = "<span style='color:red; font-size:12px;'>You don't have permission.</span>";
    &showLoginScreen("clearid", "ViewMode");
    exit(0);
}


#-------------------------------------------------------------
# Can edit?
#-------------------------------------------------------------

my $canAttachedSprite = 0; # write_attachedsprite
my $canSuperSprite = 0; # write_supersprite

# If $spriteHtml == 1 Then HTML tags are available
my $spriteHtml = scalar($configHash->{"sprite_html"});

if(PositLogAuth::isAdminUser)
{
    $canSuperSprite = 1;
    $canAttachedSprite = 1;
    $spriteHtml = 1;
    if($positlogMode eq "ViewEditMode")
    {
				$positlogMode = "EditMode";
    }
}

if(($positlogMode eq "ViewEditMode" || $positlogMode eq "EditMode")
   && PositLogAuth::isValidUser && !PositLogAuth::isAdminUser)
{
    my $canEditFlag = 0;

    if(scalar($permissionHash->{"write_supersprite"}{$loginid}) == 1)
    {
				$canEditFlag = 1;
				$canSuperSprite = 1;
				$canAttachedSprite = 1;
				$spriteHtml = 1;
    }
    elsif(scalar($permissionHash->{"write_attachedsprite"}{$loginid}) == 1)
    {
				$canEditFlag = 1;
				$canAttachedSprite = 1;
    }
    elsif(scalar($permissionHash->{"write_plainsprite"}{$loginid}) == 1)
    {
				$canEditFlag = 1;
    }
    
    # check user group list
    if($canEditFlag != 1)
    {
				foreach my $usergroupname (keys %{$permissionHash->{"write_plainsprite_group"}})
				{
						my $usergroupnameenc = $usergroupname;
						$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
						$usergroupnameenc =~ tr/ /+/;

						my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
						if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
						if($UserList->{$loginid} == 1)
						{
								$canEditFlag = 1;
						}
				}
    }

    if($canAttachedSprite != 1)
    {
				foreach my $usergroupname (keys %{$permissionHash->{"write_attachedsprite_group"}})
				{
						my $usergroupnameenc = $usergroupname;
						$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
						$usergroupnameenc =~ tr/ /+/;

						my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
						if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
						if($UserList->{$loginid} == 1)
						{
								$canEditFlag = 1;
								$canAttachedSprite = 1;
						}
				}
    }

    if($canSuperSprite != 1)
    {
				foreach my $usergroupname (keys %{$permissionHash->{"write_supersprite_group"}})
				{
						my $usergroupnameenc = $usergroupname;
						$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
						$usergroupnameenc =~ tr/ /+/;

						my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
						if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
						if($UserList->{$loginid} == 1)
						{
								$canEditFlag = 1;
								$canSuperSprite = 1;
								$canAttachedSprite = 1;
								$spriteHtml = 1;
						}
				}
    }


    if($positlogMode eq "EditMode" && !$canEditFlag)
    {
				$loginerror = "<span style='color:red; font-size:12px;'>You don't have permission.</span>";
				&showLoginScreen("clearid", "EditMode");
				exit(0);
    }

    if($positlogMode eq "ViewEditMode")
    {
				if($canEditFlag)
				{
						$positlogMode = "EditMode";
				}
				else
				{
						$positlogMode = "ViewMode";
				}
    }
}

if(($positlogMode eq "ViewEditMode" || $positlogMode eq "EditMode")
   && $loginid eq "public")
{
    my $canEditFlag = 0;

    if(scalar($permissionHash->{"write_supersprite"}{"public"}) == 1)
    {
				$canEditFlag = 1;
				$canSuperSprite = 1;
				$canAttachedSprite = 1;
				$spriteHtml = 1;
    }
    if(scalar($permissionHash->{"write_attachedsprite"}{"public"}) == 1)
    {
				$canEditFlag = 1;
				$canAttachedSprite = 1;
    }
    if(scalar($permissionHash->{"write_plainsprite"}{"public"}) == 1)
    {
				$canEditFlag = 1;
    }

    if($positlogMode eq "EditMode" && !$canEditFlag)
    {
				$loginerror = "<span style='color:red; font-size:12px;'>You don't have permission.</span>";
				&showLoginScreen("clearid", "EditMode");
				exit(0);
    }

    if($positlogMode eq "ViewEditMode")
    {
				if($canEditFlag)
				{
						$positlogMode = "EditMode";
				}
				else
				{
						$positlogMode = "ViewMode";
				}
    }
}



#-------------------------------------------------------------
# Load Page
#-------------------------------------------------------------

my $bodycolor = "#" . $configHash->{"page_bgcolor"};
my $footercolor = "#" . $configHash->{"footer_bgcolor"};
my $pageType = $configHash->{"page_type"};
if(!$pageType){
		$pageType = "document";
}
my $worldMaxWidth = $configHash->{"page_max_width"};
if(!$worldMaxWidth){
		$worldMaxWidth = 100000;
}
my $worldMaxHeight = $configHash->{"page_max_height"};
if(!$worldMaxHeight){
		$worldMaxHeight = 100000;
}
my $sprite_autolink = $configHash->{"sprite_autolink"};
my $sprite_autobr = $configHash->{"sprite_autobr"};


my $autolinkValue = 0;
if($spriteHtml != 1 && scalar($sprite_autolink) == 1)
{
    $autolinkValue = 1;
}

my $autobrValue = 0;
if($spriteHtml != 1 && scalar($sprite_autobr) == 1)
{
    $autobrValue = 1;
}


# ---------------------------
#    Generate HTML BODY
# ------------------------

# Check user agent
my $useragent = $ENV{'HTTP_USER_AGENT'};
# wzero3 [es] opera as mobile:  Mozilla/4.0 (compatible; MSIE 6.0; Windows CE; SHARP/WS007SH; PPC; 480x640) Opera 8.60 [ja]
# Pocket Internet Explorer: MSIE 4.01; Windows CE;
if($useragent =~ /MSIE 4.01; Windows CE;/){
		$noscript = "true";
}
my $BODYELM = "<body id='positlogbody' onLoad='bodyOnLoad()' onUnload='bodyUnLoad()' style='background-color:" . $bodycolor . ";";
#if($positlogMode eq "ViewMode"){
#		my $background_image = $configHash->{'background_image'};
#		if($background_image ne ""){
#				$BODYELM .= " background-image:url(\"" . $PositLogConfig::bgimagespath . $background_image . "\");";
#		}
#		$BODYELM .= "background-position:0px 0px;";
#}
$BODYELM .= "'>\n\n";

my $BODY = "";

if($noscript ne "true"){
		$BODY .= "<noscript><div id='javascriptalert' style='background-color:white; font-size:smaller; position:absolute; z-index: 2500000; left: 0px; top: 0px;'>Welcome to [" . $configHash->{"page_title"} . "]. Please enable JavaScript and author's stylesheet to show a map-like page,<br>or you can visit <a href='./positlog.cgi?load=" . $pageid . "&noscript=true'>the no-script &amp; no-stylesheet page</a> to see a list version of this page.</div></noscript>";
}

# add controlpanel
if($positlogMode eq "EditMode")
{
    PositLogAuth::authenticatePage($loginid, $pageid);

    $BODY .= "<div id='controlpanel' style='width: 99%;'>"
#    $BODY .= "<div id='controlpanel' style='width: 100%;'>"
				. "<div id='newspritebtn'></div>";
    if(scalar($permissionHash->{"create_page"}{$loginid}) == 1 || PositLogAuth::isAdminUser)
    {
				$BODY .= "<div id='newpagebtn'></div>";
    }

# The trouble is that the admin id is displayed in ViewMode
# because positlogadmin.cgi leaves id_cookie.
# $adminUser = 0 and $loginid = admin's id in ViewMode
# after logging into positlogadmin.cgi by admin's id.
# Consequetly, $loginid is displayed in only EditMode.
    
    if(PositLogAuth::isAdminUser)
    {
				$BODY .= "<div id='yourid'><a href='./pageproperty.cgi?page=$pageid'>&lt;Property&gt;</a>&nbsp;&nbsp;admin's ID</div>";
    }
    elsif(PositLogAuth::isPageCreator)
    {
				$BODY .= "<div id='yourid'><a href='./pageproperty.cgi?page=$pageid'>&lt;Property&gt;</a>&nbsp;&nbsp;ID [$loginid]</div>";
    }
    else
    {
				$BODY .= "<div id='yourid'>ID [$loginid]</div>";
    }

    $BODY .= "<div id='controlresult'></div>";

		$BODY .= "<input onclick='drawingCheckOnClick()' type='checkbox' id='drawingCheck' style='float:left'><span style='float:left'>Drawing&nbsp;</span>";

		$BODY .= "<span style='float:left; display:none' id='drawingPasswordLabel1'>(pass </span><input type='password' size='8' id='drawingPassword' style='display: none; float:left;'><span style='float:left; display:none;' id='drawingPasswordLabel2'>)&nbsp;&nbsp;</span>";


		$BODY .= "<input onclick='showGuideCheckOnClick()' type='checkbox' id='showGuideCheck' style='float:left'><span style='float:left'>Guide&nbsp;</span>";
		
		if(PositLogAuth::isAdminUser){
				$BODY .= "<input onclick='showRegionCheckOnClick()' type='checkbox' id='showRegionCheck' style='float:left'><span style='float:left'>Frame</span>";
		}
#		$BODY .= "&nbsp;(<input onclick='allRegionCheckOnClick()' type='checkbox' id='allRegionCheck' style='float:left'><span style='float:left'>All)&nbsp;&nbsp;&nbsp;&nbsp;</span>";
		$BODY .= "<div id='status'></div>";

		$BODY .= "</div>\n\n";

}

# add spritesworld (root node of sprites)
my $borderTop = "0px";
if($positlogMode eq "EditMode")
{
    $worldTop = $worldTop + 30;
}

# background-color is needed for changing mouse cursor in spritesworld area on IE6
$BODY .= "\n\n<div id='spritesworld' style='z-index: 0; left: 0px; top: " . $worldTop . "px; width: 100%; height: 100%; border-top:" . $borderTop .  ";";
#if($positlogMode eq "EditMode"){
		my $background_image = $configHash->{'background_image'};
		if($background_image ne ""){
				$BODY .= "background-image:url(\"" . $PositLogConfig::bgimagespath . $background_image . "\");";
		}
		$BODY .= "background-position:0px 0px;";
#}
$BODY .= "'>";

# ---------------------------
# generate sprites
# ---------------------------

# attention!! 
# No line feeds (\n) or another characters allowed between <ul> and <li>
# because <ul class="spriteslist"> can include only <li> element.
if($noscript eq "true" || $pageType eq "document"){
		$BODY .= "\n<ul id='spriteslist' style='left:0px; top:0px; ";
}
else{
		$BODY .= "\n<ul id='spriteslist' style='left:0px; top:0px; display:none;";
}
if($positlogMode eq "EditMode" && $pageType eq "document"){
		$BODY .= "border-left:1px dashed #808080;";
		$BODY .= "border-top:1px dashed #808080;";
}
$BODY .= "'>";

# retrieve sprites in a page
my $spritesObj = PositLogSprites->new();
my $result = $spritesObj->generateSprites($pageid, $loginid, $loginpass,"sprite",-1,"","");
if($result eq "") {
    print "Cannot get sprites.\n";
    exit(0);
}

# get hash for exporting
my $spritesHash = $spritesObj->getHash();

# get HTML
my $BODY_ = $spritesObj->getHtml();
$BODY .= $$BODY_;

# get CSS
if($noscript ne "true"){
		my $CSS_  = $spritesObj->getCss();
		$CSSHEADER .= $$CSS_;
}

$BODY .= "</ul>";

if($noscript ne "true"){
		$BODY .= "<canvas id='drawcanvas' style='z-index:1; left: 0px; top: 0px;' width='200' height='200'></canvas>";
}

# footer of spritesworld
$BODY .= "\n</div>";




# -----------------------------------
#    Generate HTML HEADER 
# -----------------------------------

my $HEADER1 = q{<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/html4/loose.dtd">
    <html lang="ja-JP">
    <head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <meta http-equiv="Content-Style-Type" content="text/css">
    <meta http-equiv="Content-Script-Type" content="text/javascript">};

if($noscript ne "true"){
		my %spritesHashExport;

		foreach my $keyID (keys %{$spritesHash}){
				if($keyID ne ""){
						$spritesHashExport{$keyID}{"author"} = $spritesHash->{$keyID}{"author_name"};
						$spritesHashExport{$keyID}{"time"} = $spritesHash->{$keyID}{"modified_time"};
						if($spritesHash->{$keyID}{"margin_p"}){
								$spritesHashExport{$keyID}{"margin_p"} = $spritesHash->{$keyID}{"margin_p"};
						}
						if($spritesHash->{$keyID}{"margin_s"}){
								$spritesHashExport{$keyID}{"margin_s"} = $spritesHash->{$keyID}{"margin_s"};
						}
						if($spritesHash->{$keyID}{"parent"} && $spritesHash->{$keyID}{"parent"} ne ""){
								$spritesHashExport{$keyID}{"parent"} = $spritesHash->{$keyID}{"parent"};
						}
						if($spritesHash->{$keyID}{"children"} && $spritesHash->{$keyID}{"children"} ne "" && scalar(@{$spritesHash->{$keyID}{"children"}}) > 0){
								$spritesHashExport{$keyID}{"children"} = $spritesHash->{$keyID}{"children"};
						}

						if($spritesHash->{$keyID}{"display_author"} ne ""){
								push(@{$spritesHashExport{$keyID}{"disp"}},$spritesHash->{$keyID}{"display_author"});
						}
						else{
								push(@{$spritesHashExport{$keyID}{"disp"}},0);
						}
						if($spritesHash->{$keyID}{"display_created_time"} ne ""){
								push(@{$spritesHashExport{$keyID}{"disp"}},$spritesHash->{$keyID}{"display_created_time"});
						}
						else{
								push(@{$spritesHashExport{$keyID}{"disp"}},0);
						}
						if($spritesHash->{$keyID}{"display_positlink"} ne ""){
								push(@{$spritesHashExport{$keyID}{"disp"}},$spritesHash->{$keyID}{"display_positlink"});
						}
						else{
								push(@{$spritesHashExport{$keyID}{"disp"}},0);
						}

				}
		}
		my $spritesHashJSON = objToJson(\%spritesHashExport);

		my $autolayout = $configHash->{"auto_layout"};
		if($autolayout ne "0"){
				$autolayout = 1;
		}
		else{
				$autolayout = 0;
		}
		$HEADER1 .= "\n\n<script type='text/javascript'>\n<!--
var PARAM = new Object();
PARAM.spritesHash=" . $spritesHashJSON . ";
PARAM.pageid='" . $pageid ."';
PARAM.vp='" . $arg_vp ."';
PARAM.id='" . $arg_id ."';
PARAM.edge='" . $arg_edge ."';
PARAM.worldMaxWidth='" . $worldMaxWidth ."';
PARAM.worldMaxHeight='" . $worldMaxHeight ."';
PARAM.positlogMode='" . $positlogMode ."';
PARAM.IMAGEFILEPATH='" . $PositLogConfig::systempath ."';
PARAM.CGIFILEPATH='" . $PositLogConfig::cgipath ."';
PARAM.DATAFILEPATH='" . $PositLogConfig::datapath ."';
PARAM.attachedSprite=" . $canAttachedSprite .";
PARAM.superSprite=" . $canSuperSprite .";
PARAM.sprite_html=" . $spriteHtml .";
PARAM.sprite_autobr=" . $autobrValue .";
PARAM.sprite_autolink=" . $autolinkValue .";
PARAM.page_type='" . $pageType ."';
PARAM.autolayout=" . $autolayout . ";
// -->
</script>\n";

		# This css is needed for smooth scroll of fixed element when 'fixed' is emulated by using style.setExpression.
		$HEADER1 .= "<!--[if lt IE 7]><style type='text/css'> body { background: url(null) fixed; } </style> <![endif]-->\n";

		# canvas.js is emulation of canvas element.
		$HEADER1 .= "<!--[if IE]><script type='text/javascript' src='" . $PositLogConfig::systempath . "excanvas.js'></script><![endif]-->\n";

		# positlog.js is main system script.
		$HEADER1 .= "<script type='text/javascript' src='" .  $PositLogConfig::systempath . "positlog.js' charset='UTF-8'></script>\n";

		if($positlogMode eq "EditMode")
		{
				$HEADER1 .= "		<script type='text/javascript' src='" .  $PositLogConfig::systempath . "edit.js' charset='UTF-8'></script>\n";
				$HEADER1 .= "		<script type='text/javascript' src='" .  $PositLogConfig::systempath . "triangle-color-selector.js' charset='UTF-8'></script>\n";
		}

		$CSSHEADER = "		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "positlog.css' type='text/css'>\n" . $CSSHEADER;
}

my $pagetitle = "		<title>" . $configHash->{"page_title"} . "</title>\n";

my $rssinfo = "		<link rel='alternate' title='RSS' href='" . $PositLogConfig::cgipath . "pagerss.cgi?load=" . $pageid . "' type='application/rss+xml'/>\n";
my $HEADER2 = "</head>\n";

my $HEADER = $HEADER1 . $CSSHEADER .  $pagetitle . $rssinfo . $HEADER2;


# ---------------------------
#    Generate HTML FOOTER
# ---------------------------


my $FOOTER = "<div id='footer' style='text-align:right; width:280px; display:none; padding: 0px;'>";
$FOOTER .= "<span id='footerbg' style='background-color: $footercolor; padding: 2px;'>";
$FOOTER .= "<span id='copyright'> </span>\n";
$FOOTER .= "<span id='login'>";

if($positlogMode eq "EditMode")
{
    $FOOTER .= "<a href='./positlog.cgi?load=" . $pageid . "&mode=ViewMode'>[View]</a>";
}
elsif($positlogMode eq "ViewMode")
{
    if($loginid eq "public")
    {
				if(scalar($permissionHash->{"write_plainsprite"}{"public"}) == 1
					 || scalar($permissionHash->{"write_attachedsprite"}{"public"}) == 1
					 || scalar($permissionHash->{"write_supersprite"}{"public"}) == 1)
				{
						$FOOTER .= "<a href='./positlog.cgi?load=" . $pageid . "&mode=EditMode'>[Edit]</a>";
				}
    }
    else
    {
	$FOOTER .= "<a href='./positlog.cgi?load=" . $pageid . "&mode=EditMode'>[Edit]</a>";
    }

}

if($loginid ne "public")
{
    $FOOTER .= "<a href='./positlog.cgi?load=" . $pageid . "&mode=Logout'>[Logout]</a>";
    $FOOTER .= "<a href='./positlogadmin.cgi'>[Admin]</a>";
}
else
{
    $FOOTER .= "<a href='./positlog.cgi?load=" . $pageid . "&mode=Login'>[Login]</a>";
}

$FOOTER .= "&nbsp;";
$FOOTER .= "</span>";
#$FOOTER .= "url : <span id='currentposition'> </span></div>\n\n";
$FOOTER .= "<span id='currentposition'> </span></span></div>\n\n";

$FOOTER .= "<canvas id='mapcanvas' width='200' height='200'></canvas>";
$FOOTER .= "<canvas id='viewcanvas' width='200' height='200'></canvas>";

$FOOTER .= "<div id='homebtn' onclick='moveHomePosition()' style='border: 2px solid #a0a0a0; position:absolute; z-index: 2500000; width: 80px; height: 20px; background-color: #e0e0e0; text-align:center; cursor: pointer; display: none;'>HOME</div>";

my $CLOSE .= "</body>\n</html>";

# print out

if($noscript eq "true"){
		print $HEADER . $BODYELM . $BODY . $CLOSE;
}
else{
		print $HEADER . $BODYELM . $FOOTER . $BODY . $CLOSE;
}
