package PositLogConfig;

#-----------------------------
# Global Configuration File
#-----------------------------

#-------------------------------------------------------------------
# 以下の設定において挙げる例は，次のようなディレクトリ構成の場合について
# 記述しています．
# http://xxx.com/yyy/ があなたのサイトのルートURL
# http://xxx.com/yyy/positlog/ がPositLogのルートURL
# http://xxx.com/yyy/positlog/system/ がPositLogのシステムURL
#
# 以下のディレクトリは，DocumentRoot（Webサーバ上の公開したいHTMLドキュメントを
# 設置するディレクトリ）からの相対パスを指します．
# 
# /positlog/ がCGIファイルをアップロードする先のディレクトリ
# /positlog/system/ がsystemフォルダ内のファイルをアップロードする先のディレクトリ
# /positlog/pages/ がページデータを保存するためのディレクトリ
# /positlog/bgimages/ が背景画像を保存するためのディレクトリ
# /admin/ が管理用データを保存するためのディレクトリ
#-------------------------------------------------------------------

#-------------------------------------------------------------------
# PositLogのルートURL
#（CGIファイルをアップロードする先のディレクトリと対応するURLです）
# 例）http://xxx.com/yyy/positlog/

$site = "http://xxx.com/yyy/positlog/";

#-------------------------------------------------------------------
# PositLogのルートURL（ドメイン以下のパス）
#（はじめとおわりの"/"を省略しないでください）
# 例）/yyy/positlog/
# 誤った例）http://xxx.com/yyy/positlog/

$cgipath = "/yyy/positlog/";

#-------------------------------------------------------------------
# PositLogのシステムURL（ドメイン以下のパス）
#（.css files, .js files, システム画像ファイルなど，systemフォルダ内の
#  ファイルをアップロードする先のディレクトリと対応するURLです）
#（はじめとおわりの"/"を省略しないでください）
# 例）/yyy/positlog/system/
# 誤った例）http://xxx.com/yyy/positlog/system/

$systempath = "/yyy/positlog/system/";

#-------------------------------------------------------------------
# ページデータ保存用ディレクトリ
# （CGIファイルをアップロードする先のディレクトリからの相対パス
# 　で指定してください）
# （おわりの"/"を省略しないでください）
# 例) ./pages/

$datapath = "./pages/";

#-------------------------------------------------------------------
# 背景画像保存用ディレクトリ
# （CGIファイルをアップロードする先のディレクトリからの相対パス，
# あるいはサーバのルートディレクトリからの絶対パスで指定してください）
# (おわりの"/"を省略しないでください)
# 相対パスの例) ./bgimages/
# 絶対パスの例) /var/www/html/positlog/bgimages/

$bgimagespath = "./bgimages/";

#-------------------------------------------------------------------
# 管理用データ保存用ディレクトリ
# Webからはアクセスできない位置に設定するのが理想です．
# （CGIファイルをアップロードする先のディレクトリからの相対パス，
# あるいはサーバのルートディレクトリからの絶対パスで指定してください）
# (おわりの"/"を省略しないでください)
# 相対パスの例) ../admin/
# 絶対パスの例) /var/www/admin/

$adminpath = "../admin/";




1;
