//-------------------------------------------------
// positlog.js
//
// Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
//  <taro@summer.nifty.jp>
//   http://storybook.jp/ 
//
// This file is part of PositLog.
//
// PositLog is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// PositLog is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//-------------------------------------------------

//---------------------------
// Globals 
//---------------------------

// view position of sprites world
var viewPositionX = 0;
var viewPositionY = 0;
var moveViewPositionFlag = false;

// position of sprites world
var worldLeft = 0;
var worldTop = 0;
var worldHeight = 0;
var worldWidth = 0;

// loginid
var loginid = "public";

// selected sprite
var selectedSprite = null;

// focused sprite (indicated by ID)
var focusedSprite = null;

// saving sprite
var savingSprite = null;

// deleting sprite
var deletingSprite = null;

// top and left of the new sprite
var topOfNewSprite = 0;
var leftOfNewSprite = 0;

// Go back to the original border
var focusedBorderWidthOfEditingSprite = "";
var focusedBorderStyleOfEditingSprite = "";
var focusedBorderColorOfEditingSprite = "";

// Saving error.
// Go back to the original sprite!
var originalInnerHtmlOfEditingSprite = "";
var originalLeftOfEditingSprite = 0;
var originalTopOfEditingSprite = 0;
var originalWidthOfEditingSprite = 0;
var originalZindexOfEditingSprite = 0;
var originalBorderWidthOfEditingSprite = "";
var originalBorderStyleOfEditingSprite = "";
var originalBorderColorOfEditingSprite = "";

var originalShowFragmentOfEditingSprite = "";
var originalShowPositOfEditingSprite = "";
var originalShowTimeOfEditingSprite = "";
var originalShowAuthorOfEditingSprite = "";

var originalAuthorOfEditingSprite = "";


// Is sprite moving?
var movingSpriteFlag = false;

// Is sprite scaling?
var scalingSpriteFlag = false;

// Is sprite editing?
var editingSpriteFlag = false;

// Is editor moving?
var movingEditorFlag = false;

// Is mouse out of world?
var mouseOutOfWorld = false;

// original attributes of sprite 
// (attributes are temporally changed when selected)
var originalSpriteZindex = 0;
var originalSpriteBorderWidth = "";
var originalSpriteBorderColor = "";
var originalSpriteBorderStyle = "";

// previous position of Mouse
var prevMouseX = 0;
var prevMouseY = 0;

// url : urlPure?cgiargs#ureID
var urlPure = "";

// cgiargs (below) are defined in positlog.cgi
// var vpValue
// var pageidValue
// var idValue
// var edgeValue
// var positlogMode
// var spritehtmlValue
// var autobrValue
// var autolinkValue

// for checking browser
var crossBrowser = new chkAjaBrowser();

//------------------------------------
// Get Inner Scrollbar Area
//-------------------------------------

function getInnerWidth()
{
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		return parseInt(document.documentElement.clientWidth);
    }
    else
    {
		var trueWidth = parseInt(document.documentElement.clientWidth);
		if(crossBrowser.bw.safari)
		{
			trueWidth = parseInt(window.innerWidth);
		}
		else if(crossBrowser.bw.opera)
		{
			trueWidth = parseInt(window.innerWidth)-3;
			if(parseInt(window.innerHeight) < parseInt(worldHeight))
			{
				// vertical scroll bar is visible
				trueWidth -= 20;
			}
		}
		
		return trueWidth;
	}
}


function getInnerHeight()
{
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		return parseInt(document.documentElement.clientHeight);
    }
    else
    {
		var trueHeight = parseInt(document.documentElement.clientHeight);
		if(crossBrowser.bw.safari)
		{
			trueHeight = parseInt(window.innerHeight);
		}
		else if(crossBrowser.bw.opera)
		{
			trueHeight = parseInt(window.innerHeight)-3;
			if(parseInt(window.innerWidth) < parseInt(worldWidth))
			{
				// horizontal scroll bar is visible
				trueHeight -= 20;
			}
		}
		
		return trueHeight;
	}
}



//------------------------------------
// Get Mouse Position
//-------------------------------------

function getMouseX(e)
{
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		return parseInt(document.documentElement.scrollLeft) + parseInt(window.event.clientX);
    }
    else
    {
		return parseInt(e.pageX);
    }
}

function getMouseY(e){
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		return parseInt(document.documentElement.scrollTop) + parseInt(window.event.clientY);
    }
    else
    {
		return parseInt(e.pageY);
    }
}

//-------------------------------------
// Parse URL
//-------------------------------------

function parseURL(url)
{
    var urlArray = url.split("?");
    urlPure = urlArray[0];
}


//------------------------------------------------------------
//  style='position:fixed' for IE6 and Opera8
//  (IE7 and Opera9 don't need this function)
//------------------------------------------------------------

function layerFix()
{
    var controlPanelNode = document.getElementById("controlpanel");
    var footerNode = document.getElementById("footer");

    // hide fixed layers for handsome scrolling
    if(!mouseOutOfWorld)
    {
		if(controlPanelNode != null)
		{
			controlPanelNode.style.left = document.documentElement.scrollLeft + "px";
			controlPanelNode.style.top = document.documentElement.scrollTop + "px";
			controlPanelNode.style.display = "block"; 
		}
		
		footerNode.style.left = document.documentElement.scrollLeft + "px";
		footerNode.style.top = (document.documentElement.clientHeight - document.getElementById("footer").offsetHeight + document.documentElement.scrollTop).toString() + "px";
		footerNode.style.display = "block"; 
    }
    else
    {
		if(controlPanelNode != null)
		{
			controlPanelNode.style.display="none";
		}
		footerNode.style.display="none";
    }


    if(parseInt(document.documentElement.scrollTop) > worldHeight + worldTop - document.documentElement.clientHeight)
    {
		document.documentElement.scrollTop = worldHeight + worldTop - document.documentElement.clientHeight;
    }

}



//------------------------------------
// set button events
//------------------------------------

function setButtonEvents(id, mouseoverimg, mouseoutimg, mousedownimg, myfunc)
{
    var btnNode = document.getElementById(id);
    if(btnNode != null && btnNode != undefined && IMAGEFILEPATH != undefined)
    {
		btnNode.onmouseover = function(){this.style.backgroundImage = "url('" + IMAGEFILEPATH + mouseoverimg + "')";}
		btnNode.onmouseout = function(){this.style.backgroundImage = "url('" + IMAGEFILEPATH + mouseoutimg + "')";}
		btnNode.onmousedown = function(){this.style.backgroundImage = "url('" + IMAGEFILEPATH + mousedownimg + "')"; eval(myfunc)}
		btnNode.onmouseup = function(){this.style.backgroundImage = "url('" + IMAGEFILEPATH + mouseoutimg + "')";}
    }

}

//------------------------------------
// load image files into browser cache
//------------------------------------

function loadImageCache()
{
    for(var i = 0; i < arguments.length; i++)
    {
		var cacheImage = new Image();
		cacheImage.src = IMAGEFILEPATH + arguments[i];
    }
}


//-------------------------------------
// Body onLoad()
//-------------------------------------


function bodyOnLoad()
{
    // check browser
    //   alert("safari:"+crossBrowser.bw.safari+"\nkonqueror:"+crossBrowser.bw.konqueror+"\nmozes:"+crossBrowser.bw.mozes+"\nopera:"+crossBrowser.bw.opera+"\nmsie7:"+crossBrowser.bw.msie7+"\nmsie:"+crossBrowser.bw.msie);

    var spritesListNode = document.getElementById("spriteslist");
    var spritesList = spritesListNode.childNodes;

    // load image files into browser cache
    loadImageCache("scaler.gif", "mover.gif", "editor.gif", "close.gif", "save.gif", "top.gif", "bottom.gif", "newspritebtn.gif", "newspritebtn_hl.gif", "newspritebtn_rev.gif",  "newpagebtn.gif", "newpagebtn_hl.gif", "newpagebtn_rev.gif");

    // get region of the world
    var spritesWorldNode = document.getElementById("spritesworld");
    worldLeft = parseInt(spritesWorldNode.style.left.replace(/px/g, ""));
    worldTop = parseInt(spritesWorldNode.style.top.replace(/px/g, ""));
    worldWidth = parseInt(spritesWorldNode.style.width.replace(/px/g, ""));
    worldHeight = parseInt(spritesWorldNode.style.height.replace(/px/g, ""));

    viewPositionX = 0;
    viewPositionY = 0;

    parseURL(location.href);


    // apply order:  id > edge > view position
    if(idValue != "")
    {
		focusedSprite = document.getElementById(idValue);
		
		var innerWidth = getInnerWidth();
		if(innerWidth > worldWidth)
		{
			innerWidth = worldWidth;
		}
		var leftOffset = innerWidth/2 - parseInt(focusedSprite.style.width.replace(/px/g, ""))/2;

		leftOffset = Math.round(leftOffset);

		if(leftOffset < 10)
		{
			leftOffset = 10;
		}
		var topOffset = 10;
		var innerHeight = getInnerHeight();
		if(innerHeight > worldHeight)
		{
			innerHeight = worldHeight;
		}
		if(innerHeight > 200)
		{
			topOffset = 100;
		}


		moveViewPosition(-parseInt(focusedSprite.style.left.replace(/px/g, ""))+parseInt(leftOffset),-parseInt(focusedSprite.style.top.replace(/px/g, ""))+parseInt(topOffset));

		focusedSpriteBorderWidth = focusedSprite.style.borderTopWidth
				+ " " +  focusedSprite.style.borderRightWidth
				+ " " +  focusedSprite.style.borderBottomWidth
				+ " " +  focusedSprite.style.borderLeftWidth;
			
		focusedSpriteBorderColor = focusedSprite.style.borderTopColor
				+ " " +  focusedSprite.style.borderRightColor
				+ " " +  focusedSprite.style.borderBottomColor
				+ " " +  focusedSprite.style.borderLeftColor;

		focusedSpriteBorderStyle = focusedSprite.style.borderTopStyle
				+ " " +  focusedSprite.style.borderRightStyle
				+ " " +  focusedSprite.style.borderBottomStyle
				+ " " +  focusedSprite.style.borderLeftStyle;

		// show rectangle of focusedSprite
		focusedSprite.style.border = "3px solid #ffa0a0";
		focusedSprite.style.padding = "0px";

    }
    else if(edgeValue != "")
    {
		// get list of all sprites
		var targetSprite = spritesList[0];

		if(edgeValue == "top" || edgeValue == "bottom")
		{
			var topY = parseInt(targetSprite.style.top.replace(/px/g, ""));

			for (var i=0; i<spritesList.length; i++)
			{
				var tmpSprite = spritesList[i];
				if(tmpSprite.nodeType == 1)
				{
					var tmpTop = parseInt(tmpSprite.style.top.replace(/px/g, ""));

					if(edgeValue == "top" && tmpTop < topY)
					{
						topY = tmpTop;
						targetSprite = tmpSprite;
					}
					else if(edgeValue == "bottom" && tmpTop > topY)
					{
						topY = tmpTop;
						targetSprite = tmpSprite;
					}

				}
			}
		}
		else if(edgeValue == "left" || edgeValue == "right")
		{
			var leftX = parseInt(targetSprite.style.left.replace(/px/g, ""));

			for (var i=0; i<spritesList.length; i++)
			{
				var tmpSprite = spritesList[i];
				if(tmpSprite.nodeType == 1)
				{
					var tmpLeft = parseInt(tmpSprite.style.left.replace(/px/g, ""));

					if(edgeValue == "left" && tmpLeft < leftX)
					{
						leftX = tmpLeft;
						targetSprite = tmpSprite;
					}
					else if(edgeValue == "right" && tmpLeft > leftX)
					{
						leftX = tmpLeft;
						targetSprite = tmpSprite;
					}

				}
			}
		}

		moveViewPosition(-parseInt(targetSprite.style.left.replace(/px/g, ""))+5,-parseInt(targetSprite.style.top.replace(/px/g, ""))+5);
		
    }
    else if(vpValue != "")
    {
		// move to focused viewposition
		vpValue.match(/^(.+),(.+)$/);
		moveX = RegExp.$1;
		moveY = RegExp.$2;
		// to int
		moveX = moveX - 0;
		moveY = moveY - 0;

		moveViewPosition(moveX, moveY);
    }

    // config control panel
    if(positlogMode == "EditMode")
    {
		var controlPanelNode = document.getElementById("controlpanel");

		// "fixed" does not work well on ie6 and opera8,
		// but works ie7 and opera9
		if(crossBrowser.bw.msie)
		{
			controlPanelNode.style.position = "absolute";
		}
		else
		{
			controlPanelNode.style.position = "fixed";
		}

		setButtonEvents("newspritebtn", "newspritebtn_hl.gif", "newspritebtn.gif", "newspritebtn_rev.gif", "createSprite();");
		setButtonEvents("newpagebtn", "newpagebtn_hl.gif", "newpagebtn.gif", "newpagebtn_rev.gif", "createPage()");

    }

    // make spriteslist visible 
    spritesListNode.style.display = "block";


    // set footer position
    var footerNode = document.getElementById("footer");
    if(crossBrowser.bw.msie)
    {
		footerNode.style.position = "absolute";
		window.onscroll = layerFix;
		window.onresize = layerFix;
    }
    else
    {
		footerNode.style.position = "fixed";
    }

    // set events to sprites
    for (var i=0; i<spritesList.length; i++)
    {
		var tmpSprite = spritesList[i];
		if(tmpSprite.nodeType == 1)
		{
			tmpSprite.onmouseover = spriteOnMouseOver;
		}
    }

    // set mouse events
    document.onmousedown = generalOnMouseDown;
    document.onmouseup = generalOnMouseUp;
    document.onmousemove = generalOnMouseMove;
    document.onmouseout = generalOnMouseOut;

    // set current position
    document.getElementById("currentposition").innerHTML = "<a href='"+location.href+"'>" + location.href + "</a>";	

    // set login id
    loginid = getCookie("loginid");

    // set cursor
    if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		var spritesWorldNode = document.getElementById("spritesworld");	    
		spritesWorldNode.style.cursor = "url(" + IMAGEFILEPATH + "hand.cur), default";
    }

    // go to #(fragment) position on IE6
    if(crossBrowser.bw.msie)
    {
		var url = location.href;
		var urlArray = url.split("#");
		if(urlArray.length  > 1)
		{
			fragment = urlArray[1];
			var targetSprite = document.getElementById(fragment);
			if(targetSprite != null)
			{
				var top = targetSprite.style.top;
				var left = targetSprite.style.left;
				window.scrollTo(left.replace(/px/,""),top.replace(/px/,""));
				layerFix();
			}
			
		}
    }

}


//-------------------------------------
// Manipulate sprites / view position
//-------------------------------------

function clearSelectedSprite()
{	
    if(editingSpriteFlag)
    {
		return;
    }

    if(selectedSprite != null)
    {
		// reset to original border

		if(positlogMode == "EditMode")
		{
			selectedSprite.style.borderWidth = originalSpriteBorderWidth;
			selectedSprite.style.borderColor = originalSpriteBorderColor;
			selectedSprite.style.borderStyle = originalSpriteBorderStyle;

			// remove mover
			var tmpMoverElm = document.getElementById("sprite-mover");
			if(tmpMoverElm)
			{
				selectedSprite.removeChild(tmpMoverElm);
			}
			// remove scaler
			var tmpScalerElm = document.getElementById("sprite-scaler");
			if(tmpScalerElm)
			{
				selectedSprite.removeChild(tmpScalerElm);
			}
			// remove editor Icon
			var tmpEditorIconElm = document.getElementById("sprite-editor");
			if(tmpEditorIconElm)
			{
				selectedSprite.removeChild(tmpEditorIconElm);
			}

			selectedSprite.style.padding = "3px";
		}

		// reset z-index
		selectedSprite.style.zIndex = originalSpriteZindex;
		//	    selectedSprite.style.overflow = "hidden";

		selectedSprite = null;
    }
}


function inScrollbarRegion(e)
{
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		var x = window.event.clientX;
		var y = window.event.clientY;

		var cw = getInnerWidth();
		if(x > cw || x < 1)
		{
			return false;
		}
		var ch = getInnerHeight();

		if(y > ch || y < 1)
		{
			return false;
		}
    }
    else
    {
		var x = e.pageX;
		var y = e.pageY;

		var trueWidth = getInnerWidth();
		
		if(x - parseInt(window.pageXOffset) > trueWidth || x - parseInt(window.pageXOffset) < 1)
        {
			return false;
        }

		var trueHeight = getInnerHeight();

		if(y - parseInt(window.pageYOffset) > trueHeight || y - parseInt(window.pageYOffset) < 1)
        {
			return false;
        }
    }
    
    return true;

}



function generalOnMouseOut(e)
{
    if(!inScrollbarRegion(e) && !movingSpriteFlag && !movingEditorFlag)
    {
		generalOnMouseUp();
    }
}


function generalOnMouseDown(e)
{
    // check region of Sprites World
    if(getMouseX(e) < worldLeft || getMouseX(e) > worldLeft+worldWidth
       || getMouseY(e) < worldTop || getMouseY(e) > worldTop+worldHeight)
    {
		return;
    }


    // move selected sprite to front/back
    if(selectedSprite != null)
    {
		if(parseInt(selectedSprite.style.zIndex) == 2000)
		{
			selectedSprite.style.zIndex = 1;
		}
		else if(parseInt(selectedSprite.style.zIndex) == 1)
		{
			selectedSprite.style.zIndex = originalSpriteZindex;
		}
		else
		{
			selectedSprite.style.zIndex = 2000;
		}
   }

	// reset focus
	if(positlogMode == "ViewMode" && focusedSprite != null && selectedSprite != null &&
	   selectedSprite.id == focusedSprite.id)
	{
		focusedSprite.style.borderWidth = focusedSpriteBorderWidth;
		focusedSprite.style.borderColor = focusedSpriteBorderColor;
		focusedSprite.style.borderStyle = focusedSpriteBorderStyle;
		focusedSprite.style.padding = "3px";
		focusedSprite = null;
	}

    // check inner border of Scrollbar
    // if not, view position moves together with dragging scroll bar 
    if(!inScrollbarRegion(e))
    {
		return;
    }

    if(!movingSpriteFlag && !scalingSpriteFlag && selectedSprite == null)
    {
		// move view position of sprites world
		moveViewPositionFlag = true;

		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			var spritesWorldNode = document.getElementById("spritesworld");	    
			spritesWorldNode.style.cursor = "url(" + IMAGEFILEPATH + "hand2.cur), default";
		}
    }
}



function generalOnMouseMove(e)
{
    // check border of Sprites World
    // border can be ignored when moving Sprite or ViewPosition
    if(!moveViewPositionFlag 
       && !movingSpriteFlag
       && !scalingSpriteFlag
       && !movingEditorFlag
      )
    {
		if((getMouseX(e) < worldLeft || getMouseX(e) > worldLeft+worldWidth
			|| getMouseY(e) < worldTop || getMouseY(e) > worldTop+worldHeight) 
			|| !inScrollbarRegion(e)
		  )
		{
			mouseOutOfWorld = true;
			return;
		}
    }

    if(mouseOutOfWorld)
    {
		var footerElm = document.getElementById("footer");
		footerElm.style.display = "block";

		if(crossBrowser.bw.msie)
		{
			mouseOutOfWorld = false;
			layerFix();
		}
    }

    mouseOutOfWorld = false;


    if(prevMouseX == 0)
    {
		prevMouseX = getMouseX(e);
    }
    if(prevMouseY == 0)
    {
		prevMouseY = getMouseY(e);
    }
    var moveX = getMouseX(e) - prevMouseX;
    var moveY = getMouseY(e) - prevMouseY;
    
    prevMouseX = getMouseX(e);
    prevMouseY = getMouseY(e);

    if(movingSpriteFlag)
    {
		//----------------------
		// move single Sprite
		//----------------------
		selectedSprite.style.left = (parseInt(selectedSprite.style.left.replace(/px/g, "")) + moveX).toString() + "px";
		selectedSprite.style.top = (parseInt(selectedSprite.style.top.replace(/px/g, "")) + moveY).toString() + "px";

		// document.selection.empty() does not work well in opera
		if(!crossBrowser.bw.opera)
		{
			if(document.selection)
			{
				document.selection.empty();
			}
		}
    }
    else if(movingEditorFlag)
    {
		//----------------------
		// move editor
		//----------------------
		var editorElm = document.getElementById("editor");
		if(editorElm != null)
		{
			editorElm.style.left = (parseInt(editorElm.style.left.replace(/px/g, "")) + moveX).toString() + "px";
			editorElm.style.top = (parseInt(editorElm.style.top.replace(/px/g, "")) + moveY).toString() + "px";
		}
		// document.selection.empty() does not work well in opera
		if(!crossBrowser.bw.opera)
		{
			if (document.selection)
			{
				document.selection.empty();
			}
		}


    }
    else if(scalingSpriteFlag)
    {
		//----------------------
		// scale single Sprite
		//----------------------
		var scalerElm = document.getElementById("sprite-scaler");
		var editorIconElm = document.getElementById("sprite-editor");

		var newWidth = parseInt(selectedSprite.style.width.replace(/px/g, "")) + moveX;

		if(newWidth < 16)
		{
			newWidth = 16;
		}

		selectedSprite.style.width = newWidth.toString() + "px";

		// document.selection.empty() does not work well in opera
		if(!crossBrowser.bw.opera)
		{
			if (document.selection)
			{
				document.selection.empty();
			}
			else if (window.getSelection)
			{
				window.getSelection().removeAllRanges(); 
			}
		}

    }
    else if(moveViewPositionFlag)
    {
		moveViewPosition(moveX, moveY);
    }

    // Check whether mouse is on the selected Sprite.
    if(selectedSprite != null 
       && !movingEditorFlag
       && !movingSpriteFlag
       && !scalingSpriteFlag)
    {
		// Onmouseout events are occurred when mouse is on the region.
		// An onmouseout event is occurred when mouse is moved onto another object
		// on the selected object.
		// So, here, check whether mouse is out or not.
		var spriteLeft = parseInt(selectedSprite.style.left.replace(/px/g, "")) + viewPositionX;
		var spriteTop = parseInt(selectedSprite.style.top.replace(/px/g, "")) + viewPositionY;
		var spriteWidth = parseInt(selectedSprite.style.width.replace(/px/g, ""));
		var spriteHeight = parseInt(selectedSprite.offsetHeight);
		var xBorderOffset = 16; // magic number;
		var yBorderOffset = 32; // magic number;

		if((getMouseX(e) < worldLeft+spriteLeft || getMouseX(e) > worldLeft+spriteLeft+spriteWidth+xBorderOffset
			|| getMouseY(e) < worldTop+spriteTop || getMouseY(e) > worldTop+spriteTop+spriteHeight+yBorderOffset))
		{
			clearSelectedSprite();
		}
    }
}


function moveViewPosition(moveX, moveY)
{
    // move view posion (namely, move all Sprites)
    viewPositionX = parseInt(viewPositionX) + parseInt(moveX);
    viewPositionY = parseInt(viewPositionY) + parseInt(moveY);
	
    parseURL(location.href);
    newURL = urlPure + "?load=" + pageidValue + "&vp=" + viewPositionX.toString() + "," + viewPositionY.toString();
    document.getElementById("currentposition").innerHTML = "<a href='"+newURL+"'>" + newURL + "</a>";	

    var spritesListNode = document.getElementById("spriteslist");
    spritesListNode.style.left = (parseInt(spritesListNode.style.left.replace(/px/g, "")) + parseInt(moveX)).toString() + "px";
    spritesListNode.style.top = (parseInt(spritesListNode.style.top.replace(/px/g, "")) + parseInt(moveY)).toString() + "px";
    var spritesWorldNode = document.getElementById("spritesworld");
	
	var oldX = 0;
	var oldY = 0;
	if(crossBrowser.bw.safari)
	{
		oldX = spritesWorldNode.style.backgroundPositionX;
		oldY = spritesWorldNode.style.backgroundPositionY;
	}
	else
	{
		var oldBgPosition = spritesWorldNode.style.backgroundPosition;
		oldBgPosition.match(/(\-*\d+?)px (\-*\d+?)px/);
		oldX = RegExp.$1;
		oldY = RegExp.$2;
	}

    spritesWorldNode.style.backgroundPosition = (parseInt(oldX) + parseInt(moveX)).toString() + "px" + " " + (parseInt(oldY) + parseInt(moveY)).toString() + "px";

}



function setViewPosition(posX, posY)
{
    // move view posion (namely, move all Sprites)
    viewPositionX = parseInt(posX);
    viewPositionY = parseInt(posY);
	
    parseURL(location.href);
    newURL = urlPure + "?load=" + pageidValue + "&vp=" + viewPositionX.toString() + "," + viewPositionY.toString();
    document.getElementById("currentposition").innerHTML = "<a href='"+newURL+"'>" + newURL + "</a>";	

    var spritesListNode = document.getElementById("spriteslist");
    spritesListNode.style.left = (parseInt(posX)).toString() + "px";
    spritesListNode.style.top = (parseInt(posY)).toString() + "px";
    var spritesWorldNode = document.getElementById("spritesworld");
    spritesWorldNode.style.backgroundPosition = (parseInt(posX)).toString() + "px" + " " + (parseInt(posY)).toString() + "px";

}


function generalOnMouseUp()
{
    moveViewPositionFlag = false;

    var worldElm = document.getElementById("spritesworld");
    if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.style.cursor = "url(" + IMAGEFILEPATH + "hand.cur), default";
    }

    if(movingSpriteFlag)
    {
		movingSpriteFlag = false;

		saveStyles();
    }
    else if(movingEditorFlag)
    {
		movingEditorFlag = false;
    }
    else if(scalingSpriteFlag)
    {
		scalingSpriteFlag = false;

		saveStyles();
    }
}



function editorTitleOnMouseDown()
{
    if(movingEditorFlag)
    {
		return;
    }

    movingEditorFlag = true;
}

function moverOnMouseDown()
{
    if(movingSpriteFlag)
    {
		return;
    }

    movingSpriteFlag = true;

    originalLeftOfEditingSprite = selectedSprite.style.left;
    originalTopOfEditingSprite = selectedSprite.style.top;
    originalWidthOfEditingSprite = selectedSprite.style.width;
    originalZindexOfEditingSprite = originalSpriteZindex;
    originalBorderWidthOfEditingSprite = originalSpriteBorderWidth;
    originalBorderColorOfEditingSprite = originalSpriteBorderColor;
    originalBorderStyleOfEditingSprite = originalSpriteBorderStyle;

}


function scalerOnMouseDown()
{
    if(scalingSpriteFlag)
    {
		return;
    }

    scalingSpriteFlag = true;

    originalLeftOfEditingSprite = selectedSprite.style.left;
    originalTopOfEditingSprite = selectedSprite.style.top;
    originalWidthOfEditingSprite = selectedSprite.style.width;
    originalZindexOfEditingSprite = originalSpriteZindex;
    originalBorderWidthOfEditingSprite = originalSpriteBorderWidth;
    originalBorderColorOfEditingSprite = originalSpriteBorderColor;
    originalBorderStyleOfEditingSprite = originalSpriteBorderStyle;

}


//------------------------------------
// Close Editor
//------------------------------------
function editorControlCloseOnMouseDown()
{
    if(!editingSpriteFlag)
    {
		return;
    }

    editingSpriteFlag = false;

    var spritesWorldNode = document.getElementById("spritesworld");
    spritesWorldNode.removeChild(document.getElementById("editor"));

}


//------------------------------------
// Close Dialog
//------------------------------------
function dialogControlCloseOnMouseDown()
{
    if(!editingSpriteFlag)
    {
		return;
    }

    editingSpriteFlag = false;

    var spritesWorldNode = document.getElementById("spritesworld");
    spritesWorldNode.removeChild(document.getElementById("dialog-form"));

    savingSprite.style.left = originalLeftOfEditingSprite;
    savingSprite.style.top = originalTopOfEditingSprite;
    savingSprite.style.width = originalWidthOfEditingSprite;
    savingSprite.style.zIndex = originalZindexOfEditingSprite;
    savingSprite.style.borderWidth = originalBorderWidthOfEditingSprite;
    savingSprite.style.borderColor = originalBorderColorOfEditingSprite;
    savingSprite.style.borderStyle = originalBorderStyleOfEditingSprite;

}


//------------------------------------
// Layer (Top/Bottom)
//------------------------------------

function editorControlTopOnMouseDown()
{
    if(!editingSpriteFlag)
    {
		return;
    }

    // get list of all sprites
    var spritesListNode = document.getElementById("spriteslist");
    var spritesList = spritesListNode.childNodes;
    var topZ = 0;
    var topSprite = selectedSprite;
    for (var i=0; i<spritesList.length; i++)
    {
		var tmpSprite = spritesList[i];
		if(tmpSprite.nodeType == 1)
		{
			var tmpZ = parseInt(tmpSprite.style.zIndex);
			if(tmpSprite != selectedSprite){
				if(tmpZ > topZ){
					topZ = tmpZ;
					topSprite = tmpSprite;
				}
			}
		}
    }
    if(topSprite != selectedSprite)
    {
		originalSpriteZindex  = parseInt(topZ)+1;
    }

    document.getElementById("controlresult").innerHTML="Top!";
}



function editorControlBottomOnMouseDown()
{
    if(!editingSpriteFlag)
    {
		return;
    }

    if(originalSpriteZindex > 1){
		// get list of all sprites
		var spritesListNode = document.getElementById("spriteslist");
		var spritesList = spritesListNode.childNodes;

		for (var i=0; i<spritesList.length; i++)
		{
			var tmpSprite = spritesList[i];
			if(tmpSprite.nodeType == 1)
			{
				if(tmpSprite != selectedSprite){
					var newZ = parseInt(tmpSprite.style.zIndex) + 1;
					tmpSprite.style.zIndex = newZ;
				}
			}
		}
		originalSpriteZindex  = 10;
    }

    document.getElementById("controlresult").innerHTML="Bottom!";
}

//------------------------------------
// Open Editor
//------------------------------------

function editoriconOnMouseDown()
{
    if(editingSpriteFlag)
    {
		return;
    }

    openEditor();
}

function clearPassword()
{
    // clear password of public user
    var passwordElm = document.getElementById("editor-password");
    public_password = passwordElm.value;

    var postdata = "&command=clearpassword&id="+ selectedSprite.id + "&pageid="+pageidValue + "&public_password="+public_password;
    sendRequest(clearPasswordOnLoaded, postdata, "POST", CGIFILEPATH + "saveSprite.cgi", true, true);
}

function editorSubmit()
{
    return false;
}

function dialogSubmit()
{
    saveStyles();
    
    return false;
}

function openPasswordDialog()
{
    if(!document.getElementById("dialog-form"))
    {
		selectedSprite.style.zIndex = 2000;

		// remove mover
		var tmpMoverElm = document.getElementById("sprite-mover");
		if(tmpMoverElm)
		{
			selectedSprite.removeChild(tmpMoverElm);
		}
		// remove scaler
		var tmpScalerElm = document.getElementById("sprite-scaler");
		if(tmpScalerElm)
		{
			selectedSprite.removeChild(tmpScalerElm);
		}
		// remove editor Icon
		var tmpEditorIconElm = document.getElementById("sprite-editor");
		if(tmpEditorIconElm)
		{
			selectedSprite.removeChild(tmpEditorIconElm);
		}

		// form 
		var dialogFormElement = document.createElement("form");
		dialogFormElement.setAttribute("id", "dialog-form");
		dialogFormElement.onsubmit = dialogSubmit;

		var spriteLeft = parseInt(selectedSprite.style.left.replace(/px/g, ""));
		var spriteTop = parseInt(selectedSprite.style.top.replace(/px/g, ""));

		var dialogWidth = 200;
		var dialogHeight = 100;
		var dialogLeft = spriteLeft + viewPositionX;
		var dialogTop = spriteTop + viewPositionY - dialogHeight;

		if(dialogLeft + dialogWidth > worldWidth)
		{
			dialogLeft -= dialogLeft + dialogWidth  - worldWidth + 5;
		}
		if(dialogTop + dialogHeight > worldHeight)
		{
			dialogTop -= dialogTop + dialogHeight - worldHeight + 5;
		}
		if(dialogLeft < 0)	
		{
			dialogLeft = 0;
		}

		dialogFormElement.style.width = dialogWidth.toString() + "px";
		dialogFormElement.style.height = dialogHeight.toString() + "px";
		dialogFormElement.style.left = dialogLeft.toString() + "px";
		dialogFormElement.style.top = dialogTop.toString() + "px";

		var dialogControlElement = document.createElement("div");
		dialogControlElement.setAttribute("id", "dialog-control");

		// close btn
		var dialogControlCloseElement = document.createElement("img");
		dialogControlCloseElement.setAttribute("src", IMAGEFILEPATH + "close.gif");
		dialogControlCloseElement.setAttribute("id", "dialog-closebtn");
		dialogControlCloseElement.style.verticalAlign = "middle";
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			dialogControlCloseElement.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		dialogControlElement.appendChild(dialogControlCloseElement);

		dialogFormElement.appendChild(dialogControlElement);

		// controlPanel for editor 4
		var dialogControlElement2 = document.createElement("div");
		dialogControlElement2.setAttribute("id", "dialog-control2");

		var passElement = document.createElement("div");
		passElement.setAttribute("id", "dialog-passtitle");
		passElement.appendChild(document.createTextNode(""));
		passElement.innerHTML = "Please enter password";
		dialogControlElement2.appendChild(passElement);

		// password field
		var passFieldElement = document.createElement("input");
		passFieldElement.setAttribute("type", "password");
		passFieldElement.setAttribute("id", "dialog-password");
		passFieldElement.setAttribute("size", "10");
		passFieldElement.style.verticalAlign = "middle";
		passFieldElement.value = "";
		dialogControlElement2.appendChild(passFieldElement);

		var brElement = document.createElement("br");
		dialogControlElement2.appendChild(brElement);

		// submit 
		var submitElement = document.createElement("input");
		submitElement.setAttribute("type", "submit");
		submitElement.setAttribute("id", "dialog-submit");
		submitElement.value = "Enter";
		dialogControlElement2.appendChild(submitElement);

		// cancel
		var cancelElement = document.createElement("input");
		cancelElement.setAttribute("type", "button");
		cancelElement.setAttribute("id", "dialog-cancel");
		cancelElement.value = "Cancel";
		cancelElement.onclick = dialogControlCloseOnMouseDown;
		dialogControlElement2.appendChild(cancelElement);

		var brElement2 = document.createElement("br");
		dialogControlElement2.appendChild(brElement2);

		var resultElement = document.createElement("span");
		resultElement.setAttribute("id", "dialog-result");
		resultElement.appendChild(document.createTextNode(""));
		dialogControlElement2.appendChild(resultElement);

		dialogFormElement.appendChild(dialogControlElement2);

		dialogControlCloseElement.onmousedown = dialogControlCloseOnMouseDown;



		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.appendChild(dialogFormElement);
		
		passFieldElement.focus();

		editingSpriteFlag = true;

    }
}


function openEditor()
{
    if(!document.getElementById("editor"))
    {
		selectedSprite.style.zIndex = 2000;

		// remove mover
		var tmpMoverElm = document.getElementById("sprite-mover");
		if(tmpMoverElm)
		{
			selectedSprite.removeChild(tmpMoverElm);
		}
		// remove scaler
		var tmpScalerElm = document.getElementById("sprite-scaler");
		if(tmpScalerElm)
		{
			selectedSprite.removeChild(tmpScalerElm);
		}
		// remove editor Icon
		var tmpEditorIconElm = document.getElementById("sprite-editor");
		if(tmpEditorIconElm)
		{
			selectedSprite.removeChild(tmpEditorIconElm);
		}

		// form 
		var editorFormElement = document.createElement("form");
		editorFormElement.setAttribute("id", "editor");
		editorFormElement.onsubmit = editorSubmit;

		var spriteWidth = parseInt(selectedSprite.style.width.replace(/px/g, ""));
		var spriteHeight = parseInt(selectedSprite.offsetHeight);
		if(spriteHeight > 100)
		{
			spriteHeight = 100;
		}
		
		var spriteLeft = parseInt(selectedSprite.style.left.replace(/px/g, ""));
		var spriteTop = parseInt(selectedSprite.style.top.replace(/px/g, ""));

		var formWidth = 400;
		var formHeight = 0;
		var browserHeight = getInnerHeight();

		if(browserHeight > 600)
		{
			formHeight = 300;
		}
		else
		{
			formHeight = browserHeight / 2;
		}

		var editorWidth = formWidth + 1;
		var editorHeight = formHeight + 78;
		var editorLeft = spriteLeft + viewPositionX;
		var editorTop = spriteTop + viewPositionY + spriteHeight;

		if(editorLeft + editorWidth > worldWidth)
		{
			editorLeft -= editorLeft + editorWidth  - worldWidth + 5;
		}
		if(editorTop + editorHeight > worldHeight - document.getElementById("footer").offsetHeight)
		{
			editorTop -= editorTop + editorHeight - worldHeight + document.getElementById("footer").offsetHeight + 10;
		}
		if(editorLeft < 0)	
		{
			editorLeft = 0;
		}

		editorFormElement.style.width = editorWidth.toString() + "px";
		editorFormElement.style.height = editorHeight.toString() + "px";
		editorFormElement.style.left = editorLeft.toString() + "px";
		editorFormElement.style.top = editorTop.toString() + "px";


		// controlPanel for editor
		var editorControlElement = document.createElement("div");
		editorControlElement.setAttribute("id", "editor-control");
		editorControlElement.onmousedown = editorTitleOnMouseDown;
		// save btn
		var editorControlSaveElement = document.createElement("img");
		editorControlSaveElement.setAttribute("src", IMAGEFILEPATH + "save.gif");
		editorControlSaveElement.setAttribute("id", "editor-savebtn");
		editorControlSaveElement.style.verticalAlign = "middle";
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorControlSaveElement.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElement.appendChild(editorControlSaveElement);

		// top btn
		var editorControlTopElement = document.createElement("img");
		editorControlTopElement.setAttribute("src", IMAGEFILEPATH + "top.gif");
		editorControlTopElement.setAttribute("id", "editor-topbtn");
		editorControlTopElement.style.verticalAlign = "middle";
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorControlTopElement.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElement.appendChild(editorControlTopElement);

		// bottom btn
		var editorControlBottomElement = document.createElement("img");
		editorControlBottomElement.setAttribute("src", IMAGEFILEPATH + "bottom.gif");
		editorControlBottomElement.setAttribute("id", "editor-bottombtn");
		editorControlBottomElement.style.verticalAlign = "middle";
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorControlBottomElement.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElement.appendChild(editorControlBottomElement);

		// close btn
		var editorControlCloseElement = document.createElement("img");
		editorControlCloseElement.setAttribute("src", IMAGEFILEPATH + "close.gif");
		editorControlCloseElement.setAttribute("id", "editor-closebtn");
		editorControlCloseElement.style.verticalAlign = "middle";
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorControlCloseElement.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElement.appendChild(editorControlCloseElement);


		// id
		var editorIdElement = document.createElement("div");
		editorIdElement.setAttribute("id", "editor-id");
		editorIdElement.appendChild(document.createTextNode(""));
		editorIdElement.innerHTML = selectedSprite.id;
		editorControlElement.appendChild(editorIdElement);


		editorFormElement.appendChild(editorControlElement);


		// controlPanel for editor 2
		var editorControlElement2 = document.createElement("div");
		editorControlElement2.setAttribute("id", "editor-control2");

		// fragment
		var fragmentElement = document.createElement("div");
		fragmentElement.setAttribute("id", "editor-fragment");
		fragmentElement.appendChild(document.createTextNode(""));
		idValue = selectedSprite.id;
		var newURL = urlPure + "?" + "load=" + pageidValue + "#" + idValue;
		fragmentElement.innerHTML = "link  [ <a href='" + newURL + "'>fragment</a> ]";
		editorControlElement2.appendChild(fragmentElement);


		// show fragment
		var editorShowFragmentElement = document.createElement("input");
		editorShowFragmentElement.setAttribute("id", "editor-showfragmentlink");
		editorShowFragmentElement.setAttribute("type", "checkbox");
		editorShowFragmentElement.setAttribute("value", "1");
		var fragmentElm = document.getElementById(selectedSprite.id + "_fragmentlink");
		if(fragmentElm.style.display == "block")
		{
			editorShowFragmentElement.defaultChecked = true;
		}
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorShowFragmentElement.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElement2.appendChild(editorShowFragmentElement);


		// positlink
		var positlinkElement = document.createElement("div");
		positlinkElement.setAttribute("id", "editor-positlink");
		positlinkElement.appendChild(document.createTextNode(""));
		idValue = selectedSprite.id;
		var newURL = urlPure + "?" + "load=" + pageidValue + "&id=" + idValue;
		positlinkElement.innerHTML = "[ <a href='" + newURL + "'>posit</a> ]";
		editorControlElement2.appendChild(positlinkElement);

		editorFormElement.appendChild(editorControlElement2);

		// show posit
		var editorShowPositElement = document.createElement("input");
		editorShowPositElement.setAttribute("id", "editor-showpositlink");
		editorShowPositElement.setAttribute("type", "checkbox");
		editorShowPositElement.setAttribute("value", "1");
		var positElm = document.getElementById(selectedSprite.id + "_positlink");
		if(positElm.style.display == "block")
		{
			editorShowPositElement.defaultChecked = true;
		}
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorShowPositElement.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElement2.appendChild(editorShowPositElement);


		// single
		var singleURL = urlPure + "?" + "load=" + pageidValue + "&spriteid=" + idValue;
		var editorSingleElement = document.createElement("div");
		editorSingleElement.setAttribute("id", "editor-singlelink");
		editorSingleElement.appendChild(document.createTextNode(""));
		editorSingleElement.innerHTML = "[ <a href='" + singleURL + "'>single</a> ]";
		editorControlElement2.appendChild(editorSingleElement);





		// controlPanel for editor 3
		var editorControlElement3 = document.createElement("div");
		editorControlElement3.setAttribute("id", "editor-control3");

		// time
		var editorTimeElement = document.createElement("div");
		editorTimeElement.setAttribute("id", "editor-time");
		var timeElm = document.getElementById(selectedSprite.id + "_time");
		var timeValue = timeElm.innerHTML;
		editorTimeElement.appendChild(document.createTextNode("date [ " + timeValue + " ]"));
		editorControlElement3.appendChild(editorTimeElement);

		// show time
		var editorShowTimeElement = document.createElement("input");
		editorShowTimeElement.setAttribute("id", "editor-showtime");
		editorShowTimeElement.setAttribute("type", "checkbox");
		editorShowTimeElement.setAttribute("value", "1");
		if(timeElm.style.display == "block")
		{
			editorShowTimeElement.defaultChecked = true;
		}
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorShowTimeElement.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElement3.appendChild(editorShowTimeElement);


		editorFormElement.appendChild(editorControlElement3);


		// controlPanel for editor 4
		var editorControlElement4 = document.createElement("div");
		editorControlElement4.setAttribute("id", "editor-control4");

		// author
		var authorElm = document.getElementById(selectedSprite.id + "_author");
		var authorName = authorElm.innerHTML;
		if(authorName.match(/^&lt;.+&gt;$/)  || authorName.match(/^\[.+\]$/))
		{
			var authorElement = document.createElement("div");
			authorElement.setAttribute("id", "editor-authortitle");
			authorElement.appendChild(document.createTextNode("author "));
			editorControlElement4.appendChild(authorElement);

			// author field
			var authorFieldElement = document.createElement("input");
			authorFieldElement.setAttribute("type", "text");
			authorFieldElement.setAttribute("id", "editor-author");
			authorFieldElement.setAttribute("size", "15");
			authorFieldElement.style.verticalAlign = "middle";
			var pubauthor = getCookie("public_author");
			if(pubauthor == undefined)
			{
				pubauthor = "public";
			}
			else
			{
				pubauthor = decodeURIComponent(pubauthor);
			}
			authorFieldElement.value = pubauthor;
			editorControlElement4.appendChild(authorFieldElement);
		}
		else
		{
			var editorAuthorElement = document.createElement("div");
			editorAuthorElement.setAttribute("id", "editor-authortitle");
			editorAuthorElement.appendChild(document.createTextNode("author [ " + authorElm.innerHTML + " ]"));
			editorControlElement4.appendChild(editorAuthorElement);
		}


		// show author
		var editorShowAuthorElement = document.createElement("input");
		editorShowAuthorElement.setAttribute("id", "editor-showauthor");
		editorShowAuthorElement.setAttribute("type", "checkbox");
		editorShowAuthorElement.setAttribute("value", "1");
		if(authorElm.style.display == "block")
		{
			editorShowAuthorElement.defaultChecked = true;
		}
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorShowAuthorElement.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElement4.appendChild(editorShowAuthorElement);


		if(authorName.match(/^&lt;.+&gt;$/)  || authorName.match(/^\[.+\]$/))
		{
			var passElement = document.createElement("div");
			passElement.setAttribute("id", "editor-passtitle");
			passElement.appendChild(document.createTextNode(""));
			passElement.innerHTML = "password";
			editorControlElement4.appendChild(passElement);

			// password field
			var editorControlPasswordElement = document.createElement("input");
			editorControlPasswordElement.setAttribute("type", "password");
			editorControlPasswordElement.setAttribute("id", "editor-password");
			editorControlPasswordElement.setAttribute("size", "8");
			editorControlPasswordElement.style.verticalAlign = "middle";
			var pass = getCookie("public_password");

			var contentsElm = document.getElementById(selectedSprite.id + "_contents");
			if(contentsElm.innerHTML.match(/<br>\nNew Sprite!!\n<br>\n<br>\n/i)
			   || contentsElm.innerHTML.match(/<br>New Sprite!! <br><br>/i)
			   || contentsElm.innerHTML.match(/<br\/>\nNew Sprite!!\n<br\/>\n<br\/>\n/i)
			  )
			{
				// nop
			}
			else
			{
				if(pass == undefined)
				{
					pass = "";
				}
				if(authorName.match(/^\[.+\]$/))
				{
					pass = "";
				}
			}

			editorControlPasswordElement.value = pass;
			editorControlElement4.appendChild(editorControlPasswordElement);

			var clearpassElement = document.createElement("input");
			clearpassElement.setAttribute("id", "editor-clearpass");
			clearpassElement.setAttribute("type", "button");
			clearpassElement.setAttribute("value", "clear");
			clearpassElement.onclick = clearPassword;

			editorControlElement4.appendChild(clearpassElement);


		}


		editorFormElement.appendChild(editorControlElement4);


		editorControlSaveElement.onmousedown = editorControlSaveOnMouseDown;
		editorControlCloseElement.onmousedown = editorControlCloseOnMouseDown;
		editorControlTopElement.onmousedown = editorControlTopOnMouseDown;
		editorControlBottomElement.onmousedown = editorControlBottomOnMouseDown;

		// textarea
		var editorTextAreaElement = document.createElement("textarea");
		editorTextAreaElement.setAttribute("id", "editor-textarea");

		var innerHtml = "";
		var contentsElm = document.getElementById(selectedSprite.id + "_contents");
		if(contentsElm.innerHTML.match(/<br>\nNew Sprite!!\n<br>\n<br>\n/i)
		   || contentsElm.innerHTML.match(/<br>New Sprite!! <br><br>/i)
		   || contentsElm.innerHTML.match(/<br\/>\nNew Sprite!!\n<br\/>\n<br\/>\n/i)
		  )
		{
			innerHtml = "";
		}
		else
		{

			innerHtml = contentsElm.innerHTML;
			if(autobrValue == 1)
			{
				if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
				{
					innerHtml = innerHtml.replace(/<br>/gi,"\r");
				}
				else
				{
					innerHtml = innerHtml.replace(/<br>/gi,"");
					innerHtml = innerHtml.replace(/<br\/>/gi,"");
				}

			}
			if(autolinkValue == 1)
			{
				innerHtml = innerHtml.replace(/<a href=\".+?\">/gi,"");
				innerHtml = innerHtml.replace(/<\/a>/gi,"");
			}
		}

		var textareaTextNode = document.createTextNode(innerHtml);
		editorTextAreaElement.appendChild(textareaTextNode);
		editorTextAreaElement.style.width = formWidth.toString() + "px";
		editorTextAreaElement.style.height = formHeight.toString() + "px";
		editorFormElement.appendChild(editorTextAreaElement);

		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.appendChild(editorFormElement);

		editorTextAreaElement.focus();

		editingSpriteFlag = true;
    }

}



//------------------------------------
// Save or Delete Sprite
//------------------------------------

function editorControlSaveOnMouseDown()
{
    if(!editingSpriteFlag)
    {
		return;
    }

    saveAndCloseEditor();
}


function saveAndCloseEditor()
{
    document.getElementById("controlresult").innerHTML="";

    var authorElm = document.getElementById(selectedSprite.id + "_author");
    var authorName = authorElm.innerHTML;

    if(loginid == "public" && !authorName.match(/^&lt;.+&gt;$/) && !authorName.match(/^\[.+\]$/))
    {
		document.getElementById("controlresult").innerHTML="Permission denied.";
		return;
    }


    var tmpTextareaElm = document.getElementById("editor-textarea");
    var newText = tmpTextareaElm.value;

    var tmpChildren = selectedSprite.childNodes;

    var contentsElm = document.getElementById(selectedSprite.id + "_contents");	
    originalInnerHtmlOfEditingSprite = contentsElm.innerHTML;
    originalBorderWidthOfEditingSprite = originalSpriteBorderWidth;
    originalBorderColorOfEditingSprite = originalSpriteBorderColor; 
    originalBorderStyleOfEditingSprite = originalSpriteBorderStyle;

    var fragmentElm = document.getElementById(selectedSprite.id + "_fragmentlink");
    originalShowFragmentOfEditingSprite = fragmentElm.style.display;
    var positElm = document.getElementById(selectedSprite.id + "_positlink");
    originalShowPositOfEditingSprite = positElm.style.display;
    var timeElm = document.getElementById(selectedSprite.id + "_time");
    originalShowTimeOfEditingSprite = timeElm.style.display;

    originalShowAuthorOfEditingSprite = authorElm.style.display;
    originalAuthorOfEditingSprite = authorName;

    var newTextPost = newText;
    if(spritehtmlValue != 1)
    {
		newText = newText.replace(/</g,"&lt;");
		newText = newText.replace(/>/g,"&gt;");
    }
    if(autobrValue == 1)
    {
		newText = newText.replace(/\n/g,"<br/>\n");
    }
    if(autolinkValue == 1)
    {
		newText = newText.replace(/(https?|ftp)\:([\w|\:\!\#\$\%\=\&\-\^\`\\\|\@\~\[\{\]\}\;\+\*\,\.\?\/]+)/g,"<a href=\"$1\:$2\">$1\:$2<\/a>");
    }

    contentsElm.innerHTML = newText;
    
    newTextPost = encodeURIComponent(newTextPost);

    var public_password = "";
    var public_author = "";
    if(authorName.match(/^&lt;.+&gt;$/) || authorName.match(/^\[.+\]$/))
    {
		var passwordElm = document.getElementById("editor-password");
		public_password = passwordElm.value;

		var editorAuthorElm = document.getElementById("editor-author");
		public_author = editorAuthorElm.value;
		if(public_author == "public")
		{
			if(public_password != "")
			{
				authorElm.innerHTML = "&lt;public&gt;";
			}
			else
			{
				authorElm.innerHTML = "[public]";
			}
		}
		else
		{
			if(public_password != "")
			{
				authorElm.innerHTML = "&lt;" + public_author + "&gt;";
			}
			else
			{
				authorElm.innerHTML = "[" + public_author + "]";
			}
		}

		var pubauthor = encodeURIComponent(public_author);
		setCookie("public_author", pubauthor, CGIFILEPATH, 30);
    }

    if(newTextPost.length > 0)
    {	
		// save sprite contents and styles

		var borderWidth = originalSpriteBorderWidth;
		var borderColor = originalSpriteBorderColor;
		var borderStyle = originalSpriteBorderStyle;
		var zIndex = originalSpriteZindex;
		var styles = "left:" + selectedSprite.style.left + "; "
			+ "top:" + selectedSprite.style.top + "; "
			+ "width:" + selectedSprite.style.width + "; "
			+ "z-index:" + zIndex + "; "
			+ "border-width:" + borderWidth + "; "
			+ "border-color:" + borderColor + "; "
			+ "border-style:" + borderStyle + ";";

		var showFragmentElm = document.getElementById("editor-showfragmentlink");
		var showFragmentFlag = 0;
		var fragmentElm = document.getElementById(selectedSprite.id + "_fragmentlink");
		fragmentElm.style.display = "none";
		if(showFragmentElm.checked)
		{
			showFragmentFlag = 1;
			fragmentElm.style.display = "block";
		}

		var showPositElm = document.getElementById("editor-showpositlink");
		var showPositFlag = 0;
		var positElm = document.getElementById(selectedSprite.id + "_positlink");
		positElm.style.display = "none";
		if(showPositElm.checked)
		{
			showPositFlag = 1;
			positElm.style.display = "block";
		}

		var showTimeElm = document.getElementById("editor-showtime");
		var showTimeFlag = 0;
		var timeElm = document.getElementById(selectedSprite.id + "_time");
		timeElm.style.display = "none";
		if(showTimeElm.checked)
		{
			showTimeFlag = 1;
			timeElm.style.display = "block";
		}

		var showAuthorElm = document.getElementById("editor-showauthor");
		var showAuthorFlag = 0;
		var authorElm = document.getElementById(selectedSprite.id + "_author");
		authorElm.style.display = "none";
		if(showAuthorElm.checked)
		{
			showAuthorFlag = 1;
			authorElm.style.display = "block";
		}

		var postdata = "&id="+ selectedSprite.id + "&contents="+newTextPost + "&pageid="+pageidValue + "&public_password="+public_password + "&public_author="+public_author + "&styles=" + styles + "&dispauthor=" + showAuthorFlag + "&disptime=" + showTimeFlag + "&dispfragment=" + showFragmentFlag + "&dispposit=" + showPositFlag;
		savingSprite = selectedSprite;
		sendRequest(saveSpriteOnLoaded, postdata, "POST", CGIFILEPATH + "saveSprite.cgi", true, true);

    }
    else
    {
		// delete sprite
		var postdata = "&id="+ selectedSprite.id + "&pageid="+pageidValue + "&public_password="+public_password;
		deletingSprite = selectedSprite;
		sendRequest(deleteSpriteOnLoaded, postdata, "POST", CGIFILEPATH + "deleteSprite.cgi", true, true);

    }

}

function clearPasswordOnLoaded(obj)
{
    var res = obj.responseText;
    if (res == "invalid_public_password")
    {
		document.getElementById("controlresult").innerHTML="Please enter the valid password.";
    }
    else if(res == "clearpassword")
    {
		var passwordElm = document.getElementById("editor-password");
		passwordElm.value = "";

		document.getElementById("controlresult").innerHTML="The password is cleared.";
    }
    else
    {
		document.getElementById("controlresult").innerHTML=res;
    }
}

function saveSpriteOnLoaded(obj)
{
    var res = obj.responseText;
    if (res != "succeed")
    {	
		var contentsElm = document.getElementById(savingSprite.id + "_contents");	
		contentsElm.innerHTML = originalInnerHtmlOfEditingSprite;
		originalSpriteBorderWidth= originalBorderWidthOfEditingSprite;
		originalSpriteBorderStyle = originalBorderStyleOfEditingSprite;
		originalSpriteBorderColor = originalBorderColorOfEditingSprite;

		var fragmentElm = document.getElementById(savingSprite.id + "_fragmentlink");
		fragmentElm.style.display = originalShowFragmentOfEditingSprite;
		var positElm = document.getElementById(savingSprite.id + "_positlink");
		positElm.style.display = originalShowPositOfEditingSprite;
		var timeElm = document.getElementById(savingSprite.id + "_time");
		timeElm.style.display = originalShowTimeOfEditingSprite;
		var authorElm = document.getElementById(savingSprite.id + "_author");
		authorElm.style.display = originalShowAuthorOfEditingSprite;

		authorElm.innerHTML = originalAuthorOfEditingSprite;

		if (res == "invalid_public_password")
		{
			document.getElementById("controlresult").innerHTML="Please enter the valid password.";
		}
		else
		{
			document.getElementById("controlresult").innerHTML=res;
		}
		return;
    }
    else
    {
		if(document.getElementById("editor-password"))
		{
			var passwordElm = document.getElementById("editor-password");
			var public_password = passwordElm.value;
			if(public_password != "")
			{
				setCookie("public_password", public_password, CGIFILEPATH, 30);
			}
		}

		editingSpriteFlag = false;
		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.removeChild(document.getElementById("editor"));
    }
}


function deleteSpriteOnLoaded(obj)
{
    var res = obj.responseText;
    if (res != "succeed")
    {	
		var contentsElm = document.getElementById(deletingSprite.id + "_contents");	
		contentsElm.innerHTML = originalInnerHtmlOfEditingSprite;
		originalSpriteBorderWidth= originalBorderWidthOfEditingSprite;
		originalSpriteBorderStyle = originalBorderStyleOfEditingSprite;
		originalSpriteBorderColor = originalBorderColorOfEditingSprite;

		var fragmentElm = document.getElementById(deletingSprite.id + "_fragmentlink");
		fragmentElm.style.display = originalShowFragmentOfEditingSprite;
		var positElm = document.getElementById(deletingSprite.id + "_positlink");
		positElm.style.display = originalShowPositOfEditingSprite;
		var timeElm = document.getElementById(deletingSprite.id + "_time");
		timeElm.style.display = originalShowTimeOfEditingSprite;
		var authorElm = document.getElementById(deletingSprite.id + "_author");
		authorElm.style.display = originalShowAuthorOfEditingSprite;

		authorElm.innerHTML = originalAuthorOfEditingSprite;

		if (res == "invalid_public_password")
		{
			document.getElementById("controlresult").innerHTML="Please enter the valid password.";
		}
		else
		{
			document.getElementById("controlresult").innerHTML=res;
		}
		return;
    }
    else
    {
		var spritesListNode = document.getElementById("spriteslist");
		spritesListNode.removeChild(deletingSprite);
		
		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.removeChild(document.getElementById("editor"));
		
		deletingSprite = null;
		editingSpriteFlag = false;	    
    }

}


//------------------------------
// Save only styles of sprite
//------------------------------
function saveStyles()
{
    if(selectedSprite == null)
    {
		return;
    }

    // for page_autosize
    var maxHeight = worldHeight;
    if(parseInt(selectedSprite.style.top.replace(/px/g,"")) + parseInt(selectedSprite.offsetHeight) > worldHeight - document.getElementById("footer").offsetHeight)
    {	
		maxHeight = parseInt(selectedSprite.style.top.replace(/px/g,"")) + parseInt(selectedSprite.offsetHeight) + 100;
    }
    var maxWidth = worldWidth;
    if(parseInt(selectedSprite.style.left.replace(/px/g,"")) + parseInt(selectedSprite.style.width.replace(/px/g,"")) > worldWidth)
    {
		maxWidth = parseInt(selectedSprite.style.left.replace(/px/g,"")) + parseInt(selectedSprite.style.width.replace(/px/g,"")) + 100;
    }
    
    
    var borderWidth = originalSpriteBorderWidth;
    var borderColor = originalSpriteBorderColor;
    var borderStyle = originalSpriteBorderStyle;

    var zIndex = originalSpriteZindex;
    var styles = "left:" + selectedSprite.style.left + "; "
		+ "top:" + selectedSprite.style.top + "; "
		+ "width:" + selectedSprite.style.width + "; "
		+ "z-index:" + zIndex + ";"
		+ "border-width:" + borderWidth + ";"
		+ "border-color:" + borderColor + ";"
		+ "border-style:" + borderStyle + ";";

    var public_password = getCookie("public_password");
    if(document.getElementById("dialog-form"))
    {
		var passwordElm = document.getElementById("dialog-password");
		public_password = passwordElm.value;
    }

    if(public_password == undefined)
    {
		public_password = "";
    }
    var postdata = "&id="+ selectedSprite.id + "&pageid="+pageidValue + "&public_password="+public_password + "&styles=" + styles + "&height="+ maxHeight + "&width="+maxWidth;
    savingSprite = selectedSprite;
    sendRequest(saveStylesOnLoaded, postdata, "POST", CGIFILEPATH + "saveStyles.cgi", true, true);

}

function saveStylesOnLoaded(obj)
{
    var res = obj.responseText;
    var resArray = res.split(",");
    if (resArray[0] == "invalid_public_password")
    {
		selectedSprite = savingSprite;

		if(document.getElementById("dialog-form"))
		{
			document.getElementById("dialog-result").innerHTML="Permission denied.";
		}
		else
		{
			openPasswordDialog();
		}
		return;
    }
    else if(resArray[0] != "succeed" && resArray[0] != "resized")
    {
		savingSprite.style.left = originalLeftOfEditingSprite;
		savingSprite.style.top = originalTopOfEditingSprite;
		savingSprite.style.width = originalWidthOfEditingSprite;
		savingSprite.style.zIndex = originalZindexOfEditingSprite;
		savingSprite.style.borderWidth = originalBorderWidthOfEditingSprite;
		savingSprite.style.borderColor = originalBorderColorOfEditingSprite;
		savingSprite.style.borderStyle = originalBorderStyleOfEditingSprite;

		document.getElementById("controlresult").innerHTML=res;
		return;
    }
    else if(resArray[0] == "resized")
    {
		worldWidth = parseInt(resArray[1]);
		worldHeight = parseInt(resArray[2]);

		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.style.width = worldWidth.toString() + "px";
		spritesWorldNode.style.height = worldHeight.toString() + "px";
    }

    if(document.getElementById("dialog-form"))
    {
		var passwordElm = document.getElementById("dialog-password");
		var public_password = passwordElm.value;
		if(public_password != "")
		{
			setCookie("public_password", public_password, CGIFILEPATH, 30);
		}

		editingSpriteFlag = false;
		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.removeChild(document.getElementById("dialog-form"));
    }
}


//------------------------------------
// SpriteOnMouseOver
//------------------------------------

function spriteOnMouseOver()
{
    var elm = document.getElementById(this.id);

    if(elm == null && elm == undefined)
    {
		return;
    }

    if(mouseOutOfWorld)
    {
		return;
    }

    if(movingSpriteFlag || scalingSpriteFlag)
    {
		return;
    }
    
    if(selectedSprite != null && selectedSprite != elm)
    {
		clearSelectedSprite();
    }


    if(elm != null && elm != undefined  && selectedSprite == null)
    {
		selectedSprite = elm;

		// Changing visible <-> hidden causes the failuer of 
		// getting width of srpite. You must use only "hidden" style
		// or only "visible" style
		//	    selectedSprite.style.overflow = "visible";
		originalSpriteZindex = parseInt(selectedSprite.style.zIndex);


		if(positlogMode == "EditMode")
		{
			// add mover
			if(!document.getElementById("sprite-mover")){
				var moverElement = document.createElement("div");
				moverElement.setAttribute("id", "sprite-mover");
				moverElement.onmousedown = moverOnMouseDown;
				selectedSprite.appendChild(moverElement);
			}

			// add scaler
			if(!document.getElementById("sprite-scaler")){
				var scalerElement = document.createElement("div");
				scalerElement.setAttribute("id", "sprite-scaler");
				scalerElement.style.right = "-2px";
				scalerElement.style.bottom = "-2px";
				scalerElement.onmousedown = scalerOnMouseDown;
				selectedSprite.appendChild(scalerElement);
			}
			
			// add editor Icon
			if(!document.getElementById("sprite-editor")){
				var iconElement = document.createElement("div");
				iconElement.setAttribute("id", "sprite-editor");
				iconElement.style.right = "-3px";
				iconElement.style.top = "-3px";
				iconElement.onmousedown = editoriconOnMouseDown;
				if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
				{
					iconElement.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
				}

				selectedSprite.appendChild(iconElement);
			}

			// cannot get border by short name. (e.g. border, border-width) 
			// Get by full name. (e.g. border-top-width);
			originalSpriteBorderWidth = selectedSprite.style.borderTopWidth
				+ " " +  selectedSprite.style.borderRightWidth
				+ " " +  selectedSprite.style.borderBottomWidth
				+ " " +  selectedSprite.style.borderLeftWidth;
			
			originalSpriteBorderColor = selectedSprite.style.borderTopColor
				+ " " +  selectedSprite.style.borderRightColor
				+ " " +  selectedSprite.style.borderBottomColor
				+ " " +  selectedSprite.style.borderLeftColor;

			originalSpriteBorderStyle = selectedSprite.style.borderTopStyle
				+ " " +  selectedSprite.style.borderRightStyle
				+ " " +  selectedSprite.style.borderBottomStyle
				+ " " +  selectedSprite.style.borderLeftStyle;

			// show rectangle of selectedSprite
			selectedSprite.style.border = "1px dashed #b09070";
			selectedSprite.style.padding = "2px";
		}

    }

}


//--------------------------------
// Create Sprite
//--------------------------------

function createSprite()
{
    document.getElementById("controlresult").innerHTML="";

    var styles = "";
    
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		leftOfNewSprite = 5 - viewPositionX + parseInt(document.documentElement.scrollLeft) + Math.floor(Math.random()*70);
		topOfNewSprite = 5 - viewPositionY + parseInt(document.documentElement.scrollTop) + Math.floor(Math.random()*30);
    }
    else
    {
		var xOffset = 0;
		var yOffset = 0;
		if(crossBrowser.bw.safari)
		{
			xOffset = parseInt(document.body.scrollLeft);
			yOffset = parseInt(document.body.scrollTop);
		}
		else
		{
			xOffset = parseInt(document.documentElement.scrollLeft);
			yOffset = parseInt(document.documentElement.scrollTop);
		}
		
		leftOfNewSprite = 5 - viewPositionX + xOffset + Math.floor(Math.random()*70);
		topOfNewSprite = 100 - viewPositionY + yOffset + Math.floor(Math.random()*30);
    }

    var postdata = "&pageid="+pageidValue+"&top="+topOfNewSprite+"&left="+leftOfNewSprite;
    sendRequest(createSpriteOnLoaded, postdata, "POST", CGIFILEPATH + "createSprite.cgi", true, true);
}

function createSpriteOnLoaded(obj)
{

    var res = obj.responseText;
    var resArray = res.split(",");
    if(resArray == null || resArray[0] != "succeed")
    {
		document.getElementById("controlresult").innerHTML=res;
		return;
    }

    var newSpriteID = resArray[1];
    var newSprite = resArray[2];
    var newAuthor = resArray[3]; // for showing "admin" instead of showing admin user name
    var newSpriteTime = resArray[4];

    // msie
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		var ulElement = document.getElementById("spriteslist");
		var tmpHTML = ulElement.innerHTML;
		tmpHTML += 	"<li class='sprite' id='" + newSpriteID + "' style='left:" +  leftOfNewSprite.toString() + "px; top:" + topOfNewSprite.toString() + "px; width:120px;  z-index:10; border-left:0px none #000000; border-right:0px none #000000; border-top:0px none #000000; border-bottom:0px none #000000;'><div class='spritecontents' id='" + newSpriteID + "_contents' style='display:block;'>" + newSprite + "</div><div class='spriteinfo'><span class='spriteauthor' id='" + newSpriteID + "_author' style='display:block;'>" + newAuthor + "</span><span class='spritetime' id='" + newSpriteID + "_time' style='display:block;'>" + newSpriteTime + "</span><span class='spritepositlink' id='" + newSpriteID + "_positlink' style='display:block;'><a href='./positlog.cgi?load=" + pageidValue + "&id=" + newSpriteID + "'>positlink</a></span><span class='spritefragmentlink' id='" + newSpriteID + "_fragmentlink' style='display:block;'><a href='./positlog.cgi?load=" + pageidValue + "#" + newSpriteID + "'>#</a></span></div></li>";
		ulElement.innerHTML = tmpHTML;

		// reset id property for mouseover event
		var spritesList = ulElement.childNodes;
		for (var i=0; i<spritesList.length; i++)
		{
			var tmpSprite = spritesList[i];
			if(tmpSprite.nodeType == 1)
			{
				tmpSprite.onmouseover = spriteOnMouseOver;
			}
		}
    }
    else
    {
		// not msie

		var liElement = document.createElement("li");
		liElement.setAttribute("class", "sprite");
		liElement.setAttribute("id", newSpriteID);
		liElement.style.width = "120px";
		liElement.style.left = leftOfNewSprite.toString() + "px";
		liElement.style.top = topOfNewSprite.toString() + "px";
		liElement.style.zIndex = "10";

		liElement.style.borderTopWidth = "0px";
		liElement.style.borderRightWidth = "0px";
		liElement.style.borderBottomWidth = "0px";
		liElement.style.borderLeftWidth = "0px";
		liElement.style.borderTopStyle = "none";
		liElement.style.borderRightStyle = "none";
		liElement.style.borderBottomStyle = "none";
		liElement.style.borderLeftStyle = "none";
		liElement.style.borderTopColor = "#000000";
		liElement.style.borderRightColor = "#000000";
		liElement.style.borderBottomColor = "#000000";
		liElement.style.borderLeftColor = "#000000";
		
		var contentsElm = document.createElement("div");
		contentsElm.setAttribute("id", newSpriteID + "_contents");
		contentsElm.setAttribute("class", "spritecontents");
		contentsElm.appendChild(document.createTextNode(""));
		contentsElm.innerHTML = newSprite;
		liElement.appendChild(contentsElm);

		var infoElm = document.createElement("div");
		infoElm.setAttribute("class", "spriteinfo");


		var authorElm = document.createElement("span");
		authorElm.setAttribute("id", newSpriteID + "_author");
		authorElm.setAttribute("class", "spriteauthor");
		authorElm.appendChild(document.createTextNode(newAuthor));
		authorElm.style.display ="block";
		infoElm.appendChild(authorElm);

		var timeElm = document.createElement("span");
		timeElm.setAttribute("id", newSpriteID + "_time");
		timeElm.setAttribute("class", "spritetime");
		timeElm.appendChild(document.createTextNode(newSpriteTime));
		timeElm.style.display ="block";
		infoElm.appendChild(timeElm);

		var positElm = document.createElement("span");
		positElm.setAttribute("id", newSpriteID + "_positlink");
		positElm.setAttribute("class", "spritepositlink");
		positElm.appendChild(document.createTextNode(""));
		positElm.innerHTML = "<a href='./positlog.cgi?load=" + pageidValue + "&id=" + newSpriteID + "'>positlink</a>";
		positElm.style.display ="block";
		infoElm.appendChild(positElm);

		var fragmentElm = document.createElement("span");
		fragmentElm.setAttribute("id", newSpriteID + "_fragmentlink");
		fragmentElm.setAttribute("class", "spritefragmentlink");
		fragmentElm.appendChild(document.createTextNode(""));
		fragmentElm.innerHTML = "<a href='#" + newSpriteID + "'>#</a>";
		fragmentElm.style.display ="block";
		infoElm.appendChild(fragmentElm);


		liElement.appendChild(infoElm);

		liElement.onmouseover = spriteOnMouseOver;

		var ulElement = document.getElementById("spriteslist");
		ulElement.appendChild(liElement);
    }


    var newSprite = document.getElementById(newSpriteID);
    // get list of all sprites
    var spritesListNode = document.getElementById("spriteslist");
    var spritesList = spritesListNode.childNodes;
    var topZ = 0;
    var topSprite = newSprite;

    clearSelectedSprite(); // reset z-index

    for (var i=0; i<spritesList.length; i++)
    {
		var tmpSprite = spritesList[i];
		if(tmpSprite.nodeType == 1)
		{
			var tmpZ = parseInt(tmpSprite.style.zIndex);
			if(tmpSprite != newSprite)
			{
				if(tmpZ > topZ)
				{
					topZ = tmpZ;
					topSprite = tmpSprite;
				}
			}
		}
    }
    newSprite.style.zIndex = parseInt(topZ)+1;
}



function createPage()
{
    var tmppagetitle = document.title;
    var leftBraceChar = "(";
    var rightBraceChar = ")";

    var pagetitleArray = tmppagetitle.split(" ");
    if(pagetitleArray == null)
    {
		pageNumber = 2;
    }
    else
    {
		var pageNumber = pagetitleArray[pagetitleArray.length-1];
		var matchNumber = pageNumber.match(/\d+/);
		if(matchNumber)
		{
			if(pageNumber.match(/\[/))
			{
				leftBraceChar = "[";
				rightBraceChar = "]";
			}

			if(pageNumber.match(/\{/))
			{
				leftBraceChar = "{";
				rightBraceChar = "}";
			}

			if(pageNumber.match(/#/))
			{
				leftBraceChar = "#";
				rightBraceChar = "";
			}


			pageNumber = parseInt(matchNumber) + 1;
			tmppagetitle = pagetitleArray[0] + " ";
			for(var i=1; i<pagetitleArray.length-1; i++)
			{
				tmppagetitle += pagetitleArray[i] + " ";
			}
		}
		else
		{
			pageNumber = 2;
		}
    }

    var newpagetitle = window.prompt("Please enter the title of the new page.", tmppagetitle + " " + leftBraceChar + pageNumber + rightBraceChar);
    if(newpagetitle == "")
    {
		document.getElementById("controlresult").innerHTML = "The title is not entered.";
		return;
    }
    else if(newpagetitle == null)
    {
		return;
    }

    sendRequest(createPageOnLoaded, "&pageid="+pageidValue+"&newpagetitle="+newpagetitle , "POST", CGIFILEPATH + "createPage.cgi", true, true);

} 

function createPageOnLoaded(obj)
{
    var res = obj.responseText;
    var resArray = res.split(",");
    
    if(resArray == null || resArray[0] != "succeed"){
		document.getElementById("controlresult").innerHTML=res;
		return;
    }

    // get pageid
    location.href = urlPure + "?load=" + pageidValue + "&mode=EditMode";

}


//--------------------------------
// Cookie
//--------------------------------


function getCookie(key)
{
    if(!document.cookie) return undefined;
    var v=document.cookie;
    var ns=v.indexOf(key+"="); if(ns<0) return undefined; ns=ns+key.length+1;
    var ne=v.indexOf(";",ns); if(ne<0) ne=v.length;
    return v.substring(ns,ne);
}


function setCookie(key, val, path, day)
{
    theDay = new Date();
    theDay.setTime(theDay.getTime() + (day * 1000 * 60 * 60 * 24));
    var cs=key+"="+val+";";
    if(path != "")
    {
		cs+=" path="+path+";";
    }
    cs+=" expires="+theDay.toGMTString()+";";
    document.cookie=cs;
}




//------------------------------------------------------------------
// jslb_ajax050_c.js
// Source code below is almost not my contribution.
// This is a great public domain code written by Toshiro Takahashi.
// (Checking msie7 is my modification.)
//------------------------------------------------------------------

/*jslb_ajax050 2.652k @see http://jsgt.org/mt/archives/01/000409.html*/
function chkAjaBrowser(){
    var a, ua=navigator.userAgent;
    this.bw=
	{
	    safari:((a=ua.split('AppleWebKit/')[1])?a.split('(')[0]:0)>=124,
	    konqueror:((a=ua.split('Konqueror/')[1])?a.split(';')[0]:0)>=3.3,
	    mozes:((a=ua.split('Gecko/')[1])?a.split(" ")[0]:0)>=20011128,
	    opera:(!!window.opera)&&((typeof XMLHttpRequest)=='function'),
	    msie7:(!!window.ActiveXObject)?((typeof XMLHttpRequest)=='object'):false,
	    msie:(!!window.ActiveXObject)?(!!createHttpRequest())&&((typeof XMLHttpRequest)!='object'):false
	};
    return(this.bw.safari||this.bw.konqueror||this.bw.mozes||this.bw.opera||this.bw.msie7||this.bw.msie)};
function createHttpRequest(){if(window.XMLHttpRequest){return new XMLHttpRequest();}else if(window.ActiveXObject){try{return new ActiveXObject("Msxml2.XMLHTTP");}catch(e){try{return new ActiveXObject("Microsoft.XMLHTTP");}catch(e2){return null;}}}else{return null;}};function sendRequest(callback,data,method,url,async,sload,user,password){sendRequest.prototype.README={url:"http://jsgt.org/mt/archives/01/000409.html",name:"sendRequest",version:0.50,license:"Public Domain",author:"Toshiro Takahashi http://jsgt.org/mt/01/",memo:""};var oj=createHttpRequest();if(oj==null)return null;var sload=(!!sendRequest.arguments[5])?sload:false;if(sload||method.toUpperCase()=='GET')url+="?";if(sload)url=url+"t="+(new Date()).getTime();var bwoj=new chkAjaBrowser();var opera=bwoj.bw.opera;var safari=bwoj.bw.safari;var konqueror=bwoj.bw.konqueror;var mozes=bwoj.bw.mozes;if(typeof callback=='object'){var callback_onload=callback.onload;var callback_onbeforsetheader=callback.onbeforsetheader}else{var callback_onload=callback;var callback_onbeforsetheader=null;};if(opera||safari||mozes){oj.onload=function(){callback_onload(oj);}}else{oj.onreadystatechange=function(){if(oj.readyState==4){callback_onload(oj);}}};data=uriEncode(data,url);if(method.toUpperCase()=='GET'){url+=data};oj.open(method,url,async,user,password);if(!!callback_onbeforsetheader)callback_onbeforsetheader(oj);setEncHeader(oj);oj.send(data);function setEncHeader(oj){var contentTypeUrlenc='application/x-www-form-urlencoded; charset=UTF-8';if(!window.opera){oj.setRequestHeader('Content-Type',contentTypeUrlenc);}else{if((typeof oj.setRequestHeader)=='function')oj.setRequestHeader('Content-Type',contentTypeUrlenc);};return oj};function uriEncode(data,url){var encdata=(url.indexOf('?')==-1)?'?dmy':'';if(typeof data=='object'){for(var i in data)encdata+='&'+encodeURIComponent(i)+'='+encodeURIComponent(data[i]);}else if(typeof data=='string'){if(data=="")return"";var encdata='';var datas=data.split('&');for(i=1;i<datas.length;i++){var dataq=datas[i].split('=');encdata+='&'+encodeURIComponent(dataq[0])+'='+encodeURIComponent(dataq[1]);}};return encdata;};return oj}
