#!/usr/local/bin/perl

# --------------------------------------------------------
#
# saveSprite.cgi:
#      cgi for saving Sprite
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
#
# PositLog is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PositLog is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# --------------------------------------------------------


use strict;
use CGI qw/-debug :standard/;
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
use PositLogConfig;

my $CGI = new CGI;
print $CGI->header(-charset => 'utf-8'); # HTTP header

my $command = $CGI->param("command");

my $public_password = $CGI->param("public_password");
my $public_author = $CGI->param("public_author");
my $pageid = $CGI->param("pageid");

my $spriteID = $CGI->param("id");
my $styles = $CGI->param("styles");

my $contents = $CGI->param("contents");
$contents =~ tr/+/ /;
$contents =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack('H2', $1)/eg;

my $displayTime = $CGI->param("disptime");
my $displayAuthor = $CGI->param("dispauthor");
my $displayPositlink = $CGI->param("dispposit");
my $displayFragmentlink = $CGI->param("dispfragment");

# Read temporal cookie
my $loginid = $CGI->cookie("loginid") || "";
my $loginpass = $CGI->cookie("loginpass") || "";

# authentication

my $usernameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
my $loginerror = "";
my $validUser = 0;
my $adminUser = 0;
my $publicUser = 0;
if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
{
	my $cryptpass = $adminnameAuth->{$loginid}{"password"};
	my $salt="lc";
	my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 1;
		$publicUser = 0;
	}
	else
	{
		print "Permission denied.";
		exit(0);	
	}
}
elsif($usernameAuth ne "" && $usernameAuth->{$loginid})
{
	my $cryptpass = $usernameAuth->{$loginid}{"password"};
	my $salt="ry";
	my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$adminUser = 0;
		$validUser = 1;
		$publicUser = 0;
	}
	else
	{
		print "nopermission\n";
		exit(0);	
	}
}
else
{
	$adminUser = 0;
	$validUser = 0;
	$publicUser = 1;
}

# change sprites.dat
my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")} or {};
if($spritesHash eq ""){	print "Cannot read sprites.dat."; exit(0); }

# set author_id if it does not exist
if($spritesHash->{$spriteID}{"author_id"} eq "")
{
	if($adminUser)
	{
		$spritesHash->{$spriteID}{"author_id"} = "admin";
	}
	else
	{
		$spritesHash->{$spriteID}{"author_id"} = $loginid;
	}
}

# $loginid is regarded as "public" if author_id is "public".
if($spritesHash->{$spriteID}{"author_id"} eq "public")
{
	my $cryptpass = $spritesHash->{$spriteID}{"public_password"};
	my $salt="zi";
	if($cryptpass ne "" && !$adminUser)
	{
		my $cryptpass2 = crypt($public_password, $salt);
		if($cryptpass ne $cryptpass2)
		{
			print "invalid_public_password";
			exit(0);
		}
	}

	if($spritesHash->{$spriteID}{"public_password"} eq "")
	{
		if($public_password eq "")
		{
			$spritesHash->{$spriteID}{"public_password"} = "";
		}
		else
		{
			$spritesHash->{$spriteID}{"public_password"} = crypt($public_password, $salt);
		}
	}

	if($public_author eq "")
	{
		$spritesHash->{$spriteID}{"public_author"} = "";
	}
	else
	{
		$public_author =~ s/^\<(.+)\>$/$1/;
		$public_author =~ s/^&lt;(.+)&gt;$/$1/;
		$public_author =~ s/^\[(.+)\]$/$1/;
	    $spritesHash->{$spriteID}{"public_author"} = $public_author;
	}
}
elsif($spritesHash->{$spriteID}{"author_id"} ne $loginid && !$adminUser)
{
	print "Permission denied.";
	exit(0);
}

#---- The following processes are performed by only authenticated user -----

if($command eq "clearpassword")
{
	$spritesHash->{$spriteID}{"public_password"} = "";
	if(!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pageid . "/sprites.dat"}){ print "Cannot write sprites.dat."; exit(0); }
	print "clearpassword";
	exit(0);
}

# save styles
# check the range of z-index
$styles =~ /^(.+)(z-index:)(\d+?)(;.+)$/i;
if(scalar($3) >= 1000 || scalar($3) < 10)
{
    $styles = $1 . $2 . "10" . $4;
}
$spritesHash->{$spriteID}{"style"} = $styles;


# check page permission
my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};
if($permissionHash eq ""){ print "Cannot read permission.cgi.";	exit(0); }

my $write_plainsprite = 0;
my $write_attachedsprite = 0;
my $write_supersprite = 0;
if($adminUser || scalar($permissionHash->{"write_plainsprite"}{$loginid}) == 1)
{
	$write_plainsprite = 1;
}
foreach my $usergroupname (keys %{$permissionHash->{"write_plainsprite_group"}})
{
	my $usergroupnameenc = $usergroupname;
	$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$usergroupnameenc =~ tr/ /+/;

	my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	if(scalar($tmpList->{$loginid}) == 1)
	{
		$write_plainsprite = 1;		
	}
}

if($adminUser || scalar($permissionHash->{"write_attachedsprite"}{$loginid}) == 1)
{
	$write_attachedsprite = 1;
}
foreach my $usergroupname (keys %{$permissionHash->{"write_attachedsprite_group"}})
{
	my $usergroupnameenc = $usergroupname;
	$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$usergroupnameenc =~ tr/ /+/;

	my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	if(scalar($tmpList->{$loginid}) == 1)
	{
		$write_attachedsprite = 1;		
	}
}

if($adminUser || scalar($permissionHash->{"write_supersprite"}{$loginid}) == 1)
{
	$write_supersprite = 1;
}
foreach my $usergroupname (keys %{$permissionHash->{"write_supersprite_group"}})
{
	my $usergroupnameenc = $usergroupname;
	$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$usergroupnameenc =~ tr/ /+/;

	my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	if(scalar($tmpList->{$loginid}) == 1)
	{
		$write_supersprite = 1;		
	}
}

# check page configuration
my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};
if($configHash eq ""){ print "Cannot read the page configuration."; exit(0); }

# HTML or plain text processing
if($write_supersprite)
{
	# nop
	# All HTML description is available.
}
elsif (scalar($configHash->{"sprite_html"}) == 1)
{
	# A part of HTML description is avaliable.
	# Entilde '~' event handlers ;-|
	$contents =~ s/onAbort/o&ntilde;Abort/gis;
	$contents =~ s/onBlur/o&ntilde;Blur/gis;
	$contents =~ s/onChange/o&ntilde;Change/gis;
	$contents =~ s/onClick/o&ntilde;Click/gis;
	$contents =~ s/ondblclick/o&ntilde;dblclick/gis;
	$contents =~ s/ondraganddrop/o&ntilde;draganddrop/gis;
	$contents =~ s/onError/o&ntilde;Error/gis;
	$contents =~ s/onFocus/o&ntilde;Focus/gis;
	$contents =~ s/onkeydown/o&ntilde;keydown/gis;
	$contents =~ s/onkeypress/o&ntilde;keypress/gis;
	$contents =~ s/onkeyup/o&ntildeunl;keyup/gis;
	$contents =~ s/onLoad/o&ntilde;Load/gis;a
	$contents =~ s/onunload/o&ntilde;unload/gis;a
	$contents =~ s/onMouseDown/o&ntilde;MouseDown/gis;
	$contents =~ s/onMouseOut/o&ntilde;MouseOut/gis;
	$contents =~ s/onMouseOver/o&ntilde;MouseOver/gis;
	$contents =~ s/onMouseUp/o&ntilde;MouseUp/gis;
	$contents =~ s/onMouseWheel/o&ntilde;MouseWheel/gis;
	$contents =~ s/onmove/o&ntilde;move/gis;
	$contents =~ s/onReset/o&ntilde;Reset/gis;
	$contents =~ s/onresize/o&ntilde;resize/gis;
	$contents =~ s/onSelect/o&ntilde;Select/gis;
	$contents =~ s/onSubmit/o&ntilde;Submit/gis;
	$contents =~ s/onUnload/o&ntilde;Unload/gis;

	$contents =~ s/script /script&nbsp;/gis;
	$contents =~ s/ script/&nbsp;script/gis;
	$contents =~ s/<script/&lt;script/gis;
}
else
{
	# No HTML is available.
	#autolink, autobr

	$contents =~ s/</&lt;/gis;
	$contents =~ s/>/&gt;/gis;

	if(scalar($configHash->{"sprite_autobr"}) == 1)
	{
		$contents =~ s/\n/<br>\n/gis;
		$contents =~ s/\r//gis;
	}
	if(scalar($configHash->{"sprite_autolink"}) == 1)
	{
		$contents =~ s/(https?|ftp)\:([\w|\:\!\#\$\%\=\&\-\^\`\\\|\@\~\[\{\]\}\;\+\*\,\.\?\/]+)/<a href=\"$1\:$2\">$1\:$2<\/a>/ig;
	}
}

# change modified time
my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
my $time = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
$spritesHash->{$spriteID}{"modified_time"} = $time;
$configHash->{"modified_time"} = $time;

# change display mode
$spritesHash->{$spriteID}{"display_created_time"} = scalar($displayTime);
$spritesHash->{$spriteID}{"display_author"} = scalar($displayAuthor);
$spritesHash->{$spriteID}{"display_positlink"} = scalar($displayPositlink);
$spritesHash->{$spriteID}{"display_fragmentlink"} = scalar($displayFragmentlink);

# save sprites.dat
if(!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pageid . "/sprites.dat"}){ print "Cannot write sprites.dat."; exit(0); }

# save .spr
if(!eval{Storable::lock_nstore \$contents, $PositLogConfig::datapath . $pageid . "/static/" . $spriteID . ".spr"}){ print "Cannot write " . $spriteID . ".spr."; exit(0); }

# save config.dat
if(!eval{Storable::lock_nstore $configHash, $PositLogConfig::datapath . $pageid . "/config.dat"}){ print "Cannot write the page configuration."; exit(0); }

print "succeed";

