#!/usr/local/bin/perl

# --------------------------------------------------------
# createSprite.cgi:
#      cgi for creating Sprite
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
#
# PositLog is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PositLog is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# --------------------------------------------------------

use strict;
use CGI qw/-debug :standard/;
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
use PositLogConfig;

my $CGI = new CGI;
print $CGI->header(-charset => 'utf-8');  # HTTP header

my $pageid = $CGI->param("pageid");

my $newleft = $CGI->param("left");
my $newtop = $CGI->param("top");

# Read temporal cookie
my $loginid = $CGI->cookie("loginid") || "";
my $loginpass = $CGI->cookie("loginpass") || "";

# authentication

my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
my $loginerror = "";
my $validUser = 0;
my $adminUser = 0;
my $publicUser = 0;
if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
{
	my $cryptpass = $adminnameAuth->{$loginid}{"password"};
	my $salt="lc";
	my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 1;
		$publicUser = 0;
	}
	else
	{
		print "Permission denied.";
		exit(0);	
	}
}
elsif($useridAuth ne "" && $useridAuth->{$loginid})
{
	my $cryptpass = $useridAuth->{$loginid}{"password"};
	my $salt="ry";
	my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$adminUser = 0;
		$validUser = 1;
		$publicUser = 0;
	}
	else
	{
		print "Permission denied.";		
		exit(0);	
	}
}
else
{
	$adminUser = 0;
	$validUser = 0;
	$publicUser = 1;
}


my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};
if($permissionHash eq "")
{
	print "Cannot read permission.cgi.";
	exit(0);
}

my $write_plainsprite = 0;
my $write_attachedsprite = 0;
my $write_supersprite = 0;
if($adminUser || scalar($permissionHash->{"write_plainsprite"}{$loginid}) == 1)
{
	$write_plainsprite = 1;
}
foreach my $usergroupname (keys %{$permissionHash->{"write_plainsprite_group"}})
{
	my $usergroupnameenc = $usergroupname;
	$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$usergroupnameenc =~ tr/ /+/;

	my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	if(scalar($tmpList->{$loginid}) == 1)
	{
		$write_plainsprite = 1;		
	}
}

if($adminUser || scalar($permissionHash->{"write_attachedsprite"}{$loginid}) == 1)
{
	$write_attachedsprite = 1;
}
foreach my $usergroupname (keys %{$permissionHash->{"write_attachedsprite_group"}})
{
	my $usergroupnameenc = $usergroupname;
	$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$usergroupnameenc =~ tr/ /+/;

	my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	if(scalar($tmpList->{$loginid}) == 1)
	{
		$write_attachedsprite = 1;		
	}
}


if($adminUser || scalar($permissionHash->{"write_supersprite"}{$loginid}) == 1)
{
	$write_supersprite = 1;
}
foreach my $usergroupname (keys %{$permissionHash->{"write_supersprite_group"}})
{
	my $usergroupnameenc = $usergroupname;
	$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$usergroupnameenc =~ tr/ /+/;

	my $tmpList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	if(scalar($tmpList->{$loginid}) == 1)
	{
		$write_supersprite = 1;		
	}
}

if($write_plainsprite != 1 
   && $write_attachedsprite != 1 
   && $write_supersprite != 1)
{
	print "Permission denied.";
	exit(0);
}

my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")} or {};
if($spritesHash eq ""){ print "Cannot read sprites.dat."; exit(0); }

# generate new spriteID
my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst);
($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
my $createtime = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);

my $newSpriteID = "";
do
{
	my $rand = int (rand(1000));
	$rand = sprintf("%03d", $rand);
# id must start from alphabet in HTML4.01
	$newSpriteID = "sprite_" . $createtime . "_" . $rand;
}while(exists($spritesHash->{$newSpriteID}));

my $newContents = "<div style='padding:5px; border:1px solid #a0a0a0;text-align:center;'>\n<br>\nNew Sprite!!\n<br>\n<br>\n</div>";
Storable::lock_nstore \$newContents, $PositLogConfig::datapath . $pageid . "/static/" . $newSpriteID.".spr";

if($adminUser)
{
	$spritesHash->{$newSpriteID}{"author_id"} = "admin";
}
else
{
	$spritesHash->{$newSpriteID}{"author_id"} = $loginid;
}

$spritesHash->{$newSpriteID}{"display_created_time"} = 1;
$spritesHash->{$newSpriteID}{"display_author"} = 1;

$spritesHash->{$newSpriteID}{"style"} = "left:" .  $newleft . "px; top:" . $newtop .  "px; width:120px;  z-index:10; border-left:0px none #000000; border-right:0px none #000000; border-top:0px none #000000; border-bottom:0px none #000000;";
$spritesHash->{$newSpriteID}{"public_password"} = "";


# change modified time

my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};
if($configHash eq "")
{
	print "Cannot read the page configuration.";
	exit(0);
}
my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
my $time = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);

$spritesHash->{$newSpriteID}{"modified_time"} = $time;
$spritesHash->{$newSpriteID}{"created_time"} = $time;
$configHash->{"modified_time"} = $time;


if(!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pageid . "/sprites.dat"})
{
	print "Cannot write sprites.dat.";
	exit(0);

}

if(!eval{Storable::lock_nstore $configHash, $PositLogConfig::datapath . $pageid . "/config.dat"})
{
	print "Cannot write the page configuration.";
	exit(0);
}

my $author;
if($adminUser)
{
    $author = "admin";
}
else
{
	if($loginid eq "public")
	{
		$author = "[public]";
	}
	else
	{
		$author = $useridAuth->{$loginid}{"nickname"};
	}
}



$time =~ /^(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)$/i;
my $timeStr = "";
if($time ne "")
{
    $timeStr = $1 . "/" . $2 . "/" . $3 . " " . $4 . ":" . $5 . ":" .$5;
}
print "succeed,$newSpriteID,$newContents,$author,$timeStr";
