#!/usr/local/bin/perl

# --------------------------------------------------------
#
# saveStyles.cgi:
#      cgi for saving styles of Sprite 
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
#
# PositLog is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PositLog is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# --------------------------------------------------------


use strict;
use CGI qw/-debug :standard/;
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
use PositLogConfig;

my $CGI = new CGI;
print $CGI->header(-charset => 'utf-8'); # HTTP header

my $public_password = $CGI->param("public_password");
my $pageid = $CGI->param("pageid");

my $spriteID = $CGI->param("id");
my $styles = $CGI->param("styles");
my $maxWidth = $CGI->param("width");
my $maxHeight = $CGI->param("height");

# Read temporal cookie
my $loginid = $CGI->cookie("loginid") || "";
my $loginpass = $CGI->cookie("loginpass") || "";

# authentication
my $usernameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
my $loginerror = "";
my $validUser = 0;
my $adminUser = 0;
my $publicUser = 0;
if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
{
	my $cryptpass = $adminnameAuth->{$loginid}{"password"};
	my $salt="lc";
	my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 1;
		$publicUser = 0;
	}
	else
	{
		print "Permission denied.";
		exit(0);	
	}
}
elsif($usernameAuth ne "" && $usernameAuth->{$loginid})
{
	my $cryptpass = $usernameAuth->{$loginid}{"password"};
	my $salt="ry";
	my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$adminUser = 0;
		$validUser = 1;
		$publicUser = 0;
	}
	else
	{
		print "nopermission\n";
		exit(0);	
	}
}
else
{
	$adminUser = 0;
	$validUser = 0;
	$publicUser = 1;
}



my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")} or {};
if($spritesHash eq ""){	print "Cannot read sprites.dat."; exit(0); }

# set author_id if it does not exist
if($spritesHash->{$spriteID}{"author_id"} eq "")
{
	if($adminUser)
	{
		$spritesHash->{$spriteID}{"author_id"} = "admin";
	}
	else
	{
		$spritesHash->{$spriteID}{"author_id"} = $loginid;
	}
}


if($spritesHash->{$spriteID}{"author_id"} eq "public")
{
	my $cryptpass = $spritesHash->{$spriteID}{"public_password"};
	if($cryptpass ne "" && !$adminUser)
	{
		my $salt="zi";
		my $cryptpass2 = crypt($public_password, $salt);
		if($cryptpass ne $cryptpass2)
		{
			print "invalid_public_password";
			exit(0);
		}
	}
}
elsif($spritesHash->{$spriteID}{"author_id"} ne $loginid && !$adminUser)
{
	print "Permission denied.";
	exit(0);
}

# save styles
$styles =~ /^(.+)(z-index:)(\d+?)(;.*)$/i;
if(scalar($3) > 999999)
{
    $styles = $1 . $2 . "999999" . $4;
}
if(scalar($3) < 1000)
{
    $styles = $1 . $2 . "1000" . $4;
}
$spritesHash->{$spriteID}{"style"} = $styles;


my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};
if($configHash eq ""){ print "Cannot read the page configuration."; exit(0); }

# change page size 
my $changeSizeFlag = 0;
if($configHash->{"page_autosize_x"} == 1)
{
	if(scalar($configHash->{"page_width"}) != scalar($maxWidth))
	{
		$changeSizeFlag = 1;
	}
	$configHash->{"page_width"} = $maxWidth;
}
else
{
    $maxWidth = $configHash->{"page_width"};
}
if($configHash->{"page_autosize_y"} == 1)
{
	if(scalar($configHash->{"page_height"}) != scalar($maxHeight))
	{
		$changeSizeFlag = 1;
	}
	$configHash->{"page_height"} = $maxHeight;
}
else
{
    $maxHeight = $configHash->{"page_height"};
}

# change modified time
my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
my $time = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
$spritesHash->{$spriteID}{"modified_time"} = $time;
$configHash->{"modified_time"} = $time;

# save sprites.dat
if(!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pageid . "/sprites.dat"}){ print "Cannot write sprites.dat.";	exit(0); }

# save config.dat
if(!eval{Storable::lock_nstore $configHash, $PositLogConfig::datapath . $pageid . "/config.dat"}) { print "Cannot write the page configuration."; exit(0); }


if($changeSizeFlag)
{
	print "resized,$maxWidth,$maxHeight";
	exit(0);
}

print "succeed";

