#!/usr/local/bin/perl

# --------------------------------------------------------
# recentcontents.cgi
#      cgi for showing new contents on PositLog 
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
#
# PositLog is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PositLog is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# --------------------------------------------------------


use strict;
use CGI qw/-debug :standard/;
use CGI::Cookie;
use Storable qw(lock_retrieve);
use PositLogConfig;

my $CSSHEADER = "";

# parameters are already URL decoded.
my $CGI = new CGI;

my $maxnumber = $CGI->param("max");
my $type = $CGI->param("type");

my $command = $CGI->param("command");

if($maxnumber eq "")
{
    $maxnumber = 15;
}

#--------------------------------------
# Authentication
#--------------------------------------

my $loginid = $CGI->param("loginid");
my $loginpass = $CGI->param("loginpass");

if($loginid eq "")
{
# Read temporal cookie
	$loginid = $CGI->cookie("loginid") || "";
	$loginpass = $CGI->cookie("loginpass") || "";
}

if($loginid eq "public")
{
	$loginid = "";
}

if($command eq "logout")
{
	$loginid = "";
	$loginpass = "";
}


my $cookieUser = new CGI::Cookie(
	-path => "$PositLogConfig::cgipath",
	-name => "loginid",
	-value => "$loginid",
#-domain => "$cookieDomain"
	);
my $cookiePass = new CGI::Cookie(
	-path => "$PositLogConfig::cgipath",
	-name => "loginpass",
	-value => "$loginpass",
#-domain => "$cookieDomain"
	);

# Print HTTP header
# (Set cookies)
print $CGI->header(-charset => 'utf-8', -cookie => [$cookieUser,$cookiePass]); 

my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
my $loginerror = "";
my $validUser = 0;
my $adminUser = 0;

# Check admin -> Check valid user -> show error
if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
{

	my $cryptpass = $adminnameAuth->{$loginid}{"password"};
    my $salt="lc";
    my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 1;
	}
	else
	{
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
		$validUser = 0;
		$adminUser = 0;
	}
}
elsif($useridAuth ne "" && $useridAuth->{$loginid})
{
	my $cryptpass = $useridAuth->{$loginid}{"password"};
    my $salt="ry";
    my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 0;
	}
	else
	{
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
		$validUser = 0;
		$adminUser = 0;
	}
}
else
{
	if($loginid eq "" && $loginpass eq "")
	{
		$loginerror = "";
	}
	else
	{
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
	}
	$validUser = 0;
	$adminUser = 0;
}


if($command eq "login")
{
	my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<meta http-equiv='Content-Style-Type' content='text/css'>\n
		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "logincheck.css' type='text/css'>\n
		<title>PositLog Administration : Login</title>\n
	</head>\n";

	my $BODY = "<body onLoad='document.loginform.loginid.focus()'>\n
  <div id='logintop'>\n
  <div id='login'>\n
  <h1>Login to Positlog Administration</h1>\n
  <form id='loginform' action='recentcontents.cgi' method='post'>\n
    <p>\n
      user name<br>\n
      <input type='text' name='loginid' id='loginid' value='" . $loginid . "' size='20' tabindex='1'>\n
    </p>\n
    <p>\n
      password<br>\n
      <input type='password' name='loginpass' id='loginpass' value='' size='20' tabindex='2'>\n
    </p>\n
    <p id='submitarea'>\n" . $loginerror . 
    "<br/><input type='submit' id='submitbtn' value='Login' tabindex='3'>\n
    <input type='hidden' name='type' value='$type'>\n
    </p>\n
  </form>\n
  </div>\n
  <div id='copyright'>\n
  Powered by PositLog\n
  </div>\n
  </div>\n
</body>\n";

	my $FOOTER = "</html>";

	print $HEADER . $BODY . $FOOTER;
	exit(0);

}


#---------------------------------------------------------
# Generate Pages List 
#---------------------------------------------------------

sub generatePagesList
{
    my @PageList = @_;
    my %pageidModifiedTime = ();
    my %pageidPagetitle = ();

    my $homepageid = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "homepage.cgi")} or {};
    my $myBody = "";
    if($homepageid ne "")
    {
	$myBody = "<h1>Recently modified pages&nbsp;&nbsp;(<a href='./positlog.cgi?load=" . $$homepageid . "'>Home</a>)</h1>\n";
    }
    else
    {
	$myBody = "<h1>Recently modified pages</h1>\n";
    }


    if(!$validUser && !$adminUser)
    {
		$myBody .= "<p><a href='./recentcontents.cgi?command=login&type=page'>[Login]</a> <a href='./recentcontents.cgi?type=sprite'>[Recent Sprites]</a></p>";
    }
    else
    {
		$myBody .= "<p><a href='./recentcontents.cgi?command=logout&type=page'>[Logout]</a> <a href='./recentcontents.cgi?type=sprite'>[Recent Sprites]</a></p>";
    }

    $myBody .= "<form action='./recentcontents.cgi' method='POST'>"
		. "<select name='max'>"
		. "<option value='$maxnumber'>最新$maxnumber</option>"
		. "<option value='15'>最新15</option>"
		. "<option value='30'>最新30</option>"
		. "<option value='50'>最新50</option>"
		. "<option value='100'>最新100</option>"
		. "</select>"
		. "<input type='submit' value='変更'>"
		. "<input type='hidden' name='type' value='page'>"
		. "</form>";
    

    foreach my $pid  (@PageList)
    {
		if($pid eq "." || $pid eq ".." || $pid eq ".htaccess")
		{
			next;
		}


		my $canRead = 0;
		my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/permission.cgi")};
		if($@){ warn $@; print "Cannot read permission.cgi."; exit(0); }

		if($adminUser)
		{
			$canRead = 1;
		}
		elsif(scalar($permissionHash->{"read_page"}{"public"}) == 1)
		{
			$canRead = 1;
		}
		else
		{
			# check user list
			if(scalar($permissionHash->{"read_page"}{$loginid}) == 1)
			{
				$canRead = 1;
			}
			else
			{
				# check user group list
				foreach my $usergroupname (keys %{$permissionHash->{"read_page_group"}})
				{
					my $usergroupnameenc = $usergroupname;
					$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
					$usergroupnameenc =~ tr/ /+/;
					
					my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
					if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
					if(scalar($UserList->{$loginid}) == 1)
					{
						$canRead = 1;
					}
				}
			}
		}

		if($canRead != 1)
		{
			next;
		}

		my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/config.dat")};
		if($@){ warn $@; print "Cannot read the page configuration.<br>\n"; print "<a href='./pagemanager.cgi'>back</a></div>\n"; exit(0); }
		$pageidModifiedTime{$pid} = $configHash->{"modified_time"};
		$pageidPagetitle{$pid} = $configHash->{"page_title"};
    }

    my @PageList2 = ();
    while ((my $key, my $value) = each %pageidModifiedTime)
    {
		push (@PageList2, {pid => $key, modified_time => $value});
    }

    # sort pages by modified_time
    $myBody .= "<ol>\n";
    for my $item (sort { ($b->{"modified_time"}) <=> ($a->{"modified_time"}) } @PageList2)
    {
		my $tmppid = $$item{"pid"};
		my $tmpdate = $$item{"modified_time"};
		$tmpdate =~ /(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/i;
		my $modifiedTime = "$1/$2/$3&nbsp;&nbsp;$4:$5:$6";
		$myBody .= "<li class='recentcontentsline'>" . $modifiedTime . "&nbsp;&nbsp;&nbsp;&nbsp;<a href='./positlog.cgi?load=" . $tmppid . "'>" . $pageidPagetitle{$tmppid} . "</a>&nbsp;&nbsp;&nbsp;&nbsp;";

		my $spritesHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $tmppid . "/sprites.dat")};
		if($@){ warn $@; print "Cannot read the sprite list.\n"; exit(0); }
		my $latestsid;
		my $latesttime = 0;
		foreach my $sid (keys %$spritesHash)
		{
			if($latesttime < $spritesHash->{$sid}{"modified_time"})
			{
				$latesttime = $spritesHash->{$sid}{"modified_time"};
				$latestsid = $sid;
			}
		}
		
		my $singleContents = "no contents";
		my $contents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $tmppid . "/static/" . $latestsid . ".spr")} or "";
		if($contents ne "")
		{
			$singleContents = $$contents;
		}

		my $sprite_type  =$spritesHash->{$latestsid}{"type"};
		if($sprite_type eq "dynamic")
		{
		    my $sourceSprite = $spritesHash->{$latestsid}{"plugin_source"};
		    if($sourceSprite ne "")
		    {
			my $sprite_plugin  =$spritesHash->{$sourceSprite}{"plugin"};
			if($sprite_plugin =~ /^(.+?),(.+?);(.+?)$/is)
			{
			    my $pluginName = $1;
			    # import dynamic sprites
			    if (-f "./PositLogPlugin/" . $pluginName . ".pm")
			    {
				my $cssfile = eval 'use ' . "PositLogPlugin::" . $pluginName .';' . "PositLogPlugin::" . $pluginName . q/::getCSS()/;
				if($cssfile ne "")
				{
				    $CSSHEADER .= "		<link rel='stylesheet' href='" .  $PositLogConfig::systempath . $cssfile ."' type='text/css'>\n";
				}
			    }
			}
			$latestsid = $sourceSprite;
		    }
		}
		my $styles = $spritesHash->{$latestsid}{"style"};
		my $contentsstyles = $spritesHash->{$latestsid}{"contents_style"};


		$myBody .= "(<a href='./positlog.cgi?load=" . $tmppid . "&id=" . $latestsid . "'>" . $latestsid . "</a>)<br>\n";

		$myBody .= "<div class='recentcontents' style='$styles'><div style='$contentsstyles'>" . $singleContents . "</div></div>\n";

    }
    $myBody .= "</ol>\n";

    return $myBody;
}



#---------------------------------------------------------
# Generate Sprites List 
#---------------------------------------------------------

sub generateSpritesList
{
    my @PageList = @_;
    my %pageidspriteidModifiedTime = ();
    my %pageidPagetitle = ();

    my $homepageid = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "homepage.cgi")} or {};
    my $myBody = "";
    if($homepageid ne "")
    {
	$myBody = "<h1>Recently modified sprites&nbsp;&nbsp;(<a href='./positlog.cgi?load=" . $$homepageid. "'>Home</a>)</h1>\n";
    }
    else
    {
	$myBody = "<h1>Recently modified sprites</h1>\n";
    }

    my $pageCounter = 0;
    my $spriteCounter = 0;

    my $availablePageCounter = 0;
    my $availableSpriteCounter = 0;

    foreach my $pid  (@PageList)
    {
		if($pid eq "." || $pid eq ".." || $pid eq ".htaccess")
		{
			next;
		}

		my $canRead = 0;
		my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/permission.cgi")};
		if($@){ warn $@; print "Cannot read permission.cgi."; exit(0); }

		if($adminUser)
		{
			$canRead = 1;
		}
		elsif(scalar($permissionHash->{"read_page"}{"public"}) == 1)
		{
			$canRead = 1;
		}
		else
		{
			# check user list
			if(scalar($permissionHash->{"read_page"}{$loginid}) == 1)
			{
				$canRead = 1;
			}
			else
			{
				# check user group list
				foreach my $usergroupname (keys %{$permissionHash->{"read_page_group"}})
				{
					my $usergroupnameenc = $usergroupname;
					$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
					$usergroupnameenc =~ tr/ /+/;
					
					my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
					if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
					if(scalar($UserList->{$loginid}) == 1)
					{
						$canRead = 1;
					}
				}
			}
		}


		my $spritesHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/sprites.dat")};
		if($@){ warn $@; print "Cannot read the sprite list.\n"; exit(0); }


		$pageCounter ++;
		$spriteCounter += scalar(keys %$spritesHash);
		if(!$canRead)
		{
			next;
		}



		$availablePageCounter ++;
		$availableSpriteCounter += scalar(keys %$spritesHash);

		my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/config.dat")};
		if($@){ warn $@; print "Cannot read the page configuration.<br>\n"; exit(0); }

		foreach my $keyID (keys %$spritesHash){
			$pageidspriteidModifiedTime{$pid . ":" . $keyID} = $spritesHash->{$keyID}{"modified_time"};
		}
		$pageidPagetitle{$pid} = $configHash->{"page_title"};
    }

    
    if(!$validUser && !$adminUser)
    {
		$myBody .= "<p><a href='./recentcontents.cgi?command=login&type=sprite'>[Login]</a> <a href='./recentcontents.cgi?type=page'>[Recent Pages]</a>";
    }
    else
    {
		$myBody .= "<p><a href='./recentcontents.cgi?command=logout&type=sprite'>[Logout]</a> <a href='./recentcontents.cgi?type=page'>[Recent Pages]</a>";
    }

    $myBody .= "&nbsp;&nbsp;&nbsp;&nbsp;(Total pages : $pageCounter) (Total sprites: $spriteCounter)\n";

#    $myBody .= "You can access : $availablePageCounter pages, $availableSpriteCounter sprites";
    $myBody .= "</p>";

    $myBody .= "<form action='./recentcontents.cgi' method='POST'>"
		. "<select name='max'>"
		. "<option value='$maxnumber'>最新$maxnumber</option>"
		. "<option value='15'>最新15</option>"
		. "<option value='30'>最新30</option>"
		. "<option value='50'>最新50</option>"
		. "<option value='100'>最新100</option>"
		. "</select>"
		. "<input type='submit'>"
		. "<input type='hidden' name='type' value='sprite'>"
		. "</form>";


    my @PageList2 = ();
    while ((my $key, my $value) = each %pageidspriteidModifiedTime)
    {
		push (@PageList2, {pidsid => $key, modified_time => $value});
    }

    # sort pages by modified_time
    $myBody .= "<ol>\n";
    my $counter = 0;
    for my $item (sort { ($b->{"modified_time"}) <=> ($a->{"modified_time"}) } @PageList2)
    {
		my $pidsid = $$item{"pidsid"};
		my $tmpdate = $$item{"modified_time"};
		$tmpdate =~ /(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/i;
		my $modifiedTime = "$1/$2/$3&nbsp;&nbsp;$4:$5:$6";
		my @tmpArray = split(/:/, $pidsid);
		my $tmppid = $tmpArray[0];
		my $tmpsid = $tmpArray[1];
		my $singleContents = "no contents";
		my $contents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $tmppid . "/static/" . $tmpsid . ".spr")} or "";
		if($contents ne "")
		{
			$singleContents = $$contents;
		}

		my $spritesHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $tmppid . "/sprites.dat")};
		if($@){ warn $@; print "Cannot read the sprite list.\n"; exit(0); }

		my $sprite_type  = $spritesHash->{$tmpsid}{"type"};
		if($sprite_type eq "dynamic")
		{
		    my $sourceSprite = $spritesHash->{$tmpsid}{"plugin_source"};
		    if($sourceSprite ne "")
		    {
			my $sprite_plugin  =$spritesHash->{$sourceSprite}{"plugin"};

			if($sprite_plugin =~ /^(.+?),(.+?);(.+?)$/is)
			{
			    my $pluginName = $1;
			    # import dynamic sprites
			    if (-f "./PositLogPlugin/" . $pluginName . ".pm")
			    {
				my $cssfile = eval 'use ' . "PositLogPlugin::" . $pluginName .';' . "PositLogPlugin::" . $pluginName . q/::getCSS()/;
				if($cssfile ne "")
				{
				    $CSSHEADER .= "		<link rel='stylesheet' href='" .  $PositLogConfig::systempath . $cssfile ."' type='text/css'>\n";
				}
			    }
			}
			$tmpsid = $sourceSprite;
		    }
		}
		my $styles = $spritesHash->{$tmpsid}{"style"};
		my $contentsstyles = $spritesHash->{$tmpsid}{"contents_style"};

		$myBody .= "<li class='recentcontentsline'>" . $modifiedTime . "&nbsp;&nbsp;";
		$myBody .= "<a href='./positlog.cgi?load=" . $tmppid . "&id=" . $tmpsid . "'>" . $tmpsid . "</a>&nbsp;&nbsp;&nbsp;&nbsp;in <a href='./positlog.cgi?load=" . $tmppid . "'>" . $pageidPagetitle{$tmppid} . "</a><br>\n";
		$myBody .= "<div class='recentcontents' style='$styles'><div style='$contentsstyles'>" . $singleContents . "</div></div>\n";
		$counter ++;
		if($counter >= $maxnumber)
		{
			last;
		}
    }
    $myBody .= "</ol>\n";

    return $myBody;
}


sub generateMainPage
{
    my $myBODY = "";
    opendir( DATADIR, $PositLogConfig::datapath );
    my @PageList = readdir( DATADIR );
    closedir( DATADIR );
    if($type eq "page" || $type eq "")
    {
		$myBODY .= &generatePagesList(@PageList);
    }
    elsif($type eq "sprite")
    {
		$myBODY .= &generateSpritesList(@PageList);
    }
    return $myBODY;
}


#---------------------------------------------------------
# Generate HTML
#---------------------------------------------------------

my $BODY = &generateMainPage();


my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<meta http-equiv='Content-Style-Type' content='text/css'>\n";


$CSSHEADER = "		<link rel='stylesheet' href='" .  $PositLogConfig::systempath . "positlog.css' type='text/css'>\n" . $CSSHEADER;

$HEADER .= $CSSHEADER;
$HEADER .=  "		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "positlog_admin.css' type='text/css'>\n";
$HEADER .="	<title>PositLog Recent Contents</title>\n
    </head>\n<body>\n";


my $FOOTER = "</body></html>";

print $HEADER . $BODY . $FOOTER;


