/*
 * TriangleColorSelector revised for positlog (c) 2006 
 *
 * Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
 *  <taro@summer.nifty.jp>
 *   http://storybook.jp/ 
 * 
 * Original copyright:
 * Javascript TriangleColorSelector (C) 2005 cho45 <cho45@lowreal.net>
 *    http://lowreal.net/2005/triangle-color-selector
 *
 * Use GIMP `modules/colorsel_triangle.c' code.
 * Original copyright:
 *
 * colorsel_triangle module (C) 1999 Simon Budig <Simon.Budig@unix-ag.org>
 *    http://www.home.unix-ag.org/simon/gimp/colorsel.html
 *
 * Special Thanks:
 *     Huuka
 */



function tcsCloseOnMouseDown()
{
  if(EDT.tcs == null){
		return;
  }

  EDT.frameColorDialogOpen = false;
  EDT.bgColorDialogOpen = false;
  EDT.foreColorDialogOpen = false;

  var editorElm = document.getElementById("editor");
  var tcsElm = document.getElementById("trianglecolorselector");
  if(tcsElm != null && tcsElm != undefined){
		editorElm.removeChild(tcsElm);
  }
  EDT.tcs = null;
}


function setHexValue()
{
  var hexElm = document.getElementById("tcs-hexvalue")
  if(hexElm.value.match(/(\w\w)(\w\w)(\w\w)/i)){
		var rgb = EDT.tcs.hex2rgb("#" + hexElm.value);
		var r = rgb.r;
		var g = rgb.g;
		var b = rgb.b;

		if(r != 0){
			r /= 255.0;
		}
		if(g != 0){
			g /= 255.0;
		}
		if(b != 0){
			b /= 255.0;
		}

		var hsv = EDT.tcs.rgb2hsv(r, g, b);
		EDT.tcs.setColor(hsv.h, hsv.s, hsv.v);
  }	
}

function clearHexValue()
{
  var hexElm = document.getElementById("tcs-hexvalue")
  hexElm.value = "none";

  var contents = getSpriteContents(PLG.fixedSprite);
  if(EDT.frameColorDialogOpen){
		contents.style.borderColor = "";
  }
  else if(EDT.bgColorDialogOpen){
		contents.style.backgroundColor = "";
  }
  else if(EDT.foreColorDialogOpen){
		contents.style.color = "";
  }	
}


function TriangleColorSelector(parentElement) 
{
  this.triangleradius = 65;

  this.eventListener = {"change" : []};

  this.container = document.createElement("div");
  this.container.setAttribute("id", "trianglecolorselector");
	if(EDT.penColorDialogOpen){
		with(this.container.style) {
			borderTop = "1px none #000000";
			borderLeft = "1px none #000000";
			borderRight = "1px solid #000000";
			borderBottom = "1px solid #000000";
			backgroundColor = "#e0e0e0";
			padding = "0px";
			margin = "0px";
			width = "180px";
			height = "280px";
		}
	}
	else{
		with(this.container.style) {
			border = "1px solid #000";
			//		backgroundColor = "white";
			backgroundColor = "#e0e0e0";
			padding = "0px";
			margin = "0px";
			width = "180px";
			height = "260px";
		}
	}


  this.triangle = document.createElement("div");
  with(this.triangle.style) {
		width  = "180px";
		height = "180px";
		padding = "0px";
		margin = "0px";
  }

  this.img       = document.createElement("img");
  this.img.src = PARAM.IMAGEFILEPATH + "triangle.png";
  // Internet Explorer 6 does not handle alpha transparency in PNG files without using the AlphaImageLoader filter
  if(PLG.cb.bw.msie)
  {
		this.img.src = PARAM.IMAGEFILEPATH + "triangleEmpty.gif";
		this.img.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + PARAM.IMAGEFILEPATH + "triangle.png', sizingMethod='scale')";
  }

  this.pointer   = document.createElement("img");
  this.pointer.src = PARAM.IMAGEFILEPATH + "pointer.gif";
  this.pointer.style.position = "absolute";

  this.tpointer   = document.createElement("img");
  this.tpointer.src = PARAM.IMAGEFILEPATH + "tpointer.gif";
  this.tpointer.style.position = "absolute";

  this.colorarea = document.createElement("div");
	if(EDT.penColorDialogOpen){
		with (this.colorarea.style) {
			position = "absolute";
			left = "0px";
			top = "190px";
			width  = "50px";
			height = "25px";
			border = "1px solid #000";
			margin = "2px 0 0 7px";
		}
	}
	else{
		with (this.colorarea.style) {
			width  = "50px";
			height = "50px";
			border = "1px solid #000";
			margin = "2px 0 0 7px";
		}
	}

	this.information = document.createElement("div");
	if(EDT.penColorDialogOpen){
		with (this.information.style) {
			position = "absolute";
			top = "190px";
			left = "55px";
			width = "110px";
			height = "25px";
			padding = "0px";
			margin = "0px";
			fontSize = "14px";
			textAlign = "center";
		}
	}
	else{
		with (this.information.style) {
			position = "relative";
			top = "-52px";
			left = "55px";
			width = "110px";
			height = "50px";
			padding = "0 5px";
			margin = "0 0 -50px 0";
			fontSize = "14px";
			textAlign = "center";
		}
	}


  var hexElm = document.createElement("input");
  hexElm.setAttribute("id", "tcs-hexvalue");
  hexElm.setAttribute("type", "text");
  hexElm.setAttribute("value", "");
  hexElm.setAttribute("size", "6");
  hexElm.setAttribute("maxlength", "6");
  this.information.appendChild(hexElm);

  var hexSetElm = document.createElement("input");
  hexSetElm.setAttribute("id", "tcs-hexsetbtn");
  hexSetElm.setAttribute("type", "button");
  hexSetElm.setAttribute("value", "set");
  this.information.appendChild(hexSetElm);
  hexSetElm.onclick = setHexValue;

  var hexClearElm = document.createElement("div");
  hexClearElm.setAttribute("id", "tcs-hexclear");
  var hexClearBtnElm = document.createElement("input");
  hexClearBtnElm.setAttribute("id", "tcs-hexclearbtn");
  hexClearBtnElm.setAttribute("type", "button");
  hexClearBtnElm.setAttribute("value", "clear");
  hexClearElm.appendChild(hexClearBtnElm);
  this.information.appendChild(hexClearElm);
  hexClearBtnElm.onclick = clearHexValue;

	if(!EDT.penColorDialogOpen){
		var selectorTitleElm = document.createElement("div");
		selectorTitleElm.setAttribute("id", "tcs-title");
		this.information.appendChild(selectorTitleElm);
	}
	else{
		this.tool = document.createElement("div");
		with (this.tool.style) {
			position = "absolute";
			left = "0px";
			top = "230px";
			width = "180px";
			height = "50px";
			padding = "7px 0px 0px 0px";
			margin = "0px";
			fontSize = "14px";
			textAlign = "center";
			borderTop = "1px solid black";
		}

		var formElm = document.createElement("form");
		var pensizeSelectorElm = document.createElement("select");
		pensizeSelectorElm.setAttribute("id", "pensizeSelector");
    var sizeOption1 = document.createElement("option");
    sizeOption1.setAttribute("value", "1");
    sizeOption1.appendChild(document.createTextNode("1pixel"));
    var sizeOption2 = document.createElement("option");
    sizeOption2.setAttribute("value", "2");
    sizeOption2.appendChild(document.createTextNode("2pixel"));
    var sizeOption3 = document.createElement("option");
    sizeOption3.setAttribute("value", "4");
    sizeOption3.appendChild(document.createTextNode("4pixel"));
    var sizeOption4 = document.createElement("option");
    sizeOption4.setAttribute("value", "8");
    sizeOption4.appendChild(document.createTextNode("8pixel"));
    pensizeSelectorElm.appendChild(sizeOption1);
    pensizeSelectorElm.appendChild(sizeOption2);
    pensizeSelectorElm.appendChild(sizeOption3);
    pensizeSelectorElm.appendChild(sizeOption4);
    pensizeSelectorElm.selectedIndex = 1;
		pensizeSelectorElm.onchange = pensizeOnChange;
		pensizeSelectorElm.onmousedown = pensizeOnMouseDown;
		formElm.appendChild(pensizeSelectorElm);

		var undoElm = document.createElement("input");
    undoElm.setAttribute("type", "button");
		undoElm.setAttribute("id", "undoDrawBtn");
    undoElm.value = "Undo";
		formElm.appendChild(undoElm);
    undoElm.onclick = undoDraw;
		this.tool.appendChild(formElm);
	}

	if(!EDT.penColorDialogOpen){
		var tcsCloseElement = document.createElement("img");
		tcsCloseElement.setAttribute("src", PARAM.IMAGEFILEPATH + "close.gif");
		tcsCloseElement.setAttribute("id", "tcs-closebtn");
		if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7)
    {
			tcsCloseElement.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand3.cur), default";
    }
		tcsCloseElement.onmousedown = tcsCloseOnMouseDown;
		with (tcsCloseElement.style) {
			position = "absolute";
			top = "0px";
			right = "0px";
			padding = "0px";
			margin = "0px";
			verticalAlign = "middle";
		}
		this.container.appendChild(tcsCloseElement);
	}

  with (this.triangle) {
		appendChild(this.img);
		appendChild(this.pointer);
		appendChild(this.tpointer);
  }
  with (this.container) {
		appendChild(this.triangle);
		appendChild(this.colorarea);
		appendChild(this.information);
  }
	if(EDT.penColorDialogOpen){  
		this.container.appendChild(this.tool);
	}

  parentElement.appendChild(this.container);

  var t = this; // for scope change

  if ( this.triangle.addEventListener ){
		this.triangle.addEventListener("mousedown", function (e) {
																		 t.down = e.target;
																		 t.map(e.pageX, e.pageY);
																		 e.stopPropagation();
																		 e.preventDefault();
																	 }, true);
		
		this.triangle.addEventListener("mouseup", function (e) {
																		 PLG.movingDrawingToolFlag = false;
																		 t.down = null;
																		 e.stopPropagation();
																		 e.preventDefault();
																	 }, true);

		this.triangle.addEventListener("mousemove", function (e) {
																		 t.move(e.pageX, e.pageY);
																		 if(!PLG.movingDrawingToolFlag){
																			 e.stopPropagation();
																			 e.preventDefault();
																		 }
																	 }, true);
  }
  else{
		this.triangle.onmousedown = function (ev){ 
	    if (!ev) var ev = window.event; 
			if (ev.target) t.down = ev.target; 
			else if (ev.srcElement) t.down = ev.srcElement; 
			if (ev.pageX || ev.pageY){
				posx = ev.pageX;
				posy = ev.pageY;
			}
	    else if (ev.clientX || ev.clientY){
				posx = ev.clientX + document.documentElement.scrollLeft;
				posy = ev.clientY + document.documentElement.scrollTop;
			}
	    t.map(posx, posy); 
	    ev.cancelBubble = true;
	    if (ev.stopPropagation) ev.stopPropagation();
		};
		this.triangle.onmouseup = function (ev){ 
			PLG.movingDrawingToolFlag = false;
	    if (!ev) var ev = window.event; 
			t.down = null; 
	    ev.cancelBubble = true;
	    if (ev.stopPropagation) ev.stopPropagation();
		};
		this.triangle.onmousemove = function (ev){ 
	    if (!ev) var ev = window.event; 
			if (ev.pageX || ev.pageY){
				posx = ev.pageX;
				posy = ev.pageY;
			}
	    else if (ev.clientX || ev.clientY){
				posx = ev.clientX + document.documentElement.scrollLeft;
				posy = ev.clientY + document.documentElement.scrollTop;
			}
	    t.move(posx, posy); 
			if(!PLG.movingDrawingToolFlag){
				ev.returnValue = false;
				ev.cancelBubble = true;
				if (ev.stopPropagation) ev.stopPropagation();
			}
		};
		this.triangle.onselectstart = function(){return false;};
  }

  var hsv = this.rgb2hsv(1, 0, 0);
  this.setColor(hsv.h, hsv.s, hsv.v);
}
TriangleColorSelector.prototype = {
  // public
  h : 0,
  s : 0,
  v : 0,
  
  addEventListener : function (situation, func) {
		if (this.eventListener[situation]) {
	    this.eventListener[situation].push(func);
		}
  },

  toHex : function () {
		var rgb = this.hsv2rgb(this.h, this.s, this.v);
		return this.rgb2hex(rgb.r * 255, rgb.g * 255, rgb.b * 255);
  },

  setColor : function (h, s, v) {
		var hue = 90 * Math.PI / 180;
		var sat = s;
		var val = v;

		var hx = Math.sin(hue) * this.triangleradius;
		var hy = Math.cos(hue) * this.triangleradius;
		var sx = Math.sin(hue - 2 * Math.PI / 3) * this.triangleradius;
		var sy = Math.cos(hue - 2 * Math.PI / 3) * this.triangleradius;
		var vx = Math.sin(hue + 2 * Math.PI / 3) * this.triangleradius;
		var vy = Math.cos(hue + 2 * Math.PI / 3) * this.triangleradius;
		var x0 = (sx + (vx - sx) * val + (hx - vx) * sat * val);
		var y0 = (sy + (vy - sy) * val + (hy - vy) * sat * val);

		with (this.tpointer.style) {
	    top  = this.triangle.offsetTop + y0 + 83 + "px";
	    left = this.triangle.offsetLeft + x0 + 83 + "px";
		}
		this.pointHue(-h);
		this.h = h;
		this.s = sat;
		this.v = val;
		this.triangle.style.background = this.hsv2hex(h, 1, 1);
		this.oncolorchange();
  },


  // protected
  pointHue : function (rad) {
		rad += 140 * Math.PI / 180;
		with (this.pointer.style) {
	    background = "transparent";
	    top  = this.triangle.offsetTop + 80 * -Math.sin(rad) + 83 + "px";
	    left = this.triangle.offsetLeft + 80 *  Math.cos(rad) + 83 + "px";
		}
  },

  move : function (x, y) {
		var offsetLeft = 0;
		var offsetTop = 0;
		if(EDT.penColorDialogOpen){
			var tcsElm = document.getElementById("trianglecolorselector");
			offsetLeft = tcsElm.offsetLeft;
			offsetTop = tcsElm.offsetTop + 30;// controlpanel
		}
		else{
			offsetLeft = document.getElementById("editor").offsetLeft;
			offsetTop = parseInt(document.getElementById("editor").offsetTop) + 30 + parseInt(EDT.pickerTopOffset);
		}

		x -= offsetLeft;
		y -= offsetTop;

		x =  x - 90; // 90 is radius
		y =  y - 90;

		switch (this.down) {
		case this.pointer: {
			y *= -1;
			var rad = Math.atan2(y, x);
			rad -= 140 * Math.PI / 180;
			this.setColor(-rad, this.s, this.v);
			break;
		}
		case this.tpointer: {
			var hue = 90 * Math.PI / 180;
			var val = 0;
			var sat = 0;
			var hx = Math.sin(hue) * this.triangleradius;
			var hy = Math.cos(hue) * this.triangleradius;
			var sx = Math.sin(hue - 2 * Math.PI / 3) * this.triangleradius;
			var sy = Math.cos(hue - 2 * Math.PI / 3) * this.triangleradius;
			var vx = Math.sin(hue + 2 * Math.PI / 3) * this.triangleradius;
			var vy = Math.cos(hue + 2 * Math.PI / 3) * this.triangleradius;
			var x0 = (sx + (vx - sx) * val + (hx - vx) * sat * val);
			var y0 = (sy + (vy - sy) * val + (hy - vy) * sat * val);
			
			if ((x - sx) * vx + (y - sy) * vy < 0) {
				sat = 1;
				val = ( (x - sx) * (hx - sx) +  (y - sy) * (hy - sy))
					/ ((hx - sx) * (hx - sx) + (hy - sy) * (hy - sy));
				if (val < 0)
					val = 0;
				else if (val > 1)
				val = 1;
			} else if ((x - sx) * hx + (y - sy) * hy < 0) {
				sat = 0;
				val = ( (x - sx) * (vx - sx) +  (y - sy) * (vy - sy))
					/ ((vx - sx) * (vx - sx) + (vy - sy) * (vy - sy));
				if (val < 0)
					val = 0;
				else if (val > 1)
				val = 1;
			} else if ((x - hx) * sx + (y - hy) * sy < 0) {
				val = 1;
				sat = ( (x - vx) * (hx - vx) +  (y - vy) * (hy - vy))
					/ ((hx - vx) * (hx - vx) + (hy - vy) * (hy - vy));
				if (sat < 0)
					sat = 0;
				else if (sat > 1)
				sat = 1;
			} else {
				val = ( (x - sx) * (hy - vy) -  (y - sy) * (hx - vx))
					/ ((vx - sx) * (hy - vy) - (vy - sy) * (hx - vx));
				if (val <= 0) {
					val = 0;
					sat = 0;
				} else {
					if (val > 1)
						val = 1;
					if (hy == vy)
						sat = (x - sx - val * (vx - sx)) / (val * (hx - vx));
					else
						sat = (y - sy - val * (vy - sy)) / (val * (hy - vy));

					if (sat < 0)
						sat = 0;
					else if (sat > 1)
					sat = 1;
				}
			}
			
			this.s = sat;
			this.v = val;
			this.triangle.style.background = this.hsv2hex(this.h, 1, 1);

			x0 = (sx + (vx - sx) * val + (hx - vx) * sat * val);
			y0 = (sy + (vy - sy) * val + (hy - vy) * sat * val);


			with (this.tpointer.style) {
				if(EDT.penColorDialogOpen){
					var tcsElm = document.getElementById("trianglecolorselector");
					top  = ( this.triangle.offsetParent.offsetTop ? this.triangle.offsetParent.offsetTop : 0 ) - tcsElm.offsetTop	+ this.triangle.offsetTop + y0 + 79 + "px";
					left = this.triangle.offsetLeft + x0 + 80 + "px";
				}
				else{
					top  = ( this.triangle.offsetParent.offsetTop ? this.triangle.offsetParent.offsetTop : 0 ) - parseInt(EDT.pickerTopOffset) + this.triangle.offsetTop + y0 + 79 + "px";
					left = this.triangle.offsetLeft + x0 + 80 + "px";
				}
			}
			this.oncolorchange();
			break;
		}
		}
  },

  map : function (x, y) {
		var ox = x;
		var oy = y;

		var offsetLeft = 0;
		var offsetTop = 0;
		if(EDT.penColorDialogOpen){
			var tcsElm = document.getElementById("trianglecolorselector");
			offsetLeft = tcsElm.offsetLeft;
			offsetTop = tcsElm.offsetTop + 30;// controlpanel
		}
		else{
			offsetLeft = document.getElementById("editor").offsetLeft;
			offsetTop = parseInt(document.getElementById("editor").offsetTop) + 30 + parseInt(EDT.pickerTopOffset);
		}

		x -= offsetLeft;
		y -= offsetTop;

		x =   x - 90;
		y = -(y - 90);
		var rad = Math.atan2(y, x);
		var deg = rad * 180 / Math.PI;
		deg = deg < 0 ? 360 + deg : deg;
		var radius = Math.sqrt(x * x + y * y);
		var a = this.inLine(-35, 60,  70,   0, x, y);
		var b = this.inLine( 70,  0, -35, -60, x, y);
		var c = this.inLine(-35,-60, -35,  60, x, y);

		if (radius > 70 && radius < 90) {
	    // in circle
	    this.down = this.pointer;
	    this.move(ox, oy);
		} else if (!a && b && !c) {
	    // in triangle
	    this.down = this.tpointer;
	    this.move(ox, oy);
		}
  },
  
  inLine : function (x1, y1, x2, y2, px, py) {
		var a = (y2 - y1) / (x2 - x1);
		var b = y1 - a * x1;
		var c = a * px + b;
		if (x1 == x2) {
	    py = x1;
	    c  = px;
		}
		if (py >= c) {
	    return true;
		} else {
	    return false;
		}
  },

  oncolorchange : function () {
		var listener = this.eventListener["change"];
		var rgb = this.hsv2rgb(this.h, this.s, this.v);
		rgb.r *= 255;
		rgb.g *= 255;
		rgb.b *= 255;

		this.colorarea.style.background = this.rgb2hex(rgb.r, rgb.g, rgb.b);
		var deg = Math.floor(this.h * 180 / Math.PI);
		if (deg < 0) deg += 360;

		var hexElm = document.getElementById("tcs-hexvalue")
		hexElm.value = this.rgb2hex(rgb.r, rgb.g, rgb.b).replace(/#/g, "");
		
		var e   = new Object;
		e.rgb = rgb;
		e.hsv = {h : this.h, s : this.s, v : this.v};
		e.hex = this.rgb2hex(rgb.r, rgb.g, rgb.b);
		for (var i = 0, len = listener.length; i < len; i++) {
	    listener[i](e);
		}

  },


  // private
  hsv2rgb : function (h, s, v) {
		h = h * 180 / Math.PI;
		var r = 0;
		var g = 0;
		var b = 0;
		if (s < 0) s = 0; else if (s > 1) s = 1;
		if (v < 0) v = 0; else if (v > 1) v = 1;
		h %= 360;
		if (h < 0) h += 360;
		h /= 60;
		var i = Math.floor(h);
		var f = h - i;
		var p1 = v * (1 - s);
		var p2 = v * (1 - s * f);
		var p3 = v * (1 - s * (1 - f));
		switch (i) {
		case 0: r = v;  g = p3; b = p1; break;
		case 1: r = p2; g = v;  b = p1; break;
		case 2: r = p1; g = v;  b = p3; break;
		case 3: r = p1; g = p2; b = v;  break;
		case 4: r = p3; g = p1; b = v;  break;
		case 5: r = v;  g = p1; b = p2; break;
		}
		return {r : r, g : g, b : b};
  },

  rgb2hsv : function (r, g, b) {
		h = s = v = 0;
		if ( r >= g)   cmax = r; else cmax = g;
		if ( b > cmax) cmax = b;
		if ( r <= g)   cmin = r; else cmin = g;
		if ( b < cmin) cmin = b;
		v = cmax;
		var c = cmax - cmin;
		if (cmax == 0) s = 0; else s = c / cmax;
		if (s != 0) {
			if (r == cmax) {
				h = (g - b) / c;
			} else {
				if (g == cmax) {
					h = 2 + (b - r) / c;
				} else {
					if (b == cmax) h = 4 + ( r - g) / c;
				}
			}
			h = h * 60;
			if (h < 0) h += 360;
		}
		h = h * Math.PI / 180;
		return {h : h, s : s, v : v};
  },

  rgb2hex : function (r, g, b) {
		var rgb = b;
		rgb += g << 8;
		rgb += r << 16;
		rgb = Math.floor(rgb);
		var ret = rgb.toString(16);
		while (ret.length < 6) {
	    ret = "0" + ret;
		}
		return "#" + ret;
  },

  hex2rgb : function (hex) {
		if(hex.match(/#(\w\w)(\w\w)(\w\w)/i))
		{
			var r = parseInt(RegExp.$1, 16);
			var g = parseInt(RegExp.$2, 16);
			var b = parseInt(RegExp.$3, 16);
			return {r : r, g : g, b : b};
		}
  },

  hsv2hex : function (h, s, v) {
		rgb = this.hsv2rgb(h, s, v);
		return this.rgb2hex(rgb.r * 255, rgb.g * 255, rgb.b * 255);
  }
}


EDT.tcs = null;
function tcs_initialize() {
	if(EDT.penColorDialogOpen){
		EDT.tcs = new TriangleColorSelector(document.getElementById("spritesworld"));
	}
	else{
		EDT.tcs = new TriangleColorSelector(document.getElementById("editor"));
	}
  EDT.tcs.addEventListener("change", function (e) {
														 var contents = getSpriteContents(PLG.fixedSprite);
														 if(EDT.frameColorDialogOpen){
															 contents.style.borderColor = e.hex;
														 }
														 else if(EDT.bgColorDialogOpen){
															 contents.style.backgroundColor = e.hex;
														 }
														 else if(EDT.foreColorDialogOpen){
															 contents.style.color = e.hex;
														 }
   													 else if(EDT.penColorDialogOpen){
															 PLG.penColor = e.hex;
														 }													 
													 });

}

