package PositLogSprites;

use strict;
use PositLogConfig;
use Storable qw(lock_retrieve lock_nstore);
use List::Util qw{first};

# ----------------------------
# sub getSpritesFromPlugin
#   executes function dynamically
# ----------------------------

sub getSpritesFromPlugin {
    my ($pluginName, $pageid, $keyID, $loginid, $loginpass, $args) = @_;
    eval 'use ' .$pluginName .';' . $pluginName . q/::getSprites($pageid, $keyID, $loginid, $loginpass, $args)/;
}


# ----------------------------
# sub importDynamicSprites
# ----------------------------

sub importDynamicSprites
{
    my $pluginBody = "";

    my ($pluginID, $parentID, $authorName, $zindex, $spritesHash, $pageid, $loginid, $loginpass, $className, $args) = @_;

    # getSprites(arg1, arg2, ...) returns associative array ("date,spriteid", "contents", ...)

    my $spriteidPlugincontents = &getSpritesFromPlugin("PositLogPlugin::" . $pluginID, $pageid, $parentID, $loginid, $loginpass,$args);

    my $pluginType = eval 'use ' . "PositLogPlugin::" . $pluginID .';' . "PositLogPlugin::" . $pluginID . q/::getType()/;

		my %idContents;

    if($pluginType eq "create")
    {
				my $widthOfSprite = eval 'use ' . "PositLogPlugin::" . $pluginID .';' . "PositLogPlugin::" . $pluginID . q/::getWidth()/;

				# current number of sprites
				my $spriteCounter = scalar($zindex);

				# variables for generating new spriteStyle
				my $xcount = 0;
				my $xdiv = 600 / 40 -1;
				my $ycount = 0;
				my $ydiv = 600 / 40 -1;


				# sort by date
				foreach my $tmpID (sort {$b cmp $a} keys %$spriteidPlugincontents) {
						$pluginBody = "";
						# get modified date and spriteID
						$tmpID =~ /^(\w+?),(\w+?)$/s;
						my $modified_time = $1;
						my $spriteID = $2;

						# check if existing page data includes style of $spriteID
						my $spriteStyle = $spritesHash->{$spriteID}{"style"};
						if (!$spriteStyle) {
								# if not, generate new spriteStyle

								my $newleft = 10;
								my $newtop = 10;
								if ($xcount > $xdiv) {
										$xcount = 0;
										$ycount ++;
										if ($ycount > $ydiv) {
												$ycount = 0;
										}
								}
								$newleft += 40 * $xcount;
								$newtop += 40 * $ycount;

								$xcount ++;

								$spriteStyle = "border-left:0px none #000000; border-right:0px none #000000; border-top:0px none #000000; border-bottom:0px none #000000; top:" . $newtop ."px; left:" . $newleft . "px; width:" . $widthOfSprite . "px;  z-index:" . $spriteCounter . ";";
						}

						if(!$spritesHash->{$spriteID}{"parent"} || $spritesHash->{$spriteID}{"parent"} eq ""){
								$spritesHash->{$spriteID}{"parent"} = $parentID;
								if($spritesHash->{$parentID}{"children"} && $spritesHash->{$parentID}{"children"} ne ""){
										my @children = @{$spritesHash->{$parentID}{"children"}};
										my $isExist = first {$_ eq $spriteID} @children;
										if(!defined $isExist){
												push(@children, $spriteID);
												$spritesHash->{$parentID}{"children"} = \@children;
										}
								}
								else{
										my @children;
										push(@children, $spriteID);
										$spritesHash->{$parentID}{"children"} = \@children;
								}
						}

						# create sprite
						my $valueContents = $spriteidPlugincontents->{$tmpID};

						$pluginBody .= "<li class='" . $className . "' id='";
						$pluginBody .= $spriteID;
						$pluginBody .= "' style='" . $spriteStyle . "'>";
						$pluginBody .= "<div class='spriteregion'>";
						$pluginBody .= "<div class='spritecontents'>";
						$pluginBody .= $valueContents;
						$pluginBody .= "</div>\n";

						$pluginBody .= "<div class='spriteinfo'>";
						$pluginBody .= "<span class='iemagic'> </span>"; # need space for IE

						$pluginBody .= "<span class='spriteplugin'";
						$pluginBody .= " style='display:none;'>";
						$pluginBody .= "</span>\n";

						if(scalar($spritesHash->{$spriteID}{"display_author"}) == 1)
						{
								$pluginBody .= "<span class='spriteauthor'";
								$pluginBody .= " style='display:block;'>";
								$pluginBody .= $authorName;
								$pluginBody .= "</span>\n";
						}

						if(scalar($spritesHash->{$spriteID}{"display_created_time"}) == 1)
						{
								$pluginBody .= "<span class='spritedate'";
								$pluginBody .= " style='display:block;'>";
								my $cdate = $spritesHash->{$spriteID}{"modified_time"};
								$cdate =~ /^(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)$/i;
								my $timeStr = $1 . "/" . $2 . "/" . $3 . " " . $4 . ":" . $5 . ":" .$6;
								$pluginBody .= $timeStr;
								$pluginBody .= "</span>\n";
						}

						if(scalar($spritesHash->{$spriteID}{"display_positlink"}) == 1)
						{
								$pluginBody .= "<span class='spriteuri'";
								$pluginBody .= " style='display:block;'>";
								$pluginBody .= "<a href='./positlog.cgi?load=" . $pageid . "&id=" . $spriteID . "'>link</a>";
								$pluginBody .= "</span>\n";
						}

						$pluginBody .= "</div>\n";
						$pluginBody .= "</div>\n";

						$spriteCounter++;

						$idContents{$spriteID} = $pluginBody;
				}
    }
    elsif($pluginType eq "replace")
    {
				foreach my $myID (keys %$spriteidPlugincontents) {
						$myID =~ /^(\w*?),(\w*?)$/;
						my $modtime = $1;
						$spritesHash->{$parentID}{"modified_time"} = $modtime;
						$pluginBody = $spriteidPlugincontents->{$myID};
						$idContents{$myID} = $pluginBody;
				}
    }
    elsif($pluginType eq "replacesprite")
    {
				# sort by date
				my $prevSprite = "";
				my $margin_p = 20;
				foreach my $tmpID (sort {$b cmp $a} keys %$spriteidPlugincontents) {
						$tmpID =~ /^(\w*?),(\w*?),(\w*?),(.*?),(.*?),(.*?),(.*?)$/;

						my $modtime = $1;
						my $myID = $2;
						my $myParent = $3;
						my $pos = $4;
						my $p_pixel = $5;
						my $elder = $6;
						my $s_pixel = $7;

						$pluginBody = $spriteidPlugincontents->{$tmpID};

						$idContents{$myID} = $pluginBody;

						$spritesHash->{$myID}{"author"}	=	$spritesHash->{$parentID}{"author"};
						$spritesHash->{$myID}{"author_name"} = getAuthorName($spritesHash->{$parentID}{"author"}, $spritesHash->{$parentID}{"public_author"}, $spritesHash->{$parentID}{"public_password"});
						$spritesHash->{$myID}{"modified_time"} = $modtime;

						$spritesHash->{$myID}{"margin_s"}{"elder"} = $elder;
						$spritesHash->{$myID}{"margin_s"}{"pixel"} = $s_pixel;

						if($myParent eq ""){
								$spritesHash->{$myID}{"parent"} = $parentID;
								$spritesHash->{$myID}{"margin_p"}{"position"} = "BT";
								$spritesHash->{$myID}{"margin_p"}{"pixel"} = $margin_p;
								$spritesHash->{$myID}{"margin_s"}{"pixel"} = 20;

								$margin_p = scalar($margin_p) + 1;

								if($spritesHash->{$parentID}{"children"} && $spritesHash->{$parentID}{"children"} ne ""){
										my @children = @{$spritesHash->{$parentID}{"children"}};
										my $isExist = first {$_ eq $myID} @children;
										if(!defined $isExist){
												push(@children, $myID);
												$spritesHash->{$parentID}{"children"} = \@children;
										}
								}
								else{
										my @children;
										push(@children, $myID);
										$spritesHash->{$parentID}{"children"} = \@children;
								}

						
								if($prevSprite ne ""){
										$spritesHash->{$myID}{"margin_s"}{"elder"} = $prevSprite;
										$spritesHash->{$myID}{"margin_s"}{"pixel"} = 20;
								}
								$prevSprite = $myID;
						}
						else{
								$spritesHash->{$myID}{"parent"} = $myParent;
								$spritesHash->{$myID}{"margin_p"}{"position"} = $pos;
								$spritesHash->{$myID}{"margin_p"}{"pixel"} = $p_pixel;

								if($spritesHash->{$myParent}{"children"} && $spritesHash->{$myParent}{"children"} ne ""){
										my @children = @{$spritesHash->{$myParent}{"children"}};
										my $isExist = first {$_ eq $myID} @children;
										if(!defined $isExist){
												push(@children, $myID);
												$spritesHash->{$myParent}{"children"} = \@children;
										}
								}
								else{
										my @children;
										push(@children, $myID);
										$spritesHash->{$myParent}{"children"} = \@children;
								}
						}

				}

    }

		\%idContents;
}


sub getAuthorName
{
		my($author_id,$public_author,$public_password) = @_;

		my $authorName = "[public]";
		if($author_id eq "admin"){
				$authorName = "admin";
		}
		else{
				if($author_id eq "public"){
						if($public_password eq ""){
								if($public_author eq "" || $public_author eq "public"){
										$authorName = "[public]";
								}
								else{
										$authorName = '[' . $public_author . ']';
								}
						}
						else{
								if($public_author eq "" || $public_author eq "public"){
										$authorName = "&lt;public&gt;";
								}
								else{
										$authorName = '&lt;' . $public_author . '&gt;';
								}
						}
				}
				else{
						my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")};
						if($@){ warn $@; exit(0);}

						if($useridAuth->{$author_id}{"nickname"} ne ""){
								$authorName = $useridAuth->{$author_id}{"nickname"};
						}
						else{
								$authorName = "emanon";
						}
				}
		}
		return $authorName;
}

#################################################
## getContents generates contents of a sprite. ##
#################################################
sub getContents
{
		my($sid, $pageid, $spritesHash, $replaceContents, $className) = @_;
		my $valueContentsStyle = $spritesHash->{$sid}{"contents_style"};
		my $author_id = $spritesHash->{$sid}{"author_id"};
		my $modified_time = $spritesHash->{$sid}{"modified_time"};
		my $created_time = $spritesHash->{$sid}{"created_time"};
		my $display_created_time = $spritesHash->{$sid}{"display_created_time"};
		my $display_author = $spritesHash->{$sid}{"display_author"};
		my $display_positlink = $spritesHash->{$sid}{"display_positlink"};
		my $sprite_plugin = $spritesHash->{$sid}{"plugin"};
		my $valueStyle = $spritesHash->{$sid}{"style"};

		# get position
		$valueStyle =~ /top:(-*\d+)px/is;
		my $spritetop = $1;
		$valueStyle =~ /left:(-*\d+)px/is;
		my $spriteleft = $1;
		$valueStyle =~ /z-index:(-*\d+?);/is;
		my $spriteZindex = $1;

		# get author name
		my $authorName = getAuthorName($author_id, $spritesHash->{$sid}{"public_author"}, $spritesHash->{$sid}{"public_password"});

		# temporal author_name data for exporting to JavaScript
		$spritesHash->{$sid}{"author_name"} = $authorName;

		# get contents
		my $spriteContents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/static/" . $sid.".spr")} or "";
		my $staticContents;

		if($spriteContents ne "" || ($replaceContents->{$sid} && $replaceContents->{$sid} ne "")){
				$staticContents .= "<li class='" . $className . "' id='" . $sid . "' ";
				$staticContents .= "style='" . $valueStyle . "'>";
				$staticContents .= "<div class='spriteregion'>";
				$staticContents .= "<div class='spritecontents' style='" . $valueContentsStyle . "'>";
				if($replaceContents->{$sid} && $replaceContents->{$sid} ne ""){
						$staticContents .= $replaceContents->{$sid};
				}
				else{
						$staticContents .= $$spriteContents;
				}
				$staticContents .= "</div>\n";

				$staticContents .= "<div class='spriteinfo'>";
				$staticContents .= "<span class='iemagic'> </span>"; # need space for IE

				$staticContents .= "<span class='spriteplugin'";
				$staticContents .= " style='display:none;'>";
				$staticContents .= $sprite_plugin;
				$staticContents .= "</span>\n";

				if(scalar($display_author) == 1)
				{
						$staticContents .= "<span class='spriteauthor'";
						$staticContents .= " style='display:block;'>";
						$staticContents .= $authorName;
						$staticContents .= "</span>\n";
				}

				if(scalar($display_created_time) == 1)
				{
						$staticContents .= "<span class='spritedate'";
						$staticContents .= " style='display:block;'>";
						$modified_time =~ /^(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)$/i;
						my $timeStr = "";
						if($modified_time ne "")
						{
								$timeStr = $1 . "/" . $2 . "/" . $3 . " " . $4 . ":" . $5 . ":" .$6;
						}
						$staticContents .= $timeStr;
						$staticContents .= "</span>\n";
				}

				if(scalar($display_positlink) == 1)
				{
						$staticContents .= "<span class='spriteuri'";
						$staticContents .= " style='display:block;'>";

						my $linkStr = "<a href='./positlog.cgi?load=" . $pageid . "&id=" . $sid . "'>link</a>";
						$staticContents .= $linkStr;
						$staticContents .= "</span>\n";
				}

				$staticContents .= "</div>\n";
				$staticContents .= "</div>\n";
		}

		return $staticContents;
}


################################################
## createSpriteTree builds a tree of sprites ###
################################################
sub createSpriteTree
{
		my($rootID, $pageid, $resultSprites, $spritesHash, $createContents, $replaceContents, $idPosition, $className) = @_;
		my $treeBody = "";
		if($createContents->{$rootID} && $createContents->{$rootID} ne ""){
				# is plugin contents
				$treeBody = $createContents->{$rootID};
		}
		else{
				$treeBody = getContents($rootID, $pageid, $spritesHash, $replaceContents, $className);
		}

		if($treeBody ne ""){
				push(@$resultSprites, $rootID);
				if($spritesHash->{$rootID}{"children"} && $spritesHash->{$rootID}{"children"} ne ""){
						$treeBody .= "<ul class='parent'>";
						my @children = @{$spritesHash->{$rootID}{"children"}};
						foreach my $sortedID (sort {$idPosition->{$a} <=> $idPosition->{$b}} @children) {
								$treeBody .= createSpriteTree($sortedID, $pageid, $resultSprites, $spritesHash, $createContents, $replaceContents, $idPosition, $className);
						}
						$treeBody .= "</ul>";
				}

				$treeBody .= "</li>";
		}
		return $treeBody;
}


##########################################
## getSprites() returns <li>(sprite)s. ###
##########################################
sub getSprites
{
    my ($pageid, $spritesHash, $loginid, $loginpass, $max, $className) = @_;
		my %idPosition;
		my @rootIDs;
		my $BODY = "";
		my $CSSHEADER = "";
		my %createContents;
		my %replaceContents;

		# extract root sprites
		foreach my $keyID (keys %$spritesHash) {
				my $type = $spritesHash->{$keyID}{"type"};
				if($type eq "dynamic")
				{
						next;
				}

				if(!($spritesHash->{$keyID}{"parent"} && $spritesHash->{$keyID}{"parent"} ne "")){
						push(@rootIDs, $keyID);
				}

				my $valueStyle = $spritesHash->{$keyID}{"style"};
				$valueStyle =~ /top:(-*\d+)px/is;
				my $spritetop = $1;
				$valueStyle =~ /left:(-*\d+)px/is;
				my $spriteleft = $1;
				my $spriteposition = sprintf("%010d:%010d", $spritetop, $spriteleft);
				$idPosition{$keyID} = $spriteposition;


				my $sprite_plugin = $spritesHash->{$keyID}{"plugin"};
				# check plugin
				my $pluginName = "";
				my $pluginOption = "";
				my $pluginType = "";
				my $idPlugincontents = "";
				my $template = "";
				if($sprite_plugin =~ /^(.+?),(.+?);(.+?)$/is)
				{
						$pluginName = $1;
						$pluginOption = $2;
						$template = $3;
						# import dynamic sprites
						if (-f "./PositLogPlugin/" . $pluginName . ".pm")
						{
								# load plugin
								my $author_id = $spritesHash->{$keyID}{"author_id"};
								my $authorName = getAuthorName($author_id, $spritesHash->{$keyID}{"public_author"}, $spritesHash->{$keyID}{"public_password"});
								
								my $valueStyle = $spritesHash->{$keyID}{"style"};
								$valueStyle =~ /z-index:(-*\d+?);/is;
								my $spriteZindex = $1;

								$idPlugincontents = &importDynamicSprites($pluginName, $keyID, $authorName, $spriteZindex, $spritesHash, $pageid, $loginid, $loginpass, $className, $pluginOption);
								# add related CSS
								my $cssfile = eval 'use ' . "PositLogPlugin::" . $pluginName .';' . "PositLogPlugin::" . $pluginName . q/::getCSS()/;
								if($cssfile ne ""){
										$CSSHEADER .= "		<link rel='stylesheet' href='" .  $PositLogConfig::systempath . $cssfile ."' type='text/css'>\n";
								}
								$pluginType = eval 'use ' . "PositLogPlugin::" . $pluginName .';' . "PositLogPlugin::" . $pluginName . q/::getType()/;
								
								if($pluginType eq "create"){
										foreach my $tmpID (keys %$idPlugincontents){
												$createContents{$tmpID} = $idPlugincontents->{$tmpID};
												$spritesHash->{$tmpID}{"author_name"} = $authorName;
												if(!($spritesHash->{$tmpID}{"parent"} && $spritesHash->{$tmpID}{"parent"} ne "")){
														push(@rootIDs, $tmpID);
												}
										}
      										my $dynamicContents = $template;
										$dynamicContents =~ s/\[\[plugin\]\]//gis;
										$replaceContents{$keyID} = $dynamicContents;                                                                                                                                    
								}
								elsif($pluginType eq "replacesprite"){
										my $pluginContents = "";
										foreach my $tmpID (keys %$idPlugincontents) {
												$createContents{$tmpID} = $idPlugincontents->{$tmpID};
												if(!($spritesHash->{$tmpID}{"parent"} && $spritesHash->{$tmpID}{"parent"} ne "")){
														push(@rootIDs, $tmpID);
												}
										}

      										my $dynamicContents = $template;
										$dynamicContents =~ s/\[\[plugin\]\]//gis;
										$replaceContents{$keyID} = $dynamicContents;                                                                                                                                    		}
								elsif($pluginType eq "replace"){
										my $dynamicContents = "";
										my $pluginContents = "";
										foreach my $value (values %$idPlugincontents) {
												$pluginContents = $value;
										}
										$dynamicContents = $template;
										$dynamicContents =~ s/\[\[plugin\]\]/$pluginContents/gis;
										$replaceContents{$keyID} = $dynamicContents;
								}
						}
				}

		}

		my @resultSprites;
		my $counter = 0;
		foreach my $sortedID (sort {$idPosition{$a} <=> $idPosition{$b}} @rootIDs){
				if(scalar($max) == -1 || $counter < scalar($max)){
						$BODY .= createSpriteTree($sortedID, $pageid, \@resultSprites, $spritesHash, \%createContents, \%replaceContents, \%idPosition, $className);
				}
				if(scalar($max) != -1){
						$counter = $counter+1;
				}
		}

		my @results;
		push(@results, \@resultSprites);
		push(@results, \$BODY);
		push(@results, \$CSSHEADER);

		return \@results;
}

1;
