package PositLogPlugin::RecentSprites;

# --------------------------------------------------------
# RecentSprites.pm:
#      module for showing recent sprite groups on the page
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://storybook.jp/
#
# --------------------------------------------------------


use strict;
use Time::Local;
use Storable qw(lock_retrieve lock_nstore);
use Encode qw/encode decode/;
use PositLogConfig;
use PositLogSprites;

my $serializedData = "recentsprites";

sub getWidth
{
	return 320;
}

sub getCSS
{
	return "recent_sprites_contents.css";
}

sub getType
{
	return "replacesprite";
}


sub clearCache
{
    return "No cache.";
}


sub getSprites
{
    my ($pageid, $sourceID, $loginid, $loginpass, $args) = @_;
    my @argsArray = split(/,/, $args);
    my $sourcepageid = $argsArray[0];
    my $maxnumber = $argsArray[1];
    my %spriteidItem = ();



		my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
		my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
		my $loginerror = "";
		my $validUser = 0;
		my $adminUser = 0;


    # Check admin -> Check valid user -> show error
		if($adminnameAuth ne "" && $adminnameAuth->{$loginid}){
				my $cryptpass = $adminnameAuth->{$loginid}{"password"};
				my $salt="lc";
				my $cryptpass2 = crypt($loginpass, $salt);
				if($cryptpass eq $cryptpass2){
						$validUser = 1;
						$adminUser = 1;
				}
				else
				{
						$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
						$validUser = 0;
						$adminUser = 0;
				}
		}
		elsif($useridAuth ne "" && $useridAuth->{$loginid}){
				my $cryptpass = $useridAuth->{$loginid}{"password"};
				my $salt="ry";
				my $cryptpass2 = crypt($loginpass, $salt);
				if($cryptpass eq $cryptpass2){
						$validUser = 1;
						$adminUser = 0;
				}
				else{
						$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
						$validUser = 0;
						$adminUser = 0;
				}
		}
		else
		{
				if($loginid eq "" && $loginpass eq ""){
						$loginerror = "";
				}
				else
				{
						$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
				}
				$validUser = 0;
				$adminUser = 0;
		}



		my $counter = 0;

		my $canRead = 0;
		my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $sourcepageid . "/permission.cgi")};
		if($@){ warn $@; print "Cannot read permission.cgi."; return \%spriteidItem; }

		if($adminUser)
		{
				$canRead = 1;
		}
		elsif(scalar($permissionHash->{"read_page"}{"public"}) == 1)
		{
				$canRead = 1;
		}
		else
		{
				# check user list
				if(scalar($permissionHash->{"read_page"}{$loginid}) == 1)
				{
						$canRead = 1;
				}
				else
				{
						# check user group list
						foreach my $usergroupname (keys %{$permissionHash->{"read_page_group"}})
						{
								my $usergroupnameenc = $usergroupname;
								$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
								$usergroupnameenc =~ tr/ /+/;
								
								my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
								if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
								if(scalar($UserList->{$loginid}) == 1)
								{
										$canRead = 1;
								}
						}
				}
		}

		if(!$canRead)
		{
				return \%spriteidItem;
		}



		# get sprites
		my $spritesHashOrg = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")};
		if($@){ warn $@; print "Cannot read the sprite list.\n"; return \%spriteidItem; }

		my $spritesHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $sourcepageid . "/sprites.dat")};
		if($@){ warn $@; print "Cannot read the sprite list.\n"; return \%spriteidItem; }


#		my $newContents = "<div class='recentsprite_contents'>\n<ol style='position:absolute'>\n";
		my $newContents = "";

		
		# extract root sprites
		my @rootIDs;
		my $counter = 0;
		foreach my $keyID (sort {$spritesHash->{$b}{"modified_time"} <=> $spritesHash->{$a}{"modified_time"}} (keys %$spritesHash)) {
				my $sprite_plugin = $spritesHash->{$keyID}{"plugin"};
				if($sprite_plugin && $sprite_plugin ne ""){
						if($sprite_plugin =~ /^(.+?),(.+?);(.+?)$/is){
								my $pluginName = $1;
								my $pluginType = eval 'use ' . "PositLogPlugin::" . $pluginName .';' . "PositLogPlugin::" . $pluginName . q/::getType()/;
								if($pluginType eq "replace"){
										next;
								}
						}
				}

				my $parent = $spritesHash->{$keyID}{"parent"};
				my $topID = $keyID;
				while($parent && $parent ne ""){
						$topID = $parent;
						$parent = $spritesHash->{$parent}{"parent"};
				}

				if((grep {$_ eq $topID} @rootIDs) == 0){
						if($counter < scalar($maxnumber)){
								my $valueStyle = $spritesHashOrg->{$sourceID}{"style"};
								# get position
								$valueStyle =~ /left:(-*\d+)px/is;
#								my $parentleft = $1;
								my $parentleft = 0;

								my $parent = $spritesHashOrg->{$sourceID}{"parent"};
								while($parent && $parent ne ""){
										my $valueStyle = $spritesHashOrg->{$parent}{"style"};
										# get position
										$valueStyle =~ /left:(-*\d+)px/is;
#										my $pleft = $1;
										my $pleft = 0;
										$parentleft += scalar($pleft);
										$parent = $spritesHashOrg->{$parent}{"parent"};
								}


								my $result = createSpriteTree("", $topID, $sourcepageid, $spritesHash, $spritesHashOrg, \%spriteidItem, $spritesHash->{$topID}{"modified_time"}, $parentleft);

								$counter = $counter+1;
						}
						if($counter >= scalar($maxnumber)){
								last;
						}
						push(@rootIDs, $topID);
				}
		}


    return \%spriteidItem;
}

sub createSpriteTree
{
		my($parentID, $rootID, $pageid, $spritesHash, $spritesHashOrg, $spriteidItem, $recenttime, $pleft) = @_;
		my %replaceContents;

		my $valueStyle = $spritesHash->{$rootID}{"style"};
		$valueStyle =~ /left:(-*\d+)px/is;
		
		my $left = scalar($1);
		if($parentID ne ""){
				$left = $left + scalar($pleft);
		}
		my $maxleft = $left;



		if($spritesHash->{$rootID}{"children"} && $spritesHash->{$rootID}{"children"} ne "" && @{$spritesHash->{$rootID}{"children"}}){
				my @children = @{$spritesHash->{$rootID}{"children"}};

				foreach my $sortedID (@children) {
						my $result = createSpriteTree($rootID, $sortedID, $pageid, $spritesHash, $spritesHashOrg, $spriteidItem, $recenttime, $left);
						my @resultArray = split(/,/, $result);
						my $modified_time = $resultArray[0];
						my $childleft = $resultArray[1];

						if(scalar($recenttime) < $modified_time){
								$recenttime = $modified_time;
						}
						if($maxleft > $childleft){
								$maxleft = $childleft;
						}
				}

				if($parentID eq ""){
						my $valueStyle = $spritesHash->{$rootID}{"style"};
						# get position
						$valueStyle =~ /top:(-*\d+)px/is;
						my $spritetop = $1;
						$valueStyle =~ /z-index:(-*\d+?);/is;
						my $spriteZindex = $1;
						$valueStyle =~ /width:(\d+?)px;/is;
						my $spriteWidth = $1;

						my $newleft = - ($maxleft - $left) + $pleft;

						$spritesHash->{$rootID}{"style"} = "left:" . $newleft . "px; top:" . $spritetop . "px; width:" . $spriteWidth . "px; z-index:" . $spriteZindex . ";";
				}
				my $treeBody = PositLogSprites::getContents($rootID, $pageid, $spritesHash, \%replaceContents, "sprite");
				
 				my $pos = $spritesHash->{$rootID}{"margin_p"}{"position"};
				my $p_pixel = $spritesHash->{$rootID}{"margin_p"}{"pixel"};
 				my $elder = $spritesHash->{$rootID}{"margin_s"}{"elder"};
				my $s_pixel = $spritesHash->{$rootID}{"margin_s"}{"pixel"};
				$spriteidItem->{$recenttime . "," . $rootID . "," . $parentID . "," . $pos . "," .  $p_pixel . "," . $elder . "," . $s_pixel} = $treeBody;
				return $recenttime . "," . $maxleft;
		}
		else{
				$recenttime = $spritesHash->{$rootID}{"modified_time"};
				if($parentID eq ""){
						my $valueStyle = $spritesHash->{$rootID}{"style"};
						# get position
						$valueStyle =~ /top:(-*\d+)px/is;
						my $spritetop = $1;
						$valueStyle =~ /z-index:(-*\d+?);/is;
						my $spriteZindex = $1;
						$valueStyle =~ /width:(\d+?)px;/is;
						my $spriteWidth = $1;

						$spritesHash->{$rootID}{"style"} = "left:" . $pleft . "px; top:" . $spritetop . "px; width:" . $spriteWidth . "px; z-index:" . $spriteZindex . ";";
				}
				my $treeBody = PositLogSprites::getContents($rootID, $pageid, $spritesHash, \%replaceContents, "sprite");
				my $pos = $spritesHash->{$rootID}{"margin_p"}{"position"};
				my $p_pixel = $spritesHash->{$rootID}{"margin_p"}{"pixel"};

				my $elder = $spritesHash->{$rootID}{"margin_s"}{"elder"};
				my $s_pixel = $spritesHash->{$rootID}{"margin_s"}{"pixel"};

				$spriteidItem->{$recenttime . "," . $rootID . "," . $parentID . "," . $pos . "," .  $p_pixel . "," . $elder . "," . $s_pixel} = $treeBody;

				return $recenttime . "," . $maxleft;
		}
}
