/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.util;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;


/**
 * L[AlɊ܂܂j[jbNi[ɏ Properties łB
 * <p>
 * @author C/pHeR
 */
public class UnMnemonicProperties extends Properties {

	/** VAEo[W ID */
	private static final long serialVersionUID = -4066795589235888438L;

	/** j[jbN̐K\ubN */
	public static final String MNEMONIC_CHARS = "[\\w\\.@]";

	/**
	 * j[jbNvpeB[\z܂B
	 */
	public UnMnemonicProperties() {
	}

	/**
	 * pXw肵ăj[jbNvpeB[\z܂B<br>
	 * pXfBNg[̏ꍇ́A̒ɂvpeB[Et@C
	 * ׂă[h܂B
	 * <p>
	 * @param path pX
	 */
	public UnMnemonicProperties(String path) {
		this(FileSystem.getResourceFile(path));
	}

	/**
	 * [gpXw肵ăj[jbNvpeB[\z܂B<br>
	 * pXfBNg[̏ꍇ́A̒ɂvpeB[Et@C
	 * ׂă[h܂B
	 * <p>
	 * @param root [gpX
	 */
	public UnMnemonicProperties(File root) {

		// fBNg[̏ꍇ
		if (root.isDirectory()) {

			File[] files = root.listFiles();
			Arrays.sort(files); // 

			for (File file : files) {
				if (file.isFile() && file.getName().endsWith(".properties")) {
					Properties prop = FileSystem.loadProperties(file);
					putAll(prop);
				}
			}
		}
		// t@C̏ꍇ
		else {
			Properties prop = FileSystem.loadProperties(root);
			putAll(prop);
		}
	}

	/**
	 * w肵L[ƒlj[jbNA
	 * vpeB[ɃZbg܂B
	 */
	@Override
	public synchronized Object put(Object key, Object value) {
		return super.put(
				removeMnemonic(key),
				removeMnemonic(value));
	}

	/**
	 * w肵lɊ܂܂ &a  (&A) ̂悤ȃj[jbN܂B
	 * <p>
	 * @param value l
	 * @return j[jbN̒l
	 */
	public static String removeMnemonic(Object value) {

		String strValue = value.toString();
		// for ja
		strValue = strValue.replaceFirst("\\(\\&" + MNEMONIC_CHARS + "\\)", "");
		// for ja bug (&)
		strValue = strValue.replaceFirst("\\(\\&\\)", "");
		// for en
		strValue = strValue.replaceFirst("\\&(" + MNEMONIC_CHARS + ")", "$1");
		return strValue;
	}
}
