/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Map.Entry;

import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

/**
 * |󏜊OvpeB[łB
 * <p>
 * @author C/pHeR
 */
public class TranslationExcludeProperties {
	
	/** K[ */
	private static final Logger log = Logger.getLogger(TranslationExcludeProperties.class);
	
	/** |󏜊OvpeB[Et@C */
	private static final String PROP_FILE_NAME = "translation-exclude.properties";
	
	/** ̃NX̃VOgECX^X */
	private static final TranslationExcludeProperties singleton = new TranslationExcludeProperties();
	
	/**
	 * |󏜊OvpeB[EIuWFNg擾܂B
	 * <p>
	 * @return |󏜊OvpeB[EIuWFNg
	 */
	public static TranslationExcludeProperties getInstance() {
		return singleton;
	}
	
	/** |󏜊O}bv */
	private final Map<String, Set<String>> map = new HashMap<String, Set<String>>();
	
	/**
	 * |󏜊OvpeB[\z܂B
	 */
	private TranslationExcludeProperties() {
		
		File file = FileSystem.getResourceFile(PROP_FILE_NAME);
		if (!file.exists()) {
			Exception e = new FileNotFoundException(file.getPath());
			log.fatal("|󏜊OvpeB[܂B", e);
			return;
		}
		
		Properties prop = FileSystem.loadProperties(file);
		for (Entry<Object, Object> entry : prop.entrySet()) {
			map.put(
				(String) entry.getKey(),
				new HashSet<String>(Arrays.asList(entry.getValue().toString().split("\\s*,\\s*"))));
		}
		log.info("|󏜊OvpeB[[h܂B" + map.size());
	}
	
	/**
	 * w肵pꃊ\[X񂩂|󏜊OpXEGg[擾܂B
	 * <p>
	 * @param enValue pꃊ\[X
	 * @return |󏜊OpXEGg[B݂Ȃꍇ nullB
	 */
	public Set<String> getPathEntries(String enValue) {
		
		Set<String> pathEntries = map.get(enValue);
		if (pathEntries != null && pathEntries.contains("")) {
			log.info(
					"[" + enValue + "] ̖|ĂяoX^bNg[XB",
					new IllegalStateException());
			return null;
		}
		return pathEntries;
	}
}
