/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.controls;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.ne.k_tech.kposrcp.commons.dto.BaseDto;
import jp.ne.k_tech.kposrcp.controls.ControlLabelProvider;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.WrapDynaBean;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class ControlViewer<T extends BaseDto> {
    protected final Map<String, Control> controls = new HashMap<String, Control>();
    protected ControlLabelProvider<T> controlLabelProvider;
    protected T model;

    public ControlViewer(ControlLabelProvider<T> controlLabelProvider) {
        this.controlLabelProvider = controlLabelProvider;
        this.model = this.createModel();
    }

    public T getModel() {
        return this.model;
    }

    public void setModel(T model) {
        this.model = model;
    }

    public void refresh() {
        if (this.model == null) {
            return;
        }
        Set<String> keySet = this.controls.keySet();
        DynaProperty[] props = new WrapDynaBean(this.model).getDynaClass().getDynaProperties();
        int i = 0;
        while (i < props.length) {
            String key = props[i].getName();
            if (keySet.contains(key)) {
                this.setText(this.controls.get(key), this.controlLabelProvider.getText(key, this.model));
            }
            ++i;
        }
    }

    public void addText(String key, Text text) {
        this.controls.put(key, (Control)text);
    }

    public void addCLabel(String key, CLabel label) {
        this.controls.put(key, (Control)label);
    }

    public void addLabel(String key, Label label) {
        this.controls.put(key, (Control)label);
    }

    private void setText(Control control, String text) {
        if (control instanceof Text) {
            ((Text)control).setText(text);
        } else if (control instanceof CLabel) {
            ((CLabel)control).setText(text);
        } else if (control instanceof Label) {
            ((Label)control).setText(text);
        }
    }

    protected abstract T createModel();
}

