/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.receipt;

import java.util.ArrayList;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.OposReceiptPrinter;
import jp.ne.k_tech.kposrcp.kpos.common.PosConstants;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiptSalesCancel
extends ReceiptAbstract {
    private static Log log = LogFactory.getLog(ReceiptSalesCancel.class);
    private long totalAmount = 0L;

    public ReceiptSalesCancel(long totalAmount) {
        this.totalAmount = totalAmount;
    }

    @Override
    public void executeReceiptPrint(String slipNo) {
        int usePoint;
        log.info((Object)"\u8ca9\u58f2\u53d6\u6d88\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:START");
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getStoreHeader());
        list.add(this.getEmptyLine());
        list.addAll(this.getReceiptHeader(slipNo));
        list.add(this.getEmptyLine());
        long discount = 0L;
        int i = 0;
        while (i < this.journalDetail.size()) {
            JournalDetail element = (JournalDetail)this.journalDetail.get(i);
            if (this.showItemName()) {
                list.add(element.getItemName());
            } else {
                list.add(element.getItemCd());
            }
            String price = PosNumberUtils.currencyFormat(element.getPrice() * -1L);
            price = element.getPriceTaxKind().equals("0") ? price.concat(" " + PosConstants.TAX_KIND_NAMES_HEAD[Integer.valueOf("0")]) : (element.getPriceTaxKind().equals("1") ? price.concat(" " + PosConstants.TAX_KIND_NAMES_HEAD[Integer.valueOf("1")]) : (element.getPriceTaxKind().equals("2") ? price.concat(" " + PosConstants.TAX_KIND_NAMES_HEAD[Integer.valueOf("2")]) : price.concat("   ")));
            String quantity = element.getItemQuantity() == null ? "0" : element.getItemQuantity().toString();
            String itemQuantity = PosStringUtils.fill(quantity, 15);
            discount += element.getDiscountAmount() == null ? 0L : element.getDiscountAmount();
            list.add(PosStringUtils.fill(itemQuantity, price, 30));
            ++i;
        }
        list.add(this.getReceiptLine());
        long tax = this.journalHead.getTotalSaleTax() == null ? 0L : this.journalHead.getTotalSaleTax();
        list.add(PosStringUtils.fill("\u6d88\u8cbb\u7a0e", PosNumberUtils.currencyFormat(tax * -1L), 27));
        if (discount > 0L) {
            list.add(PosStringUtils.fill("\u5024\u5f15", PosNumberUtils.currencyFormat(discount), 27));
        }
        int n = usePoint = this.journalHead.getUsePoint() == null ? 0 : this.journalHead.getUsePoint();
        if (usePoint > 0) {
            list.add(PosStringUtils.fill("(\u5229\u7528\u30dd\u30a4\u30f3\u30c8 " + PosNumberUtils.commaFormat(usePoint * -1) + ")", 28));
        }
        String totalItemQuantity = PosStringUtils.fill("\u8fd4\u91d1\u91d1\u984d", String.valueOf(this.journalHead.getTotalItemQuantity() * -1), 15);
        list.add(PosStringUtils.fill(totalItemQuantity, PosNumberUtils.currencyFormat(this.totalAmount * -1L), 27));
        list.add(this.getReceiptLine());
        list.add("\u203b   \u8ca9 \u58f2 \u30ad \u30e3 \u30f3 \u30bb \u30eb   \u203b");
        list.add(this.getReceiptLine());
        list.addAll(this.getReceiptFooter(false));
        OposReceiptPrinter rp = OposController.getInstance().getReceiptPrinter();
        rp.print(slipNo, list);
        list.clear();
        log.info((Object)"\u8ca9\u58f2\u53d6\u6d88\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:END");
    }
}

