/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.receipt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import jp.ne.k_tech.kposrcp.commons.utils.BeanUtils;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.OposReceiptPrinter;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiptRecycle
extends ReceiptAbstract {
    private static Log log = LogFactory.getLog(ReceiptRecycle.class);
    private boolean recycleFlag;
    private boolean copy;
    private String posLinkBarcode;
    private List<BigDecimal> recycleUpAmountList;

    public ReceiptRecycle(String posLinkBarcode) {
        this.recycleFlag = true;
        this.copy = true;
        this.posLinkBarcode = posLinkBarcode;
    }

    public ReceiptRecycle(boolean recycleFlag) {
        this.recycleFlag = recycleFlag;
        this.copy = false;
    }

    @Override
    public void executeReceiptPrint(String slipNo) {
        log.info((Object)"\u8cb7\u53d6\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:START");
        ArrayList<String> list = new ArrayList<String>();
        if (this.recycleFlag && !this.copy) {
            String salesMessage = null;
            try {
                salesMessage = MstManager.getInstance().findStoreMstByCD().getSalesMessage();
            }
            catch (AbsentMstException e) {
                log.error((Object)"\u4f8b\u5916\u767a\u751f", (Throwable)e);
            }
            if (StringUtils.isNotEmpty((String)salesMessage)) {
                list.add(this.getEmptyLine());
                list.add(salesMessage);
                list.add(this.getEmptyLine());
            }
        }
        list.add(this.getStoreHeader());
        list.add(this.getEmptyLine());
        list.addAll(this.getReceiptHeader(slipNo));
        if (this.recycleFlag) {
            if (this.copy) {
                list.add(this.getReceiptTitle("   \u8cb7\u53d6 \u660e\u7d30   "));
                list.add(this.getReceiptTitle("  \uff08\u5e97\u8217 \u63a7\uff09  "));
            } else {
                list.add(this.getReceiptTitle(" \u8cb7\u53d6 \u30ec\u30b7\u30fc\u30c8 "));
            }
        } else {
            list.add(this.getReceiptTitle(" \u8cb7\u53d6 \u3054\u78ba\u8a8d\u7968 "));
            list.add(this.getEmptyLine());
            list.add("|cA\u767a\u884c\u6642\u306e\u307f\u6709\u52b9");
        }
        list.add(this.getReceiptLine());
        long recycleUpTotal = 0L;
        HashMap map = new HashMap();
        int i = 0;
        while (i < this.journalDetail.size()) {
            JournalDetail element = (JournalDetail)BeanUtils.cloneBean((Object)((JournalDetail)this.journalDetail.get(i)));
            long recycleUpAmount = this.recycleUpAmountList.get(i).longValue();
            element.setCostAmount(element.getCostAmount() - recycleUpAmount);
            recycleUpTotal += recycleUpAmount;
            String classCd = element.getClassCd();
            if (map.keySet().contains(classCd)) {
                ((List)map.get(classCd)).add(element);
            } else {
                ArrayList<JournalDetail> jl = new ArrayList<JournalDetail>();
                jl.add(element);
                map.put(classCd, jl);
            }
            ++i;
        }
        Set keys = map.keySet();
        for (String key : keys) {
            List jl = (List)map.get(key);
            long q = 0L;
            long c = 0L;
            for (JournalDetail journalDetail : jl) {
                q += (long)journalDetail.getItemQuantity().intValue();
                c += journalDetail.getCostAmount().longValue();
            }
            try {
                list.add(MstManager.getInstance().findClassNameByCD(key));
            }
            catch (AbsentMstException absentMstException) {
                list.add(key);
            }
            list.add(PosStringUtils.fill(PosStringUtils.fill(Long.toString(q), 15), PosNumberUtils.currencyFormat(c), 30));
        }
        list.add(this.getReceiptLine());
        list.add("|4C" + PosStringUtils.fill("\u8cb7\u53d6\u70b9\u6570", String.valueOf(String.valueOf(this.journalHead.getTotalItemQuantity())) + "\u70b9", 15));
        if (recycleUpTotal > 0L) {
            list.add("|4C" + PosStringUtils.fill("\u5c0f\u8a08", PosNumberUtils.currencyFormat(this.journalHead.getTotalAmount() - recycleUpTotal), 15));
            list.add("|4C" + PosStringUtils.fill("\u3000\uff35\uff30\u5206", PosNumberUtils.currencyFormat(recycleUpTotal), 15));
        }
        list.add("|4C" + PosStringUtils.fill("\u5408\u8a08", PosNumberUtils.currencyFormat(this.journalHead.getTotalAmount()), 15));
        list.add(this.getReceiptLine());
        if (this.recycleFlag) {
            if (this.copy) {
                list.add("::       \u4fdd\u7ba1\u7528\u5e97\u8217\u63a7       ::");
                if (StringUtils.isNotEmpty((String)this.posLinkBarcode) && this.posLinkBarcode.length() == 13) {
                    list.add(this.getReceiptLine());
                    list.add(String.format("[%s]", this.posLinkBarcode));
                }
            } else {
                list.add("::  \u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3057\u305f  ::");
            }
        } else {
            list.add("\u3054\u78ba\u8a8d\u5f8c\u3001\u7834\u68c4\u3055\u305b\u3066\u9802\u304d\u307e\u3059\u3002");
        }
        list.add(this.getReceiptLine());
        list.addAll(this.getReceiptFooter(false));
        OposReceiptPrinter rp = OposController.getInstance().getReceiptPrinter();
        rp.print(slipNo, list);
        list.clear();
        log.info((Object)"\u8cb7\u53d6\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:END");
    }

    public void setRecycleUpAmountList(List<BigDecimal> recycleUpAmountList) {
        this.recycleUpAmountList = recycleUpAmountList;
    }
}

