/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.receipt;

import java.util.ArrayList;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.OposReceiptPrinter;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiptReceive
extends ReceiptAbstract {
    private static Log log = LogFactory.getLog(ReceiptReceive.class);
    private String kindCd = null;

    public ReceiptReceive(String receiveKindCd) {
        this.kindCd = receiveKindCd;
    }

    @Override
    public void executeReceiptPrint(String slipNo) {
        log.info((Object)"\u5165\u8377\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:START");
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getStoreHeader());
        list.add(this.getEmptyLine());
        list.addAll(this.getReceiptHeader(slipNo));
        list.add(this.getEmptyLine());
        list.add(this.getReceiptTitle().concat("\u4e00\u89a7"));
        list.add(this.getReceiptLine());
        long changedCostTotal = 0L;
        int i = 0;
        while (i < this.journalDetail.size()) {
            JournalDetail element = (JournalDetail)this.journalDetail.get(i);
            list.add(element.getItemName());
            list.add(element.getItemCd());
            String price = PosNumberUtils.currencyFormat(element.getCost());
            price = price.concat("   ");
            String itemQuantity = PosStringUtils.fill(element.getItemQuantity().toString(), 15);
            list.add(PosStringUtils.fill(itemQuantity, price, 30));
            changedCostTotal += element.getCost() * (long)element.getItemQuantity().intValue();
            ++i;
        }
        list.add(this.getReceiptLine());
        list.add(String.valueOf(this.getReceiptTitle().concat("\u70b9\u6570:")) + this.journalHead.getTotalItemQuantity() + "\u70b9");
        list.add(String.valueOf(this.getReceiptTitle().concat("\u5916\u7a0e:")) + PosNumberUtils.currencyFormat(this.journalHead.getTotalAmount() - changedCostTotal));
        list.add(String.valueOf(this.getReceiptTitle().concat("\u91d1\u984d:")) + PosNumberUtils.currencyFormat(this.journalHead.getTotalAmount()));
        if (this.journalDetail.size() != 0) {
            String SupplierName = null;
            try {
                SupplierName = MstManager.getInstance().findSupplierNameByCD(((JournalDetail)this.journalDetail.get(0)).getSuppCd());
            }
            catch (AbsentMstException absentMstException) {
                SupplierName = "-----";
            }
            list.add("\u3000");
            list.add("\u3000\u4ed5\u5165\u5148\u3000:" + SupplierName);
        }
        list.add(this.getReceiptLine());
        list.addAll(this.getReceiptFooter(true));
        OposReceiptPrinter rp = OposController.getInstance().getReceiptPrinter();
        rp.print(slipNo, list);
        list.clear();
        log.info((Object)"\u5165\u8377\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:END");
    }

    private String getReceiptTitle() {
        String title = "";
        if (this.kindCd.equals("N0")) {
            title = "\u8cb7\u53d6\u5165\u8377";
        }
        return title;
    }
}

