/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.receipt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.OposReceiptPrinter;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiptMove
extends ReceiptAbstract {
    private static Log log = LogFactory.getLog(ReceiptMove.class);
    private String moveStoreCd = null;
    private String kindCd = null;
    private String info = null;
    private boolean copy;

    public ReceiptMove(String moveKindCd, String moveInfo, String moveStoreCd, boolean copy) {
        this.kindCd = moveKindCd;
        this.info = moveInfo;
        this.moveStoreCd = moveStoreCd;
        this.copy = copy;
    }

    @Override
    public void executeReceiptPrint(String slipNo) {
        List<JournalDetail> jl;
        log.info((Object)"\u51fa\u5eab\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:START");
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getStoreHeader());
        list.add(this.getEmptyLine());
        list.addAll(this.getReceiptHeader(slipNo));
        list.add(this.getReceiptTitle());
        if (this.copy) {
            list.add(this.getReceiptTitle("  \uff08\u5e97\u8217 \u63a7\uff09  "));
        }
        list.add(this.getEmptyLine());
        list.add("|cA" + this.info);
        if (!this.copy && this.kindCd.equals("S0")) {
            list.add("[" + MstManager.getInstance().getDbmBarcode().createMoveBarcode(Activator.getDefault().getPreferenceStore().getString("STORE_CD"), this.moveStoreCd, this.journalHead.getTotalItemQuantity()) + "]");
        }
        list.add(this.getReceiptLine());
        HashMap map = new HashMap();
        int i = 0;
        while (i < this.journalDetail.size()) {
            JournalDetail element = (JournalDetail)this.journalDetail.get(i);
            String classCd = element.getClassCd();
            if (map.keySet().contains(classCd)) {
                ((List)map.get(classCd)).add(element);
            } else {
                jl = new ArrayList();
                jl.add(element);
                map.put(classCd, jl);
            }
            ++i;
        }
        Set keys = map.keySet();
        for (String key : keys) {
            jl = (List)map.get(key);
            long q = 0L;
            long c = 0L;
            for (JournalDetail journalDetail : jl) {
                q += (long)journalDetail.getItemQuantity().intValue();
                c += journalDetail.getCostAmount().longValue();
            }
            try {
                list.add(MstManager.getInstance().findClassNameByCD(key));
            }
            catch (AbsentMstException absentMstException) {
                list.add(key);
            }
            list.add(PosStringUtils.fill(PosStringUtils.fill(Long.toString(q), 15), PosNumberUtils.currencyFormat(c), 30));
        }
        list.add(this.getReceiptLine());
        list.add("|4C" + PosStringUtils.fill(this.getTotalTitle(), String.valueOf(String.valueOf(this.journalHead.getTotalItemQuantity())) + "\u70b9", 15));
        list.add("|4C" + PosStringUtils.fill(PosNumberUtils.currencyFormat(this.journalHead.getTotalAmount()), 15));
        list.add(this.getReceiptLine());
        list.addAll(this.getReceiptFooter(true));
        OposReceiptPrinter rp = OposController.getInstance().getReceiptPrinter();
        rp.print(slipNo, list);
        list.clear();
        log.info((Object)"\u51fa\u5eab\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:END");
    }

    private String getReceiptTitle() {
        String title = "";
        if (this.kindCd.equals("S0")) {
            title = "   \u5e97\u9593 \u51fa\u5eab   ";
        } else if (this.kindCd.equals("Q0")) {
            title = "   \u5e97\u9593 \u5165\u5eab   ";
        } else if (this.kindCd.equals("L0")) {
            title = "   \u8cb7\u53d6 \u8fd4\u54c1   ";
        } else if (this.kindCd.equals("60")) {
            title = "   \u51fa\u5eab \u4e0d\u53ef   ";
        }
        return this.getReceiptTitle(title);
    }

    private String getTotalTitle() {
        String title = "";
        if (this.kindCd.equals("S0")) {
            title = "\u51fa\u5eab\u5408\u8a08";
        } else if (this.kindCd.equals("Q0")) {
            title = "\u5165\u5eab\u5408\u8a08";
        } else if (this.kindCd.equals("L0")) {
            title = "\u8fd4\u54c1\u5408\u8a08";
        } else if (this.kindCd.equals("60")) {
            title = "\u51fa\u5eab\u4e0d\u53ef\u5408\u8a08";
        }
        return title;
    }
}

