/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.receipt;

import java.util.ArrayList;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.OposReceiptPrinter;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiptDispose
extends ReceiptAbstract {
    private static Log log = LogFactory.getLog(ReceiptDispose.class);

    @Override
    public void executeReceiptPrint(String slipNo) {
        log.info((Object)"\u5ec3\u68c4\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:START");
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getStoreHeader());
        list.add(this.getEmptyLine());
        list.addAll(this.getReceiptHeader(slipNo));
        list.add(this.getReceiptTitle("     \u5ec3 \u68c4     "));
        list.add(this.getReceiptLine());
        int i = 0;
        while (i < this.journalDetail.size()) {
            if (this.showItemName()) {
                list.add(((JournalDetail)this.journalDetail.get(i)).getItemName());
            } else {
                list.add(((JournalDetail)this.journalDetail.get(i)).getItemCd());
            }
            list.add(((JournalDetail)this.journalDetail.get(i)).getBarcode());
            String cost = PosNumberUtils.currencyFormat(((JournalDetail)this.journalDetail.get(i)).getCost());
            cost = cost.concat("   ");
            String itemQuantity = PosStringUtils.fill(((JournalDetail)this.journalDetail.get(i)).getItemQuantity().toString(), 15);
            list.add(PosStringUtils.fill(itemQuantity, cost, 30));
            ++i;
        }
        list.add(this.getReceiptLine());
        list.add("|4C" + PosStringUtils.fill("\u5ec3\u68c4\u5408\u8a08", String.valueOf(String.valueOf(this.journalHead.getTotalItemQuantity())) + "\u70b9", 15));
        list.add("|4C" + PosStringUtils.fill(PosNumberUtils.currencyFormat(this.journalHead.getTotalAmount()), 15));
        list.add(this.getReceiptLine());
        list.addAll(this.getReceiptFooter(true));
        OposReceiptPrinter rp = OposController.getInstance().getReceiptPrinter();
        rp.print(slipNo, list);
        list.clear();
        log.info((Object)"\u5ec3\u68c4\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:END");
    }
}

