/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.label;

import java.util.Date;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosDateUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.print.Print;
import jp.ne.k_tech.kposrcp.kpos.print.label.LabelAbstract;

public class LabelRecycle
extends LabelAbstract {
    private List<JournalDetail> journalDetailList = null;

    public LabelRecycle(List<JournalDetail> journalDetailList) {
        this.journalDetailList = journalDetailList;
    }

    @Override
    public Print executeLabelPrint(int index) {
        Print print = new Print();
        JournalDetail journalDetail = this.journalDetailList.get(index);
        print.setCode(journalDetail.getBarcode());
        print.setPrice((int)PosNumberUtils.amountWithTax(journalDetail.getPrice().intValue(), journalDetail.getPriceTaxKind()));
        print.setItemNum(journalDetail.getItemNum());
        Date now = new Date();
        print.setLastDate(PosDateUtils.format_yyyyMMdd(now));
        String genreName = "\u3000";
        try {
            genreName = MstManager.getInstance().findGenreNameByCD(journalDetail.getGenreCd());
        }
        catch (AbsentMstException absentMstException) {}
        print.setGnereName(genreName);
        String lastdate = PosDateUtils.format_yyMMdd(now);
        print.setInfo(String.valueOf(Activator.getDefault().getPreferenceStore().getString("STORE_CD")) + " " + lastdate);
        print.setItemCode(journalDetail.getMakerCd());
        String name = journalDetail.getItemName();
        if (name.length() == 0) {
            name = "\u3000\u3000";
        }
        print.setItemName(name);
        return print;
    }
}

