/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.list;

import java.util.ArrayList;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.PosConstants;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosDateUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.gui.component.ExGridData;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.ItemSearchTableData;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ItemSearchResultList {
    private static Log log = LogFactory.getLog(ItemSearchResultList.class);
    private Table tableItemSearchResultList = null;
    private List<ItemSearchTableData> bodyList = null;

    public ItemSearchResultList(PosMain posMain, List<ItemSearchTableData> list) {
        this.bodyList = list;
    }

    public void createItemSearchResultList(Composite parent) {
        this.tableItemSearchResultList = new Table(parent, 67586);
        this.tableItemSearchResultList.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        this.tableItemSearchResultList.setLinesVisible(true);
        this.tableItemSearchResultList.setHeaderVisible(true);
        this.tableItemSearchResultList.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: {
                        if ((e.stateMask & 0x40000) == 0) break;
                        e.doit = false;
                        break;
                    }
                    default: {
                        e.doit = false;
                    }
                }
            }
        });
        this.initItemSearchResultTableHeader();
        this.refreshBody();
        if (this.tableItemSearchResultList.getItemCount() > 0) {
            this.tableItemSearchResultList.setSelection(0);
        }
    }

    private void initItemSearchResultTableHeader() {
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < PosConstants.COLUMN_NAME_ITEMSEARCH.length) {
            TableColumn column = new TableColumn(this.tableItemSearchResultList, 16384);
            column.setText(PosConstants.COLUMN_NAME_ITEMSEARCH[i]);
            int w = PosConstants.COLUMN_WIDTH_ITEMSEARCH[i];
            layout.addColumnData((ColumnLayoutData)(w > 0 ? new ColumnWeightData(w) : new ColumnPixelData(0)));
            column.setResizable(w > 0);
            if (ArrayUtils.contains((Object[])PosConstants.COLUMN_NAMES_ALIGN_RIGHT, (Object)PosConstants.COLUMN_NAME_ITEMSEARCH[i])) {
                column.setAlignment(131072);
            }
            ++i;
        }
        this.tableItemSearchResultList.setLayout((Layout)layout);
        this.tableItemSearchResultList.layout();
    }

    private void refreshBody() {
        MstManager mstManager = MstManager.getInstance();
        ArrayList<ItemSearchTableData> resultList = new ArrayList<ItemSearchTableData>();
        int i = 0;
        while (i < this.bodyList.size()) {
            block3: {
                if (PosConstants.SEARCH_MAX_RECORD <= i) break;
                ItemSearchTableData itemSearchTableData = this.bodyList.get(i);
                String className = null;
                String genreName = null;
                String labelName = null;
                String rankName = null;
                ItemMst itemMst = itemSearchTableData.getItemMst();
                try {
                    className = mstManager.findClassNameByCD(itemMst.getClassCd());
                    genreName = mstManager.findGenreNameByCD(itemMst.getGenreCd());
                    labelName = mstManager.findLabelNameByCD(itemMst.getLabelCd());
                    rankName = mstManager.findRank(itemMst.getClassCd(), itemMst.getOnsaleDate(), itemMst.getRankCd()).getRankName();
                }
                catch (AbsentMstException e) {
                    log.error((Object)"\u30de\u30b9\u30bf\u53d6\u5f97\u5931\u6557\uff0e", (Throwable)e);
                    break block3;
                }
                TableItem item = new TableItem(this.tableItemSearchResultList, 0);
                int count = this.tableItemSearchResultList.getItemCount();
                item.setBackground(count % 2 == 1 ? JFaceResources.getColorRegistry().get("white") : JFaceResources.getColorRegistry().get("aliceblue"));
                item.setImage(Activator.getDefault().getImageRegistry().get("bgdummy"));
                int col = 0;
                item.setText(col++, String.valueOf(this.tableItemSearchResultList.getItemCount()));
                item.setText(col++, itemMst.getBarcode());
                item.setText(col++, itemMst.getMakerCd());
                item.setText(col++, className);
                item.setText(col++, genreName);
                item.setText(col++, StringUtils.defaultString((String)itemMst.getItemName()));
                item.setText(col++, ObjectUtils.toString((Object)itemMst.getItemNum()));
                item.setText(col++, labelName);
                item.setText(col++, StringUtils.defaultString((String)itemMst.getItemDetail2()));
                item.setText(col++, PosNumberUtils.currencyFormat(itemMst.getPrice()));
                item.setText(col++, PosNumberUtils.currencyFormat(itemMst.getCost()));
                item.setText(col++, rankName);
                item.setText(col++, PosNumberUtils.currencyFormat(itemMst.getMakerPrice()));
                item.setText(col++, PosDateUtils.format_yyyyMMdd(itemMst.getOnsaleDate()));
                item.setText(col++, StringUtils.defaultString((String)PosDateUtils.format_yyyyMMddHHmm(itemMst.getLastDate())));
                resultList.add(itemSearchTableData);
            }
            ++i;
        }
        this.bodyList.clear();
        this.bodyList.addAll(resultList);
    }

    public Table getItemSearchResultList() {
        return this.tableItemSearchResultList;
    }

    public List<ItemSearchTableData> getSelectedData() {
        ArrayList<ItemSearchTableData> list = new ArrayList<ItemSearchTableData>();
        int i = 0;
        while (i < this.tableItemSearchResultList.getItemCount()) {
            if (this.tableItemSearchResultList.isSelected(i)) {
                list.add(this.bodyList.get(i));
            }
            ++i;
        }
        return list;
    }
}

