/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.dialogs;

import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.OposReceiptPrinter;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.SlipNoManager;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogCashier;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogEmpChange;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogItemSearch;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogItemSearchResult;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogMoveConfirm;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogMoveStore;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogRecycle;
import jp.ne.k_tech.kposrcp.kpos.logic.PosCheck;
import jp.ne.k_tech.kposrcp.kpos.logic.PosCustomerCount;
import jp.ne.k_tech.kposrcp.kpos.logic.PosDispose;
import jp.ne.k_tech.kposrcp.kpos.logic.PosDrawer;
import jp.ne.k_tech.kposrcp.kpos.logic.PosEmpChange;
import jp.ne.k_tech.kposrcp.kpos.logic.PosExpense;
import jp.ne.k_tech.kposrcp.kpos.logic.PosItemSearch;
import jp.ne.k_tech.kposrcp.kpos.logic.PosItemSearchResult;
import jp.ne.k_tech.kposrcp.kpos.logic.PosJournalSearch;
import jp.ne.k_tech.kposrcp.kpos.logic.PosJournalSearchResult;
import jp.ne.k_tech.kposrcp.kpos.logic.PosLogin;
import jp.ne.k_tech.kposrcp.kpos.logic.PosMoney;
import jp.ne.k_tech.kposrcp.kpos.logic.PosMove;
import jp.ne.k_tech.kposrcp.kpos.logic.PosRecycle;
import jp.ne.k_tech.kposrcp.kpos.logic.PosRecycleSummary;
import jp.ne.k_tech.kposrcp.kpos.logic.PosSales;
import jp.ne.k_tech.kposrcp.kpos.logic.PosScan;
import jp.ne.k_tech.kposrcp.kpos.print.label.LabelPrint;
import jp.ne.k_tech.kposrcp.panes.BasePane;
import jp.ne.k_tech.kposrcp.panes.TopPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DialogKeyEventHandler
implements KeyListener {
    private static Log log = LogFactory.getLog(DialogKeyEventHandler.class);
    private PosMain posMain = null;
    private Shell targetShell = null;
    private Button buttonOk = null;
    private Button buttonCancel = null;
    private Button buttonBack = null;
    private DialogAbstract dialog = null;
    private StringBuffer buff = new StringBuffer();
    private int barcodeTerminateCode;

    public DialogKeyEventHandler(PosMain posMain, Shell targetShell, DialogAbstract dialog) {
        this.posMain = posMain;
        this.targetShell = targetShell;
        this.dialog = dialog;
        this.barcodeTerminateCode = Activator.getDefault().getPreferenceStore().getInt("BARCODE_TERMINAL_CODE");
    }

    public void keyReleased(KeyEvent e) {
        DialogAbstract dialogAbstract = this.posMain.getKeyEventHandler().getDialog();
        String nowDialog = dialogAbstract.getNowName();
        DialogCashier dialogCashier = null;
        DialogRecycle dialogRecycle = null;
        if (nowDialog.endsWith("DialogCashier")) {
            dialogCashier = (DialogCashier)dialogAbstract;
        } else if (nowDialog.endsWith("DialogRecycle")) {
            dialogRecycle = (DialogRecycle)dialogAbstract;
        } else if (nowDialog.endsWith("DialogEmpChange")) {
            char character = e.character;
            if (Character.isLetterOrDigit(character)) {
                this.buff.append(character);
                return;
            }
            if (e.keyCode == this.barcodeTerminateCode) {
                this.scanEmp(this.buff.toString());
                this.buff.delete(0, this.buff.length());
                log.debug((Object)"this keyCode is a barcodeTerminateCode.");
                return;
            }
        } else {
            return;
        }
        switch (e.character) {
            case 'L': 
            case 'l': {
                if (dialogRecycle == null) break;
                dialogRecycle.setLabelPrint();
                break;
            }
            case 'K': 
            case 'k': {
                if (dialogCashier == null) break;
                dialogCashier.setSalesCredit();
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        String nowDialog = this.posMain.getKeyEventHandler().getDialog().getNowName();
        switch (e.keyCode) {
            case 13: 
            case 0x1000050: {
                log.debug((Object)"Enter \u30ad\u30fc\u30a4\u30d9\u30f3\u30c8\u691c\u77e5");
                if (this.buttonOk != null) {
                    this.buttonOk.setEnabled(false);
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
                if (nowDialog.endsWith("DialogEmpChange")) break;
                if (nowDialog.endsWith("DialogCashier")) {
                    PosSales posSales = new PosSales(this.posMain);
                    if (!posSales.enterDialogCashier(this.dialog)) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogScan")) {
                    PosScan posScan = new PosScan(this.posMain, this.targetShell);
                    if (posScan.enterDialog(this.dialog)) break;
                    this.buttonOk.setEnabled(true);
                    return;
                }
                if (nowDialog.endsWith("DialogDiscount")) {
                    PosSales posSales = new PosSales(this.posMain);
                    if (!posSales.enterDialogDiscount(this.dialog)) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogRecycle")) {
                    PosRecycle posRecycle = new PosRecycle(this.posMain);
                    if (!posRecycle.enterDialogRecycle(this.dialog)) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogAssessment")) {
                    PosRecycle posRecycle = new PosRecycle(this.posMain);
                    if (!posRecycle.enterDialogAssessment(this.dialog)) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogLineCopy")) {
                    PosRecycle posRecycle = new PosRecycle(this.posMain);
                    if (!posRecycle.enterDialogLineCopy(this.dialog)) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogRecycleUp")) {
                    PosRecycle posRecycle = new PosRecycle(this.posMain);
                    if (!posRecycle.enterDialogRecycleUp(this.dialog)) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogCannotRecycle")) {
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogRecycleUnknown")) {
                    PosRecycle posRecycle = new PosRecycle(this.posMain);
                    if (!posRecycle.enterDialogUnknown(this.dialog)) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogSetConfirm")) {
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogCheck")) {
                    PosCheck posCheck = new PosCheck(this.posMain);
                    if (!posCheck.enterDialog(this.dialog)) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogDisposeConfirm")) {
                    PosDispose posDispose = new PosDispose(this.posMain);
                    if (!posDispose.enterDialogDispose()) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogCustomerCount")) {
                    PosCustomerCount posCustomerCount = new PosCustomerCount(this.posMain);
                    if (!posCustomerCount.enterDialog(this.dialog)) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogItemSearch")) {
                    PosItemSearch posItemSearch = new PosItemSearch(this.posMain, this.targetShell);
                    if (posItemSearch.enterDialog(this.dialog)) break;
                    this.buttonOk.setEnabled(true);
                    return;
                }
                if (nowDialog.endsWith("DialogItemSearchResult")) {
                    PosItemSearchResult posItemSearchResult = new PosItemSearchResult(this.posMain, this.targetShell);
                    if (posItemSearchResult.enterDialog(this.dialog)) break;
                    this.buttonOk.setEnabled(true);
                    return;
                }
                if (nowDialog.endsWith("DialogMoveStore")) {
                    DialogMoveStore dialogMoveStore = (DialogMoveStore)this.dialog;
                    DialogMoveConfirm dialogMoveConfirm = new DialogMoveConfirm();
                    dialogMoveConfirm.setMoveStoreCd(dialogMoveStore.getStoreSelection().getStoreCd());
                    this.targetShell.close();
                    DialogMoveConfirm dialog = dialogMoveConfirm;
                    dialog.create(this.posMain, Display.getCurrent(), 0);
                    this.posMain.getKeyEventHandler().setDialog(dialog);
                    break;
                }
                if (nowDialog.endsWith("DialogMoveConfirm")) {
                    PosMove posMove = new PosMove(this.posMain);
                    if (!posMove.enterDialogMove(this.dialog)) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogMoveCancelConfirm")) {
                    PosMove posMove = new PosMove(this.posMain);
                    if (!posMove.enterDialogMoveCancel(this.dialog)) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogLabelPrintConfirm")) {
                    LabelPrint labelPrint = new LabelPrint();
                    labelPrint.executePrint(this.posMain);
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogJournalSearch")) {
                    PosJournalSearch posJournalSearch = new PosJournalSearch(this.posMain, this.targetShell);
                    if (posJournalSearch.enterDialog(this.dialog)) break;
                    this.buttonOk.setEnabled(true);
                    return;
                }
                if (nowDialog.endsWith("DialogJournalSearchResult")) {
                    PosJournalSearchResult posJournalSearchResult = new PosJournalSearchResult(this.posMain, this.targetShell);
                    posJournalSearchResult.enterDialog(this.dialog);
                    break;
                }
                if (nowDialog.endsWith("DialogExpense")) {
                    PosExpense posExpense = new PosExpense(this.posMain);
                    if (!posExpense.enterDialog(this.dialog)) {
                        this.buttonOk.setEnabled(true);
                        return;
                    }
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogReceiptPrintConfirm")) {
                    OposReceiptPrinter rp = OposController.getInstance().getReceiptPrinter();
                    rp.printRepeat(SlipNoManager.getInstance().getLastPrintSlipNo());
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogLogin")) {
                    PosLogin posLogin = new PosLogin(this.posMain, this.targetShell);
                    posLogin.enterDialogLogin(this.dialog);
                    break;
                }
                if (nowDialog.endsWith("DialogMoney")) {
                    PosMoney posMoney = new PosMoney(this.posMain, this.targetShell);
                    posMoney.enterDialogMoney(this.dialog);
                    break;
                }
                if (nowDialog.endsWith("DialogIOConfirm")) {
                    this.dialog.resultYES();
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogSameItem")) {
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogCannotCopy")) {
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogNotExistsSummaryCsv")) {
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (!nowDialog.endsWith("DialogRecycleSummary")) break;
                PosRecycleSummary posRecycleSummary = new PosRecycleSummary(this.posMain);
                posRecycleSummary.enterDialogRecycleSummary(this.dialog);
                if (this.targetShell.isDisposed()) break;
                this.targetShell.close();
                break;
            }
            case 8: {
                if (!nowDialog.endsWith("DialogItemSearchResult")) break;
                if (this.buttonBack != null) {
                    this.buttonBack.setEnabled(false);
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
                DialogAbstract dialogAbstract = this.posMain.getKeyEventHandler().getDialog();
                String keyword = ((DialogItemSearchResult)dialogAbstract).getKeyword();
                String kindName = ((DialogItemSearchResult)dialogAbstract).getKindName();
                if (!this.targetShell.isDisposed()) {
                    this.targetShell.close();
                }
                DialogItemSearch dialog = new DialogItemSearch();
                dialog.create(this.posMain, Display.getCurrent(), 0);
                this.posMain.getKeyEventHandler().setDialog(dialog);
                dialog.setKeyword(keyword);
                dialog.setKeyKindName(kindName);
                break;
            }
            case 27: {
                log.debug((Object)"Esc \u30ad\u30fc\u30a4\u30d9\u30f3\u30c8\u691c\u77e5");
                if (this.buttonCancel != null) {
                    this.buttonCancel.setEnabled(false);
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
                if (nowDialog.endsWith("DialogLogin") || nowDialog.endsWith("DialogMoney")) {
                    BasePane.setTopControl((Composite)TopPane.getInstance());
                    this.posMain.getStatusBar().setText("");
                    if (!this.targetShell.isDisposed()) {
                        this.targetShell.close();
                    }
                    if (this.buttonCancel == null) break;
                    this.buttonCancel.setEnabled(true);
                    break;
                }
                if (nowDialog.endsWith("DialogEmpChange")) {
                    BasePane.setTopControl((Composite)TopPane.getInstance());
                    this.posMain.getStatusBar().setText("");
                    if (!this.targetShell.isDisposed()) {
                        this.targetShell.close();
                    }
                    if (this.buttonCancel == null) break;
                    this.buttonCancel.setEnabled(true);
                    break;
                }
                if (nowDialog.endsWith("DialogCashier")) {
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogCheck")) {
                    PosCheck posCheck = new PosCheck(this.posMain);
                    posCheck.escapeDialog(this.dialog);
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                if (nowDialog.endsWith("DialogRecycleSummary")) {
                    if (this.targetShell.isDisposed()) break;
                    this.targetShell.close();
                    break;
                }
                this.dialog.resultNO();
                if (this.targetShell.isDisposed()) break;
                this.targetShell.close();
            }
        }
        this.posMain.getShell().setFocus();
        this.posMain.getPosTabFolder().getPosAbstract()[this.posMain.getPosTabFolder().getTabFolder().getSelectionIndex()].getItemList().getTableItemList().setFocus();
    }

    public void setButtonCancel(Button buttonCancel) {
        this.buttonCancel = buttonCancel;
    }

    public void setButtonOk(Button buttonOk) {
        this.buttonOk = buttonOk;
    }

    public void setButtonBack(Button buttonBack) {
        this.buttonBack = buttonBack;
    }

    public synchronized void scanEmp(String barcode) {
        if (OposController.getInstance().getCashDrawer().isOpen()) {
            PosDrawer posDrawer = new PosDrawer(this.posMain);
            posDrawer.warning();
            return;
        }
        String empBarcode = "12345678";
        log.debug((Object)"call scanEmp()");
        PosEmpChange posEmpChange = ((DialogEmpChange)this.dialog).getPosEmpChange();
        posEmpChange.enterDialog(this.dialog, empBarcode);
    }
}

