/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.dbm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.common.SlipNoManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.InappropriateUsageException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosFileUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.dao.SlipDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Indicate;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.IndicatePK;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetailPK;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.OrderDetail;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.OrderDetailPK;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.OrderHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Slip;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbmSlip {
    private static Log log = LogFactory.getLog(DbmSlip.class);

    public String regist(Slip slip, JournalHead journalHead) {
        slip.setStoreCd(Activator.getDefault().getPreferenceStore().getString("STORE_CD"));
        slip.setCreateDate(Calendar.getInstance().getTime());
        slip.setSendFlag("0");
        journalHead.setPosVersion("0.1.1BS");
        String slipNo = null;
        String kind = slip.getKindMst().getKindCd();
        if ("R0".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo(false);
        } else if ("T0".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo(false);
        } else if ("O0".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo();
        } else if ("K0".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo();
        } else if ("Y0".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo(false);
        } else if ("E0".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo(false);
        } else if ("W0".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo(false);
        } else {
            throw new InappropriateUsageException();
        }
        slip.setSlipNo(slipNo);
        journalHead.setSlipNo(slipNo);
        ArrayList<JournalDetail> journalDetailList = new ArrayList<JournalDetail>();
        JournalDetail journalDetail = new JournalDetail();
        journalDetail.setItemCd("0");
        journalDetail.setSuppCd("0");
        journalDetail.setMakerCd("0");
        journalDetail.setLabelCd("0");
        journalDetail.setClassCd("0");
        journalDetail.setGenreCd("0");
        journalDetail.setPrice(BigDecimal.ZERO.longValue());
        journalDetail.setPriceTaxKind("0");
        journalDetail.setCost(BigDecimal.ZERO.longValue());
        journalDetail.setCostTaxKind("0");
        journalDetail.setBarcode("0000000000000");
        journalDetail.setItemQuantity(0);
        journalDetail.setAmount(BigDecimal.ZERO.longValue());
        journalDetail.setCostAmount(BigDecimal.ZERO.longValue());
        journalDetailList.add(journalDetail);
        JournalDetailPK journalDetailPK = new JournalDetailPK(slipNo, 1);
        ((JournalDetail)journalDetailList.get(0)).setComp_id(journalDetailPK);
        SlipDAO slipDAO = new SlipDAO();
        slipDAO.saveSlipJournal(slip, journalHead, journalDetailList);
        PosFileUtils.createTriggerFile();
        return slipNo;
    }

    public String regist(Slip slip, JournalHead journalHead, List<JournalDetail> journalDetailList) {
        slip.setStoreCd(Activator.getDefault().getPreferenceStore().getString("STORE_CD"));
        slip.setCreateDate(Calendar.getInstance().getTime());
        slip.setSendFlag("0");
        journalHead.setPosVersion("0.1.1BS");
        journalHead.setDetailsCount(journalDetailList.size());
        String slipNo = null;
        String kind = slip.getKindMst().getKindCd();
        if ("U0".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo();
        } else if ("G0".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo(false);
        } else if ("B0".equals(kind) || "C0".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo();
        } else if ("V0".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo();
        } else if ("N0".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo();
        } else if ("S0".equals(kind) || "Q0".equals(kind) || "L0".equals(kind) || "60".equals(kind)) {
            slipNo = SlipNoManager.getInstance().getNextSlipNo();
        } else {
            throw new InappropriateUsageException();
        }
        slip.setSlipNo(slipNo);
        journalHead.setSlipNo(slipNo);
        int i = 0;
        while (i < journalDetailList.size()) {
            JournalDetailPK journalDetailPK = new JournalDetailPK(slipNo, i + 1);
            journalDetailList.get(i).setComp_id(journalDetailPK);
            ++i;
        }
        SlipDAO slipDAO = new SlipDAO();
        slipDAO.saveSlipJournal(slip, journalHead, journalDetailList);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u30b8\u30e3\u30fc\u30ca\u30eb\u767b\u9332::::::::::::::::::::::::");
            log.debug((Object)PosStringUtils.toString4Bean(slip));
            log.debug((Object)PosStringUtils.toString4Bean(journalHead));
            for (JournalDetail journalDetail : journalDetailList) {
                log.debug((Object)PosStringUtils.toString4Bean(journalDetail));
            }
        }
        PosFileUtils.createTriggerFile();
        return slipNo;
    }

    public String regist(Slip slip, List<Indicate> indicateList) {
        String slipNo = SlipNoManager.getInstance().getNextSlipNo();
        slip.setSlipNo(slipNo);
        int i = 0;
        while (i < indicateList.size()) {
            IndicatePK indicatePK = new IndicatePK(slipNo, i);
            indicateList.get(i).setComp_id(indicatePK);
            ++i;
        }
        PosFileUtils.createTriggerFile();
        return slipNo;
    }

    public String regist(Slip slip, OrderHead orderHead, List<OrderDetail> orderDetailList) {
        String slipNo = SlipNoManager.getInstance().getNextSlipNo();
        slip.setSlipNo(slipNo);
        orderHead.setSlipNo(slipNo);
        int i = 0;
        while (i < orderDetailList.size()) {
            OrderDetailPK orderDetailPK = new OrderDetailPK(slipNo, i);
            orderDetailList.get(i).setComp_id(orderDetailPK);
            ++i;
        }
        PosFileUtils.createTriggerFile();
        return slipNo;
    }
}

