/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.common;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.common.exception.NotDefinedException;
import jp.ne.k_tech.kposrcp.kpos.common.exception.NotInitializedException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosDateUtils;
import jp.ne.k_tech.kposrcp.kpos.db.dao.SlipDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SlipNoManager {
    private static Log log = LogFactory.getLog(SlipNoManager.class);
    private static final NumberFormat NUMBER_FORMAT_00000 = new DecimalFormat("00000");
    private static SlipNoManager instance = null;
    private String bizDate = null;
    private int seq = 0;
    private String prefix = null;
    private String lastPrintSlipNo = null;
    private String storeCd = null;
    private String registerNo = null;

    private SlipNoManager() {
        log.debug((Object)"\u4f1d\u7968\u756a\u53f7\u521d\u671f\u5316\u958b\u59cb");
        this.storeCd = Activator.getDefault().getPreferenceStore().getString("STORE_CD");
        if (this.storeCd == null) {
            throw new NotDefinedException("Store.StoreCD");
        }
        this.registerNo = String.format("%02d", Activator.getDefault().getPreferenceStore().getInt("REGISTER_NO"));
        if (this.storeCd == null) {
            throw new NotDefinedException("Store.CashRegisterNo");
        }
        this.bizDate = PosDateUtils.getBizDate4SlipNo();
        this.prefix = String.valueOf(this.bizDate) + this.storeCd + this.registerNo;
        SlipDAO slipDAO = new SlipDAO();
        this.seq = slipDAO.getMaxSlipNoSeq(this.prefix);
        log.debug((Object)("\u4f1d\u7968\u756a\u53f7\u521d\u671f\u5316\u7d42\u4e86[" + this.prefix + NUMBER_FORMAT_00000.format(this.seq) + "]"));
    }

    public static synchronized SlipNoManager getInstance() {
        if (instance == null) {
            throw new NotInitializedException();
        }
        return instance;
    }

    public static synchronized void initialize() {
        if (instance == null) {
            instance = new SlipNoManager();
        }
    }

    public static synchronized void refresh() {
        instance = new SlipNoManager();
    }

    public String getSlipNo() {
        return String.valueOf(this.prefix) + NUMBER_FORMAT_00000.format(this.seq);
    }

    public String getNextSlipNo() {
        return this.getNextSlipNo(true);
    }

    public synchronized String getNextSlipNo(boolean print) {
        ++this.seq;
        if (print) {
            this.lastPrintSlipNo = String.valueOf(this.registerNo) + NUMBER_FORMAT_00000.format(this.seq);
        }
        return this.getSlipNo();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLastPrintSlipNo() {
        return this.lastPrintSlipNo;
    }

    public String getBizDate() {
        return this.bizDate;
    }
}

