/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.common;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.common.PosConstants;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.exception.NotInitializedException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosBeanUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosDateUtils;
import jp.ne.k_tech.kposrcp.kpos.db.dao.ClassMstDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.EmpMstDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.GenreMstDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.KindMstDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.LabelMstDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.RankMstDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.StoreMstDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.SupplierMstDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ClassMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.DynamicChange;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.EmpMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.GenreMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.KindMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.LabelMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.PointConversion;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.RankMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.StoreMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.SupplierMst;
import jp.ne.k_tech.kposrcp.kpos.dbm.DbmBarcode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MstManager {
    private static Log log = LogFactory.getLog(MstManager.class);
    private static MstManager instance = null;
    private List<StoreMst> storeMstList = null;
    private List<ClassMst> classMstList = null;
    private List<SupplierMst> supplierMstList = null;
    private List<GenreMst> genreMstList = null;
    private List<LabelMst> labelMstList = null;
    private List<EmpMst> empMstList = null;
    private List<KindMst> kindMstList = null;
    private List<RankMst> rankMstList = null;
    private Map<String, List<RankMst>> rankMstMap = null;
    private Map<String, List<RankMst>> rankMstMapFixed = null;
    private List<PointConversion> pointConversionList = null;
    private List<DynamicChange> dynamicChangeList = null;
    private Set<String> fixedRank = null;
    private Map<String, Integer> recycleBuyUpMap = null;
    private DbmBarcode dbmBarcode = null;

    private MstManager() {
        log.debug((Object)"\u30de\u30b9\u30bf\u30ea\u30b9\u30c8\u521d\u671f\u5316\u51e6\u7406\u958b\u59cb");
        this.fixedRank = new HashSet<String>();
        this.fixedRank.add("S");
        this.fixedRank.add("Z");
        StoreMstDAO storeMstDAO = new StoreMstDAO();
        this.storeMstList = storeMstDAO.loadAll();
        ClassMstDAO classMstDAO = new ClassMstDAO();
        this.classMstList = classMstDAO.loadAll();
        SupplierMstDAO supplierMstDAO = new SupplierMstDAO();
        this.supplierMstList = supplierMstDAO.loadAll();
        GenreMstDAO genreMstDAO = new GenreMstDAO();
        this.genreMstList = genreMstDAO.loadAll();
        LabelMstDAO labelMstDAO = new LabelMstDAO();
        this.labelMstList = labelMstDAO.loadAll();
        EmpMstDAO empMstDAO = new EmpMstDAO();
        this.empMstList = empMstDAO.loadAll();
        KindMstDAO kindMstDAO = new KindMstDAO();
        this.kindMstList = kindMstDAO.loadAll();
        RankMstDAO rankMstDAO = new RankMstDAO();
        this.rankMstList = rankMstDAO.loadAll();
        this.rankMstMap = new HashMap<String, List<RankMst>>();
        this.rankMstMapFixed = new HashMap<String, List<RankMst>>();
        String classCd = null;
        ArrayList<RankMst> subList = null;
        ArrayList<RankMst> subListFixed = null;
        for (RankMst rankMst : this.rankMstList) {
            if (rankMst.getComp_id().getClassCd().equals(classCd)) {
                if (!this.fixedRank.contains(rankMst.getComp_id().getRankCd())) {
                    this.rankMstMap.get(classCd).add(rankMst);
                    continue;
                }
                subListFixed.add(rankMst);
                continue;
            }
            classCd = rankMst.getComp_id().getClassCd();
            subList = new ArrayList<RankMst>();
            subListFixed = new ArrayList<RankMst>();
            this.rankMstMap.put(classCd, subList);
            this.rankMstMapFixed.put(classCd, subListFixed);
            if (!this.fixedRank.contains(rankMst.getComp_id().getRankCd())) {
                subList.add(rankMst);
                continue;
            }
            subListFixed.add(rankMst);
        }
        this.dbmBarcode = new DbmBarcode();
        this.dbmBarcode.initialize();
        log.debug((Object)"\u30de\u30b9\u30bf\u30ea\u30b9\u30c8\u521d\u671f\u5316\u51e6\u7406\u7d42\u4e86");
    }

    public static synchronized MstManager getInstance() {
        if (instance == null) {
            throw new NotInitializedException();
        }
        return instance;
    }

    public static synchronized void initialize() {
        if (instance == null) {
            instance = new MstManager();
        }
    }

    public List<StoreMst> getStoreMstList() {
        return PosBeanUtils.cloneList(this.storeMstList);
    }

    public List<ClassMst> getClassMstList() {
        return PosBeanUtils.cloneList(this.classMstList);
    }

    public List<SupplierMst> getSupplierMstList() {
        return PosBeanUtils.cloneList(this.supplierMstList);
    }

    public List<GenreMst> getGenreMstList() {
        return PosBeanUtils.cloneList(this.genreMstList);
    }

    public List<LabelMst> getLabelMstList() {
        return PosBeanUtils.cloneList(this.labelMstList);
    }

    public List<EmpMst> getEmpMstList() {
        return PosBeanUtils.cloneList(this.empMstList);
    }

    public List<KindMst> getKindMstList() {
        return PosBeanUtils.cloneList(this.kindMstList);
    }

    public List<RankMst> getRankMstList() {
        return PosBeanUtils.cloneList(this.rankMstList);
    }

    public List<RankMst> getRankMstList(String classCd) {
        ArrayList<RankMst> list = new ArrayList<RankMst>();
        if (this.rankMstMap.keySet().contains(classCd)) {
            list.addAll((Collection)this.rankMstMap.get(classCd));
        }
        if (this.rankMstMapFixed.keySet().contains(classCd)) {
            list.addAll((Collection<RankMst>)this.rankMstMapFixed.get(classCd));
        }
        return list;
    }

    public List<PointConversion> getPointConversionList() {
        return PosBeanUtils.cloneList(this.pointConversionList);
    }

    public List<DynamicChange> getDynamicChangeList() {
        return PosBeanUtils.cloneList(this.dynamicChangeList);
    }

    public StoreMst findStoreMstByCD(String cd) throws AbsentMstException {
        StoreMst storeMst2 = null;
        for (StoreMst storeMst2 : this.storeMstList) {
            if (!cd.equals(storeMst2.getStoreCd().trim())) continue;
            return PosBeanUtils.cloneObject(storeMst2);
        }
        throw new AbsentMstException(String.format("\u5e97\u8217\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[%s]", cd));
    }

    public String findStoreNameByCD(String cd) throws AbsentMstException {
        return StringUtils.defaultString((String)this.findStoreMstByCD(cd).getStoreName());
    }

    public StoreMst findStoreMstByCD() throws AbsentMstException {
        return this.findStoreMstByCD(Activator.getDefault().getPreferenceStore().getString("STORE_CD"));
    }

    public String findStoreNameByCD() throws AbsentMstException {
        return StringUtils.defaultString((String)this.findStoreMstByCD().getStoreName());
    }

    public ClassMst findClassMstByCD(String cd) throws AbsentMstException {
        ClassMst classMst2 = null;
        for (ClassMst classMst2 : this.classMstList) {
            if (!cd.equals(classMst2.getClassCd().trim())) continue;
            return PosBeanUtils.cloneObject(classMst2);
        }
        throw new AbsentMstException(String.format("\u5206\u985e\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[%s]", cd));
    }

    public String findClassNameByCD(String cd) throws AbsentMstException {
        return StringUtils.defaultString((String)this.findClassMstByCD(cd).getClassName());
    }

    public SupplierMst findSupplierMstByCD(String cd) throws AbsentMstException {
        SupplierMst supplierMst2 = null;
        for (SupplierMst supplierMst2 : this.supplierMstList) {
            if (!cd.equals(supplierMst2.getSuppCd().trim())) continue;
            return PosBeanUtils.cloneObject(supplierMst2);
        }
        throw new AbsentMstException(String.format("\u4ed5\u5165\u5148\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[%s]", cd));
    }

    public String findSupplierNameByCD(String cd) throws AbsentMstException {
        return StringUtils.defaultString((String)this.findSupplierMstByCD(cd).getSuppName());
    }

    public GenreMst findGenreMstByCD(String cd) throws AbsentMstException {
        GenreMst genreMst2 = null;
        for (GenreMst genreMst2 : this.genreMstList) {
            if (!cd.equals(genreMst2.getGenreCd().trim())) continue;
            return PosBeanUtils.cloneObject(genreMst2);
        }
        throw new AbsentMstException(String.format("\u30b8\u30e3\u30f3\u30eb\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[%s]", cd));
    }

    public String findGenreNameByCD(String cd) throws AbsentMstException {
        return StringUtils.defaultString((String)this.findGenreMstByCD(cd).getGenreName());
    }

    public LabelMst findLabelMstByCD(String cd) throws AbsentMstException {
        LabelMst labelMst2 = null;
        for (LabelMst labelMst2 : this.labelMstList) {
            if (!cd.equals(labelMst2.getLabelCd().trim())) continue;
            return PosBeanUtils.cloneObject(labelMst2);
        }
        throw new AbsentMstException(String.format("\u30ec\u30fc\u30d9\u30eb\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[%s]", cd));
    }

    public String findLabelNameByCD(String cd) throws AbsentMstException {
        return StringUtils.defaultString((String)this.findLabelMstByCD(cd).getLabelName());
    }

    public KindMst findKindMstByCD(String cd) throws AbsentMstException {
        KindMst kindMst2 = null;
        for (KindMst kindMst2 : this.kindMstList) {
            if (!cd.equals(kindMst2.getKindCd().trim())) continue;
            return PosBeanUtils.cloneObject(kindMst2);
        }
        throw new AbsentMstException(String.format("\u533a\u5206\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[%s]", cd));
    }

    public String findKindNameByCD(String cd) throws AbsentMstException {
        return StringUtils.defaultString((String)this.findKindMstByCD(cd).getKindName());
    }

    public RankMst findRank(String classCd, Date onsaleDate) throws AbsentMstException {
        List<RankMst> list = this.rankMstMap.get(classCd);
        if (list == null || list.size() == 0) {
            throw new AbsentMstException(String.format("\u30e9\u30f3\u30af\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[classCd:%s,onsaleDate:%tF %tT]", classCd, onsaleDate, onsaleDate));
        }
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.clear();
        calendar.set(year, month, 1);
        long diffDays = PosDateUtils.dateDiff(onsaleDate, calendar.getTime());
        if (diffDays < 0L) {
            diffDays = 0L;
        }
        boolean found = false;
        RankMst rankMst = null;
        int i = 0;
        while (i < list.size()) {
            rankMst = list.get(i);
            if ((long)rankMst.getStartDays() <= diffDays && diffDays <= (long)rankMst.getEndDays()) {
                found = true;
                break;
            }
            ++i;
        }
        return PosBeanUtils.cloneObject(found ? rankMst : this.getLastRank(classCd));
    }

    public String findRankCdByRankName(String classCd, String rankName) throws AbsentMstException {
        ArrayList list = new ArrayList();
        if (this.rankMstMap.containsKey(classCd)) {
            list.addAll(this.rankMstMap.get(classCd));
        }
        if (this.rankMstMapFixed.containsKey(classCd)) {
            list.addAll(this.rankMstMapFixed.get(classCd));
        }
        if (list == null || list.size() == 0) {
            throw new AbsentMstException(String.format("\u30e9\u30f3\u30af\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[classCd:%s,rankName:%s]", classCd, rankName));
        }
        int i = 0;
        while (i < list.size()) {
            RankMst rankMst = (RankMst)list.get(i);
            if (rankMst.getRankName().equals(rankName)) {
                return rankMst.getComp_id().getRankCd();
            }
            ++i;
        }
        return this.getLastRank(classCd).getRankName();
    }

    public RankMst findRank(String classCd, Date onsaleDate, String rankCd) throws AbsentMstException {
        if (this.fixedRank.contains(rankCd)) {
            List<RankMst> list = this.rankMstMapFixed.get(classCd);
            if (list == null || list.size() == 0) {
                throw new AbsentMstException(String.format("\u30e9\u30f3\u30af\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[classCd:%s,onsaleDate:%tF %tT,rankCd:%s]", classCd, onsaleDate, onsaleDate, rankCd));
            }
            int i = 0;
            while (i < list.size()) {
                RankMst rankMst = list.get(i);
                if (rankMst.getComp_id().getRankCd().equals(rankCd)) {
                    return PosBeanUtils.cloneObject(rankMst);
                }
                ++i;
            }
            throw new AbsentMstException(String.format("\u30e9\u30f3\u30af\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[classCd:%s,onsaleDate:%tF %tT,rankCd:%s]", classCd, onsaleDate, onsaleDate, rankCd));
        }
        return this.findRank(classCd, onsaleDate);
    }

    public RankMst findRank(String classCd, String rankCd) throws AbsentMstException {
        List<RankMst> list = null;
        list = this.fixedRank.contains(rankCd) ? this.rankMstMapFixed.get(classCd) : this.rankMstMap.get(classCd);
        if (list == null || list.size() == 0) {
            throw new AbsentMstException(String.format("\u30e9\u30f3\u30af\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[classCd:%s,rankCd:%s]", classCd, rankCd));
        }
        int i = 0;
        while (i < list.size()) {
            RankMst rankMst = list.get(i);
            if (rankMst.getComp_id().getRankCd().equals(rankCd)) {
                return PosBeanUtils.cloneObject(rankMst);
            }
            ++i;
        }
        return PosBeanUtils.cloneObject(this.getLastRank(classCd));
    }

    public RankMst upRank(String classCd, String rankCd) throws AbsentMstException {
        if (this.fixedRank.contains(rankCd)) {
            return this.findRank(classCd, rankCd);
        }
        List<RankMst> list = this.rankMstMap.get(classCd);
        if (list == null || list.size() == 0) {
            throw new AbsentMstException(String.format("\u30e9\u30f3\u30af\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[classCd:%s,rankCd:%s]", classCd, rankCd));
        }
        RankMst rankMst = null;
        int i = 0;
        while (i < list.size()) {
            rankMst = list.get(i);
            if (rankMst.getComp_id().getRankCd().equals(rankCd)) {
                return PosBeanUtils.cloneObject(list.get(Math.max(i - 1, 0)));
            }
            ++i;
        }
        throw new AbsentMstException(String.format("\u30e9\u30f3\u30af\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[classCd:%s,rankCd:%s]", classCd, rankCd));
    }

    public RankMst downRank(String classCd, String rankCd) throws AbsentMstException {
        if (this.fixedRank.contains(rankCd)) {
            return this.findRank(classCd, rankCd);
        }
        List<RankMst> list = this.rankMstMap.get(classCd);
        if (list == null || list.size() == 0) {
            throw new AbsentMstException(String.format("\u30e9\u30f3\u30af\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[classCd:%s,rankCd:%s]", classCd, rankCd));
        }
        RankMst rankMst = null;
        int i = 0;
        while (i < list.size()) {
            rankMst = list.get(i);
            if (rankMst.getComp_id().getRankCd().equals(rankCd)) {
                return PosBeanUtils.cloneObject(list.get(Math.min(i + 1, list.size() - 1)));
            }
            ++i;
        }
        throw new AbsentMstException(String.format("\u30e9\u30f3\u30af\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[classCd:%s,rankCd:%s]", classCd, rankCd));
    }

    private RankMst getLastRank(String classCd) throws AbsentMstException {
        List<RankMst> list = this.rankMstMap.get(classCd);
        if (list == null || list.size() == 0) {
            throw new AbsentMstException(String.format("\u30e9\u30f3\u30af\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[classCd:%s]", classCd));
        }
        return list.get(Math.max(0, list.size() - 1));
    }

    public String findTaxKindNameByCD(String taxKind) throws AbsentMstException {
        int flag = NumberUtils.toInt((String)taxKind, (int)-1);
        if (flag >= 0) {
            return PosConstants.TAX_KIND_NAMES[flag];
        }
        throw new AbsentMstException(String.format("\u7a0e\u533a\u5206\u540d\u79f0\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[%s]", taxKind));
    }

    public long findPricePerPoint(String suppCd, String classCd, String genreCd) {
        PointConversion pointConversion = null;
        int i = 0;
        while (i < this.pointConversionList.size()) {
            pointConversion = this.pointConversionList.get(i);
            if (!(!StringUtils.equals((String)suppCd, (String)pointConversion.getSuppCd()) && pointConversion.getSuppCd() != null || !StringUtils.equals((String)classCd, (String)pointConversion.getClassCd()) && pointConversion.getClassCd() != null || !StringUtils.equals((String)genreCd, (String)pointConversion.getGenreCd()) && pointConversion.getGenreCd() != null)) {
                return pointConversion.getPricePerPoint().longValue();
            }
            ++i;
        }
        return this.pointConversionList.get(this.pointConversionList.size() - 1).getPricePerPoint().longValue();
    }

    public long findPricePerPoint() {
        return this.findPricePerPoint(null, null, null);
    }

    public DynamicChange findDynamicChange(String suppCd, String classCd, String genreCd) {
        DynamicChange dynamicChange = null;
        int i = 0;
        while (i < this.dynamicChangeList.size()) {
            dynamicChange = this.dynamicChangeList.get(i);
            if (!(!StringUtils.equals((String)suppCd, (String)dynamicChange.getSuppCd()) && dynamicChange.getSuppCd() != null || !StringUtils.equals((String)classCd, (String)dynamicChange.getClassCd()) && dynamicChange.getClassCd() != null || !StringUtils.equals((String)genreCd, (String)dynamicChange.getGenreCd()) && dynamicChange.getGenreCd() != null || dynamicChange.getRecycleSale() == null || dynamicChange.getRecycleBuy() == null)) {
                return PosBeanUtils.cloneObject(dynamicChange);
            }
            ++i;
        }
        return null;
    }

    public EmpMst findEmpMstByCD(String cd) throws AbsentMstException {
        EmpMst empMst2 = null;
        for (EmpMst empMst2 : this.empMstList) {
            if (!cd.equals(empMst2.getEmpCd().trim())) continue;
            return PosBeanUtils.cloneObject(empMst2);
        }
        throw new AbsentMstException(String.format("\u793e\u54e1\u30de\u30b9\u30bf\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e[%s]", cd));
    }

    public DbmBarcode getDbmBarcode() {
        return this.dbmBarcode;
    }

    public int getUpRateByClassCd(String classCd) {
        int result = 0;
        if (this.recycleBuyUpMap.containsKey(classCd)) {
            result = this.recycleBuyUpMap.get(classCd);
        }
        return result;
    }
}

