/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos;

import jp.ne.k_tech.kposrcp.controls.creators.CLabelCreator;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.PosFunctionBar;
import jp.ne.k_tech.kposrcp.kpos.PosInitialize;
import jp.ne.k_tech.kposrcp.kpos.PosKeyEventHandler;
import jp.ne.k_tech.kposrcp.kpos.PosTabFolder;
import jp.ne.k_tech.kposrcp.kpos.PosTraverseHandler;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.PosCommon;
import jp.ne.k_tech.kposrcp.kpos.common.PosTimerTask;
import jp.ne.k_tech.kposrcp.kpos.common.SlipNoManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.exception.ExitException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosDateUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.db.dao.SlipDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.EmpMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.StoreMst;
import jp.ne.k_tech.kposrcp.kpos.gui.component.ExGridData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PosMain {
    private static Log log = LogFactory.getLog(PosMain.class);
    private Shell shell = null;
    private Composite base = null;
    private Composite headerTop = null;
    private Composite middleArea = null;
    private Composite footerArea = null;
    private Label labelNow = null;
    private Label labelStore = null;
    private Label labelEmp = null;
    private Button buttonExpand = null;
    private SashForm verticalForm = null;
    private StyledText nowSales = null;
    private StyledText nowCustomer = null;
    private StyledText nowSlipNo = null;
    private CLabel statusBar = null;
    private Label messageFunctionkey = null;
    private PosTabFolder posTabFolder = null;
    private PosFunctionBar functionBar = null;
    private PosKeyEventHandler keyEventHandler = null;
    private Display display = null;
    private static PrinterData printService = null;
    private EmpMst posEmpMst = null;
    private EmpMst managerEmpMst = null;
    private boolean loginFlag = false;
    private static PosMain instance;

    public Shell getShell() {
        return this.shell;
    }

    public static synchronized void init(Composite parent) {
        if (instance == null) {
            instance = new PosMain(parent, 0);
        }
    }

    public static PosMain getInstance() {
        return instance;
    }

    private PosMain(Composite parent, int style) {
        this.open(parent, style);
    }

    public PosFunctionBar getFunctionBar() {
        return this.functionBar;
    }

    public CLabel getStatusBar() {
        return this.statusBar;
    }

    public SashForm getVerticalForm() {
        return this.verticalForm;
    }

    public PosTabFolder getPosTabFolder() {
        return this.posTabFolder;
    }

    public Button getButtonExpand() {
        return this.buttonExpand;
    }

    public Font getLargeFont() {
        return JFaceResources.getFontRegistry().getBold("poslargen");
    }

    public Font getNormalFont() {
        return JFaceResources.getFontRegistry().get("posnomaln");
    }

    public Font getSmallFont() {
        return JFaceResources.getFontRegistry().get("possmalln");
    }

    public Composite getBase() {
        return this.base;
    }

    public PosKeyEventHandler getKeyEventHandler() {
        return this.keyEventHandler;
    }

    public Label getMessageFunctionkey() {
        return this.messageFunctionkey;
    }

    public StyledText getNowCustomer() {
        return this.nowCustomer;
    }

    public StyledText getNowSales() {
        return this.nowSales;
    }

    public StyledText getNowSlipNo() {
        return this.nowSlipNo;
    }

    protected void open(Composite parent, int style) {
        log.debug((Object)"POS\u30b9\u30bf\u30fc\u30c8");
        this.display = Display.getCurrent();
        PosInitialize initialize = new PosInitialize(this);
        initialize.initMstTables();
        initialize.initSlipNo();
        initialize.initCheckMoney();
        printService = initialize.initLabelPrinter();
        this.posTabFolder = new PosTabFolder(this);
        this.createBase(parent, style);
        this.createStatusbar();
        this.keyEventHandler = new PosKeyEventHandler(this);
        PosCommon.addKeyListener(this.base, this.keyEventHandler);
        PosTraverseHandler traverseHandler = new PosTraverseHandler();
        PosCommon.addTraverseListener(this.base, traverseHandler);
        initialize.initTableData(0);
        this.posTabFolder.initTableFooter();
        parent.layout();
        parent.pack();
        this.scheduleNextTask(5);
        this.loginFlag = true;
    }

    private void createBase(Composite parent, int style) {
        this.shell = parent.getShell();
        this.base = new Composite(parent, style);
        this.base.setLayout((Layout)new GridLayout(1, true));
        this.base.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        this.createHeaderTop();
        this.createMiddleArea();
        this.createFooterArea();
    }

    private void createHeaderTop() {
        this.headerTop = new Composite(this.base, 0);
        this.headerTop.setLayoutData((Object)new GridData(768));
        this.headerTop.setLayout((Layout)new GridLayout(20, false));
        this.labelNow = new Label(this.headerTop, 0);
        this.labelNow.setText(PosDateUtils.format_jp());
        this.labelNow.setFont(this.getNormalFont());
        Label labelWork1 = new Label(this.headerTop, 0);
        StoreMst storeMst = null;
        try {
            storeMst = MstManager.getInstance().findStoreMstByCD();
        }
        catch (AbsentMstException e) {
            throw new ExitException("\u81ea\u5e97\u8217\u60c5\u5831\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\uff0e", e);
        }
        labelWork1.setText(" \u5e97\u8217");
        labelWork1.setFont(this.getNormalFont());
        this.labelStore = new Label(this.headerTop, 0);
        this.labelStore.setText(String.format("\u3010%s\uff3b%02d\uff3d\uff1a%s\u3011", storeMst.getStoreCd().trim(), Activator.getDefault().getPreferenceStore().getInt("REGISTER_NO"), storeMst.getStoreLongName()));
        this.labelStore.setFont(this.getNormalFont());
        Label labelWork2 = new Label(this.headerTop, 0);
        labelWork2.setText(" \u62c5\u5f53");
        labelWork2.setFont(this.getNormalFont());
        this.labelEmp = new Label(this.headerTop, 0);
        this.labelEmp.setText("\u3010-----\uff1a------------------\u3011");
        this.labelEmp.setFont(this.getNormalFont());
        Label labelWork3 = new Label(this.headerTop, 0);
        labelWork3.setText(" ");
        Label labelWork4 = new Label(this.headerTop, 0);
        labelWork4.setText(" \u4f1d\u7968\u756a\u53f7");
        labelWork4.setFont(this.getNormalFont());
        this.nowSlipNo = new StyledText(this.headerTop, 0x1000000);
        this.nowSlipNo.setBackground(Display.getCurrent().getSystemColor(22));
        this.nowSlipNo.setEditable(false);
        this.nowSlipNo.setFont(this.getNormalFont());
        this.updateLabelSlipNo();
    }

    private void createMiddleArea() {
        this.middleArea = new Composite(this.base, 2048);
        this.middleArea.setLayout((Layout)new GridLayout(1, true));
        this.middleArea.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        this.createVerticalForm();
    }

    private void createVerticalForm() {
        this.verticalForm = new SashForm(this.middleArea, 0);
        this.verticalForm.setLayout((Layout)new GridLayout(1, false));
        this.verticalForm.setOrientation(512);
        this.verticalForm.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        this.posTabFolder.createTabFolder();
        int[] weights = new int[]{100};
        this.verticalForm.setWeights(weights);
    }

    private void createFooterArea() {
        this.footerArea = new Composite(this.base, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.footerArea.setLayout((Layout)layout);
        this.footerArea.setLayoutData((Object)new GridData(768));
        this.functionBar = new PosFunctionBar(this, this.footerArea);
        this.functionBar.setup();
        this.messageFunctionkey = new Label(this.footerArea, 0);
        this.messageFunctionkey.setText("\u2605F13\u4ee5\u964d\u306fCtrl\u30ad\u30fc\u62bc\u3057\u306a\u304c\u3089\u30d5\u30a1\u30f3\u30af\u30b7\u30e7\u30f3\u30ad\u30fc\u3092\u62bc\u3057\u307e\u3059");
        this.messageFunctionkey.setFont(this.getSmallFont());
    }

    private void createStatusbar() {
        CLabelCreator labelCreator = new CLabelCreator(this.base, 0, "bgstripelight");
        labelCreator.setImageRegistry(Activator.getDefault().getImageRegistry());
        this.statusBar = labelCreator.create();
        this.statusBar.setForeground(Display.getCurrent().getSystemColor(3));
        this.statusBar.setLayoutData((Object)new ExGridData().getGridData(true, false, false, false));
        this.statusBar.setFont(this.getLargeFont());
    }

    public void updateLabelEmp() {
        this.labelEmp.setText(String.format("\u3010%s\uff1a%s\u3011", this.posEmpMst.getEmpCd().trim(), this.posEmpMst.getEmpName()));
    }

    public void setPosEmpMst(EmpMst empMst) {
        this.posEmpMst = empMst;
    }

    public EmpMst getPosEmpMst() {
        return this.posEmpMst;
    }

    public void setManagerEmpMst(EmpMst empMst) {
        this.managerEmpMst = empMst;
    }

    public EmpMst getManagerEmpMst() {
        return this.managerEmpMst;
    }

    public void setLoginFlag(boolean flag) {
        this.loginFlag = flag;
    }

    public boolean isLogin() {
        return this.loginFlag;
    }

    public void updateLabelTime() {
        this.labelNow.setText(PosDateUtils.format_jp());
    }

    public void updateLabelTotalAmount() {
    }

    public void updateLabelPurchaser() {
        SlipDAO slipDAO = new SlipDAO();
        this.nowCustomer.setText(String.format("%s\u4eba", PosNumberUtils.commaFormat(slipDAO.countPurchaser())));
    }

    public void updateLabelSlipNo() {
        this.nowSlipNo.setText("\u3010" + SlipNoManager.getInstance().getSlipNo() + "\u3011");
    }

    public void updateHeaderTopLabels() {
        this.updateLabelSlipNo();
    }

    public void scheduleNextTask(int sleeptime) {
        if (!this.display.isDisposed()) {
            PosTimerTask timerTask = new PosTimerTask(this);
            this.display.timerExec(sleeptime * 1000, (Runnable)timerTask);
        }
    }

    public void scheduleNextTask() {
        this.scheduleNextTask(Activator.getDefault().getPreferenceStore().getInt("APP_SLEEPTIME"));
    }

    public PrinterData getPrintService() {
        return printService;
    }
}

