/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.device.opos;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.ne.k_tech.kposrcp.device.Constants;
import jp.ne.k_tech.kposrcp.device.opos.AbstractOpos;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.common.util.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OposCashDrawer
extends AbstractOpos {
    protected static Log log = LogFactory.getLog(OposCashDrawer.class);
    public static final int CONDITION_UNKNOWN = 0;
    public static final int CONDITION_OPEN = 1;
    public static final int CONDITION_CLOSE = 2;
    public static final int CONDITION_NORMAL = 10;
    public static final int CONDITION_ERROR = 20;
    private static Emulator form = null;
    private int condition = 0;
    private static Color COLOR_WHITE = new Color(255, 255, 255);
    private static Color COLOR_RED = new Color(255, 0, 0);
    private String oposCommander;
    private String dirPath;
    private String message;

    public OposCashDrawer(boolean mode) {
        this.setEmulate(mode);
    }

    @Override
    public void initialize() {
        this.oposCommander = this.store.getString("OPOS_COMMANDER");
        this.dirPath = this.store.getString("OPOS_CASHDRAWER_EXCHANGEDIR");
        if (!this.dirPath.endsWith(Constants.SEP)) {
            this.dirPath = String.valueOf(this.dirPath) + Constants.SEP;
        }
        File file = new File(String.valueOf(this.dirPath) + "CashDrawer.ERROR");
        file.delete();
        file = null;
        if (this.isEmulate()) {
            if (form == null) {
                form = new Emulator();
            }
            OposCashDrawer.form.setCondition(2);
        } else {
            String[] cmd = new String[]{this.oposCommander, "I", "ALL"};
            OposController.execute(cmd, false);
        }
    }

    @Override
    public void terminate() {
        if (this.isEmulate()) {
            OposCashDrawer.form.setCondition(0);
            form.dispose();
        } else {
            this.setCondition(0);
        }
    }

    @Override
    public void sense() {
        if (!this.isEmulate()) {
            File file = new File(String.valueOf(this.dirPath) + "CashDrawer.ERROR");
            if (file.exists()) {
                this.message = FileUtil.readFile(String.valueOf(this.dirPath) + "CashDrawer.ERROR");
                if (this.message.startsWith("ERROR")) {
                    this.setCondition(20);
                } else {
                    this.setCondition(10);
                }
            } else {
                this.setCondition(10);
            }
            file = new File(String.valueOf(this.dirPath) + "CashDrawer.OPEN");
            if (file.exists()) {
                this.setCondition(1);
            }
        } else {
            OposCashDrawer.form.setCondition(10);
        }
    }

    public void open() {
        if (this.isEmulate()) {
            OposCashDrawer.form.setCondition(1);
            OposCashDrawer.form.open();
        } else {
            this.setCondition(1);
            String[] cmd = new String[]{this.oposCommander, "D", "OPEN"};
            OposController.execute(cmd, false);
        }
    }

    public void close() {
        if (this.isEmulate()) {
            OposCashDrawer.form.close();
            OposCashDrawer.form.setCondition(2);
        }
    }

    public int getCondition() {
        if (this.isEmulate()) {
            return OposCashDrawer.form.getCondition();
        }
        return this.condition;
    }

    private void setCondition(int condition) {
        if (!this.isEmulate()) {
            this.condition = condition;
        } else {
            OposCashDrawer.form.setCondition(condition);
        }
    }

    public boolean isOpen() {
        File file;
        if (this.isEmulate()) {
            if (form.status.getText().equals("OPEN")) {
                return true;
            }
            if (form.status.getText().equals("CLOSE")) {
                return false;
            }
        }
        if (!(file = new File(String.valueOf(this.dirPath) + "CashDrawer.OPEN")).exists()) {
            return false;
        }
        this.setCondition(1);
        return true;
    }

    @Override
    public String getMessage() {
        this.sense();
        if (this.isEmulate()) {
            this.message = "\u30ad\u30e3\u30c3\u30b7\u30e5\u30c9\u30ed\u30a2\u306f\u30a8\u30df\u30e5\u30ec\u30fc\u30bf\u30e2\u30fc\u30c9\u3067\u52d5\u4f5c\u3057\u3066\u3044\u307e\u3059\u3002\n";
        }
        return this.message;
    }

    private class Emulator
    extends JFrame
    implements ActionListener {
        private static final long serialVersionUID = -394755449572427378L;
        private static final String WINDOW_TITLE = "CashDrawer";
        private int condition;
        private JTextField status;
        private JButton drawer;

        private Emulator() {
            super(WINDOW_TITLE);
            this.condition = 0;
            this.status = null;
            this.drawer = null;
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(2, 1));
            this.status = new JTextField(20);
            this.status.setBackground(COLOR_WHITE);
            this.status.setFocusable(false);
            panel.add(this.status);
            this.drawer = new JButton("DRAWER");
            this.drawer.setActionCommand("DRAWER");
            this.drawer.addActionListener(this);
            panel.add(this.drawer);
            this.getContentPane().add(panel);
            this.setBounds(200, 0, 180, 80);
            this.setDefaultCloseOperation(3);
            this.setDefaultCloseOperation(0);
            this.setVisible(true);
            this.setFocusable(false);
            this.setAlwaysOnTop(true);
            this.status.setText("CLOSE");
        }

        private void open() {
            this.condition = 1;
            this.status.setText("OPEN");
            this.status.setBackground(COLOR_RED);
        }

        private void close() {
            this.condition = 2;
            this.status.setText("CLOSE");
            this.status.setBackground(COLOR_WHITE);
        }

        private int getCondition() {
            return this.condition;
        }

        private void setCondition(int condition) {
            this.condition = condition;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("DRAWER")) {
                if (this.status.getText().equals("OPEN")) {
                    this.close();
                } else if (this.status.getText().equals("CLOSE")) {
                    this.open();
                }
            }
        }
    }
}

