/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import jp.sourceforge.mergedoc.pleiades.aspect.ITimingLogger;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class TranslationLoggingDictionary
extends TranslationDictionary
implements ITimingLogger {
    private static final Logger log = Logger.getLogger(TranslationLoggingDictionary.class);
    private volatile long convertTime;
    private volatile int convertCall;
    private volatile long lookupTime;
    private volatile int lookupCall;
    private volatile long lookupIgnoreMnemonicTime;
    private volatile int lookupIgnoreMnemonicCall;
    private volatile long hasJaMnemonicTime;
    private volatile int hasJaMnemonicCall;
    private volatile long getJaValueTime;
    private volatile int getJaValueCall;
    private volatile long getJaValueByTrimmedTime;
    private volatile int getJaValueByTrimmedCall;
    private volatile long getJaValueByRegexTime;
    private volatile int getJaValueByRegexCall;
    private volatile long isNoTranslationTime;
    private volatile int isNoTranslationCall;
    private volatile long editMnemonicEnToJaTime;
    private volatile int editMnemonicEnToJaCall;

    TranslationLoggingDictionary() {
        Pleiades.getInstance().registTimingLogger(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convert() {
        long startTime = System.currentTimeMillis();
        super.convert();
        TranslationLoggingDictionary translationLoggingDictionary = this;
        synchronized (translationLoggingDictionary) {
            this.convertTime += System.currentTimeMillis() - startTime;
            ++this.convertCall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookup(String enValue, JointPoint jointPoint) {
        long startTime = System.currentTimeMillis();
        String result = super.lookup(enValue, jointPoint);
        TranslationLoggingDictionary translationLoggingDictionary = this;
        synchronized (translationLoggingDictionary) {
            this.lookupTime += System.currentTimeMillis() - startTime;
            ++this.lookupCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookupIgnoreMnemonic(String enValue, JointPoint jointPoint) {
        long startTime = System.currentTimeMillis();
        String result = super.lookupIgnoreMnemonic(enValue, jointPoint);
        TranslationLoggingDictionary translationLoggingDictionary = this;
        synchronized (translationLoggingDictionary) {
            this.lookupIgnoreMnemonicTime += System.currentTimeMillis() - startTime;
            ++this.lookupIgnoreMnemonicCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasJaMnemonic(String value) {
        long startTime = System.currentTimeMillis();
        boolean result = super.hasJaMnemonic(value);
        TranslationLoggingDictionary translationLoggingDictionary = this;
        synchronized (translationLoggingDictionary) {
            this.hasJaMnemonicTime += System.currentTimeMillis() - startTime;
            ++this.hasJaMnemonicCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getJaValue(String enNoMnemonic, JointPoint jointPoint) {
        long startTime = System.currentTimeMillis();
        String result = super.getJaValue(enNoMnemonic, jointPoint);
        TranslationLoggingDictionary translationLoggingDictionary = this;
        synchronized (translationLoggingDictionary) {
            this.getJaValueTime += System.currentTimeMillis() - startTime;
            ++this.getJaValueCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getJaValueByTrimmed(String enNoMnemonic) {
        long startTime = System.currentTimeMillis();
        String result = super.getJaValueByTrimmed(enNoMnemonic);
        TranslationLoggingDictionary translationLoggingDictionary = this;
        synchronized (translationLoggingDictionary) {
            this.getJaValueByTrimmedTime += System.currentTimeMillis() - startTime;
            ++this.getJaValueByTrimmedCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getJaValueByRegex(String enNoMnemonic) {
        long startTime = System.currentTimeMillis();
        String result = super.getJaValueByRegex(enNoMnemonic);
        TranslationLoggingDictionary translationLoggingDictionary = this;
        synchronized (translationLoggingDictionary) {
            this.getJaValueByRegexTime += System.currentTimeMillis() - startTime;
            ++this.getJaValueByRegexCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isNoTranslation(String enValueNonMnemonic, JointPoint jointPoint) {
        long startTime = System.currentTimeMillis();
        boolean result = super.isNoTranslation(enValueNonMnemonic, jointPoint);
        TranslationLoggingDictionary translationLoggingDictionary = this;
        synchronized (translationLoggingDictionary) {
            this.isNoTranslationTime += System.currentTimeMillis() - startTime;
            ++this.isNoTranslationCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String editMnemonicEnToJa(String enValue, String enValueNonMnemonic, String result) {
        long startTime = System.currentTimeMillis();
        String jaResult = super.editMnemonicEnToJa(enValue, enValueNonMnemonic, result);
        TranslationLoggingDictionary translationLoggingDictionary = this;
        synchronized (translationLoggingDictionary) {
            this.editMnemonicEnToJaTime += System.currentTimeMillis() - startTime;
            ++this.editMnemonicEnToJaCall;
        }
        return jaResult;
    }

    public void logUptime() {
        String msg = "%-30s %6.3f \u79d2\u3001%8d \u56de";
        log.debug(String.format(msg, "convert", (double)this.convertTime / 1000.0, this.convertCall));
        log.debug(String.format(msg, "lookupIgnoreMnemonic", (double)this.lookupIgnoreMnemonicTime / 1000.0, this.lookupIgnoreMnemonicCall));
        log.debug(String.format(msg, "lookup", (double)this.lookupTime / 1000.0, this.lookupCall));
        log.debug(String.format(msg, "  hasJaMnemonic", (double)this.hasJaMnemonicTime / 1000.0, this.hasJaMnemonicCall));
        log.debug(String.format(msg, "  editMnemonicEnToJa", (double)this.editMnemonicEnToJaTime / 1000.0, this.editMnemonicEnToJaCall));
        log.debug(String.format(msg, "  getJaValue", (double)this.getJaValueTime / 1000.0, this.getJaValueCall));
        log.debug(String.format(msg, "    isNoTranslation", (double)this.isNoTranslationTime / 1000.0, this.isNoTranslationCall));
        log.debug(String.format(msg, "    getJaValueByTrimmed", (double)this.getJaValueByTrimmedTime / 1000.0, this.getJaValueByTrimmedCall));
        log.debug(String.format(msg, "      getJaValueByRegex", (double)this.getJaValueByRegexTime / 1000.0, this.getJaValueByRegexCall));
    }
}

