/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.ITimingLogger;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationTransformer;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationLoggingTransformer
extends TranslationTransformer
implements ITimingLogger {
    private static final Logger log = Logger.getLogger(TranslationLoggingTransformer.class);
    private volatile long loadTime;
    private volatile long loadCall;
    private volatile long transformAbstractTime;
    private volatile long transformAbstractCall;
    private volatile long createCtClassTime;
    private volatile long createCtClassCall;
    private volatile long transformTime;
    private volatile long transformCall;
    private volatile long weaveTranslationAspectTime;
    private volatile long weaveTranslationAspectCall;

    public TranslationLoggingTransformer() {
        Pleiades.getInstance().registTimingLogger(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load() {
        long startTime = System.currentTimeMillis();
        super.load();
        TranslationLoggingTransformer translationLoggingTransformer = this;
        synchronized (translationLoggingTransformer) {
            this.loadTime += System.currentTimeMillis() - startTime;
            ++this.loadCall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String internalName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytecode) throws IllegalClassFormatException {
        long startTime = System.currentTimeMillis();
        byte[] result = super.transform(loader, internalName, classBeingRedefined, protectionDomain, bytecode);
        TranslationLoggingTransformer translationLoggingTransformer = this;
        synchronized (translationLoggingTransformer) {
            this.transformAbstractTime += System.currentTimeMillis() - startTime;
            ++this.transformAbstractCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        long startTime = System.currentTimeMillis();
        byte[] result = super.transform(loader, className, protectionDomain, bytecode);
        TranslationLoggingTransformer translationLoggingTransformer = this;
        synchronized (translationLoggingTransformer) {
            this.transformTime += System.currentTimeMillis() - startTime;
            ++this.transformCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] weaveTranslationAspect(CtClass ctClass) throws CannotCompileException, NotFoundException, IOException {
        long startTime = System.currentTimeMillis();
        byte[] result = super.weaveTranslationAspect(ctClass);
        TranslationLoggingTransformer translationLoggingTransformer = this;
        synchronized (translationLoggingTransformer) {
            this.weaveTranslationAspectTime += System.currentTimeMillis() - startTime;
            ++this.weaveTranslationAspectCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CtClass createCtClass(byte[] bytecode, ProtectionDomain protectionDomain) throws IOException, NotFoundException {
        long startTime = System.currentTimeMillis();
        CtClass result = super.createCtClass(bytecode, protectionDomain);
        TranslationLoggingTransformer translationLoggingTransformer = this;
        synchronized (translationLoggingTransformer) {
            this.createCtClassTime += System.currentTimeMillis() - startTime;
            ++this.createCtClassCall;
        }
        return result;
    }

    @Override
    public void logUptime() {
        String msg = "%-30s %6.3f \u79d2\u3001%8d \u56de";
        log.debug(String.format(msg, "load", (double)this.loadTime / 1000.0, this.loadCall));
        log.debug(String.format(msg, "transform (Abstract)", (double)this.transformAbstractTime / 1000.0, this.transformAbstractCall));
        log.debug(String.format(msg, "  transform", (double)this.transformTime / 1000.0, this.transformCall));
        log.debug(String.format(msg, "    createCtClass (Abstract)", (double)this.createCtClassTime / 1000.0, this.createCtClassCall));
        log.debug(String.format(msg, "    weaveTranslationAspect", (double)this.weaveTranslationAspectTime / 1000.0, this.weaveTranslationAspectCall));
    }
}

