/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.awt.Toolkit;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import jp.sourceforge.mergedoc.pleiades.aspect.ITimingLogger;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherLoggingTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.log.PopupFileLogger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pleiades {
    private static Logger log;
    private static PleiadesOption pleiadesOption;
    private static Pleiades pleiades;
    public static final File configurationPath;
    private static final File logFile;
    private Instrumentation instrumentation;
    private List<ITimingLogger> timeingLoggers;

    static {
        configurationPath = Pleiades.getConfigurationPath();
        logFile = new File(configurationPath, "pleiades.log");
    }

    private static File getConfigurationPath() {
        File baseDir;
        String base;
        Matcher mat;
        File eclipseHome = FileSystem.resourceRoot.getParentFile().getParentFile().getParentFile();
        File configPath = new File(eclipseHome, "configuration");
        Properties configIni = FileSystem.loadProperties(new File(configPath, "config.ini"));
        String CONFIG_AREA_KEY = "osgi.configuration.area";
        String configArea = configIni.getProperty("osgi.configuration.area");
        if (configArea == null) {
            configArea = System.getProperty("osgi.configuration.area");
        }
        File userConfigPath = null;
        if (configArea != null && (mat = Pattern.compile("^@([\\w\\.]+)(.+)$").matcher(configArea)).find() && (base = System.getProperty(mat.group(1))) != null && (baseDir = new File(base)).exists()) {
            String childPath = mat.group(2);
            userConfigPath = new File(baseDir, childPath);
        }
        if (userConfigPath == null) {
            userConfigPath = configPath;
        }
        File pleiadesConfigPath = new File(userConfigPath, "jp.sourceforge.mergedoc.pleiades/");
        pleiadesConfigPath.mkdirs();
        return pleiadesConfigPath;
    }

    public static void premain(String option, Instrumentation inst) throws Throwable {
        pleiadesOption = new PleiadesOption(option);
        System.setProperty("pleiades.logger.class.name", PopupFileLogger.class.getName());
        System.setProperty("pleiades.log.level", pleiadesOption.getLogLevel());
        System.setProperty("pleiades.log.file.name", logFile.getAbsolutePath());
        log = Logger.getLogger(Pleiades.class);
        if (log.isDebugEnabled()) {
            Properties p = System.getProperties();
            FileSystem.storeProperties(p, new File(configurationPath, "system.properties"));
        }
        try {
            Pleiades.initSwingFont();
        }
        catch (Throwable e) {
            log.warn("Swing \u306e LookAndFeel \u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e);
        }
        try {
            pleiades = new Pleiades();
            pleiades.run(inst);
        }
        catch (Throwable e) {
            log.fatal("Pleiades AOP \u7ffb\u8a33\u30b3\u30f3\u30c6\u30ca\u30fc\u306e\u8d77\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            Pleiades.exit();
        }
        log.info("Pleiades AOP \u7ffb\u8a33\u30b3\u30f3\u30c6\u30ca\u30fc\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002Pleiades \u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3:" + option);
    }

    private static void initSwingFont() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        FontUIResource propoFont = new FontUIResource("MS UI Gothic", 0, 12);
        FontUIResource fixedFont = new FontUIResource("MS Gothic", 0, 12);
        String osName = System.getProperty("os.name", "");
        if (!osName.contains("Windows")) {
            propoFont = new FontUIResource("sansserif", 0, 12);
            fixedFont = new FontUIResource("sansserif", 0, 12);
        }
        for (Object keyObj : UIManager.getLookAndFeelDefaults().keySet()) {
            String key = keyObj.toString();
            if (!key.endsWith("font") && !key.endsWith("Font")) continue;
            UIManager.put(key, propoFont);
        }
        UIManager.put("TextPane.font", fixedFont);
        UIManager.put("TextArea.font", fixedFont);
    }

    public static void exit() {
        System.exit(-1);
    }

    public static Pleiades getInstance() {
        return pleiades;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public PleiadesOption getPleiadesOption() {
        return pleiadesOption;
    }

    private void run(Instrumentation inst) throws Throwable {
        this.instrumentation = inst;
        if (log.isDebugEnabled()) {
            this.instrumentation.addTransformer(new LauncherLoggingTransformer());
        } else {
            this.instrumentation.addTransformer(new LauncherTransformer());
        }
    }

    public void registTimingLogger(ITimingLogger timeingLogger) {
        this.getTimeingLoggers().add(timeingLogger);
    }

    public List<ITimingLogger> getTimeingLoggers() {
        if (this.timeingLoggers == null) {
            this.timeingLoggers = new LinkedList<ITimingLogger>();
        }
        return this.timeingLoggers;
    }
}

