/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.AbstractTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.BundleClassCache;
import jp.sourceforge.mergedoc.pleiades.aspect.ExcludesClassList;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationLoggingTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationTransformer;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

public class LauncherTransformer
extends AbstractTransformer {
    private static final Logger log = Logger.getLogger(LauncherTransformer.class);

    protected byte[] transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        if (className.endsWith(".launcher.Main")) {
            if (!log.isDebugEnabled()) {
                Pleiades.getInstance().getInstrumentation().removeTransformer(this);
            }
            return this.weaveStartTranslationAspect(protectionDomain, bytecode);
        }
        if (className.equals("org.eclipse.ui.internal.Workbench")) {
            Pleiades.getInstance().getInstrumentation().removeTransformer(this);
            return this.weaveUptimeMethod(protectionDomain, bytecode);
        }
        return null;
    }

    protected byte[] weaveStartTranslationAspect(ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        log.info("Eclipse \u306e\u8d77\u52d5\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002");
        CtClass ctClass = this.createCtClass(bytecode, protectionDomain);
        CtMethod run = ctClass.getMethod("basicRun", "([Ljava/lang/String;)V");
        String className = this.getClass().getName();
        run.insertBefore("$1 = " + className + ".startTranslationTransformer($$);");
        run.insertAfter(String.valueOf(className) + ".destroyTranslationTransformer();", true);
        PleiadesOption agentOption = Pleiades.getInstance().getPleiadesOption();
        if (!agentOption.isDefaultSplash()) {
            System.setProperty("osgi.splashLocation", LauncherTransformer.getSplashLocation());
        }
        return ctClass.toBytecode();
    }

    protected byte[] weaveFastLoadAspect(ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        CtClass ctClass = this.createCtClass(bytecode, protectionDomain);
        CtMethod getBytes = ctClass.getMethod("getBytes", "()[B");
        String cache = String.valueOf(BundleClassCache.class.getName()) + ".getInstance()";
        if (Pleiades.getInstance().getPleiadesOption().isClean()) {
            getBytes.insertAfter(String.valueOf(cache) + ".put($0.getLocalURL().toString(), $_);", false);
        } else {
            CtMethod getBytesOriginal = CtNewMethod.copy((CtMethod)getBytes, (String)"getBytes$original", (CtClass)ctClass, null);
            ctClass.addMethod(getBytesOriginal);
            getBytes.setBody("{byte[] bytecode = " + cache + ".get($0.getLocalURL().toString());" + "if (bytecode != null) return bytecode;" + "return getBytes$original();" + "}");
        }
        return ctClass.toBytecode();
    }

    protected byte[] weaveUptimeMethod(ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        return null;
    }

    public static String[] startTranslationTransformer(String ... args) {
        try {
            LinkedList<String> argList = new LinkedList<String>((Collection)Arrays.asList(args));
            Pleiades pleiades = Pleiades.getInstance();
            PleiadesOption option = pleiades.getPleiadesOption();
            option.setClean(argList.contains("-clean"));
            if (!option.isClean()) {
                boolean isClean = false;
                if (!ExcludesClassList.file.exists()) {
                    isClean = true;
                    log.info("\u30a2\u30b9\u30da\u30af\u30c8\u9664\u5916\u30af\u30e9\u30b9\u30fb\u30ea\u30b9\u30c8\u304c\u5b58\u5728\u3057\u306a\u3044\u305f\u3081\u3001\u5f37\u5236\u7684\u306b -clean \u30e2\u30fc\u30c9\u3067\u8d77\u52d5\u3057\u307e\u3059\u3002");
                }
                if (isClean) {
                    argList.add("-clean");
                    option.setClean(true);
                }
            }
            log.info("-clean: " + option.isClean());
            Instrumentation inst = pleiades.getInstrumentation();
            if (log.isDebugEnabled()) {
                inst.addTransformer(new TranslationLoggingTransformer());
            } else {
                inst.addTransformer(new TranslationTransformer());
            }
            return argList.toArray(new String[0]);
        }
        catch (Throwable e) {
            String msg = "\u7ffb\u8a33\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u306e\u958b\u59cb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            log.fatal(msg, e);
            throw new IllegalStateException(msg, e);
        }
    }

    public static void destroyTranslationTransformer() {
        TranslationTransformer.destroy();
    }

    public static String getSplashLocation() {
        String version = "";
        File pluginsFolder = FileSystem.resourceRoot.getParentFile().getParentFile();
        File[] fileArray = pluginsFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            String folderName = folder.getName();
            if (folderName.startsWith("org.eclipse.osgi_")) {
                version = folderName.replaceFirst(".*?_(\\d+\\.\\d+).*", "$1");
                break;
            }
            ++n2;
        }
        String fileName = "splash" + version + ".bmp";
        File file = FileSystem.getResourceFile(fileName);
        if (!file.exists()) {
            fileName = "splash.bmp";
        }
        File splashFile = FileSystem.getResourceFile(fileName);
        return splashFile.getAbsolutePath().replace('\\', '/');
    }
}

