/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.DefaultSiteParser;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.ExtendedSite;
import org.eclipse.update.internal.core.SiteURLFactory;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfiguredSiteModel;

public class SiteModel
extends ModelObject {
    private String type;
    private URLEntryModel description;
    private List featureReferences;
    private List archiveReferences;
    private Set categories;
    private List mirrors;
    private String locationURLString;
    private URL locationURL;
    private String mirrorsURLString;
    private ConfiguredSiteModel configuredSiteModel;

    public String getType() {
        return this.type;
    }

    public URLEntryModel getDescriptionModel() {
        return this.description;
    }

    public SiteFeatureReferenceModel[] getFeatureReferenceModels() {
        if (this.featureReferences == null || this.featureReferences.size() == 0) {
            return new SiteFeatureReferenceModel[0];
        }
        return (SiteFeatureReferenceModel[])this.featureReferences.toArray(this.arrayTypeFor(this.featureReferences));
    }

    public ArchiveReferenceModel[] getArchiveReferenceModels() {
        if (this.archiveReferences == null || this.archiveReferences.size() == 0) {
            return new ArchiveReferenceModel[0];
        }
        return (ArchiveReferenceModel[])this.archiveReferences.toArray(this.arrayTypeFor(this.archiveReferences));
    }

    public CategoryModel[] getCategoryModels() {
        if (this.categories == null || this.categories.size() == 0) {
            return new CategoryModel[0];
        }
        return (CategoryModel[])this.categories.toArray(this.arrayTypeFor(this.categories));
    }

    public String getLocationURLString() {
        return this.locationURLString;
    }

    public URL getLocationURL() {
        return this.locationURL;
    }

    public void setType(String type) {
        this.assertIsWriteable();
        this.type = type;
    }

    public void setDescriptionModel(URLEntryModel description) {
        this.assertIsWriteable();
        this.description = description;
    }

    public void setFeatureReferenceModels(FeatureReferenceModel[] featureReferences) {
        this.assertIsWriteable();
        this.featureReferences = featureReferences == null ? null : new ArrayList<FeatureReferenceModel>(Arrays.asList(featureReferences));
    }

    public void setArchiveReferenceModels(ArchiveReferenceModel[] archiveReferences) {
        this.assertIsWriteable();
        this.archiveReferences = archiveReferences == null ? null : new ArrayList<ArchiveReferenceModel>(Arrays.asList(archiveReferences));
    }

    public void setCategoryModels(CategoryModel[] categories) {
        this.assertIsWriteable();
        if (categories == null) {
            this.categories = null;
        } else {
            this.categories = new TreeSet(CategoryModel.getComparator());
            this.categories.addAll(Arrays.asList(categories));
        }
    }

    public void setLocationURLString(String locationURLString) {
        this.assertIsWriteable();
        this.locationURLString = locationURLString;
    }

    public void addFeatureReferenceModel(SiteFeatureReferenceModel featureReference) {
        this.assertIsWriteable();
        if (this.featureReferences == null) {
            this.featureReferences = new ArrayList();
        }
        this.featureReferences.add(featureReference);
    }

    public void addArchiveReferenceModel(ArchiveReferenceModel archiveReference) {
        this.assertIsWriteable();
        if (this.archiveReferences == null) {
            this.archiveReferences = new ArrayList();
        }
        if (!this.archiveReferences.contains((Object)archiveReference)) {
            this.archiveReferences.add(archiveReference);
        }
    }

    public void addCategoryModel(CategoryModel category) {
        this.assertIsWriteable();
        if (this.categories == null) {
            this.categories = new TreeSet(CategoryModel.getComparator());
        }
        if (!this.categories.contains((Object)category)) {
            this.categories.add(category);
        }
    }

    public void addMirrorModel(URLEntryModel mirror) {
        this.assertIsWriteable();
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        if (!this.mirrors.contains((Object)mirror)) {
            this.mirrors.add(mirror);
        }
    }

    public void removeFeatureReferenceModel(FeatureReferenceModel featureReference) {
        this.assertIsWriteable();
        if (this.featureReferences != null) {
            this.featureReferences.remove((Object)featureReference);
        }
    }

    public void removeArchiveReferenceModel(ArchiveReferenceModel archiveReference) {
        this.assertIsWriteable();
        if (this.archiveReferences != null) {
            this.archiveReferences.remove((Object)archiveReference);
        }
    }

    public void removeCategoryModel(CategoryModel category) {
        this.assertIsWriteable();
        if (this.categories != null) {
            this.categories.remove((Object)category);
        }
    }

    public void removeMirror(URLEntryModel mirror) {
        this.assertIsWriteable();
        if (this.mirrors != null) {
            this.mirrors.remove((Object)mirror);
        }
    }

    public void markReadOnly() {
        super.markReadOnly();
        this.markReferenceReadOnly(this.getDescriptionModel());
        this.markListReferenceReadOnly(this.getFeatureReferenceModels());
        this.markListReferenceReadOnly(this.getArchiveReferenceModels());
        this.markListReferenceReadOnly(this.getCategoryModels());
    }

    public void resolve(URL base, URL bundleURL) throws MalformedURLException {
        this.locationURL = this.resolveURL(base, bundleURL, this.getLocationURLString());
        if (this.locationURL == null) {
            this.locationURL = base;
        }
        this.resolveListReference(this.getFeatureReferenceModels(), this.locationURL, bundleURL);
        this.resolveListReference(this.getArchiveReferenceModels(), this.locationURL, bundleURL);
        this.resolveReference(this.getDescriptionModel(), base, bundleURL);
        this.resolveListReference(this.getCategoryModels(), base, bundleURL);
        URL url = this.resolveURL(base, bundleURL, this.mirrorsURLString);
        if (url != null) {
            this.mirrorsURLString = url.toString();
        }
        if (this instanceof ExtendedSite && ((ExtendedSite)this).isDigestExist()) {
            ExtendedSite extendedSite = (ExtendedSite)this;
            extendedSite.setLiteFeatures(UpdateManagerUtils.getLightFeatures(extendedSite));
        }
    }

    public ConfiguredSiteModel getConfiguredSiteModel() {
        return this.configuredSiteModel;
    }

    public void setConfiguredSiteModel(ConfiguredSiteModel configuredSiteModel) {
        this.configuredSiteModel = configuredSiteModel;
    }

    protected String getPropertyName() {
        return "site";
    }

    public URLEntryModel[] getMirrorSiteEntryModels() {
        if ((this.mirrors == null || this.mirrors.size() == 0) && this.mirrorsURLString != null) {
            this.doSetMirrorSiteEntryModels(DefaultSiteParser.getMirrors(this.mirrorsURLString, new SiteURLFactory()));
        }
        if (this.mirrors == null || this.mirrors.size() == 0) {
            return new URLEntryModel[0];
        }
        return (URLEntryModel[])this.mirrors.toArray(this.arrayTypeFor(this.mirrors));
    }

    public void setMirrorSiteEntryModels(URLEntryModel[] mirrors) {
        this.assertIsWriteable();
        this.doSetMirrorSiteEntryModels(mirrors);
    }

    private void doSetMirrorSiteEntryModels(URLEntryModel[] mirrors) {
        this.mirrors = mirrors == null || mirrors.length == 0 ? null : new ArrayList<URLEntryModel>(Arrays.asList(mirrors));
    }

    public void setMirrorsURLString(String mirrorsURL) {
        this.assertIsWriteable();
        this.mirrorsURLString = mirrorsURL;
    }
}

