#! /bin/sh -efu
# $Id$

usage() {
	echo "usage: ${0##*/} [-hainRv] [-c target] pkgname ..."
	exit ${1:-0}
}

init_options() {
	opt_all=NO
	opt_command=
	opt_interactive=NO
	opt_noexecute=NO
	opt_depends=NO
	opt_verbose=NO
}

parse_options () {
	local OPT OPTARG OPTIND

	while getopts "hac:inRv" OPT; do
		case ${OPT} in
		h)	usage ;;
		a)	opt_all=YES ;;
		c)	opt_command="${opt_command} ${OPTARG}" ;;
		i)	opt_interactive=YES ;;
		n)	opt_noexecute=YES ;;
		R)	opt_depends=YES ;;
		v)	opt_verbose=YES ;;
		\?)	usage 1 ;;
		esac
	done

	OPTC=$((${OPTIND}-1))
}

perform() {
	local port_name pkg_origin pkg_portdir command

	while [ $# -gt 0 ]; do
		pkg_origin=$1
		set_pkg_portdir "$1"; shift
		correct_pkg || continue
		set_port_name "${pkg_portdir}" || continue

		if [ -n "${opt_command}" ]; then
			info "Make ${opt_command} for '${port_name}'"
			prompt_yesno_if_interactive || continue

			command="run_make ${pkg_portdir} ${opt_command}"
		else
			command="perform_info"
		fi

		if ! ${command}; then
			warn "Fix the problem and try again."
			echo
		fi
	done
}

perform_info() {
	local masterdir descr distinfo pkg depends

	case ${_SYSTEM} in
	pkgsrc)		descr="${pkg_portdir}/DESCR" ;;
	OpenBSD)	descr="${pkg_portdir}/pkg/DESCR" ;;
	FreeBSD)	descr="${pkg_portdir}/pkg-descr" ;;
	esac

	distinfo="${pkg_portdir}/distinfo"

	info "Information for '${port_name}'"
	prompt_yesno_if_interactive || return 0

	cd ${pkg_portdir} || return 1
	echo
	echo "Comment:"

	case ${_SYSTEM} in
	pkgsrc)		${MAKE_CMD} -V '${COMMENT}' ;;
	OpenBSD)	${MAKE_CMD} show=COMMENT ;;
	FreeBSD)	${MAKE_CMD} -VCOMMENT ;;
	esac

	echo

	if [ -r "${descr}" ]; then
		echo "Description:"
		cat "${descr}"
		echo
	fi

	is_yes ${opt_verbose} || return 0

	echo "Depends on:"
	ports_depends "${pkg_portdir}" '$depends'

	for pkg in ${depends}; do
		set_port_name "${PORTSDIR}/${pkg}"
		echo "${port_name} (${pkg})"
	done
	echo
	cd ${pkg_portdir}

	if [ -r "${distinfo}" ] || {
		case ${_SYSTEM} in
		pkgsrc)		distinfo=$(${MAKE_CMD} -V '${DISTINFO_FILE}') ;;
		OpenBSD)	distinfo=$(${MAKE_CMD} show=CHECKSUM_FILE) ;;
		FreeBSD)	distinfo=$(${MAKE_CMD} -VMD5_FILE) ;;
		esac
		[ -r "${distinfo}" ]
	}; then
		echo "Distfile(s):"
		sed -n 's,^S[Ii][Zz][Ee] (\(.*\)) = \(.*\),\1 (\2 bytes),p' "${distinfo}"
		echo
	fi
}

main() {
	init_variables
	init_options
	parse_options ${1+"$@"}
	shift ${OPTC}

	if is_yes ${opt_all}; then
		opt_depends=NO
		set -- '*'
	elif [ $# -eq 0 ]; then
		case ${PWD} in
		${PORTSDIR}/*/*) set -- "${PWD#${PORTSDIR}/}" ;;
		*) usage ;;
		esac
	fi

	glob_args=
	is_yes ${opt_depends} && glob_args="-R"

	set -- $(ports_glob ${glob_args} ${1+"$@"})

	if [ $# -gt 0 ]; then
		perform ${1+"$@"}
	fi

	exit 0
}

. /usr/local/bin/portutil
IFS=' 
'
main ${1+"$@"}
