#!/usr/bin/awk -f
#
# $Id: unifdef.awk,v 1.2 2006/10/20 08:54:06 securedog Exp $

BEGIN {
	cur[0] = 1
	depth = 0
	symlist = 0
	parse_options()
	if (ARGV[ARGC - 1] == "") ARGV[ARGC - 1] = "-"
}

function usage(val) {
	print "usage: unifdef.awk -- [-st] [-Dsym[=val]] [-Usym] ... [file]"
	exit val
}

function parse_options(i, opt, optarg, optval, delim) {
	for (i = 1; i < ARGC; i++) {
		opt = ARGV[i]
		optarg = substr(opt, 3)

		if (opt == "-s")
			symlist = 1
		else if (opt == "-t")
			;
		else if (opt ~ /^-D.+$/) {
			if (delim = index(optarg, "=")) {
				optval = substr(optarg, delim + 1)
				optarg = substr(optarg, 0, delim - 1)
			}
			else
				optval = 1
			symbols[optarg] = optval
		}
		else if (opt ~ /^-U.+$/)
			symbols[optarg] = 0
		else if (opt ~ /^-/)
			usage(1)
		else
			break
		delete ARGV[i]
	}
}

{
	if ($1 == "#ifdef" || $1 == "#ifndef") {
		depth++
		if (symlist)
			print $2
		else if (cur[depth - 1]) {
			if ($2 in symbols) {
				cur[depth] = (symbols[$2])
				if ($1 == "#ifndef") cur[depth] = ! cur[depth]
				next
			}
			else
				cur[depth] = -1
		}
		else {
			cur[depth] = 0
			next
		}
	}

	if (depth > 0) {
		if ($0 == "#else") {
			if (cur[depth] != -1) {
				if (cur[depth - 1]) cur[depth] = ! cur[depth]
				next
			}
		}
		if ($0 == "#endif") {
			depth--
			if (cur[depth + 1] != -1) next
		}
	}

	if (!symlist && cur[depth]) print
}
