#! /bin/sh -efu
# $Id$

usage() {
	echo "usage: ${0##*/} [-hinRv] [-o output_dir] pkgname ..."
	exit ${1:-0}
}

init_options() {
	opt_interactive=NO
	opt_noexecute=NO
	opt_depends=NO
	opt_verbose=NO
	opt_output=

	if [ -x "/usr/bin/fetch" ]; then
		fetch_cmd="/usr/bin/fetch"
		fetch_args="-ApRr"
	else
		fetch_cmd="ftp"
		fetch_args=
	fi
}

parse_options () {
	local OPT OPTARG OPTIND

	while getopts "hfino:Rv" OPT; do
		case ${OPT} in
		h)	usage ;;
		i)	opt_interactive=YES ;;
		n)	opt_noexecute=YES ;;
		o)	opt_output=${OPTARG} ;;
		R)	opt_depends=YES ;;
		v)	opt_verbose=YES ;;
		\?)	usage 1 ;;
		esac
	done

	OPTC=$((${OPTIND}-1))
}

perform() {
	local port_name pkg_origin pkg_portdir

	while [ $# -gt 0 ]; do
		set_pkg_portdir "$1"; shift
		set_port_name "${pkg_portdir}" || continue

		if ! perform_fetch; then
			warn "Fix the problem and try again."
			echo
		fi
	done
}

perform_fetch() {
	local distname remote_pkg_uri

	distname=${port_name}${PKG_SUFX}
	set_remote_pkg_uri "${distname}"

	info "Fetching the package: ${remote_pkg_uri}"

	prompt_yesno_if_interactive || return 0

	try ${fetch_cmd} ${fetch_args} ${remote_pkg_uri}
}

set_remote_pkg_uri() {
	local distname pkg_branch subdir

	distname=$1
	remote_pkg_uri=
	if [ -n "${PACKAGESITE}" ]; then
		remote_pkg_uri="${PACKAGESITE%/}/${distname}"
		return 0
	fi

	case ${distname} in
	*-[0-9]*[0-9].t[bg]z) subdir="All" ;;
	*) subdir="Latest" ;;
	esac

	case ${OPSYS} in
	FreeBSD)
		case ${OS_VERSION} in
		*-CURRENT)	pkg_branch="${OS_MAJOR}-current" ;;
		*-RELEASE*)	pkg_branch="${OS_REVISION}-release" ;;
		*)		pkg_branch="${OS_MAJOR}-stable" ;;
		esac

		remote_pkg_uri="${PACKAGEROOT%/}/pub/FreeBSD/ports/${ARCH}/packages-${pkg_branch}/${subdir}/${distname}" ;;
	OpenBSD)
		remote_pkg_uri="${PACAGEROOT%/}/pub/OpenBSD/${OS_MAJOR}/packages/${ARCH}/${distname}" ;;
	NetBSD|*)
		remote_pkg_uri="${PACKAGEROOT%/}/pub/pkgsrc/packages/${OPSYS}-${OS_REVISION}/${ARCH}/All/${distname}" ;;
	esac
}

main() {
	init_variables
	init_options
	parse_options ${1+"$@"}
	shift ${OPTC}

	if [ $# -eq 0 ]; then
		case ${PWD} in
		${PORTSDIR}/*/*) set -- "${PWD#${PORTSDIR}/}" ;;
		*) usage ;;
		esac
	fi

	set_system_info
	if [ -n "${opt_output}" ]; then
		fetch_args="${fetch_args} -o ${opt_output}"
	fi

	glob_args=
	is_yes ${opt_depends} && glob_args="-R"

	set -- $(ports_glob ${glob_args} ${1+"$@"})

	if [ $# -gt 0 ]; then
		perform ${1+"$@"}
	fi

	exit 0
}

. /usr/local/bin/portutil
IFS=' 
'
main ${1+"$@"}
