#! /bin/sh -efu
# $Id: fast_distclean.sh,v 1.2 2006/10/07 10:59:58 securedog Exp $
#
# usage: fast_distclean.sh

: ${PORTSDIR="/usr/ports"}
: ${DISTDIR="${PORTSDIR}/distfiles"}

[ -d "${PORTSDIR}" ] || [ -d "${DISTDIR}" ] || return 1

ARCH=$(uname -p)
case ${ARCH} in
amd64)		LINUX_RPM_ARCH=i386 ;;
powerpc)	LINUX_RPM_ARCH=ppc ;;
*)		LINUX_RPM_ARCH=${ARCH} ;;
esac

distfiles=$(mktemp -t distfiles)
keepfiles=$(mktemp -t keepfiles)
trap 'safe_exit' 1 2 3 15

safe_exit() {
	/bin/rm -f "${distfiles}" "${keepfiles}"
	exit 0
}

IFS='
'
echo -n "Detecting unreferenced distfiles"
for origin in $(pkg_info -qoa); do
	cd ${PORTSDIR}/${origin} || continue
	distfile=distinfo
	if [ ! -e ${distfile} ]; then
		masterdir=
		if grep -q '^USE_LINUX_RPM=' Makefile; then
			distfile="${distfile}.${LINUX_RPM_ARCH}"
		fi
		if grep -q '^MASTERDIR=' Makefile; then
			masterdir=$(sed -n 's|^MASTERDIR=[[:space:]]*\(.*\)$|\1|p' Makefile | \
				    sed -e 's|${\.CURDIR}/||g')
		fi
		if grep -q '^MD5_FILE=' Makefile; then
			distfile=$(sed -n -e 's|^MD5_FILE=[[:space:]]*\(.*\)$|\1|p' Makefile | \
				   sed	-e 's|${\.CURDIR}/||g' \
					-e "s|\${MASTERDIR}|${masterdir}|g" \
					-e "s|\${ARCH}|${ARCH}|g")
		elif [ -n "${masterdir}" ]; then
			distfile=${masterdir}/${distfile}
		elif [ "${distfile}" = distinfo ]; then
			distfile=
		fi
	fi
	if [ -n "${distfile}" ] && [ -e "${distfile}" ]; then
		sed -n 's/^SIZE (\(.*\)).*/\1/p' ${distfile} >> ${keepfiles}
		echo -n .
	fi
done
echo

cd ${DISTDIR}

find . -type f | sed 's|^\./||' | sort > "${distfiles}"
sort "${keepfiles}" > "${keepfiles}.sort"
mv -f "${keepfiles}.sort" "${keepfiles}"

for file in $(comm -23 "${distfiles}" "${keepfiles}"); do
	if /bin/rm -f "${file}"; then
		echo "${DISTDIR}/${file}"
	fi
done

safe_exit
