//
//  TableControllerForText.m
//  ArmorP3V1
//

#import "TableControllerForText.h"
#import "Repository.h"
#import "PSMutex.h"

@implementation TableControllerForText

@synthesize text = _text;
@synthesize nextText = _nextText;
@synthesize height = _height;
@synthesize armorSet = _armorSet;
@synthesize item = _item;

-(id)init
{
    self = [super init];
    if (self) {
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}

-(id)initWithText:(NSString*) text
{
    self = [super init];
    if (self) {
        _text = text;
        [_text retain];
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}

-(id)initWithItem:(PSWrap*) wrap {
    self = [super init];
    if (self) {
        NSMutableString* text = [[NSMutableString alloc]init];
        [wrap.item printContents:text];

        if (wrap.sameArmors.count > 0) {
            [text appendFormat: @"同等:\n"];
            for (int i = 0; i < wrap.sameArmors.count; ++ i) {
                PSWrap* child = [wrap.sameArmors objectAtIndex:i];
                [text appendFormat: @"  %@ %@\n", child.item.name, child.item.skills];
            }
        }else {
            //NSLog(@"sameCount = %d", wrap.sameArmors.count);
        }
        _text = text;
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}

-(void)loadView {
    [super loadView];
    
    CGRect bounds = [[UIScreen mainScreen] applicationFrame];

    //UIScrollView* scrollView = [[UIScrollView alloc]initWithFrame:bounds];
    UITextView* textView = [[UITextView alloc]initWithFrame:bounds];
    
    //[self.view addSubview:scrollView];
    //[scrollView addSubview:textView];
    Repository* repo = [Repository mainRepository];
    textView.font = repo.userFont;
    textView.text = _text;
    textView.editable = NO;
    //[scrollView sizeToFit];
    //[textView sizeToFit];
    
    self.view = textView;
}

-(id)initWithArmorSet:(id)armorSet {
    self = [self initWithText: @"計算中"];
    
    if (self) {
        _armorSet = armorSet;
        [_armorSet retain];
        [self performSelectorInBackground:@selector(doInBankground) withObject:nil];
    }
    return self;
}

-(void)doInBankground {
    NSMutableString* string1 = [[NSMutableString alloc]init];
    NSMutableString* string2 = [[NSMutableString alloc]init];
    NSMutableString* string3 = [[NSMutableString alloc]init];
    
    [_armorSet printArmorSetDetail:string1 :string2 : string3: TRUE];
            
    [string1 appendString:string2];
    [_text release];
    _text = nil;
    _nextText = string1;
    [_nextText retain];
    [string1 release];
    [string2 release];
    [string3 release];

    [self performSelectorOnMainThread:@selector(doInForeground) withObject:nil waitUntilDone:TRUE];
}

-(void)doInForeground {
    UITextView *view = (UITextView*)self.view;
    view.text = _nextText;
    [_text release];
    _text = _nextText;
    [_text retain];
    _nextText = nil;
}

-(void)dealloc {
//  [_text release];
    [_armorSet release];
    [_nextText release];
    [_item release];
    
    [super dealloc];
}
@end
