//
//  TableControllerForSettingSub.m
//  ArmorP3V1
//

#import "TableControllerForSettingSub.h"
#import "Repository.h"

@implementation TableControllerForSettingSub

@synthesize elem = _elem;

-(id)initWithData:(PSTableElement*)elem {
    self = [self initWithStyle:UITableViewStyleGrouped];
    if (self) {
        _elem = elem;
        [_elem retain];
    }
    return self;
}

- (void)dealloc
{
    [_elem release];
    [super dealloc];
}

-(void)callBackLoad1:(PSTableModel *)model {
    PSTableModel* prepared = _elem.nextModel;
    model.selectable = PS_SELECTABLE_SINGLE;
    for (int i = 0; i < prepared.count; ++ i) {
        PSTableSection* org = [prepared getSectionAtIndex:i];
        PSTableSection* session = [model getSection: org.title: TRUE];
        
        for (int j = 0; j < org.listElements.count; ++ j) {
            PSTableElement* orgE = [org.listElements objectAtIndex: j];
            [session.listElements addObject:orgE];
        }
    }
    [model validate];
}

#pragma mark - Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    PSTableModel* model = self.model;
    PSTableSection* sect = [model getSectionAtIndex:indexPath.section];

    for (int j = 0; j < sect.listElements.count; ++ j) {
        PSTableElement* elem = [sect.listElements objectAtIndex:j];
        if (elem.selected || j == indexPath.row) {
            if (j == indexPath.row) {
                elem.selected = TRUE;
            }else {
                elem.selected = FALSE;
            }
        }
    }  
    
    [self.tableView reloadData];
}

@end
