//
//  TableControllerForResult.m
//  ArmorP3V1
//

#import "TableControllerForResult.h"
#import "TableControllerForArmorSet.h"
#import "TableControllerForViewFilter.h"

@implementation TableControllerForResult

@synthesize engine = _engine;
@synthesize textLabel = _textLabel;

-(id)initWithData:(Engine *)engine {
    [self initWithStyle: UITableViewStyleGrouped];
    if (self) {
        _engine = engine;
        [_engine retain];
    }
    return self;
}

-(void)dealloc {
    [_engine release];
    [_textLabel release];
    [super dealloc];
}

-(void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    [self createDatas];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    if (_textLabel != nil)  {
        [_textLabel release];
    }
    _textLabel = [[NSString alloc]initWithFormat:@"%d件", _engine.listResultSearch.count];
    [self.navigationItem setTitle:_textLabel];
    
    NSMutableString* str = [[NSMutableString alloc]init];
    NSMutableArray* array = [_engine.session.searchSkills getNamedSkillNameForSearch];
    for (int i = 0; i < array.count; ++ i) {
        if (i != 0) {
            [str appendString:@", "];
        }
        NSString* str2 = [array objectAtIndex:i];
        [str appendString:str2];
    }
    
    NSString* newStr = [[NSString alloc]initWithFormat:@"%@ <%@>", _textLabel, str];

    if (TRUE) {
        Repository* repo = [Repository mainRepository];

        UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 480, 44)];
        label.backgroundColor = [UIColor clearColor];
        label.numberOfLines = 2;
        label.font = repo.userFont;
        label.shadowColor = [UIColor colorWithWhite:0.0 alpha:0.5];
        label.textAlignment = UITextAlignmentCenter;
        label.textColor = [UIColor whiteColor];
        label.text = newStr;
        
        self.navigationItem.titleView = label;  
        [label release];

    }else {
        [self.navigationItem setTitle:newStr];
    }
    [newStr release];

    UIBarButtonItem *rightButtonItem = 
    [[UIBarButtonItem alloc] initWithTitle:@"絞り込み"
                                     style:UIBarButtonItemStyleBordered
                                    target:self
                                    action:nil];
    rightButtonItem.action = @selector(showOnly:);
    [self.navigationItem setRightBarButtonItem:rightButtonItem animated:TRUE];
    [rightButtonItem release];
}

- (IBAction)showOnly:(UIButton*)sender {
    TableControllerForViewFilter* view = [[TableControllerForViewFilter alloc]initWithList: _engine.listResultSearch];
    
    UIBarButtonItem *backBarButtonItem = 
    [[UIBarButtonItem alloc] initWithTitle:@"一覧"
                                     style:UIBarButtonItemStyleBordered
                                    target:nil 
                                    action:nil];
    [self.navigationItem setBackBarButtonItem:backBarButtonItem];
    [backBarButtonItem release];
    
    [self.navigationController pushViewController:view animated:YES];
    [view release];  
}

NSComparisonResult orderByDeffence(id a, id b, void *context) {
    PSArmorSet* set1 = a;
    PSArmorSet* set2 = b;
    
    if (set1.defMax > set2.defMax) {
        return NSOrderedAscending;
    }
    if (set1.defMax < set2.defMax) {
        return NSOrderedDescending;
    }
    return NSOrderedSame;
}

-(void)callBackLoad1:(PSTableModel *)model {
    PSTableSection *sect = [model getSection:nil : TRUE]; 
    [model validate];

    TableControllerForViewFilter* view = [[TableControllerForViewFilter alloc]initWithList: _engine.listResultSearch];
    [view doSearch:nil: nil];
   
    NSMutableArray* result = view.listResultChecked;
    
    for (int i = 0; i < result.count; ++ i) {
        [model validate];
        PSArmorSet* set = [result objectAtIndex:i];        
        [set calculateUseList:nil];
    }
    [result sortUsingFunction:orderByDeffence context:nil];

    for (int i = 0; i < result.count; ++ i) {
        [model validate];
        PSArmorSet* set = [result objectAtIndex:i];        
        [model validate];
        PSTableElement* elem = [[PSTableElement alloc]init];
        [model validate];
        elem.text = nil;
        [model validate];
        elem.value = set;
        [model validate];
        [sect.listElements addObject:elem];       
        [model validate];
        [elem release];
    }
    [view release];
    [model validate];
}

-(void)fillTextForElement:(NSIndexPath *)indexPath :(PSTableElement *)element {
    PSArmorSet* set = element.value;
    NSMutableString* str = [[NSMutableString alloc]init];
    [self createText:str :set :indexPath.row + 1];    
    element.text = str;
    [str release];
}

- (void)createText: (NSMutableString*)text: (PSArmorSet *)set: (int)number {
    int shell = 0;
    
    [text appendFormat:@"%d. 防御力[%d→%d]／武器スロ【%d】", number, set.defInitial, set.defMax, set.weaponSlotCount];
    [text appendString:@"\n"];
    
    for(int i = 0; i < set.listArmor.count; ++ i) {
        PSWrap *wrap = [set.listArmor objectAtIndex:i];
        /*if (wrap.item.isVirtualNone) {
            [text appendFormat:@"%@:%@", [PSItemType itemTypeText:i], wrap.item.name];
        }else */{
            [text appendFormat:@"%@:%@[%d]", [PSItemType itemTypeText:i], wrap.item.name, wrap.item.slotCount];
            if (i == ITEM_TYPE_CHARM) {
                [text appendString:@"\n　　　"];
                [wrap.item.skills skillToString:text :nil :TRUE];
            }
        }
        [text appendString:@"\n"];
    }
    [text appendString:@"耐性値:"];
    [text appendFormat:@"火[%d]", set.shellFire];    shell += set.shellFire;
    [text appendFormat:@"水[%d]", set.shellWater];   shell += set.shellWater;
    [text appendFormat:@"氷[%d]", set.shellIce];     shell += set.shellIce;
    [text appendString:@"\n　　　 "];
    [text appendFormat:@"雷[%d]", set.shellThunder]; shell += set.shellThunder;
    [text appendFormat:@"龍[%d]", set.shellDragon];  shell += set.shellDragon;
    [text appendFormat:@"計[%d] ", shell];
    [text appendString:@"\n"];
    //[text appendString:@"--------------------\n"];
}

-(void)scrollViewDidScroll:(UIScrollView *)scrollView {
    // ヘッダを取得
    UIView *headerView = self.tableView.tableHeaderView;
    
    // UITableViewのスクロールに合わせて表示位置を調整
    [headerView setFrame:CGRectMake(headerView.frame.origin.x,
                                    self.tableView.contentOffset.y,
                                    headerView.frame.size.width,
                                    headerView.frame.size.height)];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    PSTableModel* model = self.model;
    PSTableSection* sect = [model getSectionAtIndex:indexPath.section];
    PSTableElement* elem = [sect.listElements objectAtIndex:indexPath.row];
    PSArmorSet* obj = elem.value;
    
    TableControllerForArmorSet* view = [[TableControllerForArmorSet alloc]initWithArmorSet:obj];

    UIBarButtonItem *backBarButtonItem = 
    [[UIBarButtonItem alloc] initWithTitle:@"一覧"
                                     style:UIBarButtonItemStyleBordered
                                    target:nil 
                                    action:nil];
    [self.navigationItem setBackBarButtonItem:backBarButtonItem];
    [backBarButtonItem release];        
    
    [self.navigationController pushViewController:view animated:YES];
    [view release];  
}

@end
