//
//  SkillPoint.m
//  MHP3SkillSim
//

#import "SkillPoint.h"
#import "Repository.h"
#import "PSMutex.h"

@implementation SkillPoint

@synthesize skillKind = _kind;
@synthesize skillPoint = _point;
@synthesize positiveRange = _positive;
@synthesize pointName = _skillName;
@synthesize category = _category;

-(id)copyWithZone:(NSZone *)zone {
    [self retain];
    return self;
}

-(NSUInteger)hash {
    SkillKind* kind = _kind;
    return kind.name.hash + _point + _positive;
}

-(BOOL)isEqual:(id)object {
    SkillPoint* eq = object;
    if ([eq.skillKind isEqual: self.skillKind]) {
        if (eq.skillPoint == self.skillPoint) {
            if (eq.positiveRange == self.positiveRange) {
                return TRUE;
            }
        }
    }
    return FALSE;
}

-(id)init {
    self = [super init];
    if (self) {
        
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    return self;
}

- (void)dealloc {
    [_skillName release];
    [_category release];
    [super dealloc];
}

-(NSString*)description
{
    SkillKind* kind = _kind;
    NSMutableString* string = [[NSMutableString alloc]init];
    [string appendString: @"[SkillPoint"];
    [string appendFormat: @"%@=%d", kind.name, _point];
    if (_positive == FALSE) {
        [string appendString: @"--"]; 
    }
    if (_skillName != nil) {
        [string appendFormat: @"(%@)", _skillName];
    }
    [string appendString: @"]"];
    NSString* ret = [NSString stringWithString:string];
    [string release];
    return ret;
}

- (NSComparisonResult) PointComparator:(SkillPoint*)point {  
    int n = self.skillPoint - point.skillPoint;
    if (n < 0) return NSOrderedDescending;
    if (n > 0) return NSOrderedAscending;
    return NSOrderedSame;
}  

- (NSComparisonResult) NameComparator:(SkillPoint*)point {
    SkillKind* kind1 = _kind;
    SkillKind* kind2 = point.skillKind;
    int n = [kind1.name compare: kind2.name];
    if (n < 0) return NSOrderedAscending;
    if (n > 0) return NSOrderedDescending;
    return NSOrderedSame;
}

- (NSComparisonResult) FullComparator:(SkillPoint*)point {
    SkillPoint* p1 = (SkillPoint*)self;
    SkillPoint* p2 = (SkillPoint*)point;
    
    SkillKind* k1 = p1.skillKind;
    SkillKind* k2 = p2.skillKind;
    
    int x = 0;
    
    if (k1 != k2) {
        x = [k1.name compare: k2.name];
    }
    
    if (x == 0) {
        x = p1.skillPoint - p2.skillPoint;
    }
    
    if (x == 0) {
        x = p1.positiveRange - p2.positiveRange;
    }
    
    if (x < 0) return 1;
    if (x > 0) return -1;
    return 0;
}

+ (void)sortPoint: (NSMutableArray*) ar1 {
    [ar1 sortUsingSelector:@selector(PointComparator:)];
}

+ (void)sortFull: (NSMutableArray*) ar1 {
    [ar1 sortUsingSelector:@selector(FullComparator:)];
}

@end
